/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-01-13 17:28:11 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gs_logo_slider` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `shortcode_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `shortcode_settings` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=2082 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1454 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1512 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  `term_order` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191)),
  KEY `term_order_idx` (`term_order`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL,
  `ancestor_id` int unsigned NOT NULL,
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `target_post_id` bigint unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2025-12-10 14:45:58", "2025-12-10 14:45:58", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.", "0", "post-trashed", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20260113_salamandre", "39aaf51f822255d73788_20260113172740", "21", "2026-01-13 17:28:10", "peaxwebdesign", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-01-13 17:27:40\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:5:\"8.4.4\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:1;s:4:\"Name\";s:19:\"20260113_salamandre\";s:4:\"Hash\";s:35:\"39aaf51f822255d73788_20260113172740\";s:8:\"NameHash\";s:55:\"20260113_salamandre_39aaf51f822255d73788_20260113172740\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:65:\"20260113_salamandre_39aaf51f822255d73788_20260113172740_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.1\";s:6:\"WPUser\";s:13:\"peaxwebdesign\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:67:\"20260113_salamandre_39aaf51f822255d73788_20260113172740_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:54:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1503;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:8618;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-01-13 17:27:40\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:5:\"8.4.4\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:19:\"20260113_salamandre\";s:4:\"Hash\";s:35:\"39aaf51f822255d73788_20260113172740\";s:8:\"NameHash\";s:55:\"20260113_salamandre_39aaf51f822255d73788_20260113172740\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:73:\"20260113_salamandre_39aaf51f822255d73788_20260113172740_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:68:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:68:\"20260113_salamandre_39aaf51f822255d73788_20260113172740_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:155:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public/wp-content/backups-dup-lite/tmp/20260113_salamandre_39aaf51f822255d73788_20260113172740_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:63:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public/wp-admin\";i:1;s:66:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public/wp-includes\";i:2;s:75:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:54:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public\";i:1;s:54:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public\";i:2;s:65:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public/wp-content\";i:3;s:73:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public/wp-content/uploads\";i:4;s:73:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public/wp-content/plugins\";i:5;s:76:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public/wp-content/mu-plugins\";i:6;s:72:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:86:\"C:/Users/peaxw/Local Sites/salamandre-clone/app/public/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_gs_logo_slider */
INSERT INTO `wp_gs_logo_slider` VALUES("1", "Full Width Slider & Grayscale", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"off\",\"gs_l_pagi\":\"on\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"slider_fullwidth\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"6\",\"gs_l_tab_logo\":\"4\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"900\",\"gs_l_autop_pause\":\"2500\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:03", "2026-01-07 23:06:03");
INSERT INTO `wp_gs_logo_slider` VALUES("2", "Slider & Default Color", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_self\",\"gs_l_theme\":\"slider1\",\"image_size\":\"medium_large\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:03", "2026-01-07 23:06:03");
INSERT INTO `wp_gs_logo_slider` VALUES("3", "Slider & Gray to Default Color", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"slider1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray_to_def\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:03", "2026-01-07 23:06:03");
INSERT INTO `wp_gs_logo_slider` VALUES("4", "Slider & Default Color to Gray", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"slider1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"def_to_gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:03", "2026-01-07 23:06:03");
INSERT INTO `wp_gs_logo_slider` VALUES("5", "Slider & Grayscale", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"off\",\"gs_l_pagi\":\"on\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"slider1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"6\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"3000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:03", "2026-01-07 23:06:03");
INSERT INTO `wp_gs_logo_slider` VALUES("6", "Grid - 1 & Default Color", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"grid1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:03", "2026-01-07 23:06:03");
INSERT INTO `wp_gs_logo_slider` VALUES("7", "Grid - 2 & Gray to Default Color", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"grid2\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray_to_def\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"rand\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:03", "2026-01-07 23:06:03");
INSERT INTO `wp_gs_logo_slider` VALUES("8", "Grid - 3 & Default Color to Gray", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"grid3\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"def_to_gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:03", "2026-01-07 23:06:03");
INSERT INTO `wp_gs_logo_slider` VALUES("9", "Grid - 2 & Grayscale", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"grid2\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:03", "2026-01-07 23:06:03");
INSERT INTO `wp_gs_logo_slider` VALUES("10", "List - 1 & Default Color", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"list1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("11", "List - 2 & Gray to Default Color", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"list2\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray_to_def\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("12", "List - 3 & Default Color to Gray", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"list3\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"def_to_gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("13", "List - 4 & Grayscale", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"list4\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("14", "Table - 1 & Default Color", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"table1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("15", "Table - 2 & Gray to Default Color", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"table2\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray_to_def\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("16", "Table - 3 & Default Color to Gray", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"table3\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"def_to_gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("17", "Table - 2 & Grayscale", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"table2\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("18", "Ticker & Default Color", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"ticker1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"2500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("19", "Ticker & Gray to Default Color", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"ticker1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray_to_def\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"2500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("20", "Ticker & Default Color to Gray", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"ticker1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"def_to_gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"2500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("21", "Vertical Ticker Up", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"verticalticker\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("22", "Vertical Ticker Down", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"verticaltickerdown\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"def_to_gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("23", "2 Rows Slider & Default Color", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"off\",\"gs_l_pagi\":\"on\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"on\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"slider-2rows\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("24", "2 Rows Slider & Gray to Default Color", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"off\",\"gs_l_pagi\":\"on\",\"gs_l_pagi_dynamic\":\"off\",\"gs_l_play_pause\":\"on\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"slider-2rows\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray_to_def\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("25", "2 Rows Slider & Default Color to Gray", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"off\",\"gs_l_play_pause\":\"on\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"slider-2rows\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"def_to_gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("26", "2 Rows Slider & Grayscale", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"off\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"off\",\"gs_l_play_pause\":\"on\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"slider-2rows\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("27", "Vertical Display", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"vslider1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("28", "Vertical Display & Tooltip", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"vslider1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"def_to_gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("29", "Filter - 1 & Default Color", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"filter1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("30", "Filter - 2 & Gray to Default Color", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"filter2\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray_to_def\",\"gs_logo_filter_align\":\"right\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All \\/ any Text\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("31", "Filter - 3 & Default Color to Gray", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"filter3\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"def_to_gray\",\"gs_logo_filter_align\":\"left\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All \\/ any Text\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("32", "Filter - 2 & Grayscale", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"filter2\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("33", "Filter - Selected Cats", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"filter3\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"category-one,category-three\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("34", "Live Filter - 1 & Default Color", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"filterlive1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("35", "Live Filter - 2 & Gray to Default Color", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"filterlive2\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray_to_def\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("36", "Live Filter - 3 & Default Color to Gray", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"filterlive3\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"def_to_gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("37", "Live Filter - 2 & Grayscale", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"filterlive2\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("38", "Custom Order in List View", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"list1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"ASC\",\"orderby\":\"menu_order\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("39", "Custom Order in Slider View", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"slider1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"ASC\",\"orderby\":\"menu_order\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("40", "Logo Order by Title in List View", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"list1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"ASC\",\"orderby\":\"title\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("41", "Center Mode & Default Color", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"off\",\"gs_l_pagi\":\"on\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"center\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"1000\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("42", "Center Mode & Gray to Default Color", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"off\",\"gs_l_pagi\":\"on\",\"gs_l_pagi_dynamic\":\"off\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"center\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray_to_def\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"1000\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("43", "Center Mode & Default Color to Gray", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"off\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"center\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"def_to_gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"1000\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("44", "Center Mode & Grayscale", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"off\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"center\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"1000\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("45", "Full Width Slider & Default Color", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"off\",\"gs_l_pagi\":\"on\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"slider_fullwidth\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"6\",\"gs_l_tab_logo\":\"4\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"900\",\"gs_l_autop_pause\":\"2500\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("46", "Full Width Slider & Gray to Default Color", "{\"gs_l_title\":\"off\",\"gs_l_ctrl\":\"off\",\"gs_l_pagi\":\"on\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"on\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"slider_fullwidth\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"gray_to_def\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"date\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"6\",\"gs_l_tab_logo\":\"4\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"900\",\"gs_l_autop_pause\":\"2500\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("47", "Logo Order by Title in Slider View", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"slider1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"ASC\",\"orderby\":\"title\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("48", "Logos in Random Order", "{\"gs_l_title\":\"on\",\"gs_l_ctrl\":\"on\",\"gs_l_pagi\":\"off\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"on\",\"gs_l_tooltip\":\"off\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"gs_l_clkable\":\"_blank\",\"gs_l_theme\":\"slider1\",\"image_size\":\"medium\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_gray\":\"\",\"gs_logo_filter_align\":\"center\",\"order\":\"DESC\",\"orderby\":\"rand\",\"logo_cat\":\"\",\"gs_logo_filter_name\":\"All\",\"posts\":\"-1\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"5\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"2000\",\"gslogo-demo_data\":true}", "2026-01-07 23:06:04", "2026-01-07 23:06:04");
INSERT INTO `wp_gs_logo_slider` VALUES("49", "logos-partenaires", "{\"posts\":\"-1\",\"order\":\"DESC\",\"orderby\":\"date\",\"filter_order\":\"ASC\",\"filter_orderby\":\"name\",\"gs_l_title\":\"off\",\"title_tag\":\"h3\",\"gs_l_link_logos\":\"on\",\"include_category\":[],\"include_tag\":[],\"include_extra_one\":[],\"include_extra_two\":[],\"include_extra_three\":[],\"include_extra_four\":[],\"include_extra_five\":[],\"exclude_category\":[],\"exclude_tag\":[],\"exclude_extra_one\":[],\"exclude_extra_two\":[],\"exclude_extra_three\":[],\"exclude_extra_four\":[],\"exclude_extra_five\":[],\"gs_l_ctrl\":\"off\",\"gs_l_ctrl_pos\":\"bottom\",\"gs_l_pagi\":\"on\",\"gs_l_pagi_dynamic\":\"on\",\"gs_l_play_pause\":\"off\",\"gs_l_inf_loop\":\"on\",\"gs_l_slider_stop\":\"off\",\"gs_l_tooltip\":\"off\",\"gs_l_tooltip_placement\":\"top\",\"gs_l_tooltip_bgcolor_one\":\"#ff5f6d\",\"gs_l_tooltip_bgcolor_two\":\"#ffc371\",\"gs_l_tooltip_textcolor\":\"#fff\",\"gs_l_all_filter\":\"on\",\"gs_secondary_img\":\"off\",\"gs_l_slide_speed\":\"500\",\"gs_l_autop_pause\":\"3000\",\"gs_l_theme\":\"slider1\",\"filter_enabled\":\"off\",\"gs_logo_filter_type\":\"normal-filter\",\"gs_logo_pagination\":\"off\",\"pagination_type\":\"normal-pagination\",\"initial_items\":\"6\",\"logo_per_page\":\"6\",\"load_per_click\":\"3\",\"per_load\":\"3\",\"load_button_text\":\"Load More\",\"gs_l_s2_border_thickness\":\"50\",\"gs_l_s2_gradient_start\":\"#003729\",\"gs_l_s2_gradient_end\":\"#1f9e74\",\"gs_l_rb_border\":\"1px,solid,#000000\",\"gs_l_rb_border_radius\":\"10,10,10,10\",\"gs_l_rb_hover_shadow_color\":\"#1d202f\",\"gs_l_rb_hover_shadow_control\":\"6,6,15,0\",\"image_size\":\"medium\",\"custom_image_size_width\":\"\",\"custom_image_size_height\":\"\",\"custom_image_size_crop\":\"hard-crop\",\"gs_l_clkable\":\"_blank\",\"gs_l_is_autop\":\"on\",\"gs_reverse_direction\":\"off\",\"image_filter\":\"none\",\"hover_image_filter\":\"none\",\"gs_l_align\":\"center\",\"gs_l_margin\":\"10\",\"gs_l_min_logo\":\"4\",\"gs_l_tab_logo\":\"3\",\"gs_l_mob_logo\":\"2\",\"gs_l_move_logo\":\"1\",\"gs_logo_filter_name\":\"All\",\"gs_logo_filter_align\":\"center\",\"show_cat\":\"off\",\"gs_l_show_content\":\"off\",\"gs_l_content_limit_count\":\"80\",\"gs_l_content_limit_type\":\"chars\",\"gs_l_show_excerpt\":\"off\",\"gs_l_excerpt_limit_count\":\"20\",\"gs_l_excerpt_limit_type\":\"words\",\"gs_l_read_more_text\":\"Read More\",\"row_heading_image\":\"Image\",\"row_heading_name\":\"Name\",\"row_heading_desc\":\"Description\"}", "2026-01-07 23:25:32", "2026-01-13 10:51:55");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:16:{i:1768326359;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1768358767;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1768362358;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1768364158;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1768365958;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1768401959;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1768401967;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1768401970;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1768402837;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768406791;a:1:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1768407792;a:1:{s:21:\"ai1wm_storage_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1768488359;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768767895;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768831200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770999792;a:1:{s:27:\"delete_block_library_folder\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2678400;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "http://salamandre-clone.local", "on");
INSERT INTO `wp_options` VALUES("3", "home", "http://salamandre-clone.local", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "Salamandre", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "Éditeur de logiciels pour la restauration collective", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "dev-email@wpengine.local", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "d/m/Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:117:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:54:\"logo-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?taxonomy=logo-category&term=$matches[1]&feed=$matches[2]\";s:49:\"logo-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?taxonomy=logo-category&term=$matches[1]&feed=$matches[2]\";s:30:\"logo-category/([^/]+)/embed/?$\";s:60:\"index.php?taxonomy=logo-category&term=$matches[1]&embed=true\";s:42:\"logo-category/([^/]+)/page/?([0-9]{1,})/?$\";s:67:\"index.php?taxonomy=logo-category&term=$matches[1]&paged=$matches[2]\";s:24:\"logo-category/([^/]+)/?$\";s:49:\"index.php?taxonomy=logo-category&term=$matches[1]\";s:40:\"kadence-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"kadence-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"kadence-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"kadence-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"kadence-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"kadence-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"kadence-form/([^/]+)/embed/?$\";s:45:\"index.php?kadence_form=$matches[1]&embed=true\";s:33:\"kadence-form/([^/]+)/trackback/?$\";s:39:\"index.php?kadence_form=$matches[1]&tb=1\";s:41:\"kadence-form/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?kadence_form=$matches[1]&paged=$matches[2]\";s:48:\"kadence-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?kadence_form=$matches[1]&cpage=$matches[2]\";s:37:\"kadence-form/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?kadence_form=$matches[1]&page=$matches[2]\";s:29:\"kadence-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"kadence-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"kadence-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"kadence-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"kadence-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"kadence-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=144&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:6:{i:0;s:25:\"duplicator/duplicator.php\";i:1;s:26:\"gs-logo-slider/gs-logo.php\";i:2;s:33:\"kadence-blocks/kadence-blocks.php\";i:3;s:21:\"safe-svg/safe-svg.php\";i:4;s:33:\"simple-sitemap/simple-sitemap.php\";i:5;s:41:\"wpfront-scroll-top/wpfront-scroll-top.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "twentytwentyfive", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "Salamandre", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "60717", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "0", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:2:{s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";s:53:\"child-theme-configurator/child-theme-configurator.php\";s:22:\"chld_thm_cfg_uninstall\";}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "144", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "41", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1780929958", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "wp_notes_notify", "1", "on");
INSERT INTO `wp_options` VALUES("102", "initial_db_version", "60717", "on");
INSERT INTO `wp_options` VALUES("103", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:65:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"copy_posts\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;s:26:\"manage_ast_block_templates\";b:1;s:18:\"bcn_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("104", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("105", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("106", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("107", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("122", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:3:\"6.9\";s:5:\"files\";a:584:{i:0;s:31:\"accordion-heading/style-rtl.css\";i:1;s:35:\"accordion-heading/style-rtl.min.css\";i:2;s:27:\"accordion-heading/style.css\";i:3;s:31:\"accordion-heading/style.min.css\";i:4;s:28:\"accordion-item/style-rtl.css\";i:5;s:32:\"accordion-item/style-rtl.min.css\";i:6;s:24:\"accordion-item/style.css\";i:7;s:28:\"accordion-item/style.min.css\";i:8;s:29:\"accordion-panel/style-rtl.css\";i:9;s:33:\"accordion-panel/style-rtl.min.css\";i:10;s:25:\"accordion-panel/style.css\";i:11;s:29:\"accordion-panel/style.min.css\";i:12;s:23:\"accordion/style-rtl.css\";i:13;s:27:\"accordion/style-rtl.min.css\";i:14;s:19:\"accordion/style.css\";i:15;s:23:\"accordion/style.min.css\";i:16;s:23:\"archives/editor-rtl.css\";i:17;s:27:\"archives/editor-rtl.min.css\";i:18;s:19:\"archives/editor.css\";i:19;s:23:\"archives/editor.min.css\";i:20;s:22:\"archives/style-rtl.css\";i:21;s:26:\"archives/style-rtl.min.css\";i:22;s:18:\"archives/style.css\";i:23;s:22:\"archives/style.min.css\";i:24;s:20:\"audio/editor-rtl.css\";i:25;s:24:\"audio/editor-rtl.min.css\";i:26;s:16:\"audio/editor.css\";i:27;s:20:\"audio/editor.min.css\";i:28;s:19:\"audio/style-rtl.css\";i:29;s:23:\"audio/style-rtl.min.css\";i:30;s:15:\"audio/style.css\";i:31;s:19:\"audio/style.min.css\";i:32;s:19:\"audio/theme-rtl.css\";i:33;s:23:\"audio/theme-rtl.min.css\";i:34;s:15:\"audio/theme.css\";i:35;s:19:\"audio/theme.min.css\";i:36;s:21:\"avatar/editor-rtl.css\";i:37;s:25:\"avatar/editor-rtl.min.css\";i:38;s:17:\"avatar/editor.css\";i:39;s:21:\"avatar/editor.min.css\";i:40;s:20:\"avatar/style-rtl.css\";i:41;s:24:\"avatar/style-rtl.min.css\";i:42;s:16:\"avatar/style.css\";i:43;s:20:\"avatar/style.min.css\";i:44;s:21:\"button/editor-rtl.css\";i:45;s:25:\"button/editor-rtl.min.css\";i:46;s:17:\"button/editor.css\";i:47;s:21:\"button/editor.min.css\";i:48;s:20:\"button/style-rtl.css\";i:49;s:24:\"button/style-rtl.min.css\";i:50;s:16:\"button/style.css\";i:51;s:20:\"button/style.min.css\";i:52;s:22:\"buttons/editor-rtl.css\";i:53;s:26:\"buttons/editor-rtl.min.css\";i:54;s:18:\"buttons/editor.css\";i:55;s:22:\"buttons/editor.min.css\";i:56;s:21:\"buttons/style-rtl.css\";i:57;s:25:\"buttons/style-rtl.min.css\";i:58;s:17:\"buttons/style.css\";i:59;s:21:\"buttons/style.min.css\";i:60;s:22:\"calendar/style-rtl.css\";i:61;s:26:\"calendar/style-rtl.min.css\";i:62;s:18:\"calendar/style.css\";i:63;s:22:\"calendar/style.min.css\";i:64;s:25:\"categories/editor-rtl.css\";i:65;s:29:\"categories/editor-rtl.min.css\";i:66;s:21:\"categories/editor.css\";i:67;s:25:\"categories/editor.min.css\";i:68;s:24:\"categories/style-rtl.css\";i:69;s:28:\"categories/style-rtl.min.css\";i:70;s:20:\"categories/style.css\";i:71;s:24:\"categories/style.min.css\";i:72;s:19:\"code/editor-rtl.css\";i:73;s:23:\"code/editor-rtl.min.css\";i:74;s:15:\"code/editor.css\";i:75;s:19:\"code/editor.min.css\";i:76;s:18:\"code/style-rtl.css\";i:77;s:22:\"code/style-rtl.min.css\";i:78;s:14:\"code/style.css\";i:79;s:18:\"code/style.min.css\";i:80;s:18:\"code/theme-rtl.css\";i:81;s:22:\"code/theme-rtl.min.css\";i:82;s:14:\"code/theme.css\";i:83;s:18:\"code/theme.min.css\";i:84;s:22:\"columns/editor-rtl.css\";i:85;s:26:\"columns/editor-rtl.min.css\";i:86;s:18:\"columns/editor.css\";i:87;s:22:\"columns/editor.min.css\";i:88;s:21:\"columns/style-rtl.css\";i:89;s:25:\"columns/style-rtl.min.css\";i:90;s:17:\"columns/style.css\";i:91;s:21:\"columns/style.min.css\";i:92;s:33:\"comment-author-name/style-rtl.css\";i:93;s:37:\"comment-author-name/style-rtl.min.css\";i:94;s:29:\"comment-author-name/style.css\";i:95;s:33:\"comment-author-name/style.min.css\";i:96;s:29:\"comment-content/style-rtl.css\";i:97;s:33:\"comment-content/style-rtl.min.css\";i:98;s:25:\"comment-content/style.css\";i:99;s:29:\"comment-content/style.min.css\";i:100;s:26:\"comment-date/style-rtl.css\";i:101;s:30:\"comment-date/style-rtl.min.css\";i:102;s:22:\"comment-date/style.css\";i:103;s:26:\"comment-date/style.min.css\";i:104;s:31:\"comment-edit-link/style-rtl.css\";i:105;s:35:\"comment-edit-link/style-rtl.min.css\";i:106;s:27:\"comment-edit-link/style.css\";i:107;s:31:\"comment-edit-link/style.min.css\";i:108;s:32:\"comment-reply-link/style-rtl.css\";i:109;s:36:\"comment-reply-link/style-rtl.min.css\";i:110;s:28:\"comment-reply-link/style.css\";i:111;s:32:\"comment-reply-link/style.min.css\";i:112;s:30:\"comment-template/style-rtl.css\";i:113;s:34:\"comment-template/style-rtl.min.css\";i:114;s:26:\"comment-template/style.css\";i:115;s:30:\"comment-template/style.min.css\";i:116;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:117;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:118;s:38:\"comments-pagination-numbers/editor.css\";i:119;s:42:\"comments-pagination-numbers/editor.min.css\";i:120;s:34:\"comments-pagination/editor-rtl.css\";i:121;s:38:\"comments-pagination/editor-rtl.min.css\";i:122;s:30:\"comments-pagination/editor.css\";i:123;s:34:\"comments-pagination/editor.min.css\";i:124;s:33:\"comments-pagination/style-rtl.css\";i:125;s:37:\"comments-pagination/style-rtl.min.css\";i:126;s:29:\"comments-pagination/style.css\";i:127;s:33:\"comments-pagination/style.min.css\";i:128;s:29:\"comments-title/editor-rtl.css\";i:129;s:33:\"comments-title/editor-rtl.min.css\";i:130;s:25:\"comments-title/editor.css\";i:131;s:29:\"comments-title/editor.min.css\";i:132;s:23:\"comments/editor-rtl.css\";i:133;s:27:\"comments/editor-rtl.min.css\";i:134;s:19:\"comments/editor.css\";i:135;s:23:\"comments/editor.min.css\";i:136;s:22:\"comments/style-rtl.css\";i:137;s:26:\"comments/style-rtl.min.css\";i:138;s:18:\"comments/style.css\";i:139;s:22:\"comments/style.min.css\";i:140;s:20:\"cover/editor-rtl.css\";i:141;s:24:\"cover/editor-rtl.min.css\";i:142;s:16:\"cover/editor.css\";i:143;s:20:\"cover/editor.min.css\";i:144;s:19:\"cover/style-rtl.css\";i:145;s:23:\"cover/style-rtl.min.css\";i:146;s:15:\"cover/style.css\";i:147;s:19:\"cover/style.min.css\";i:148;s:22:\"details/editor-rtl.css\";i:149;s:26:\"details/editor-rtl.min.css\";i:150;s:18:\"details/editor.css\";i:151;s:22:\"details/editor.min.css\";i:152;s:21:\"details/style-rtl.css\";i:153;s:25:\"details/style-rtl.min.css\";i:154;s:17:\"details/style.css\";i:155;s:21:\"details/style.min.css\";i:156;s:20:\"embed/editor-rtl.css\";i:157;s:24:\"embed/editor-rtl.min.css\";i:158;s:16:\"embed/editor.css\";i:159;s:20:\"embed/editor.min.css\";i:160;s:19:\"embed/style-rtl.css\";i:161;s:23:\"embed/style-rtl.min.css\";i:162;s:15:\"embed/style.css\";i:163;s:19:\"embed/style.min.css\";i:164;s:19:\"embed/theme-rtl.css\";i:165;s:23:\"embed/theme-rtl.min.css\";i:166;s:15:\"embed/theme.css\";i:167;s:19:\"embed/theme.min.css\";i:168;s:19:\"file/editor-rtl.css\";i:169;s:23:\"file/editor-rtl.min.css\";i:170;s:15:\"file/editor.css\";i:171;s:19:\"file/editor.min.css\";i:172;s:18:\"file/style-rtl.css\";i:173;s:22:\"file/style-rtl.min.css\";i:174;s:14:\"file/style.css\";i:175;s:18:\"file/style.min.css\";i:176;s:23:\"footnotes/style-rtl.css\";i:177;s:27:\"footnotes/style-rtl.min.css\";i:178;s:19:\"footnotes/style.css\";i:179;s:23:\"footnotes/style.min.css\";i:180;s:23:\"freeform/editor-rtl.css\";i:181;s:27:\"freeform/editor-rtl.min.css\";i:182;s:19:\"freeform/editor.css\";i:183;s:23:\"freeform/editor.min.css\";i:184;s:22:\"gallery/editor-rtl.css\";i:185;s:26:\"gallery/editor-rtl.min.css\";i:186;s:18:\"gallery/editor.css\";i:187;s:22:\"gallery/editor.min.css\";i:188;s:21:\"gallery/style-rtl.css\";i:189;s:25:\"gallery/style-rtl.min.css\";i:190;s:17:\"gallery/style.css\";i:191;s:21:\"gallery/style.min.css\";i:192;s:21:\"gallery/theme-rtl.css\";i:193;s:25:\"gallery/theme-rtl.min.css\";i:194;s:17:\"gallery/theme.css\";i:195;s:21:\"gallery/theme.min.css\";i:196;s:20:\"group/editor-rtl.css\";i:197;s:24:\"group/editor-rtl.min.css\";i:198;s:16:\"group/editor.css\";i:199;s:20:\"group/editor.min.css\";i:200;s:19:\"group/style-rtl.css\";i:201;s:23:\"group/style-rtl.min.css\";i:202;s:15:\"group/style.css\";i:203;s:19:\"group/style.min.css\";i:204;s:19:\"group/theme-rtl.css\";i:205;s:23:\"group/theme-rtl.min.css\";i:206;s:15:\"group/theme.css\";i:207;s:19:\"group/theme.min.css\";i:208;s:21:\"heading/style-rtl.css\";i:209;s:25:\"heading/style-rtl.min.css\";i:210;s:17:\"heading/style.css\";i:211;s:21:\"heading/style.min.css\";i:212;s:19:\"html/editor-rtl.css\";i:213;s:23:\"html/editor-rtl.min.css\";i:214;s:15:\"html/editor.css\";i:215;s:19:\"html/editor.min.css\";i:216;s:20:\"image/editor-rtl.css\";i:217;s:24:\"image/editor-rtl.min.css\";i:218;s:16:\"image/editor.css\";i:219;s:20:\"image/editor.min.css\";i:220;s:19:\"image/style-rtl.css\";i:221;s:23:\"image/style-rtl.min.css\";i:222;s:15:\"image/style.css\";i:223;s:19:\"image/style.min.css\";i:224;s:19:\"image/theme-rtl.css\";i:225;s:23:\"image/theme-rtl.min.css\";i:226;s:15:\"image/theme.css\";i:227;s:19:\"image/theme.min.css\";i:228;s:29:\"latest-comments/style-rtl.css\";i:229;s:33:\"latest-comments/style-rtl.min.css\";i:230;s:25:\"latest-comments/style.css\";i:231;s:29:\"latest-comments/style.min.css\";i:232;s:27:\"latest-posts/editor-rtl.css\";i:233;s:31:\"latest-posts/editor-rtl.min.css\";i:234;s:23:\"latest-posts/editor.css\";i:235;s:27:\"latest-posts/editor.min.css\";i:236;s:26:\"latest-posts/style-rtl.css\";i:237;s:30:\"latest-posts/style-rtl.min.css\";i:238;s:22:\"latest-posts/style.css\";i:239;s:26:\"latest-posts/style.min.css\";i:240;s:18:\"list/style-rtl.css\";i:241;s:22:\"list/style-rtl.min.css\";i:242;s:14:\"list/style.css\";i:243;s:18:\"list/style.min.css\";i:244;s:22:\"loginout/style-rtl.css\";i:245;s:26:\"loginout/style-rtl.min.css\";i:246;s:18:\"loginout/style.css\";i:247;s:22:\"loginout/style.min.css\";i:248;s:19:\"math/editor-rtl.css\";i:249;s:23:\"math/editor-rtl.min.css\";i:250;s:15:\"math/editor.css\";i:251;s:19:\"math/editor.min.css\";i:252;s:18:\"math/style-rtl.css\";i:253;s:22:\"math/style-rtl.min.css\";i:254;s:14:\"math/style.css\";i:255;s:18:\"math/style.min.css\";i:256;s:25:\"media-text/editor-rtl.css\";i:257;s:29:\"media-text/editor-rtl.min.css\";i:258;s:21:\"media-text/editor.css\";i:259;s:25:\"media-text/editor.min.css\";i:260;s:24:\"media-text/style-rtl.css\";i:261;s:28:\"media-text/style-rtl.min.css\";i:262;s:20:\"media-text/style.css\";i:263;s:24:\"media-text/style.min.css\";i:264;s:19:\"more/editor-rtl.css\";i:265;s:23:\"more/editor-rtl.min.css\";i:266;s:15:\"more/editor.css\";i:267;s:19:\"more/editor.min.css\";i:268;s:30:\"navigation-link/editor-rtl.css\";i:269;s:34:\"navigation-link/editor-rtl.min.css\";i:270;s:26:\"navigation-link/editor.css\";i:271;s:30:\"navigation-link/editor.min.css\";i:272;s:29:\"navigation-link/style-rtl.css\";i:273;s:33:\"navigation-link/style-rtl.min.css\";i:274;s:25:\"navigation-link/style.css\";i:275;s:29:\"navigation-link/style.min.css\";i:276;s:33:\"navigation-submenu/editor-rtl.css\";i:277;s:37:\"navigation-submenu/editor-rtl.min.css\";i:278;s:29:\"navigation-submenu/editor.css\";i:279;s:33:\"navigation-submenu/editor.min.css\";i:280;s:25:\"navigation/editor-rtl.css\";i:281;s:29:\"navigation/editor-rtl.min.css\";i:282;s:21:\"navigation/editor.css\";i:283;s:25:\"navigation/editor.min.css\";i:284;s:24:\"navigation/style-rtl.css\";i:285;s:28:\"navigation/style-rtl.min.css\";i:286;s:20:\"navigation/style.css\";i:287;s:24:\"navigation/style.min.css\";i:288;s:23:\"nextpage/editor-rtl.css\";i:289;s:27:\"nextpage/editor-rtl.min.css\";i:290;s:19:\"nextpage/editor.css\";i:291;s:23:\"nextpage/editor.min.css\";i:292;s:24:\"page-list/editor-rtl.css\";i:293;s:28:\"page-list/editor-rtl.min.css\";i:294;s:20:\"page-list/editor.css\";i:295;s:24:\"page-list/editor.min.css\";i:296;s:23:\"page-list/style-rtl.css\";i:297;s:27:\"page-list/style-rtl.min.css\";i:298;s:19:\"page-list/style.css\";i:299;s:23:\"page-list/style.min.css\";i:300;s:24:\"paragraph/editor-rtl.css\";i:301;s:28:\"paragraph/editor-rtl.min.css\";i:302;s:20:\"paragraph/editor.css\";i:303;s:24:\"paragraph/editor.min.css\";i:304;s:23:\"paragraph/style-rtl.css\";i:305;s:27:\"paragraph/style-rtl.min.css\";i:306;s:19:\"paragraph/style.css\";i:307;s:23:\"paragraph/style.min.css\";i:308;s:35:\"post-author-biography/style-rtl.css\";i:309;s:39:\"post-author-biography/style-rtl.min.css\";i:310;s:31:\"post-author-biography/style.css\";i:311;s:35:\"post-author-biography/style.min.css\";i:312;s:30:\"post-author-name/style-rtl.css\";i:313;s:34:\"post-author-name/style-rtl.min.css\";i:314;s:26:\"post-author-name/style.css\";i:315;s:30:\"post-author-name/style.min.css\";i:316;s:25:\"post-author/style-rtl.css\";i:317;s:29:\"post-author/style-rtl.min.css\";i:318;s:21:\"post-author/style.css\";i:319;s:25:\"post-author/style.min.css\";i:320;s:33:\"post-comments-count/style-rtl.css\";i:321;s:37:\"post-comments-count/style-rtl.min.css\";i:322;s:29:\"post-comments-count/style.css\";i:323;s:33:\"post-comments-count/style.min.css\";i:324;s:33:\"post-comments-form/editor-rtl.css\";i:325;s:37:\"post-comments-form/editor-rtl.min.css\";i:326;s:29:\"post-comments-form/editor.css\";i:327;s:33:\"post-comments-form/editor.min.css\";i:328;s:32:\"post-comments-form/style-rtl.css\";i:329;s:36:\"post-comments-form/style-rtl.min.css\";i:330;s:28:\"post-comments-form/style.css\";i:331;s:32:\"post-comments-form/style.min.css\";i:332;s:32:\"post-comments-link/style-rtl.css\";i:333;s:36:\"post-comments-link/style-rtl.min.css\";i:334;s:28:\"post-comments-link/style.css\";i:335;s:32:\"post-comments-link/style.min.css\";i:336;s:26:\"post-content/style-rtl.css\";i:337;s:30:\"post-content/style-rtl.min.css\";i:338;s:22:\"post-content/style.css\";i:339;s:26:\"post-content/style.min.css\";i:340;s:23:\"post-date/style-rtl.css\";i:341;s:27:\"post-date/style-rtl.min.css\";i:342;s:19:\"post-date/style.css\";i:343;s:23:\"post-date/style.min.css\";i:344;s:27:\"post-excerpt/editor-rtl.css\";i:345;s:31:\"post-excerpt/editor-rtl.min.css\";i:346;s:23:\"post-excerpt/editor.css\";i:347;s:27:\"post-excerpt/editor.min.css\";i:348;s:26:\"post-excerpt/style-rtl.css\";i:349;s:30:\"post-excerpt/style-rtl.min.css\";i:350;s:22:\"post-excerpt/style.css\";i:351;s:26:\"post-excerpt/style.min.css\";i:352;s:34:\"post-featured-image/editor-rtl.css\";i:353;s:38:\"post-featured-image/editor-rtl.min.css\";i:354;s:30:\"post-featured-image/editor.css\";i:355;s:34:\"post-featured-image/editor.min.css\";i:356;s:33:\"post-featured-image/style-rtl.css\";i:357;s:37:\"post-featured-image/style-rtl.min.css\";i:358;s:29:\"post-featured-image/style.css\";i:359;s:33:\"post-featured-image/style.min.css\";i:360;s:34:\"post-navigation-link/style-rtl.css\";i:361;s:38:\"post-navigation-link/style-rtl.min.css\";i:362;s:30:\"post-navigation-link/style.css\";i:363;s:34:\"post-navigation-link/style.min.css\";i:364;s:27:\"post-template/style-rtl.css\";i:365;s:31:\"post-template/style-rtl.min.css\";i:366;s:23:\"post-template/style.css\";i:367;s:27:\"post-template/style.min.css\";i:368;s:24:\"post-terms/style-rtl.css\";i:369;s:28:\"post-terms/style-rtl.min.css\";i:370;s:20:\"post-terms/style.css\";i:371;s:24:\"post-terms/style.min.css\";i:372;s:31:\"post-time-to-read/style-rtl.css\";i:373;s:35:\"post-time-to-read/style-rtl.min.css\";i:374;s:27:\"post-time-to-read/style.css\";i:375;s:31:\"post-time-to-read/style.min.css\";i:376;s:24:\"post-title/style-rtl.css\";i:377;s:28:\"post-title/style-rtl.min.css\";i:378;s:20:\"post-title/style.css\";i:379;s:24:\"post-title/style.min.css\";i:380;s:26:\"preformatted/style-rtl.css\";i:381;s:30:\"preformatted/style-rtl.min.css\";i:382;s:22:\"preformatted/style.css\";i:383;s:26:\"preformatted/style.min.css\";i:384;s:24:\"pullquote/editor-rtl.css\";i:385;s:28:\"pullquote/editor-rtl.min.css\";i:386;s:20:\"pullquote/editor.css\";i:387;s:24:\"pullquote/editor.min.css\";i:388;s:23:\"pullquote/style-rtl.css\";i:389;s:27:\"pullquote/style-rtl.min.css\";i:390;s:19:\"pullquote/style.css\";i:391;s:23:\"pullquote/style.min.css\";i:392;s:23:\"pullquote/theme-rtl.css\";i:393;s:27:\"pullquote/theme-rtl.min.css\";i:394;s:19:\"pullquote/theme.css\";i:395;s:23:\"pullquote/theme.min.css\";i:396;s:39:\"query-pagination-numbers/editor-rtl.css\";i:397;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:398;s:35:\"query-pagination-numbers/editor.css\";i:399;s:39:\"query-pagination-numbers/editor.min.css\";i:400;s:31:\"query-pagination/editor-rtl.css\";i:401;s:35:\"query-pagination/editor-rtl.min.css\";i:402;s:27:\"query-pagination/editor.css\";i:403;s:31:\"query-pagination/editor.min.css\";i:404;s:30:\"query-pagination/style-rtl.css\";i:405;s:34:\"query-pagination/style-rtl.min.css\";i:406;s:26:\"query-pagination/style.css\";i:407;s:30:\"query-pagination/style.min.css\";i:408;s:25:\"query-title/style-rtl.css\";i:409;s:29:\"query-title/style-rtl.min.css\";i:410;s:21:\"query-title/style.css\";i:411;s:25:\"query-title/style.min.css\";i:412;s:25:\"query-total/style-rtl.css\";i:413;s:29:\"query-total/style-rtl.min.css\";i:414;s:21:\"query-total/style.css\";i:415;s:25:\"query-total/style.min.css\";i:416;s:20:\"query/editor-rtl.css\";i:417;s:24:\"query/editor-rtl.min.css\";i:418;s:16:\"query/editor.css\";i:419;s:20:\"query/editor.min.css\";i:420;s:19:\"quote/style-rtl.css\";i:421;s:23:\"quote/style-rtl.min.css\";i:422;s:15:\"quote/style.css\";i:423;s:19:\"quote/style.min.css\";i:424;s:19:\"quote/theme-rtl.css\";i:425;s:23:\"quote/theme-rtl.min.css\";i:426;s:15:\"quote/theme.css\";i:427;s:19:\"quote/theme.min.css\";i:428;s:23:\"read-more/style-rtl.css\";i:429;s:27:\"read-more/style-rtl.min.css\";i:430;s:19:\"read-more/style.css\";i:431;s:23:\"read-more/style.min.css\";i:432;s:18:\"rss/editor-rtl.css\";i:433;s:22:\"rss/editor-rtl.min.css\";i:434;s:14:\"rss/editor.css\";i:435;s:18:\"rss/editor.min.css\";i:436;s:17:\"rss/style-rtl.css\";i:437;s:21:\"rss/style-rtl.min.css\";i:438;s:13:\"rss/style.css\";i:439;s:17:\"rss/style.min.css\";i:440;s:21:\"search/editor-rtl.css\";i:441;s:25:\"search/editor-rtl.min.css\";i:442;s:17:\"search/editor.css\";i:443;s:21:\"search/editor.min.css\";i:444;s:20:\"search/style-rtl.css\";i:445;s:24:\"search/style-rtl.min.css\";i:446;s:16:\"search/style.css\";i:447;s:20:\"search/style.min.css\";i:448;s:20:\"search/theme-rtl.css\";i:449;s:24:\"search/theme-rtl.min.css\";i:450;s:16:\"search/theme.css\";i:451;s:20:\"search/theme.min.css\";i:452;s:24:\"separator/editor-rtl.css\";i:453;s:28:\"separator/editor-rtl.min.css\";i:454;s:20:\"separator/editor.css\";i:455;s:24:\"separator/editor.min.css\";i:456;s:23:\"separator/style-rtl.css\";i:457;s:27:\"separator/style-rtl.min.css\";i:458;s:19:\"separator/style.css\";i:459;s:23:\"separator/style.min.css\";i:460;s:23:\"separator/theme-rtl.css\";i:461;s:27:\"separator/theme-rtl.min.css\";i:462;s:19:\"separator/theme.css\";i:463;s:23:\"separator/theme.min.css\";i:464;s:24:\"shortcode/editor-rtl.css\";i:465;s:28:\"shortcode/editor-rtl.min.css\";i:466;s:20:\"shortcode/editor.css\";i:467;s:24:\"shortcode/editor.min.css\";i:468;s:24:\"site-logo/editor-rtl.css\";i:469;s:28:\"site-logo/editor-rtl.min.css\";i:470;s:20:\"site-logo/editor.css\";i:471;s:24:\"site-logo/editor.min.css\";i:472;s:23:\"site-logo/style-rtl.css\";i:473;s:27:\"site-logo/style-rtl.min.css\";i:474;s:19:\"site-logo/style.css\";i:475;s:23:\"site-logo/style.min.css\";i:476;s:27:\"site-tagline/editor-rtl.css\";i:477;s:31:\"site-tagline/editor-rtl.min.css\";i:478;s:23:\"site-tagline/editor.css\";i:479;s:27:\"site-tagline/editor.min.css\";i:480;s:26:\"site-tagline/style-rtl.css\";i:481;s:30:\"site-tagline/style-rtl.min.css\";i:482;s:22:\"site-tagline/style.css\";i:483;s:26:\"site-tagline/style.min.css\";i:484;s:25:\"site-title/editor-rtl.css\";i:485;s:29:\"site-title/editor-rtl.min.css\";i:486;s:21:\"site-title/editor.css\";i:487;s:25:\"site-title/editor.min.css\";i:488;s:24:\"site-title/style-rtl.css\";i:489;s:28:\"site-title/style-rtl.min.css\";i:490;s:20:\"site-title/style.css\";i:491;s:24:\"site-title/style.min.css\";i:492;s:26:\"social-link/editor-rtl.css\";i:493;s:30:\"social-link/editor-rtl.min.css\";i:494;s:22:\"social-link/editor.css\";i:495;s:26:\"social-link/editor.min.css\";i:496;s:27:\"social-links/editor-rtl.css\";i:497;s:31:\"social-links/editor-rtl.min.css\";i:498;s:23:\"social-links/editor.css\";i:499;s:27:\"social-links/editor.min.css\";i:500;s:26:\"social-links/style-rtl.css\";i:501;s:30:\"social-links/style-rtl.min.css\";i:502;s:22:\"social-links/style.css\";i:503;s:26:\"social-links/style.min.css\";i:504;s:21:\"spacer/editor-rtl.css\";i:505;s:25:\"spacer/editor-rtl.min.css\";i:506;s:17:\"spacer/editor.css\";i:507;s:21:\"spacer/editor.min.css\";i:508;s:20:\"spacer/style-rtl.css\";i:509;s:24:\"spacer/style-rtl.min.css\";i:510;s:16:\"spacer/style.css\";i:511;s:20:\"spacer/style.min.css\";i:512;s:20:\"table/editor-rtl.css\";i:513;s:24:\"table/editor-rtl.min.css\";i:514;s:16:\"table/editor.css\";i:515;s:20:\"table/editor.min.css\";i:516;s:19:\"table/style-rtl.css\";i:517;s:23:\"table/style-rtl.min.css\";i:518;s:15:\"table/style.css\";i:519;s:19:\"table/style.min.css\";i:520;s:19:\"table/theme-rtl.css\";i:521;s:23:\"table/theme-rtl.min.css\";i:522;s:15:\"table/theme.css\";i:523;s:19:\"table/theme.min.css\";i:524;s:24:\"tag-cloud/editor-rtl.css\";i:525;s:28:\"tag-cloud/editor-rtl.min.css\";i:526;s:20:\"tag-cloud/editor.css\";i:527;s:24:\"tag-cloud/editor.min.css\";i:528;s:23:\"tag-cloud/style-rtl.css\";i:529;s:27:\"tag-cloud/style-rtl.min.css\";i:530;s:19:\"tag-cloud/style.css\";i:531;s:23:\"tag-cloud/style.min.css\";i:532;s:28:\"template-part/editor-rtl.css\";i:533;s:32:\"template-part/editor-rtl.min.css\";i:534;s:24:\"template-part/editor.css\";i:535;s:28:\"template-part/editor.min.css\";i:536;s:27:\"template-part/theme-rtl.css\";i:537;s:31:\"template-part/theme-rtl.min.css\";i:538;s:23:\"template-part/theme.css\";i:539;s:27:\"template-part/theme.min.css\";i:540;s:24:\"term-count/style-rtl.css\";i:541;s:28:\"term-count/style-rtl.min.css\";i:542;s:20:\"term-count/style.css\";i:543;s:24:\"term-count/style.min.css\";i:544;s:30:\"term-description/style-rtl.css\";i:545;s:34:\"term-description/style-rtl.min.css\";i:546;s:26:\"term-description/style.css\";i:547;s:30:\"term-description/style.min.css\";i:548;s:23:\"term-name/style-rtl.css\";i:549;s:27:\"term-name/style-rtl.min.css\";i:550;s:19:\"term-name/style.css\";i:551;s:23:\"term-name/style.min.css\";i:552;s:28:\"term-template/editor-rtl.css\";i:553;s:32:\"term-template/editor-rtl.min.css\";i:554;s:24:\"term-template/editor.css\";i:555;s:28:\"term-template/editor.min.css\";i:556;s:27:\"term-template/style-rtl.css\";i:557;s:31:\"term-template/style-rtl.min.css\";i:558;s:23:\"term-template/style.css\";i:559;s:27:\"term-template/style.min.css\";i:560;s:27:\"text-columns/editor-rtl.css\";i:561;s:31:\"text-columns/editor-rtl.min.css\";i:562;s:23:\"text-columns/editor.css\";i:563;s:27:\"text-columns/editor.min.css\";i:564;s:26:\"text-columns/style-rtl.css\";i:565;s:30:\"text-columns/style-rtl.min.css\";i:566;s:22:\"text-columns/style.css\";i:567;s:26:\"text-columns/style.min.css\";i:568;s:19:\"verse/style-rtl.css\";i:569;s:23:\"verse/style-rtl.min.css\";i:570;s:15:\"verse/style.css\";i:571;s:19:\"verse/style.min.css\";i:572;s:20:\"video/editor-rtl.css\";i:573;s:24:\"video/editor-rtl.min.css\";i:574;s:16:\"video/editor.css\";i:575;s:20:\"video/editor.min.css\";i:576;s:19:\"video/style-rtl.css\";i:577;s:23:\"video/style-rtl.min.css\";i:578;s:15:\"video/style.css\";i:579;s:19:\"video/style.min.css\";i:580;s:19:\"video/theme-rtl.css\";i:581;s:23:\"video/theme-rtl.min.css\";i:582;s:15:\"video/theme.css\";i:583;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("126", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("127", "WPLANG", "fr_FR", "auto");
INSERT INTO `wp_options` VALUES("139", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("154", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("158", "new_admin_email", "dev-email@wpengine.local", "auto");
INSERT INTO `wp_options` VALUES("166", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("175", "recently_activated", "a:7:{s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";i:1768324921;s:33:\"duplicate-post/duplicate-post.php\";i:1768321214;s:24:\"wordpress-seo/wp-seo.php\";i:1768321209;s:35:\"autodescription/autodescription.php\";i:1768321048;s:37:\"breadcrumb-navxt/breadcrumb-navxt.php\";i:1767974762;s:53:\"child-theme-configurator/child-theme-configurator.php\";i:1767957729;s:63:\"ultimate-addons-for-gutenberg/ultimate-addons-for-gutenberg.php\";i:1767791813;}", "off");
INSERT INTO `wp_options` VALUES("176", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1765379109;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("177", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"65444a9d92f2c38b8de430a0f6bc8029\";s:6:\"blocks\";a:53:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:18:\"core/term-template\";s:0:\"\";s:12:\"core/columns\";s:769:\":root :where(.wp-block-columns-is-layout-flow) > :first-child{margin-block-start: 0;}:root :where(.wp-block-columns-is-layout-flow) > :last-child{margin-block-end: 0;}:root :where(.wp-block-columns-is-layout-flow) > *{margin-block-start: var(--wp--preset--spacing--50);margin-block-end: 0;}:root :where(.wp-block-columns-is-layout-constrained) > :first-child{margin-block-start: 0;}:root :where(.wp-block-columns-is-layout-constrained) > :last-child{margin-block-end: 0;}:root :where(.wp-block-columns-is-layout-constrained) > *{margin-block-start: var(--wp--preset--spacing--50);margin-block-end: 0;}:root :where(.wp-block-columns-is-layout-flex){gap: var(--wp--preset--spacing--50);}:root :where(.wp-block-columns-is-layout-grid){gap: var(--wp--preset--spacing--50);}\";s:14:\"core/pullquote\";s:306:\":root :where(.wp-block-pullquote){font-size: var(--wp--preset--font-size--xx-large);font-weight: 300;line-height: 1.2;padding-top: var(--wp--preset--spacing--30);padding-bottom: var(--wp--preset--spacing--30);}:root :where(.wp-block-pullquote p:last-of-type){margin-bottom: var(--wp--preset--spacing--30);}\";s:32:\"c48738dcb285a3f6ab83acff204fc486\";s:106:\":root :where(.wp-block-pullquote cite){font-size: var(--wp--preset--font-size--small);font-style: normal;}\";s:11:\"core/avatar\";s:57:\":root :where(.wp-block-avatar img){border-radius: 100px;}\";s:12:\"core/buttons\";s:665:\":root :where(.wp-block-buttons-is-layout-flow) > :first-child{margin-block-start: 0;}:root :where(.wp-block-buttons-is-layout-flow) > :last-child{margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-flow) > *{margin-block-start: 16px;margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-constrained) > :first-child{margin-block-start: 0;}:root :where(.wp-block-buttons-is-layout-constrained) > :last-child{margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-constrained) > *{margin-block-start: 16px;margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-flex){gap: 16px;}:root :where(.wp-block-buttons-is-layout-grid){gap: 16px;}\";s:9:\"core/code\";s:427:\":root :where(.wp-block-code){background-color: var(--wp--preset--color--accent-5);color: var(--wp--preset--color--contrast);font-family: var(--wp--preset--font-family--fira-code);font-size: var(--wp--preset--font-size--medium);font-weight: 300;padding-top: var(--wp--preset--spacing--40);padding-right: var(--wp--preset--spacing--40);padding-bottom: var(--wp--preset--spacing--40);padding-left: var(--wp--preset--spacing--40);}\";s:24:\"core/comment-author-name\";s:169:\":root :where(.wp-block-comment-author-name){color: var(--wp--preset--color--accent-4);font-size: var(--wp--preset--font-size--small);margin-top: 5px;margin-bottom: 0px;}\";s:32:\"c0002c260f8238c4212f3e4c369fc4f7\";s:143:\":root :where(.wp-block-comment-author-name a:where(:not(.wp-element-button))){color: var(--wp--preset--color--accent-4);text-decoration: none;}\";s:32:\"1e7c38b45537b325dbbbaec17a301676\";s:112:\":root :where(.wp-block-comment-author-name a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:20:\"core/comment-content\";s:178:\":root :where(.wp-block-comment-content){font-size: var(--wp--preset--font-size--medium);margin-top: var(--wp--preset--spacing--30);margin-bottom: var(--wp--preset--spacing--30);}\";s:17:\"core/comment-date\";s:127:\":root :where(.wp-block-comment-date){color: var(--wp--preset--color--contrast);font-size: var(--wp--preset--font-size--small);}\";s:32:\"c83ca7b3e52884c70f7830c54f99b318\";s:114:\":root :where(.wp-block-comment-date a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast);}\";s:22:\"core/comment-edit-link\";s:90:\":root :where(.wp-block-comment-edit-link){font-size: var(--wp--preset--font-size--small);}\";s:32:\"41d70710612536a90e368c12bcb0efea\";s:119:\":root :where(.wp-block-comment-edit-link a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast);}\";s:23:\"core/comment-reply-link\";s:91:\":root :where(.wp-block-comment-reply-link){font-size: var(--wp--preset--font-size--small);}\";s:32:\"13c96340dbf37700add1f4c5cae19f3e\";s:120:\":root :where(.wp-block-comment-reply-link a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast);}\";s:23:\"core/post-comments-form\";s:565:\":root :where(.wp-block-post-comments-form){font-size: var(--wp--preset--font-size--medium);padding-top: var(--wp--preset--spacing--40);padding-bottom: var(--wp--preset--spacing--40);}:root :where(.wp-block-post-comments-form textarea, .wp-block-post-comments-form input:not([type=submit])){border-radius:.25rem; border-color: var(--wp--preset--color--accent-6) !important;}:root :where(.wp-block-post-comments-form input[type=checkbox]){margin:0 .2rem 0 0 !important;}:root :where(.wp-block-post-comments-form label){font-size: var(--wp--preset--font-size--small);}\";s:24:\"core/comments-pagination\";s:182:\":root :where(.wp-block-comments-pagination){font-size: var(--wp--preset--font-size--medium);margin-top: var(--wp--preset--spacing--40);margin-bottom: var(--wp--preset--spacing--40);}\";s:29:\"core/comments-pagination-next\";s:98:\":root :where(.wp-block-comments-pagination-next){font-size: var(--wp--preset--font-size--medium);}\";s:32:\"core/comments-pagination-numbers\";s:101:\":root :where(.wp-block-comments-pagination-numbers){font-size: var(--wp--preset--font-size--medium);}\";s:33:\"core/comments-pagination-previous\";s:102:\":root :where(.wp-block-comments-pagination-previous){font-size: var(--wp--preset--font-size--medium);}\";s:14:\"core/post-date\";s:124:\":root :where(.wp-block-post-date){color: var(--wp--preset--color--accent-4);font-size: var(--wp--preset--font-size--small);}\";s:32:\"ac0d4e00f5ec22d14451759983e5bd43\";s:133:\":root :where(.wp-block-post-date a:where(:not(.wp-element-button))){color: var(--wp--preset--color--accent-4);text-decoration: none;}\";s:32:\"0ae6ffd1b886044c2da62d75d05ab13d\";s:102:\":root :where(.wp-block-post-date a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:25:\"core/post-navigation-link\";s:94:\":root :where(.wp-block-post-navigation-link){font-size: var(--wp--preset--font-size--medium);}\";s:15:\"core/post-terms\";s:158:\":root :where(.wp-block-post-terms){font-size: var(--wp--preset--font-size--small);font-weight: 600;}:root :where(.wp-block-post-terms a){white-space: nowrap;}\";s:15:\"core/post-title\";s:0:\"\";s:32:\"bb496d3fcd9be3502ce57ff8281e5687\";s:92:\":root :where(.wp-block-post-title a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"12380ab98fdc81351bb32a39bbfc9249\";s:103:\":root :where(.wp-block-post-title a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:10:\"core/quote\";s:1315:\":root :where(.wp-block-quote){border-color: currentColor;border-width: 0 0 0 2px;border-style: solid;font-size: var(--wp--preset--font-size--large);font-weight: 300;margin-right: 0;margin-left: 0;padding-top: var(--wp--preset--spacing--30);padding-right: var(--wp--preset--spacing--40);padding-bottom: var(--wp--preset--spacing--30);padding-left: var(--wp--preset--spacing--40);}:root :where(.wp-block-quote-is-layout-flow) > :first-child{margin-block-start: 0;}:root :where(.wp-block-quote-is-layout-flow) > :last-child{margin-block-end: 0;}:root :where(.wp-block-quote-is-layout-flow) > *{margin-block-start: var(--wp--preset--spacing--30);margin-block-end: 0;}:root :where(.wp-block-quote-is-layout-constrained) > :first-child{margin-block-start: 0;}:root :where(.wp-block-quote-is-layout-constrained) > :last-child{margin-block-end: 0;}:root :where(.wp-block-quote-is-layout-constrained) > *{margin-block-start: var(--wp--preset--spacing--30);margin-block-end: 0;}:root :where(.wp-block-quote-is-layout-flex){gap: var(--wp--preset--spacing--30);}:root :where(.wp-block-quote-is-layout-grid){gap: var(--wp--preset--spacing--30);}:root :where(.wp-block-quote.has-text-align-right ){border-width: 0 2px 0 0;}:root :where(.wp-block-quote.has-text-align-center ){border-width: 0;border-inline: 0; padding-inline: 0;}\";s:32:\"1de7a22e22013106efc5be82788cb6c0\";s:176:\":root :where(.wp-block-quote cite){font-size: var(--wp--preset--font-size--small);font-style: normal;font-weight: 300;}:root :where(.wp-block-quote cite sub){font-size: 0.65em}\";s:21:\"core/query-pagination\";s:107:\":root :where(.wp-block-query-pagination){font-size: var(--wp--preset--font-size--medium);font-weight: 500;}\";s:11:\"core/search\";s:380:\":root :where(.wp-block-search .wp-block-search__label, .wp-block-search .wp-block-search__input, .wp-block-search .wp-block-search__button){font-size: var(--wp--preset--font-size--medium);line-height: 1.6;}:root :where(.wp-block-search .wp-block-search__input){border-radius:3.125rem;padding-left:1.5625rem;padding-right:1.5625rem;border-color:var(--wp--preset--color--accent-6);}\";s:32:\"14fa6a3d0cfbde171cbc0fb04aa8a6cf\";s:138:\":root :where(.wp-block-search .wp-element-button,.wp-block-search  .wp-block-button__link){border-radius: 3.125rem;margin-left: 1.125rem;}\";s:32:\"05993ee2f3de94b5d1350998a7e9b6b0\";s:130:\":root :where(.wp-block-search .wp-element-button:hover,.wp-block-search  .wp-block-button__link:hover){border-color: transparent;}\";s:14:\"core/separator\";s:148:\":root :where(.wp-block-separator){border-color: currentColor;border-width: 0 0 1px 0;border-style: solid;color: var(--wp--preset--color--accent-6);}\";s:17:\"core/site-tagline\";s:86:\":root :where(.wp-block-site-tagline){font-size: var(--wp--preset--font-size--medium);}\";s:15:\"core/site-title\";s:75:\":root :where(.wp-block-site-title){font-weight: 700;letter-spacing: -.5px;}\";s:32:\"f513d889cf971b13995cc3fffed2f39b\";s:92:\":root :where(.wp-block-site-title a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"22c37a317cc0ebd50155b5ad78564f37\";s:103:\":root :where(.wp-block-site-title a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:21:\"core/term-description\";s:90:\":root :where(.wp-block-term-description){font-size: var(--wp--preset--font-size--medium);}\";s:15:\"core/navigation\";s:84:\":root :where(.wp-block-navigation){font-size: var(--wp--preset--font-size--medium);}\";s:32:\"25289a01850f5a0264ddb79a9a3baf3d\";s:92:\":root :where(.wp-block-navigation a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"026c04da08398d655a95047f1f235d97\";s:103:\":root :where(.wp-block-navigation a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:9:\"core/list\";s:52:\":root :where(.wp-block-list li){margin-top: 0.5rem;}\";s:12:\"core/heading\";s:0:\"\";s:14:\"core/paragraph\";s:0:\"\";s:10:\"core/group\";s:0:\"\";s:11:\"core/column\";s:0:\"\";}}", "on");
INSERT INTO `wp_options` VALUES("191", "theme_mods_Salamandre", "a:4:{s:18:\"custom_css_post_id\";i:6;s:16:\"sidebars_widgets\";a:2:{s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}s:4:\"time\";i:1765378982;}s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}}", "on");
INSERT INTO `wp_options` VALUES("194", "current_theme", "Salamandre", "auto");
INSERT INTO `wp_options` VALUES("195", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("247", "site_logo", "93", "auto");
INSERT INTO `wp_options` VALUES("331", "duplicate_post_show_notice", "1", "auto");
INSERT INTO `wp_options` VALUES("332", "duplicate_post_copytitle", "1", "auto");
INSERT INTO `wp_options` VALUES("333", "duplicate_post_copydate", "0", "auto");
INSERT INTO `wp_options` VALUES("334", "duplicate_post_copystatus", "0", "auto");
INSERT INTO `wp_options` VALUES("335", "duplicate_post_copyslug", "0", "auto");
INSERT INTO `wp_options` VALUES("336", "duplicate_post_copyexcerpt", "1", "auto");
INSERT INTO `wp_options` VALUES("337", "duplicate_post_copycontent", "1", "auto");
INSERT INTO `wp_options` VALUES("338", "duplicate_post_copythumbnail", "1", "auto");
INSERT INTO `wp_options` VALUES("339", "duplicate_post_copytemplate", "1", "auto");
INSERT INTO `wp_options` VALUES("340", "duplicate_post_copyformat", "1", "auto");
INSERT INTO `wp_options` VALUES("341", "duplicate_post_copyauthor", "0", "auto");
INSERT INTO `wp_options` VALUES("342", "duplicate_post_copypassword", "0", "auto");
INSERT INTO `wp_options` VALUES("343", "duplicate_post_copyattachments", "0", "auto");
INSERT INTO `wp_options` VALUES("344", "duplicate_post_copychildren", "0", "auto");
INSERT INTO `wp_options` VALUES("345", "duplicate_post_copycomments", "0", "auto");
INSERT INTO `wp_options` VALUES("346", "duplicate_post_copymenuorder", "1", "auto");
INSERT INTO `wp_options` VALUES("347", "duplicate_post_taxonomies_blacklist", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("348", "duplicate_post_blacklist", "", "auto");
INSERT INTO `wp_options` VALUES("349", "duplicate_post_types_enabled", "a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}", "auto");
INSERT INTO `wp_options` VALUES("350", "duplicate_post_show_original_column", "0", "auto");
INSERT INTO `wp_options` VALUES("351", "duplicate_post_show_original_in_post_states", "0", "auto");
INSERT INTO `wp_options` VALUES("352", "duplicate_post_show_original_meta_box", "0", "auto");
INSERT INTO `wp_options` VALUES("353", "duplicate_post_show_link", "a:3:{s:9:\"new_draft\";s:1:\"1\";s:5:\"clone\";s:1:\"1\";s:17:\"rewrite_republish\";s:1:\"1\";}", "auto");
INSERT INTO `wp_options` VALUES("354", "duplicate_post_show_link_in", "a:4:{s:3:\"row\";s:1:\"1\";s:8:\"adminbar\";s:1:\"1\";s:9:\"submitbox\";s:1:\"1\";s:11:\"bulkactions\";s:1:\"1\";}", "auto");
INSERT INTO `wp_options` VALUES("355", "duplicate_post_version", "4.5", "auto");
INSERT INTO `wp_options` VALUES("359", "_transient_health-check-site-status-result", "{\"good\":16,\"recommended\":5,\"critical\":0}", "on");
INSERT INTO `wp_options` VALUES("554", "wp_calendar_block_has_published_posts", "", "auto");
INSERT INTO `wp_options` VALUES("685", "_site_transient_timeout_feed_mod_0d2db5fea5a8633b56992c916819b198", "1768341847", "off");
INSERT INTO `wp_options` VALUES("686", "_site_transient_feed_mod_0d2db5fea5a8633b56992c916819b198", "1768298647", "off");
INSERT INTO `wp_options` VALUES("689", "_site_transient_timeout_feed_mod_b0b1001e5bc3fbacad8b49ec075d19a5", "1768341847", "off");
INSERT INTO `wp_options` VALUES("690", "_site_transient_feed_mod_b0b1001e5bc3fbacad8b49ec075d19a5", "1768298647", "off");
INSERT INTO `wp_options` VALUES("922", "kadence_blocks_schema_version", "1", "auto");
INSERT INTO `wp_options` VALUES("923", "stellarwp_telemetry_last_send", "", "auto");
INSERT INTO `wp_options` VALUES("924", "stellarwp_telemetry", "a:1:{s:7:\"plugins\";a:1:{s:14:\"kadence-blocks\";a:2:{s:7:\"wp_slug\";s:33:\"kadence-blocks/kadence-blocks.php\";s:5:\"optin\";b:0;}}}", "auto");
INSERT INTO `wp_options` VALUES("925", "stellarwp_telemetry_kadence-blocks_show_optin", "0", "auto");
INSERT INTO `wp_options` VALUES("926", "kadenceblocks_data_settings", "a:4:{s:10:\"db_version\";i:0;s:15:\"version_history\";a:3:{i:1768043380;s:6:\"3.5.31\";i:1767957694;s:6:\"3.5.30\";i:0;s:3:\"new\";}s:13:\"prior_version\";s:6:\"3.5.30\";s:15:\"current_version\";s:6:\"3.5.31\";}", "auto");
INSERT INTO `wp_options` VALUES("927", "__uagb_do_redirect", "", "auto");
INSERT INTO `wp_options` VALUES("928", "__uagb_activated_before", "1", "auto");
INSERT INTO `wp_options` VALUES("929", "__uagb_asset_version", "1767791670", "auto");
INSERT INTO `wp_options` VALUES("930", "uagb_site_url", "salamandre-clone-local", "auto");
INSERT INTO `wp_options` VALUES("931", "uagb_block_analytics_status", "a:1:{s:15:\"first_run_check\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("932", "_uagb_allow_file_generation", "enabled", "auto");
INSERT INTO `wp_options` VALUES("933", "uagb-version", "2.19.17", "auto");
INSERT INTO `wp_options` VALUES("934", "spectra_analytics_installed_time", "1767791663", "off");
INSERT INTO `wp_options` VALUES("935", "ast-block-templates-version", "2.4.8", "auto");
INSERT INTO `wp_options` VALUES("936", "_transient_timeout_uag_rollback_versions_2.19.17", "1768396463", "off");
INSERT INTO `wp_options` VALUES("937", "_transient_uag_rollback_versions_2.19.17", "a:10:{i:0;s:7:\"2.19.16\";i:1;s:7:\"2.19.15\";i:2;s:7:\"2.19.14\";i:3;s:7:\"2.19.13\";i:4;s:7:\"2.19.12\";i:5;s:7:\"2.19.11\";i:6;s:7:\"2.19.10\";i:7;s:6:\"2.19.9\";i:8;s:6:\"2.19.8\";i:9;s:6:\"2.19.7\";}", "off");
INSERT INTO `wp_options` VALUES("938", "uag_content_width_set_by", "Styles globaux de l’éditeur de site", "auto");
INSERT INTO `wp_options` VALUES("941", "nps-survey-spectra", "a:6:{s:13:\"dismiss_count\";i:0;s:19:\"dismiss_permanently\";b:0;s:12:\"dismiss_step\";s:0:\"\";s:12:\"dismiss_time\";s:0:\"\";s:16:\"dismiss_timespan\";N;s:17:\"first_render_time\";i:1767791664;}", "auto");
INSERT INTO `wp_options` VALUES("942", "uag_container_global_padding", "10", "auto");
INSERT INTO `wp_options` VALUES("943", "ast_block_templates_fresh_site", "no", "auto");
INSERT INTO `wp_options` VALUES("944", "ast_blocks_sync_in_progress", "no", "off");
INSERT INTO `wp_options` VALUES("945", "ast-block-templates-last-export-checksums-time", "1767791734", "off");
INSERT INTO `wp_options` VALUES("1081", "_site_transient_timeout_community-events-d41d8cd98f00b204e9800998ecf8427e", "1768364348", "off");
INSERT INTO `wp_options` VALUES("1082", "_site_transient_community-events-d41d8cd98f00b204e9800998ecf8427e", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";b:0;}s:6:\"events\";a:2:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:20:\"WordPress Werkstatt \";s:3:\"url\";s:56:\"https://www.meetup.com/wordpress-baden/events/312815480/\";s:6:\"meetup\";s:15:\"WordPress Baden\";s:10:\"meetup_url\";s:39:\"https://www.meetup.com/WordPress-Baden/\";s:4:\"date\";s:19:\"2026-02-03 18:00:00\";s:8:\"end_date\";s:19:\"2026-02-03 20:00:00\";s:20:\"start_unix_timestamp\";i:1770138000;s:18:\"end_unix_timestamp\";i:1770145200;s:8:\"location\";a:4:{s:8:\"location\";s:18:\"Baden, Switzerland\";s:7:\"country\";s:2:\"ch\";s:8:\"latitude\";d:47.483919999999998;s:9:\"longitude\";d:8.2805669999999996;}}i:1;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:20:\"WordCamp Torino 2026\";s:3:\"url\";s:33:\"https://torino.wordcamp.org/2026/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2026-05-08 00:00:00\";s:8:\"end_date\";s:19:\"2026-05-09 00:00:00\";s:20:\"start_unix_timestamp\";i:1778191200;s:18:\"end_unix_timestamp\";i:1778277600;s:8:\"location\";a:4:{s:8:\"location\";s:14:\"Torino (Italy)\";s:7:\"country\";s:2:\"IT\";s:8:\"latitude\";d:45.050186600000004;s:9:\"longitude\";d:7.6688508999999998;}}}}", "off");
INSERT INTO `wp_options` VALUES("1104", "wp_gs_logo_slider_db_version", "1.0", "auto");
INSERT INTO `wp_options` VALUES("1105", "gs_logo_slider_version", "3.8.1", "auto");
INSERT INTO `wp_options` VALUES("1106", "gslogo_term_order_column_done", "1", "auto");
INSERT INTO `wp_options` VALUES("1116", "gslogo_dummy_logo_data_created", "1", "auto");
INSERT INTO `wp_options` VALUES("1119", "gslogo_dummy_shortcode_data_created", "1", "auto");
INSERT INTO `wp_options` VALUES("1120", "gs_logo_autoimport_done", "1", "auto");
INSERT INTO `wp_options` VALUES("1129", "logo-category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("1296", "kadence_blocks_settings", "{\"enable_custom_css_indicator\":true}", "auto");
INSERT INTO `wp_options` VALUES("1374", "widget_bcn_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("1394", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"26.7\";}", "auto");
INSERT INTO `wp_options` VALUES("1395", "wpseo", "a:121:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";s:5:\"false\";s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:13:\"first_install\";s:29:\"indexables_indexing_completed\";b:0;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"26.7\";s:16:\"previous_version\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:12:\"ahrefsverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:1;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";s:10:\"1767974792\";s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:29:\"http://salamandre-clone.local\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:1:{s:13:\"logo-category\";s:13:\"logo-category\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:4:{i:0;s:15:\"optimizeSeoData\";i:1;s:18:\"siteRepresentation\";i:2;s:14:\"socialProfiles\";i:3;s:19:\"personalPreferences\";}s:36:\"dismiss_configuration_workout_notice\";b:1;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:1;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";s:10:\"1767974792\";s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:14:\"gs-logo-slider\";}s:28:\"last_known_public_taxonomies\";a:3:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";}s:23:\"last_known_no_unindexed\";a:1:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1767974810;}s:14:\"new_post_types\";a:0:{}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:0;s:44:\"site_kit_configuration_permanently_dismissed\";b:0;s:18:\"site_kit_connected\";b:0;s:37:\"site_kit_tracking_setup_widget_loaded\";s:3:\"yes\";s:41:\"site_kit_tracking_first_interaction_stage\";s:7:\"install\";s:40:\"site_kit_tracking_last_interaction_stage\";s:7:\"install\";s:52:\"site_kit_tracking_setup_widget_temporarily_dismissed\";s:2:\"no\";s:52:\"site_kit_tracking_setup_widget_permanently_dismissed\";s:2:\"no\";s:31:\"google_site_kit_feature_enabled\";b:0;s:25:\"ai_free_sparks_started_on\";s:4:\"null\";s:15:\"enable_llms_txt\";b:0;s:15:\"last_updated_on\";b:0;s:17:\"default_seo_title\";a:0:{}s:21:\"default_seo_meta_desc\";a:0:{}s:18:\"first_activated_by\";s:1:\"1\";s:16:\"enable_task_list\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("1396", "wpseo_titles", "a:138:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:50:\"%%name%%, auteur/autrice sur %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:65:\"Vous avez cherché %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:38:\"Page non trouvée %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:64:\"L’article %%POSTLINK%% est apparu en premier sur %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:30:\"Erreur 404 : Page introuvable\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:13:\"Archives pour\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:7:\"Accueil\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:18:\"Vous avez cherché\";s:15:\"breadcrumbs-sep\";s:1:\"/\";s:12:\"website_name\";s:10:\"Salamandre\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:10:\"Salamandre\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";i:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:15:\"org-description\";s:0:\"\";s:9:\"org-email\";s:0:\"\";s:9:\"org-phone\";s:0:\"\";s:14:\"org-legal-name\";s:0:\"\";s:17:\"org-founding-date\";s:0:\"\";s:20:\"org-number-employees\";s:0:\"\";s:10:\"org-vat-id\";s:0:\"\";s:10:\"org-tax-id\";s:0:\"\";s:7:\"org-iso\";s:0:\"\";s:8:\"org-duns\";s:0:\"\";s:11:\"org-leicode\";s:0:\"\";s:9:\"org-naics\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:18:\"title-tax-category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:27:\"Archives des %%term_title%%\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:27:\"Archives des %%term_title%%\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:27:\"Archives des %%term_title%%\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:20:\"title-gs-logo-slider\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-gs-logo-slider\";s:0:\"\";s:22:\"noindex-gs-logo-slider\";b:0;s:33:\"display-metabox-pt-gs-logo-slider\";b:1;s:33:\"post_types-gs-logo-slider-maintax\";i:0;s:31:\"schema-page-type-gs-logo-slider\";s:7:\"WebPage\";s:34:\"schema-article-type-gs-logo-slider\";s:4:\"None\";s:27:\"social-title-gs-logo-slider\";s:9:\"%%title%%\";s:33:\"social-description-gs-logo-slider\";s:0:\"\";s:31:\"social-image-url-gs-logo-slider\";s:0:\"\";s:30:\"social-image-id-gs-logo-slider\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "auto");
INSERT INTO `wp_options` VALUES("1397", "wpseo_social", "a:20:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:13:\"Salamandre_tm\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:1:{i:0;s:46:\"https://www.linkedin.com/company/salamandre_tm\";}s:12:\"mastodon_url\";s:0:\"\";}", "auto");
INSERT INTO `wp_options` VALUES("1398", "wpseo_llmstxt", "a:7:{s:23:\"llms_txt_selection_mode\";s:4:\"auto\";s:13:\"about_us_page\";i:0;s:12:\"contact_page\";i:0;s:10:\"terms_page\";i:0;s:19:\"privacy_policy_page\";i:0;s:9:\"shop_page\";i:0;s:20:\"other_included_pages\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("1471", "kadence_blocks_header_notice_dismissed", "1", "auto");
INSERT INTO `wp_options` VALUES("1587", "_site_transient_timeout_php_check_64a39130b63a997cea1ee4f2b9432afe", "1768673210", "off");
INSERT INTO `wp_options` VALUES("1588", "_site_transient_php_check_64a39130b63a997cea1ee4f2b9432afe", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("1649", "wpfront-scroll-top-options", "a:46:{s:7:\"enabled\";b:1;s:16:\"javascript_async\";b:0;s:13:\"scroll_offset\";i:100;s:12:\"button_width\";i:40;s:13:\"button_height\";i:40;s:14:\"button_opacity\";i:80;s:20:\"button_fade_duration\";i:0;s:15:\"scroll_duration\";i:400;s:9:\"auto_hide\";b:0;s:15:\"auto_hide_after\";i:2;s:17:\"hide_small_window\";b:0;s:18:\"small_window_width\";i:640;s:12:\"hide_wpadmin\";b:1;s:11:\"hide_iframe\";b:1;s:12:\"button_style\";s:5:\"image\";s:13:\"button_action\";s:3:\"top\";s:30:\"button_action_element_selector\";s:0:\"\";s:32:\"button_action_container_selector\";s:10:\"html, body\";s:28:\"button_action_element_offset\";i:0;s:22:\"button_action_page_url\";s:0:\"\";s:8:\"location\";i:1;s:8:\"margin_x\";i:20;s:8:\"margin_y\";i:20;s:13:\"display_pages\";i:1;s:13:\"include_pages\";s:0:\"\";s:13:\"exclude_pages\";s:0:\"\";s:5:\"image\";s:5:\"1.png\";s:9:\"image_alt\";s:0:\"\";s:11:\"image_title\";s:0:\"\";s:10:\"custom_url\";s:0:\"\";s:16:\"text_button_text\";s:0:\"\";s:22:\"text_button_text_color\";s:7:\"#FFFFFF\";s:28:\"text_button_background_color\";s:7:\"#000000\";s:23:\"text_button_hover_color\";s:7:\"#000000\";s:15:\"text_button_css\";s:0:\"\";s:15:\"fa_button_class\";s:0:\"\";s:13:\"fa_button_url\";s:0:\"\";s:21:\"fa_button_exclude_url\";b:0;s:20:\"fa_button_text_color\";s:7:\"#000000\";s:13:\"fa_button_css\";s:0:\"\";s:24:\"accessibility_aria_label\";s:0:\"\";s:19:\"accessibility_title\";s:0:\"\";s:32:\"accessibility_screen_reader_text\";s:0:\"\";s:16:\"css_enqueue_file\";b:0;s:13:\"css_extra_css\";s:0:\"\";s:12:\"last_updated\";i:1768235144;}", "off");
INSERT INTO `wp_options` VALUES("1721", "category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("1735", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:44:\"simple-sitemap/vendor/freemius/wordpress-sdk\";O:8:\"stdClass\":4:{s:7:\"version\";s:6:\"2.12.0\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1768147247;s:11:\"plugin_path\";s:33:\"simple-sitemap/simple-sitemap.php\";}}s:7:\"abspath\";s:55:\"C:\\Users\\peaxw\\Local Sites\\salamandre-clone\\app\\public/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:33:\"simple-sitemap/simple-sitemap.php\";s:8:\"sdk_path\";s:44:\"simple-sitemap/vendor/freemius/wordpress-sdk\";s:7:\"version\";s:6:\"2.12.0\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1768147247;}}", "auto");
INSERT INTO `wp_options` VALUES("1736", "fs_debug_mode", "", "auto");
INSERT INTO `wp_options` VALUES("1737", "fs_accounts", "a:7:{s:21:\"id_slug_type_path_map\";a:1:{i:4087;a:3:{s:4:\"slug\";s:14:\"simple-sitemap\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:33:\"simple-sitemap/simple-sitemap.php\";}}s:11:\"plugin_data\";a:1:{s:14:\"simple-sitemap\";a:17:{s:19:\"last_load_timestamp\";i:1768320142;s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:33:\"simple-sitemap/simple-sitemap.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1768147247;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:6:\"2.12.0\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"3.6.1\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";N;s:4:\"host\";s:22:\"salamandre-clone.local\";s:9:\"server_ip\";s:9:\"127.0.0.1\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1768147247;s:7:\"version\";s:5:\"3.6.1\";}s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1768147255;s:7:\"version\";s:5:\"3.6.1\";}}}s:13:\"file_slug_map\";a:1:{s:33:\"simple-sitemap/simple-sitemap.php\";s:14:\"simple-sitemap\";}s:7:\"plugins\";a:1:{s:14:\"simple-sitemap\";O:9:\"FS_Plugin\":24:{s:2:\"id\";s:4:\"4087\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;s:10:\"public_key\";s:32:\"pk_d7776ef9a819e02b17ef810b17551\";s:10:\"secret_key\";N;s:16:\"parent_plugin_id\";N;s:5:\"title\";s:14:\"Simple Sitemap\";s:4:\"slug\";s:14:\"simple-sitemap\";s:12:\"premium_slug\";s:18:\"simple-sitemap-pro\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:33:\"simple-sitemap/simple-sitemap.php\";s:7:\"version\";s:5:\"3.6.1\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:3:\"Pro\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;}}s:12:\"gc_timestamp\";a:0:{}s:10:\"theme_data\";a:0:{}s:9:\"unique_id\";s:32:\"17f553e25fa24692cd45f6e05adad995\";}", "auto");
INSERT INTO `wp_options` VALUES("1738", "fs_api_cache", "a:2:{s:30:\"get:/v1/plugins/4087/info.json\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":3:{s:4:\"path\";s:29:\":/plugins/plugin_id/info.json\";s:5:\"error\";O:8:\"stdClass\":5:{s:4:\"type\";s:12:\"ItemNotFound\";s:7:\"message\";s:27:\"Plugin_info 4087 not found.\";s:4:\"code\";s:21:\"plugin_info_not_found\";s:4:\"http\";i:404;s:9:\"timestamp\";s:31:\"Sun, 11 Jan 2026 16:00:48 +0000\";}s:7:\"request\";O:8:\"stdClass\":2:{s:11:\"sdk_version\";s:6:\"2.12.0\";s:9:\"plugin_id\";s:4:\"4087\";}}s:7:\"created\";i:1768147248;s:9:\"timestamp\";i:1768449648;}s:115:\"get:/v1/plugins/4087/pricing.json?is_enriched=1&trial=0&sandbox=0&s_ctx_type=0&s_ctx_id=0&s_ctx_ts=0&s_ctx_secure=0\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":12:{s:6:\"plugin\";O:8:\"stdClass\":13:{s:16:\"parent_plugin_id\";N;s:4:\"slug\";s:14:\"simple-sitemap\";s:5:\"title\";s:14:\"Simple Sitemap\";s:4:\"icon\";s:99:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/4087/icons/1a0464d9040e87c1a650d5b2112463de.png\";s:17:\"money_back_period\";i:30;s:13:\"refund_policy\";s:6:\"strict\";s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_d7776ef9a819e02b17ef810b17551\";s:2:\"id\";s:4:\"4087\";s:18:\"selling_unit_label\";O:8:\"stdClass\":2:{s:8:\"singular\";s:4:\"Site\";s:6:\"plural\";s:5:\"Sites\";}s:19:\"is_wp_org_compliant\";b:1;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:19:\"has_premium_version\";b:1;}s:5:\"plans\";a:2:{i:0;O:8:\"stdClass\":22:{s:9:\"plugin_id\";s:4:\"4087\";s:4:\"name\";s:4:\"free\";s:5:\"title\";s:4:\"Free\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";s:21:\"hello@wpgoplugins.com\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:4:\"6603\";s:7:\"created\";s:19:\"2019-07-10 08:42:18\";s:7:\"updated\";s:19:\"2019-07-11 12:34:03\";}i:1;O:8:\"stdClass\":24:{s:9:\"plugin_id\";s:4:\"4087\";s:4:\"name\";s:3:\"pro\";s:5:\"title\";s:3:\"Pro\";s:11:\"description\";s:0:\"\";s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:0;s:25:\"is_block_features_monthly\";b:0;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";s:21:\"hello@wpgoplugins.com\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:1;s:9:\"is_hidden\";b:0;s:2:\"id\";s:4:\"6617\";s:7:\"created\";s:19:\"2019-07-11 08:26:58\";s:7:\"updated\";s:19:\"2019-07-17 15:48:36\";s:7:\"pricing\";a:3:{i:0;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:4:\"6617\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";d:29.989999999999998;s:14:\"lifetime_price\";N;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:4:\"6018\";s:7:\"created\";s:19:\"2019-07-11 08:31:53\";s:7:\"updated\";s:19:\"2020-09-07 14:17:30\";s:8:\"currency\";s:3:\"usd\";}i:1;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:4:\"6617\";s:8:\"licenses\";i:3;s:13:\"monthly_price\";N;s:12:\"annual_price\";d:79.989999999999995;s:14:\"lifetime_price\";N;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:4:\"6020\";s:7:\"created\";s:19:\"2019-07-11 08:33:28\";s:7:\"updated\";s:19:\"2019-08-26 11:53:28\";s:8:\"currency\";s:3:\"usd\";}i:2;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:4:\"6617\";s:8:\"licenses\";N;s:13:\"monthly_price\";N;s:12:\"annual_price\";d:129.99000000000001;s:14:\"lifetime_price\";N;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:4:\"6021\";s:7:\"created\";s:19:\"2019-07-11 08:34:25\";s:7:\"updated\";s:19:\"2019-08-26 11:52:51\";s:8:\"currency\";s:3:\"usd\";}}s:8:\"features\";a:19:{i:0;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:17:\"Priority support!\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"9099\";s:7:\"created\";s:19:\"2021-02-26 12:00:00\";s:7:\"updated\";N;}i:1;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:23:\"Build sitemaps visually\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"9097\";s:7:\"created\";s:19:\"2021-02-26 11:56:54\";s:7:\"updated\";s:19:\"2021-02-26 12:00:24\";}i:2;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:37:\"No coding required for customization!\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4979\";s:7:\"created\";s:19:\"2019-07-11 08:55:29\";s:7:\"updated\";N;}i:3;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:28:\"Preview changes in real-time\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"9098\";s:7:\"created\";s:19:\"2021-02-26 11:57:14\";s:7:\"updated\";N;}i:4;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:34:\"FREE localhost license for testing\";s:11:\"description\";s:142:\"Install and activate the plugin on a local development site for testing purposes, without it affecting the number of site license activations.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4967\";s:7:\"created\";s:19:\"2019-07-11 08:39:44\";s:7:\"updated\";s:19:\"2019-07-12 10:14:40\";}i:5;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:20:\"TWO - Sitemap blocks\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"5050\";s:7:\"created\";s:19:\"2019-07-22 09:49:05\";s:7:\"updated\";s:19:\"2021-02-26 11:58:59\";}i:6;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:25:\"FIVE - Sitemap shortcodes\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"5049\";s:7:\"created\";s:19:\"2019-07-22 09:48:29\";s:7:\"updated\";s:19:\"2021-02-26 11:59:07\";}i:7;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:26:\"Supports custom post types\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4964\";s:7:\"created\";s:19:\"2019-07-11 08:36:44\";s:7:\"updated\";s:19:\"2021-02-26 11:59:22\";}i:8;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:22:\"Exclude specific pages\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4972\";s:7:\"created\";s:19:\"2019-07-11 08:52:16\";s:7:\"updated\";s:19:\"2019-07-22 08:56:25\";}i:9;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:28:\"Include ONLY specified pages\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4973\";s:7:\"created\";s:19:\"2019-07-11 08:52:23\";s:7:\"updated\";s:19:\"2019-07-22 08:56:40\";}i:10;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:34:\"Customize styles via control panel\";s:11:\"description\";s:152:\"e.g. edit tab colors via color picker controls. There are MANY other controls available to help configure your sitemap. Who needs shortcodes anymore? :)\";s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4974\";s:7:\"created\";s:19:\"2019-07-11 08:52:37\";s:7:\"updated\";s:19:\"2019-07-12 09:03:11\";}i:11;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:30:\"Advanced tabbed layout options\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4966\";s:7:\"created\";s:19:\"2019-07-11 08:38:49\";s:7:\"updated\";s:19:\"2019-07-22 08:56:53\";}i:12;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:24:\"List posts by taxonomies\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4965\";s:7:\"created\";s:19:\"2019-07-11 08:37:27\";s:7:\"updated\";s:19:\"2019-07-22 08:57:02\";}i:13;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:30:\"Display list of taxonomy terms\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4971\";s:7:\"created\";s:19:\"2019-07-11 08:51:32\";s:7:\"updated\";s:19:\"2019-07-22 08:57:31\";}i:14;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:24:\"Responsive tabbed layout\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4968\";s:7:\"created\";s:19:\"2019-07-11 08:40:15\";s:7:\"updated\";s:19:\"2021-02-26 12:01:44\";}i:15;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:25:\"Horizontal sitemap layout\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4969\";s:7:\"created\";s:19:\"2019-07-11 08:40:56\";s:7:\"updated\";s:19:\"2021-02-26 12:02:07\";}i:16;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:28:\"Add custom menus to sitemaps\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4970\";s:7:\"created\";s:19:\"2019-07-11 08:41:37\";s:7:\"updated\";s:19:\"2021-02-26 12:02:27\";}i:17;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:39:\"Filter sitemap title (e.g. if too long)\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4975\";s:7:\"created\";s:19:\"2019-07-11 08:53:50\";s:7:\"updated\";s:19:\"2019-07-15 10:46:07\";}i:18;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:4:\"6617\";s:9:\"plugin_id\";s:4:\"4087\";s:5:\"title\";s:27:\"Shortcode aliases available\";s:11:\"description\";s:125:\"All shortcodes have aliases available to help speed up entering shortcodes. e.g. you can use [ss] instead of [simple-sitemap]\";s:11:\"is_featured\";b:1;s:2:\"id\";s:4:\"4978\";s:7:\"created\";s:19:\"2019-07-11 08:55:12\";s:7:\"updated\";s:19:\"2019-07-11 10:45:42\";}}}}s:7:\"reviews\";a:21:{i:0;O:8:\"stdClass\":22:{s:5:\"first\";s:5:\"Peter\";s:4:\"last\";s:6:\"Warren\";s:5:\"email\";s:16:\"more@dotco.co.uk\";s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"1098105\";s:4:\"rate\";i:100;s:5:\"title\";s:12:\"Just the job\";s:4:\"text\";s:38:\"Really simple to use and great support\";s:4:\"name\";s:11:\"stewarthunt\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:6:\"989790\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"10489\";s:7:\"created\";s:19:\"2022-08-29 14:39:53\";s:7:\"updated\";s:19:\"2022-12-05 18:32:34\";}i:1;O:8:\"stdClass\":22:{s:5:\"first\";s:6:\"Thomas\";s:4:\"last\";s:8:\"Marchido\";s:5:\"email\";s:22:\"tom@tscottmarchido.com\";s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"4347607\";s:4:\"rate\";i:100;s:5:\"title\";s:22:\"Simple is in the name!\";s:4:\"text\";s:305:\"With all of us way too busy for our own good, wouldn\'t it be nice if we could just download a useful plugin and it just works? Simple Sitemap is one that does work right out of the box. And, the extra ranking bump from the engines for making our sites easier to navigate is a huge plus! Worth every penny.\";s:4:\"name\";s:15:\"Thomas Marchido\";s:9:\"job_title\";s:5:\"Owner\";s:7:\"company\";s:20:\"Affiliate Milestones\";s:11:\"company_url\";s:31:\"https://affiliatemilestones.com\";s:7:\"picture\";s:101:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/4087/reviews/4ce997214f0674e4af06d530c38c4f26.jpg\";s:11:\"profile_url\";N;s:10:\"license_id\";s:6:\"986116\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"10456\";s:7:\"created\";s:19:\"2022-08-21 16:57:42\";s:7:\"updated\";s:19:\"2022-12-05 18:32:33\";}i:2;O:8:\"stdClass\":22:{s:5:\"first\";s:4:\"Kuno\";s:4:\"last\";s:8:\"Arnkilde\";s:5:\"email\";s:16:\"kuno@arnkilde.dk\";s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"1756653\";s:4:\"rate\";i:100;s:5:\"title\";s:14:\"A great plugin\";s:4:\"text\";s:124:\"Have been looking for a plugin for a long time that gave a useful overview in a simple way. I found that with Simple Sitemap\";s:4:\"name\";s:13:\"Kuno Arnkilde\";s:9:\"job_title\";s:7:\"Manager\";s:7:\"company\";s:30:\"Catholic Life │ EWTN Denamrk\";s:11:\"company_url\";s:21:\"https://katolskliv.dk\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:6:\"972395\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:5:\"10278\";s:7:\"created\";s:19:\"2022-07-25 20:45:08\";s:7:\"updated\";s:19:\"2022-12-05 18:32:31\";}i:3;O:8:\"stdClass\":22:{s:5:\"first\";s:7:\"Roxanne\";s:4:\"last\";s:0:\"\";s:5:\"email\";s:16:\"hainesca@msn.com\";s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"5602860\";s:4:\"rate\";i:100;s:5:\"title\";s:28:\"Great Plugin - Recommend It!\";s:4:\"text\";s:316:\"Simple, easy to upload and configure. We use it to increase our website SEO, search engines still look for sitemaps. I would recommend any Theme or Plugin by David Gwyer. You can reach him with questions. He is responsive, accessible, and a technologically savvy individual. I\'d recommend all his Plugins and Themes.\";s:4:\"name\";s:12:\"Carol Haines\";s:9:\"job_title\";s:5:\"Owner\";s:7:\"company\";s:10:\"CH Designs\";s:11:\"company_url\";s:16:\"hainesca@msn.com\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:6:\"908243\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"9597\";s:7:\"created\";s:19:\"2022-03-31 17:48:24\";s:7:\"updated\";s:19:\"2022-12-05 18:32:30\";}i:4;O:8:\"stdClass\":22:{s:5:\"first\";s:6:\"Mischa\";s:4:\"last\";s:7:\"Spörer\";s:5:\"email\";s:27:\"spoerer@netzkantine-gmbh.de\";s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";s:6:\"945255\";s:4:\"rate\";i:100;s:5:\"title\";s:19:\"Perfect for my site\";s:4:\"text\";s:79:\"Installed quickly and easily. Good feature set for SEO and accessible websites.\";s:4:\"name\";s:10:\"M. Spoerer\";s:9:\"job_title\";s:9:\"Developer\";s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:6:\"857237\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"8971\";s:7:\"created\";s:19:\"2021-12-30 15:30:28\";s:7:\"updated\";s:19:\"2022-12-05 18:32:30\";}i:5;O:8:\"stdClass\":22:{s:5:\"first\";s:4:\"Paul\";s:4:\"last\";s:10:\"Gilpatrick\";s:5:\"email\";s:21:\"pgilpat@hostworks.com\";s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"4627012\";s:4:\"rate\";i:100;s:5:\"title\";s:17:\"Top-notch plugin!\";s:4:\"text\";s:84:\"This is falling over a log easy. Opted for the Pro version to support menu sitemaps.\";s:4:\"name\";s:15:\"Paul Gilpatrick\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";s:24:\"http://www.hostworks.com\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:6:\"796270\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"8450\";s:7:\"created\";s:19:\"2021-10-14 21:50:46\";s:7:\"updated\";s:19:\"2022-12-05 18:32:26\";}i:6;O:8:\"stdClass\":22:{s:5:\"first\";s:6:\"Warren\";s:4:\"last\";s:8:\"Petersen\";s:5:\"email\";s:33:\"warrenpetersen@oakgroveschool.org\";s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"2013196\";s:4:\"rate\";i:80;s:5:\"title\";s:11:\"A must have\";s:4:\"text\";s:89:\"I love Simple Sitemap\'s simplicity. It does almost everything I need in a sitemap plugin.\";s:4:\"name\";s:15:\"Warren Petersen\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:5:\"96762\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"6610\";s:7:\"created\";s:19:\"2021-02-02 20:02:36\";s:7:\"updated\";s:19:\"2022-12-05 18:32:23\";}i:7;O:8:\"stdClass\":22:{s:5:\"first\";s:4:\"Mike\";s:4:\"last\";s:5:\"Clark\";s:5:\"email\";s:24:\"mike@prepaidcards123.com\";s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"4039383\";s:4:\"rate\";i:100;s:5:\"title\";s:15:\"Useful and easy\";s:4:\"text\";s:199:\"Boy, I hate dealing with still more learning curves when using plugins. Simple Sitemap exceeded expectations to solve the problem of creating an html site map--30 seconds from download to done. Great\";s:4:\"name\";s:10:\"Mike Clark\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";s:32:\"https://www.prepaidcards123.com/\";s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:6:\"485357\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"6008\";s:7:\"created\";s:19:\"2020-11-25 19:16:18\";s:7:\"updated\";s:19:\"2022-12-05 18:32:22\";}i:8;O:8:\"stdClass\":22:{s:5:\"first\";s:7:\"Desiree\";s:4:\"last\";s:6:\"Mehbod\";s:5:\"email\";s:25:\"appraisersblogs@gmail.com\";s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"3571557\";s:4:\"rate\";i:100;s:5:\"title\";s:12:\"Great plugin\";s:4:\"text\";s:58:\"Very useful plugin, easy setup and great customer service.\";s:4:\"name\";s:14:\"Desiree Mehbod\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:6:\"428244\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"5550\";s:7:\"created\";s:19:\"2020-09-22 23:41:31\";s:7:\"updated\";s:19:\"2022-12-05 18:32:20\";}i:9;O:8:\"stdClass\":22:{s:5:\"first\";s:4:\"Mark\";s:4:\"last\";s:8:\"Phillips\";s:5:\"email\";s:19:\"admin@giftmethis.uk\";s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"3553765\";s:4:\"rate\";i:80;s:5:\"title\";s:45:\"Very useful plugin and great email repsponse.\";s:4:\"text\";s:194:\"Liked the plugin which allowed me to easily format a nice readable sitemap for users while submitting a full site map via xml in the background. Works especially well for accessible needs users.\";s:4:\"name\";s:13:\"Mark Phillips\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:6:\"426119\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"5537\";s:7:\"created\";s:19:\"2020-09-20 18:08:20\";s:7:\"updated\";s:19:\"2022-12-05 18:32:19\";}i:10;O:8:\"stdClass\":22:{s:5:\"first\";s:3:\"Uwe\";s:4:\"last\";s:7:\"Remppel\";s:5:\"email\";s:14:\"uwe@remppel.de\";s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"2402215\";s:4:\"rate\";i:100;s:5:\"title\";s:26:\"Works perfect for my Site.\";s:4:\"text\";s:55:\"Simple and useful. Smart, at least no config nessesary.\";s:4:\"name\";s:11:\"Uwe Remppel\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:6:\"272183\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"3087\";s:7:\"created\";s:19:\"2019-12-29 16:50:32\";s:7:\"updated\";s:19:\"2022-12-05 18:32:18\";}i:11;O:8:\"stdClass\":22:{s:5:\"first\";s:4:\"Mark\";s:4:\"last\";s:6:\"Barrus\";s:5:\"email\";s:20:\"markbarrus@gmail.com\";s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";s:7:\"2023265\";s:4:\"rate\";i:100;s:5:\"title\";s:27:\"Very useful - great support\";s:4:\"text\";s:117:\"We\'ve been using the plugin for a long time now. and have had great support from the developer. Thank you again, Mark\";s:4:\"name\";s:11:\"Mark Barrus\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";N;s:11:\"profile_url\";N;s:10:\"license_id\";s:5:\"98263\";s:11:\"is_verified\";b:1;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"2443\";s:7:\"created\";s:19:\"2019-07-26 00:27:55\";s:7:\"updated\";s:19:\"2019-07-26 06:55:50\";}i:12;O:8:\"stdClass\":22:{s:5:\"first\";N;s:4:\"last\";N;s:5:\"email\";N;s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";N;s:4:\"rate\";i:100;s:5:\"title\";s:11:\"Works great\";s:4:\"text\";s:51:\"Been using for a few years now. Plugin works great!\";s:4:\"name\";s:8:\"soflaweb\";s:9:\"job_title\";s:18:\"Digital Strategist\";s:7:\"company\";s:24:\"South Florida Web Studio\";s:11:\"company_url\";N;s:7:\"picture\";s:102:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/4087/reviews/7ce33590de0d3d0e616912b75f2f0174.jpeg\";s:11:\"profile_url\";N;s:10:\"license_id\";N;s:11:\"is_verified\";b:0;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"2398\";s:7:\"created\";s:19:\"2019-07-13 10:32:16\";s:7:\"updated\";s:19:\"2019-07-13 10:49:32\";}i:13;O:8:\"stdClass\":22:{s:5:\"first\";N;s:4:\"last\";N;s:5:\"email\";N;s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";N;s:4:\"rate\";i:100;s:5:\"title\";s:45:\"Fantastic Plugin / Fast and Excellent Support\";s:4:\"text\";s:167:\"Had a problem with a shortcode not working correctly. David, thank you very much for a great plugin, your hard work, and especially the top-notch support you provided!\";s:4:\"name\";s:11:\"Judy Leslie\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";s:101:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/4087/reviews/3727036f71b391fb0890e215989bfdde.png\";s:11:\"profile_url\";N;s:10:\"license_id\";N;s:11:\"is_verified\";b:0;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"2397\";s:7:\"created\";s:19:\"2019-07-13 10:30:00\";s:7:\"updated\";s:19:\"2019-07-26 06:55:54\";}i:14;O:8:\"stdClass\":22:{s:5:\"first\";N;s:4:\"last\";N;s:5:\"email\";N;s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";N;s:4:\"rate\";i:100;s:5:\"title\";s:32:\"Excellent, easy to setup and use\";s:4:\"text\";s:128:\"The help information is very clearly displayed and explained on exactly what to do next after installing this plugin. Well done!\";s:4:\"name\";s:6:\"AITpro\";s:9:\"job_title\";s:5:\"Owner\";s:7:\"company\";s:7:\"AIT-pro\";s:11:\"company_url\";N;s:7:\"picture\";s:101:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/4087/reviews/f8023f1f865387fc1e4ee3f334901980.png\";s:11:\"profile_url\";N;s:10:\"license_id\";N;s:11:\"is_verified\";b:0;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"2396\";s:7:\"created\";s:19:\"2019-07-13 10:28:22\";s:7:\"updated\";s:19:\"2019-07-13 10:49:04\";}i:15;O:8:\"stdClass\":22:{s:5:\"first\";N;s:4:\"last\";N;s:5:\"email\";N;s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";N;s:4:\"rate\";i:100;s:5:\"title\";s:28:\"Work great and fast support!\";s:4:\"text\";s:101:\"Thank you for your great plugin! It’s work as described and support reply really fast! I’m happy!\";s:4:\"name\";s:5:\"mmaur\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";s:101:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/4087/reviews/1c47b1adb56baa9887c0481a9cc491df.png\";s:11:\"profile_url\";N;s:10:\"license_id\";N;s:11:\"is_verified\";b:0;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"2395\";s:7:\"created\";s:19:\"2019-07-13 10:25:32\";s:7:\"updated\";s:19:\"2019-07-26 06:55:56\";}i:16;O:8:\"stdClass\":22:{s:5:\"first\";N;s:4:\"last\";N;s:5:\"email\";N;s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";N;s:4:\"rate\";i:100;s:5:\"title\";s:21:\"It really is SIMPLE!!\";s:4:\"text\";s:86:\"Thanks for creating this plugin, people like you make the WordPress world go ’round!\";s:4:\"name\";s:9:\"Jay Harle\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";s:102:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/4087/reviews/8eba29f9dbb7833d10f29a017a290e28.jpeg\";s:11:\"profile_url\";N;s:10:\"license_id\";N;s:11:\"is_verified\";b:0;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"2394\";s:7:\"created\";s:19:\"2019-07-13 10:23:33\";s:7:\"updated\";s:19:\"2019-07-13 10:49:01\";}i:17;O:8:\"stdClass\":22:{s:5:\"first\";N;s:4:\"last\";N;s:5:\"email\";N;s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";N;s:4:\"rate\";i:100;s:5:\"title\";s:10:\"Great Job!\";s:4:\"text\";s:68:\"Works exactly as intended, takes 15 seconds to setup. Thank you sir!\";s:4:\"name\";s:6:\"Travis\";s:9:\"job_title\";s:24:\"Owner and Lead Developer\";s:7:\"company\";s:18:\"Web Design of York\";s:11:\"company_url\";N;s:7:\"picture\";s:102:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/4087/reviews/eefedb984dca329443894c03f41a7f19.jpeg\";s:11:\"profile_url\";N;s:10:\"license_id\";N;s:11:\"is_verified\";b:0;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"2393\";s:7:\"created\";s:19:\"2019-07-13 10:21:11\";s:7:\"updated\";s:19:\"2019-07-13 10:49:47\";}i:18;O:8:\"stdClass\":22:{s:5:\"first\";N;s:4:\"last\";N;s:5:\"email\";N;s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";N;s:4:\"rate\";i:100;s:5:\"title\";s:12:\"Just Perfect\";s:4:\"text\";s:153:\"It will not take more than two minutes to get this running on your site. Simple Sitemap does exactly what it needs to do. It generates a perfect sitemap.\";s:4:\"name\";s:6:\"Fiboni\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";s:102:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/4087/reviews/b24e6891811786a6deba7769e6424c05.jpeg\";s:11:\"profile_url\";N;s:10:\"license_id\";N;s:11:\"is_verified\";b:0;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"2392\";s:7:\"created\";s:19:\"2019-07-13 10:19:04\";s:7:\"updated\";s:19:\"2019-07-13 10:50:53\";}i:19;O:8:\"stdClass\":22:{s:5:\"first\";N;s:4:\"last\";N;s:5:\"email\";N;s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";N;s:4:\"rate\";i:100;s:5:\"title\";s:26:\"Super Great Sitemap Plugin\";s:4:\"text\";s:124:\"We use this plugin on each of our websites. This is the most simple to use and easy out of the box sitemap plugin out there!\";s:4:\"name\";s:24:\"Nice and Easy Web Design\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";s:102:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/4087/reviews/76ee05255b0206e32aed7bc4e8651fe9.jpeg\";s:11:\"profile_url\";N;s:10:\"license_id\";N;s:11:\"is_verified\";b:0;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"2391\";s:7:\"created\";s:19:\"2019-07-13 10:15:45\";s:7:\"updated\";s:19:\"2019-07-13 10:50:54\";}i:20;O:8:\"stdClass\":22:{s:5:\"first\";N;s:4:\"last\";N;s:5:\"email\";N;s:9:\"plugin_id\";s:4:\"4087\";s:11:\"external_id\";N;s:7:\"user_id\";N;s:4:\"rate\";i:100;s:5:\"title\";s:31:\"Does the job with a clean look!\";s:4:\"text\";s:157:\"I have 160 or so pages and used the plugin to make a sitemap page. Then linked it via a top-left header widget. Very classy and as the author states: SIMPLE.\";s:4:\"name\";s:16:\"Mark Klinefelter\";s:9:\"job_title\";N;s:7:\"company\";N;s:11:\"company_url\";N;s:7:\"picture\";s:102:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/4087/reviews/dba3f5deac0c910b86979da8366f3f95.jpeg\";s:11:\"profile_url\";N;s:10:\"license_id\";N;s:11:\"is_verified\";b:0;s:11:\"is_featured\";b:1;s:11:\"environment\";i:0;s:2:\"id\";s:4:\"2390\";s:7:\"created\";s:19:\"2019-07-13 10:10:53\";s:7:\"updated\";s:19:\"2019-07-13 10:45:42\";}}s:15:\"active_installs\";s:6:\"110643\";s:9:\"downloads\";i:1708819;s:29:\"all_plans_single_site_pricing\";O:8:\"stdClass\":2:{s:4:\"6603\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}s:4:\"6617\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";d:2.4991666666666998;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";d:29.989999999999998;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}}s:12:\"checkout_url\";s:29:\"https://checkout.freemius.com\";s:18:\"fs_wp_endpoint_url\";s:23:\"https://wp.freemius.com\";s:10:\"trial_mode\";b:0;s:14:\"trial_utilized\";b:0;s:23:\"skip_directly_to_paypal\";b:0;s:19:\"is_paypal_supported\";b:1;}s:7:\"created\";i:1768147261;s:9:\"timestamp\";i:1768233661;}}", "off");
INSERT INTO `wp_options` VALUES("1743", "simple_sitemap_options", "a:2:{s:26:\"new_features_numbered_icon\";s:4:\"true\";s:14:\"plugin_version\";s:5:\"3.6.1\";}", "auto");
INSERT INTO `wp_options` VALUES("1823", "wpseo_llms_txt_content_hash", "", "auto");
INSERT INTO `wp_options` VALUES("1861", "_transient_timeout_gslogo_tak0v0k9b", "1768320867", "off");
INSERT INTO `wp_options` VALUES("1862", "_transient_gslogo_tak0v0k9b", "a:83:{s:5:\"posts\";s:2:\"-1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderby\";s:4:\"date\";s:12:\"filter_order\";s:3:\"ASC\";s:14:\"filter_orderby\";s:4:\"name\";s:10:\"gs_l_title\";s:3:\"off\";s:9:\"title_tag\";s:2:\"h3\";s:15:\"gs_l_link_logos\";s:2:\"on\";s:16:\"include_category\";a:0:{}s:11:\"include_tag\";a:0:{}s:17:\"include_extra_one\";a:0:{}s:17:\"include_extra_two\";a:0:{}s:19:\"include_extra_three\";a:0:{}s:18:\"include_extra_four\";a:0:{}s:18:\"include_extra_five\";a:0:{}s:16:\"exclude_category\";a:0:{}s:11:\"exclude_tag\";a:0:{}s:17:\"exclude_extra_one\";a:0:{}s:17:\"exclude_extra_two\";a:0:{}s:19:\"exclude_extra_three\";a:0:{}s:18:\"exclude_extra_four\";a:0:{}s:18:\"exclude_extra_five\";a:0:{}s:9:\"gs_l_ctrl\";s:3:\"off\";s:13:\"gs_l_ctrl_pos\";s:6:\"bottom\";s:9:\"gs_l_pagi\";s:2:\"on\";s:17:\"gs_l_pagi_dynamic\";s:2:\"on\";s:15:\"gs_l_play_pause\";s:3:\"off\";s:13:\"gs_l_inf_loop\";s:2:\"on\";s:16:\"gs_l_slider_stop\";s:2:\"on\";s:12:\"gs_l_tooltip\";s:3:\"off\";s:22:\"gs_l_tooltip_placement\";s:3:\"top\";s:24:\"gs_l_tooltip_bgcolor_one\";s:7:\"#ff5f6d\";s:24:\"gs_l_tooltip_bgcolor_two\";s:7:\"#ffc371\";s:22:\"gs_l_tooltip_textcolor\";s:4:\"#fff\";s:15:\"gs_l_all_filter\";s:2:\"on\";s:16:\"gs_secondary_img\";s:3:\"off\";s:16:\"gs_l_slide_speed\";s:3:\"500\";s:16:\"gs_l_autop_pause\";s:4:\"3000\";s:10:\"gs_l_theme\";s:7:\"slider1\";s:14:\"filter_enabled\";s:3:\"off\";s:19:\"gs_logo_filter_type\";s:13:\"normal-filter\";s:18:\"gs_logo_pagination\";s:3:\"off\";s:15:\"pagination_type\";s:17:\"normal-pagination\";s:13:\"initial_items\";s:1:\"6\";s:13:\"logo_per_page\";s:1:\"6\";s:14:\"load_per_click\";s:1:\"3\";s:8:\"per_load\";s:1:\"3\";s:16:\"load_button_text\";s:9:\"Load More\";s:24:\"gs_l_s2_border_thickness\";s:2:\"50\";s:22:\"gs_l_s2_gradient_start\";s:7:\"#003729\";s:20:\"gs_l_s2_gradient_end\";s:7:\"#1f9e74\";s:14:\"gs_l_rb_border\";s:17:\"1px,solid,#000000\";s:21:\"gs_l_rb_border_radius\";s:11:\"10,10,10,10\";s:26:\"gs_l_rb_hover_shadow_color\";s:7:\"#1d202f\";s:28:\"gs_l_rb_hover_shadow_control\";s:8:\"6,6,15,0\";s:10:\"image_size\";s:6:\"medium\";s:23:\"custom_image_size_width\";s:0:\"\";s:24:\"custom_image_size_height\";s:0:\"\";s:22:\"custom_image_size_crop\";s:9:\"hard-crop\";s:12:\"gs_l_clkable\";s:6:\"_blank\";s:13:\"gs_l_is_autop\";s:2:\"on\";s:20:\"gs_reverse_direction\";s:3:\"off\";s:12:\"image_filter\";s:4:\"none\";s:18:\"hover_image_filter\";s:4:\"none\";s:10:\"gs_l_align\";s:6:\"center\";s:11:\"gs_l_margin\";s:2:\"10\";s:13:\"gs_l_min_logo\";s:1:\"4\";s:13:\"gs_l_tab_logo\";s:1:\"3\";s:13:\"gs_l_mob_logo\";s:1:\"2\";s:14:\"gs_l_move_logo\";s:1:\"1\";s:19:\"gs_logo_filter_name\";s:3:\"All\";s:20:\"gs_logo_filter_align\";s:6:\"center\";s:8:\"show_cat\";s:3:\"off\";s:17:\"gs_l_show_content\";s:3:\"off\";s:24:\"gs_l_content_limit_count\";s:2:\"80\";s:23:\"gs_l_content_limit_type\";s:5:\"chars\";s:17:\"gs_l_show_excerpt\";s:3:\"off\";s:24:\"gs_l_excerpt_limit_count\";s:2:\"20\";s:23:\"gs_l_excerpt_limit_type\";s:5:\"words\";s:19:\"gs_l_read_more_text\";s:9:\"Read More\";s:17:\"row_heading_image\";s:5:\"Image\";s:16:\"row_heading_name\";s:4:\"Name\";s:16:\"row_heading_desc\";s:11:\"Description\";}", "off");
INSERT INTO `wp_options` VALUES("1874", "_transient_timeout_gslogo_was744wg8", "1768321130", "off");
INSERT INTO `wp_options` VALUES("1875", "_transient_gslogo_was744wg8", "a:83:{s:5:\"posts\";s:2:\"-1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderby\";s:4:\"date\";s:12:\"filter_order\";s:3:\"ASC\";s:14:\"filter_orderby\";s:4:\"name\";s:10:\"gs_l_title\";s:3:\"off\";s:9:\"title_tag\";s:2:\"h3\";s:15:\"gs_l_link_logos\";s:2:\"on\";s:16:\"include_category\";a:0:{}s:11:\"include_tag\";a:0:{}s:17:\"include_extra_one\";a:0:{}s:17:\"include_extra_two\";a:0:{}s:19:\"include_extra_three\";a:0:{}s:18:\"include_extra_four\";a:0:{}s:18:\"include_extra_five\";a:0:{}s:16:\"exclude_category\";a:0:{}s:11:\"exclude_tag\";a:0:{}s:17:\"exclude_extra_one\";a:0:{}s:17:\"exclude_extra_two\";a:0:{}s:19:\"exclude_extra_three\";a:0:{}s:18:\"exclude_extra_four\";a:0:{}s:18:\"exclude_extra_five\";a:0:{}s:9:\"gs_l_ctrl\";s:3:\"off\";s:13:\"gs_l_ctrl_pos\";s:6:\"bottom\";s:9:\"gs_l_pagi\";s:2:\"on\";s:17:\"gs_l_pagi_dynamic\";s:2:\"on\";s:15:\"gs_l_play_pause\";s:3:\"off\";s:13:\"gs_l_inf_loop\";s:2:\"on\";s:16:\"gs_l_slider_stop\";s:2:\"on\";s:12:\"gs_l_tooltip\";s:3:\"off\";s:22:\"gs_l_tooltip_placement\";s:3:\"top\";s:24:\"gs_l_tooltip_bgcolor_one\";s:7:\"#ff5f6d\";s:24:\"gs_l_tooltip_bgcolor_two\";s:7:\"#ffc371\";s:22:\"gs_l_tooltip_textcolor\";s:4:\"#fff\";s:15:\"gs_l_all_filter\";s:2:\"on\";s:16:\"gs_secondary_img\";s:3:\"off\";s:16:\"gs_l_slide_speed\";s:3:\"500\";s:16:\"gs_l_autop_pause\";s:4:\"3000\";s:10:\"gs_l_theme\";s:7:\"slider1\";s:14:\"filter_enabled\";s:3:\"off\";s:19:\"gs_logo_filter_type\";s:13:\"normal-filter\";s:18:\"gs_logo_pagination\";s:3:\"off\";s:15:\"pagination_type\";s:17:\"normal-pagination\";s:13:\"initial_items\";s:1:\"6\";s:13:\"logo_per_page\";s:1:\"6\";s:14:\"load_per_click\";s:1:\"3\";s:8:\"per_load\";s:1:\"3\";s:16:\"load_button_text\";s:9:\"Load More\";s:24:\"gs_l_s2_border_thickness\";s:2:\"50\";s:22:\"gs_l_s2_gradient_start\";s:7:\"#003729\";s:20:\"gs_l_s2_gradient_end\";s:7:\"#1f9e74\";s:14:\"gs_l_rb_border\";s:17:\"1px,solid,#000000\";s:21:\"gs_l_rb_border_radius\";s:11:\"10,10,10,10\";s:26:\"gs_l_rb_hover_shadow_color\";s:7:\"#1d202f\";s:28:\"gs_l_rb_hover_shadow_control\";s:8:\"6,6,15,0\";s:10:\"image_size\";s:6:\"medium\";s:23:\"custom_image_size_width\";s:0:\"\";s:24:\"custom_image_size_height\";s:0:\"\";s:22:\"custom_image_size_crop\";s:9:\"hard-crop\";s:12:\"gs_l_clkable\";s:6:\"_blank\";s:13:\"gs_l_is_autop\";s:2:\"on\";s:20:\"gs_reverse_direction\";s:3:\"off\";s:12:\"image_filter\";s:4:\"none\";s:18:\"hover_image_filter\";s:4:\"none\";s:10:\"gs_l_align\";s:6:\"center\";s:11:\"gs_l_margin\";s:2:\"10\";s:13:\"gs_l_min_logo\";s:1:\"4\";s:13:\"gs_l_tab_logo\";s:1:\"3\";s:13:\"gs_l_mob_logo\";s:1:\"1\";s:14:\"gs_l_move_logo\";s:1:\"1\";s:19:\"gs_logo_filter_name\";s:3:\"All\";s:20:\"gs_logo_filter_align\";s:6:\"center\";s:8:\"show_cat\";s:3:\"off\";s:17:\"gs_l_show_content\";s:3:\"off\";s:24:\"gs_l_content_limit_count\";s:2:\"80\";s:23:\"gs_l_content_limit_type\";s:5:\"chars\";s:17:\"gs_l_show_excerpt\";s:3:\"off\";s:24:\"gs_l_excerpt_limit_count\";s:2:\"20\";s:23:\"gs_l_excerpt_limit_type\";s:5:\"words\";s:19:\"gs_l_read_more_text\";s:9:\"Read More\";s:17:\"row_heading_image\";s:5:\"Image\";s:16:\"row_heading_name\";s:4:\"Name\";s:16:\"row_heading_desc\";s:11:\"Description\";}", "off");
INSERT INTO `wp_options` VALUES("1899", "_site_transient_timeout_browser_89db729cfcdc129111f017b0e7ac324a", "1768903444", "off");
INSERT INTO `wp_options` VALUES("1900", "_site_transient_browser_89db729cfcdc129111f017b0e7ac324a", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"143.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("1901", "_site_transient_timeout_php_check_8a62071f74cc2be777975866d36a2f9b", "1768903445", "off");
INSERT INTO `wp_options` VALUES("1902", "_site_transient_php_check_8a62071f74cc2be777975866d36a2f9b", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("1903", "_site_transient_timeout_feed_0d2db5fea5a8633b56992c916819b198", "1768341847", "off");
INSERT INTO `wp_options` VALUES("1904", "_site_transient_feed_0d2db5fea5a8633b56992c916819b198", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Blog – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 10 Jan 2026 23:18:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=7.0-alpha-61437\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Blog – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"Arrêt du support des versions 7.2 et 7.3 de PHP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://fr.wordpress.org/2026/01/10/arret-support-php-version-72-73/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 10 Jan 2026 08:29:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Securité\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3423\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"À partir de WordPress 7.0 (version attendue en avril 2026), les versions 7.2 et 7.3 de PHP ne seront plus supportées par notre CMS. La&#160;version minimale recommandée&#160;de PHP restera 8.3, tandis que la&#160;version minimale supportée&#160;de PHP sera dorénavant la version 7.4. La version minimale supportée de PHP avait été montée à 7.2.24 en juillet 2024. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4603:\"\n<p>À partir de WordPress 7.0 (version attendue en avril 2026), les versions 7.2 et 7.3 de PHP ne seront plus supportées par notre CMS.</p>\n\n\n\n<p>La&nbsp;<em>version minimale recommandée</em>&nbsp;de PHP restera 8.3, tandis que la&nbsp;<em>version minimale supportée</em>&nbsp;de PHP sera dorénavant la version 7.4.</p>\n\n\n\n<p>La version minimale supportée de PHP avait été montée à 7.2.24 en juillet 2024. Depuis, les parts de marché combinées de PHP 7.2 et 7.3 dans l&rsquo;écosystème WordPress sont tombés <a href=\"https://fr.wordpress.org/about/stats/\">sous le seuil de 4 % des installations WordPress</a>.</p>\n\n\n\n<p>Historiquement, le projet WordPress définit à 5 % le seuil d&rsquo;utilisation minimal pour qu&rsquo;une version de PHP puisse être retirée du support. L&rsquo;utilisation combinée de PHP 7.2 et 7.3 étant désormais bien inférieure à 5 % d&rsquo;installations, le processus d&rsquo;augmentation de la version minimale de PHP requise peut être lancé.</p>\n\n\n\n<p>L&rsquo;objectif de l&rsquo;augmentation de la version minimale de PHP requise est de garantir la maintenabilité à long terme de WordPress. Les avantages de cette augmentation se manifestent progressivement dans de nombreux domaines&nbsp;: l&rsquo;écosystème des extensions et des thèmes, les outils et bibliothèques, la perception à long terme du projet WordPress, les relations avec les développeur·euses et, à terme, le code source de WordPress lui-même, notamment ses outils de développement et son infrastructure de tests automatisés.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Quelles projections à moyen terme sur le support de PHP par WordPress&nbsp;?</h2>\n\n\n\n<p>Il n&rsquo;est pas prévu d&rsquo;augmenter la version minimale de PHP requise selon un calendrier fixe. Les équipes <em><bdo lang=\"en\" dir=\"ltr\">Core</bdo></em> et <bdo lang=\"en\" dir=\"ltr\"><em>Security</em></bdo> de WP continueront de surveiller l&rsquo;utilisation des versions de PHP et de collaborer avec l&rsquo;équipe <em><bdo lang=\"en\" dir=\"ltr\">Hosting</bdo></em> (constituée d&rsquo;hébergeurs qui contribuent activement à WordPress) afin d&rsquo;inciter l&rsquo;écosystème à mettre à jour leur version de PHP le plus rapidement possible.</p>\n\n\n\n<p>Le seuil d&rsquo;utilisation de 5&nbsp;% restera la norme pour le moment pour décider de l&rsquo;arrêt ou non du support d&rsquo;une version.</p>\n\n\n\n<h3 class=\"wp-block-heading\">PHP 7.4, le principal goulot d&rsquo;étranglement pour monter la version minimale supportée de PHP </h3>\n\n\n\n<p>À ce jour, PHP 7.4 est le principal goulot d&rsquo;étranglement empêchant d&rsquo;aller plus loin. Voici en effet les parts de marché de chaque version de PHP dans l&rsquo;écosystème WP, au 10 janvier 2026&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>8.5 : 0,23&nbsp;%</li>\n\n\n\n<li>8.4 : 4,90&nbsp;%</li>\n\n\n\n<li>8.3 : 16,74&nbsp;%</li>\n\n\n\n<li>8.2 : 27,29&nbsp;%</li>\n\n\n\n<li>8.1 : 15,39&nbsp;%</li>\n\n\n\n<li>8.0 : 5,69&nbsp;%</li>\n\n\n\n<li><strong>7.4 : 22,20&nbsp;%</strong></li>\n\n\n\n<li>7.3 : 2,04&nbsp;% (arrêt du support en avril 2026)</li>\n\n\n\n<li>7.2 : 1,81&nbsp;% (arrêt du support en avril 2026)</li>\n</ul>\n\n\n\n<p>Avec 22,2% de parts de marché, PHP 7.4 risque de ne pas pouvoir être abandonné avant plusieurs années. Or, cette version est sortie en 2019 et son support officiel par PHP s&rsquo;est arrêté en 2022.</p>\n\n\n\n<p>Malheureusement, en dehors même de WordPress, il existe une multitude d&rsquo;applications et de sites construits sur d&rsquo;anciennes versions de PHP et qui sont incompatibles avec les versions ultérieures. C&rsquo;est sans doute pour cela que tant d&rsquo;hébergeurs proposent toujours PHP 7.4 à leurs clients, et qu&rsquo;il leur est si difficile d&rsquo;opérer des mises à niveau forcées vers des versions plus récentes&nbsp;: tant qu&rsquo;aucune faille de sécurité majeure ne sera publiée concernant PHP 7.4, il y a de fortes chances que ce <em>statu quo</em> demeure chez les hébergeurs importants, qui peuvent difficilement imposer une telle migration sur leur parc et risquer de casser des applicatifs critiques pour leurs clients.</p>\n\n\n\n<p>En attendant, <strong>WordPress est entièrement compatible avec PHP 8.3 qui est la version minimale officiellement recommandée pour faire tourner WP</strong>. Et <a href=\"https://make.wordpress.org/core/handbook/references/php-compatibility-and-wordpress-versions/\">la compatibilité 8.4 et 8.5 est presque complète (en anglais)</a> au niveau du cœur du CMS. N&rsquo;attendez pas pour effectuer la montée de version de PHP de votre côté&nbsp;!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3423\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 6.9 « Gene »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://fr.wordpress.org/2025/12/02/wordpress-6-9-gene/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Dec 2025 20:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3411\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:350:\"Chaque version de WordPress rend hommage à un artiste ayant laissé une marque indélébile dans le monde la musique. Le nom de code de WordPress 6.9 est «&#160;Gene&#160;», en l&#8217;honneur du jazzman américain Gene Harris. Ce pianiste autodidacte dès l&#8217;âge de 6 ans a infusé le jazz populaire de soul de blues et de gospel, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:77715:\"\n<figure class=\"wp-block-image size-full\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"535\" src=\"https://fr.wordpress.org/files/2025/12/Release-Edition-Featured-Image-6.9-1024x535-1.png\" alt=\"\" class=\"wp-image-3413\" srcset=\"https://fr.wordpress.org/files/2025/12/Release-Edition-Featured-Image-6.9-1024x535-1.png 1024w, https://fr.wordpress.org/files/2025/12/Release-Edition-Featured-Image-6.9-1024x535-1-300x157.png 300w, https://fr.wordpress.org/files/2025/12/Release-Edition-Featured-Image-6.9-1024x535-1-768x401.png 768w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Chaque version de WordPress rend hommage à un artiste ayant laissé une marque indélébile dans le monde la musique. Le nom de code de WordPress 6.9 est «&nbsp;Gene&nbsp;», en l&rsquo;honneur du jazzman américain Gene Harris.</p>\n\n\n\n<p>Ce pianiste autodidacte dès l&rsquo;âge de 6 ans a infusé le jazz populaire de soul de blues et de gospel, apportant une chaleur et une signature iconique. L&rsquo;approche «&nbsp;<bdo lang=\"en\" dir=\"ltr\">bluesy</bdo>&nbsp;» du jazz de Gene Harris vivait à l&rsquo;intersection de deux mondes musicaux, apportant un paysage riche de textures et un supplément d&rsquo;âme qui restera à jamais.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.9</h2>\n\n\n\n<p>WordPress 6.9 apporte des changements majeurs concernant le travail collaboratif sur vos contenus éditoriaux.</p>\n\n\n\n<p>La nouvelle fonctionnalité «&nbsp;Notes&nbsp;» permet d&rsquo;ajouter des commentaires au niveau des blocs lors de la rédaction de publications, simplifiant ainsi la relecture et la validation du contenu.</p>\n\n\n\n<p>La palette de commandes étendue offre une navigation plus rapide dans votre administration.</p>\n\n\n\n<p>La nouvelle API «&nbsp;<bdo lang=\"en\" dir=\"ltr\">Abilities</bdo>&nbsp;» fournit un système de déclaration de fonctionnalités standardisé et lisible par machine, ouvrant la voie à des flux de travail automatisés et basés sur les nouvelles générations d&rsquo;outils IA.</p>\n\n\n\n<p>Cette version améliore également les performances de vos sites, notamment la vitesse de chargement des pages, et ajoute de nombreux nouveaux blocs éditoriaux, ainsi qu&rsquo;une interface de glisser-déposer plus intuitive, pour vous aider à concevoir du contenu riche et dynamique plus efficacement.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/download/\">Télécharger WordPress 6.9 «&nbsp;Gene&nbsp;»</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Les Notes, un nouveau système collaboratif</h2>\n\n\n\n<p><strong>Faites vos retours directement là où vous travaillez.</strong><br>Avec les notes liées directement aux blocs, votre équipe peut rester en phase, suivre les modifications, et transformer les retours en actions, tout au même endroit. Que vous travailliez sur l’écriture des textes ou sur l’affinage de la mise en page, la collaboration se fait avec fluidité directement dans le canevas de l’éditeur.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2025/12/6-9-notes.png\" alt=\"\" class=\"wp-image-19410\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Une palette de commandes disponible partout</h2>\n\n\n\n<p><strong>Vos outils sont toujours à portée de main.</strong><br>Accédez à la Palette de commandes depuis n’importe quelle partie de votre site, que vous soyez en train de rédiger votre dernier article, de travailler en profondeur sur le design du site dans l’Éditeur de site, ou de parcourir vos extensions. Tout ce dont vous avez besoin est maintenant à portée de clic.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2025/12/6-9-command-palette-everywhere.png\" alt=\"\" class=\"wp-image-19412\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Adapter le texte à son conteneur</h2>\n\n\n\n<p><strong>Un contenu qui s’adapte.</strong><br>Une nouvelle option de typographie pour les blocs de texte, à commencer par les blocs Paragraphe et Titre, qui ajuste automatiquement la taille de la police pour remplir parfaitement son conteneur. Idéal pour les bannières, les encadrés ou les éléments qui doivent se démarquer dans votre design. Aucun réglage manuel n’est nécessaire, vous obtenez instantanément un rendu propre.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2025/12/6-9-fit-text.png\" alt=\"\" class=\"wp-image-19413\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Une nouvelle API «&nbsp;Abilities&nbsp;»</h2>\n\n\n\n<p><strong>Un gestionnaire de fonctionnalités au cœur de WordPress</strong>.</p>\n\n\n\n<p>WordPress 6.9 pose les bases de l&rsquo;automatisation de demain grâce à l&rsquo;API «&nbsp;Abilities&nbsp;» unifiée. En créant un registre standardisé des fonctionnalités des sites, les développeurs peuvent désormais enregistrer, valider et exécuter des actions de manière cohérente dans tous les contextes (des points de terminaison PHP et REST aux agents IA), ouvrant ainsi la voie à des expériences WordPress plus intelligentes et connectées.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Amélioration de l’accessibilité</h2>\n\n\n\n<p>Plus de 30 corrections et améliorations en matière d’accessibilité, centrées sur les principales zones de l’expérience d’administration de WordPress. Cela va de la suppression complète du contenu généré par le CSS pour les technologies d’assistance, à l’amélioration des annonces des lecteurs d’écran, en passant par la correction de la position du curseur et le maintien du focus de saisie lors du clic sur les éléments de suggestion automatique.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Amélioration des performances</h2>\n\n\n\n<p>WordPress 6.9 comprend un vaste ensemble d’améliorations de performances. De meilleurs résultats sur la métrique&nbsp;LCP&nbsp;(<bdo lang=\"en\" dir=\"ltr\">Largest Contentful Paint</bdo>) sont obtenus grâce à un chargement amélioré des feuilles de style conditionnelles et en ligne, et grâce au chargement des scripts avec prise en charge de l’attribut <code>fetchpriority</code> et à des optimisations du cœur complémentaires. Les avancées de l’éditeur comprennent des correctifs pour les modifications de mise en page causés par le bloc Vidéo et un chargement plus rapide du sélecteur de termes.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Et bien plus encore</h3>\n\n\n\n<p>Pour une liste complète des nouvelles fonctionnalités, lisez <a href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/\" data-type=\"post\" data-id=\"3383\">notre guide technique à destination des développeurs et des développeuses (en français)</a>, ou consultez le <a href=\"https://wordpress.org/download/releases/6-9\">site dédié à WordPress 6.9 (en anglais)</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.9</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale :&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version :&nbsp;<a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a></li>\n\n\n\n<li>Direction technique :&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a></li>\n\n\n\n<li>Direction artistique :&nbsp;<a href=\"https://profiles.wordpress.org/karmatosed/\"></a><a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a></li>\n\n\n\n<li>Gestion de projet :&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\"></a><a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a></li>\n\n\n\n<li>Direction des tests :&nbsp;<a href=\"https://profiles.wordpress.org/krupajnanda/\"></a><a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a>, <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>La mission de WordPress est de <a href=\"https://fr.wordpress.org/about/\">démocratiser la publication de contenu</a> et ce projet <a href=\"https://opensource.org/osd-annotated\">embrasse les libertés fondamentales de l&rsquo;open-source (en anglais)</a>. Une communauté mondiale et diversifiée supporte cet effort.</p>\n\n\n\n<p>WordPress 6.9 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>900 personnes provenant de près de 67 pays différents</strong>.</p>\n\n\n\n<p>Ce travail collaboratif a abouti à plus de 340 améliorations et correctifs, ce qui donne une nouvelle version majeure stable et efficace – un vrai témoignage de la vivacité de l&rsquo;écosystème open-source de notre CMS.</p>\n\n\n\n<div class=\"wp-block-group alignwide is-layout-constrained wp-block-group-is-layout-constrained\">\n<p class=\"has-extra-small-font-size\"><a href=\"https://profiles.wordpress.org/o-o/\">2046</a> · <a href=\"https://profiles.wordpress.org/aakashverma1/\">Aakash Verma</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aarti1318/\">Aarti Chauhan</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/aatospaja/\">aatospaja</a> · <a href=\"https://profiles.wordpress.org/abduremon/\">Abdur Rahman Emon</a> · <a href=\"https://profiles.wordpress.org/hurayraiit/\">Abu Hurayra</a> · <a href=\"https://profiles.wordpress.org/kawauso/\">Adam Harley (Kawauso)</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/b1ink0/\">Aditya Dhade</a> · <a href=\"https://profiles.wordpress.org/adityashah2411/\">aditya shah</a> · <a href=\"https://profiles.wordpress.org/iamadisingh/\">Aditya Singh</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/agulbra/\">agulbra</a> · <a href=\"https://profiles.wordpress.org/elazzabi/\">Ahmed</a> · <a href=\"https://profiles.wordpress.org/ajaxstardust/\">ajaxStardust</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/akeda/\">Akeda Bagus</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/alejandrogonzalvo/\">alejandrogonzalvo</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">Alex Cuadra</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexclassroom/\">Alex Lion (阿力獅)</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexius08/\">Alexis Pandaan</a> · <a href=\"https://profiles.wordpress.org/alordiel/\">alordiel</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/theaminuldev/\">Aminul Islam</a> · <a href=\"https://profiles.wordpress.org/aialvi/\">Aminul Islam Alvi</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anatolbroder/\">Anatol Broder</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/andrewhoyer/\">Andrew Hoyer</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/mymothersdaughter/\">Anita C</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/fliespl/\">Arkadiusz Rzadkowolski</a> · <a href=\"https://profiles.wordpress.org/armandovias/\">Armando</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/artpi/\">Artur Piszek</a> · <a href=\"https://profiles.wordpress.org/artz91/\">ArtZ91</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/asdofindia/\">asdofindia</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/akashdev/\">Ashraful Haque Akash</a> · <a href=\"https://profiles.wordpress.org/askapache/\">askapache</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/aut0poietic/\">aut0poietic</a> · <a href=\"https://profiles.wordpress.org/aksl95/\">Axel DUCORON</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/azharderaiya/\">Azhar Deraiya</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/bartnv/\">bartnv</a> · <a href=\"https://profiles.wordpress.org/bchecketts/\">bchecketts</a> · <a href=\"https://profiles.wordpress.org/beee/\">Beee</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/bvl/\">Benny</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/bhattaganesh/\">bhattaganesh</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai/\">Bhavesh Desai</a> · <a href=\"https://profiles.wordpress.org/bidbmak/\">BiDbMAK</a> · <a href=\"https://profiles.wordpress.org/mbigul/\">Bigul Malayi</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/burlesonbrad/\">Brad Griffin</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradshawtm/\">bradshawtm</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/heybran/\">Brandon Zhang</a> · <a href=\"https://profiles.wordpress.org/bgoewert/\">Brennan Goewert</a> · <a href=\"https://profiles.wordpress.org/brhodes/\">brhodes</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brumack/\">brumack</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/bshuchter/\">bshuchter</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/byteninjaa0/\">byteninjaa0</a> · <a href=\"https://profiles.wordpress.org/cedche99/\">Cédric Chevillard</a> · <a href=\"https://profiles.wordpress.org/callumbw95/\">Callum Bridgford-Whittick</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/carlsteffen/\">CarlSteffen</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/corazondejaguar/\">Carolina Romo</a> · <a href=\"https://profiles.wordpress.org/ciobanucatalin/\">Catalin Ciobanu</a> · <a href=\"https://profiles.wordpress.org/catgofire/\">catgofire</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/ccharel/\">ccharel</a> · <a href=\"https://profiles.wordpress.org/cbutlerjr/\">Chad Butler</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/cherrygot/\">Chakrapani Gautam</a> · <a href=\"https://profiles.wordpress.org/chihsuan/\">Chi-Hsuan Huang</a> · <a href=\"https://profiles.wordpress.org/chillifish/\">Chillifish</a> · <a href=\"https://profiles.wordpress.org/chloed/\">ChloeD</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/czarate/\">Chris Zarate</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/chrismattix/\">chrismattix</a> · <a href=\"https://profiles.wordpress.org/christinecooper/\">christinecooper</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/cikrimcin/\">cikrimcin</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian Popescu</a> · <a href=\"https://profiles.wordpress.org/chrisvendiadvertisingcom/\">cjhaas</a> · <a href=\"https://profiles.wordpress.org/ckoerner/\">ckoerner</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/codeamp/\">Code Amp</a> · <a href=\"https://profiles.wordpress.org/codebuddy/\">codebuddy</a> · <a href=\"https://profiles.wordpress.org/coleatkinson1/\">coleatkinson1</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/ogrecooper/\">Cooper Dalrymple</a> · <a href=\"https://profiles.wordpress.org/coralietixeront/\">Coralie Tixeront</a> · <a href=\"https://profiles.wordpress.org/salzano/\">Corey Salzano</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cornwell/\">Cornwell</a> · <a href=\"https://profiles.wordpress.org/cr0ybot/\">Cory Hughart</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cucocreative/\">cucocreative</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cyrille37/\">Cyrille37</a> · <a href=\"https://profiles.wordpress.org/daanvandenbergh/\">Daan van den Bergh</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/damchtlv/\">damchtlv</a> · <a href=\"https://profiles.wordpress.org/damir-webthemer/\">Damir</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dancameron/\">Dan Cameron</a> · <a href=\"https://profiles.wordpress.org/danielpw/\">Dan Waldschmidt</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danieliser/\">Daniel Iser</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/daniellacatus/\">daniellacatus</a> · <a href=\"https://profiles.wordpress.org/danielmorell/\">danielmorell</a> · <a href=\"https://profiles.wordpress.org/dscqbus/\">Danny Schmarsel</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/dryanpress/\">Dave Ryan</a> · <a href=\"https://profiles.wordpress.org/daveguitaruno/\">daveguitaruno</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/djivad/\">David Riviera</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/davidb/\">DavidB</a> · <a href=\"https://profiles.wordpress.org/dawidadach/\">dawidadach</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/derekherman/\">derekherman</a> · <a href=\"https://profiles.wordpress.org/devasheeshkaul/\">Devasheesh Kaul</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/diebombe/\">diebombe</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divinenephron/\">divinenephron</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dominiquepijnenburg/\">dominiquepijnenburg</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/doughamlin/\">doughamlin</a> · <a href=\"https://profiles.wordpress.org/dougmelvin/\">DougMelvin</a> · <a href=\"https://profiles.wordpress.org/drawcard/\">drawcard</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dsawyers/\">dsawyers</a> · <a href=\"https://profiles.wordpress.org/dustintechsmith/\">dustintechsmith</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eduwass/\">eduwass</a> · <a href=\"https://profiles.wordpress.org/ehti/\">Ehti</a> · <a href=\"https://profiles.wordpress.org/elialum/\">elialum</a> · <a href=\"https://profiles.wordpress.org/eliezerspp/\">Eliezer Peña</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/elvismdev/\">Elvis Morales</a> · <a href=\"https://profiles.wordpress.org/emaildano/\">emaildano</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/emranahmed/\">Emran Ahmed</a> · <a href=\"https://profiles.wordpress.org/enaanfarhan/\">Enaan Farhan</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a> · <a href=\"https://profiles.wordpress.org/epeicher/\">epeicher</a> · <a href=\"https://profiles.wordpress.org/ekazda/\">Eric</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/ejoling/\">Erik Joling</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/ethanscorey/\">ethanscorey</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fakhriaz/\">fakhriaz</a> · <a href=\"https://profiles.wordpress.org/falgunihdesai/\">Falguni Desai</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fellyph/\">Fellyph Cintra</a> · <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a> · <a href=\"https://profiles.wordpress.org/frogdesk/\">FrogDesk Strategy</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Fumiki Takahashi</a> · <a href=\"https://profiles.wordpress.org/gaeldenysiak/\">Gael Denysiak</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/guddu1315/\">Gaurang Dabhi</a> · <a href=\"https://profiles.wordpress.org/gautam23/\">Gautam Mehta</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/stoyanovgs/\">Georgi Stoyanov</a> · <a href=\"https://profiles.wordpress.org/gernberg/\">gernberg</a> · <a href=\"https://profiles.wordpress.org/giuliorubelli/\">giuliorubelli</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/adrock42/\">H. Adam Lenz</a> · <a href=\"https://profiles.wordpress.org/kabir93/\">H. Kabir</a> · <a href=\"https://profiles.wordpress.org/hanimbarek/\">hanimbarek</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/harshbhonsle08/\">harshbhonsle08</a> · <a href=\"https://profiles.wordpress.org/harshdeepgill/\">harshdeepgill</a> · <a href=\"https://profiles.wordpress.org/haruncpi/\">Harun</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">Hidenori ISHIKAWA</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hiroshisato/\">Hiroshi Sato</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/hozefasmile/\">Hozefa Saleh</a> · <a href=\"https://profiles.wordpress.org/hrohh/\">Hrohh</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/hugosolar/\">hugosolar</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/igorradovanov/\">Igor Radovanov</a> · <a href=\"https://profiles.wordpress.org/ikriv/\">ikriv</a> · <a href=\"https://profiles.wordpress.org/imokweb/\">imokweb</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a> · <a href=\"https://profiles.wordpress.org/iqbal1hossain/\">Iqbal Hossain</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/ishikaatxecurify/\">Ishika Bansal</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jabe/\">Jabe</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jaiminp/\">Jaimin Prajapati</a> · <a href=\"https://profiles.wordpress.org/jakariaistauk/\">Jakaria Istauk</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jakeparis/\">jakeparis</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/isotropic/\">James LePage</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamestitus299/\">James Titus</a> · <a href=\"https://profiles.wordpress.org/codente/\">Jamie</a> · <a href=\"https://profiles.wordpress.org/jamieburchell/\">Jamie Burchell</a> · <a href=\"https://profiles.wordpress.org/jamesmarsland/\">Jamie Marsland</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/jasalt/\">Jarkko Saltiola</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jonmcpartland/\">Jay McPartland</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">Jaydip</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jeffmatson/\">Jeff Matson</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffr0/\">Jeffro</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremiahbratton/\">Jeremiah Bratton</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jkmassel/\">Jeremy Massel</a> · <a href=\"https://profiles.wordpress.org/slimndap/\">Jeroen Schmit</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jesin/\">Jesin A</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jikamens/\">jikamens</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jojo256/\">Joan Namunina</a> · <a href=\"https://profiles.wordpress.org/jobata/\">JoAnne Obata</a> · <a href=\"https://profiles.wordpress.org/jochent/\">JochenT</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes Jülg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/brandbrilliance/\">John Brand</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/mindctrl/\">John Parris</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/johnvieth/\">JohnVieth</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jrchamp/\">Jonathan Champ</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkilä</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/jhabdas/\">Josh Habdas</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jrmd/\">jrmd</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juampick/\">Juan Cook</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juliengardair/\">juliengardair</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/itsroy69/\">Jyotirmoy Roy</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/trepmal/\">Kailey (trepmal)</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/kakomap/\">Kakoma</a> · <a href=\"https://profiles.wordpress.org/kalpeshh/\">Kalpesh</a> · <a href=\"https://profiles.wordpress.org/karinchristen/\">Karin Christen</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/codebykat/\">Kat Hagan</a> · <a href=\"https://profiles.wordpress.org/katinthehatsite/\">Kateryna K. a11n</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/katrinadtl/\">Katrina Massey</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/khushdoms/\">Kaushik Domadiya</a> · <a href=\"https://profiles.wordpress.org/onlykawshar/\">Kawshar Ahmed</a> · <a href=\"https://profiles.wordpress.org/kaygee79/\">kaygee79</a> · <a href=\"https://profiles.wordpress.org/mt8biz/\">Kazuto Takeshita</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/kerfred/\">Kerfred</a> · <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a> · <a href=\"https://profiles.wordpress.org/kesselb/\">kesselb</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevin Leary</a> · <a href=\"https://profiles.wordpress.org/kgagne/\">kgagne</a> · <a href=\"https://profiles.wordpress.org/khoipro/\">Khoi Pro</a> · <a href=\"https://profiles.wordpress.org/khushipatel15/\">Khushi Patel</a> · <a href=\"https://profiles.wordpress.org/killerbishop/\">killerbishop</a> · <a href=\"https://profiles.wordpress.org/iamkingsleyf/\">Kingsley Felix</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/kleor/\">Kleor</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kpapazov/\">kpapazov</a> · <a href=\"https://profiles.wordpress.org/kprocyszyn/\">kprocyszyn</a> · <a href=\"https://profiles.wordpress.org/krishaamer/\">krishaamer</a> · <a href=\"https://profiles.wordpress.org/krunal265/\">Krunal Bhimajiyani</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/kshaner/\">kshaner</a> · <a href=\"https://profiles.wordpress.org/kub1x/\">kub1x</a> · <a href=\"https://profiles.wordpress.org/kubiq/\">kubiq</a> · <a href=\"https://profiles.wordpress.org/kunalpuri123/\">kunalpuri123</a> · <a href=\"https://profiles.wordpress.org/kushsharma/\">Kush Sharma</a> · <a href=\"https://profiles.wordpress.org/kush123/\">Kushagra Goyal</a> · <a href=\"https://profiles.wordpress.org/lgadzhev/\">Lachezar Gadzhev</a> · <a href=\"https://profiles.wordpress.org/lakrisgubben/\">lakrisgubben</a> · <a href=\"https://profiles.wordpress.org/lakshyajeet/\">Lakshyajeet Singh Goyal</a> · <a href=\"https://profiles.wordpress.org/lalitkumawat/\">Lalit Kumawat</a> · <a href=\"https://profiles.wordpress.org/lancewillett/\">Lance Willett</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurisaarni/\">Lauri Saarni</a> · <a href=\"https://profiles.wordpress.org/ldanielgiuliani/\">ldanielgiuliani</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leonidas Milosis</a> · <a href=\"https://profiles.wordpress.org/levinbaria/\">Levin Baria</a> · <a href=\"https://profiles.wordpress.org/lgseo/\">lgseo</a> · <a href=\"https://profiles.wordpress.org/lilgames/\">LilGames</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/logiclink/\">logiclink</a> · <a href=\"https://profiles.wordpress.org/logicrays/\">LogicRays Technologies</a> · <a href=\"https://profiles.wordpress.org/lordandy1984/\">lordandy1984</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/lucasms/\">Lucas Martins</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasfritzedev/\">LukasFritzeDev</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maccyd/\">maccyd</a> · <a href=\"https://profiles.wordpress.org/madhavishah01/\">Madhavi Shah</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/maikuolan/\">Maikuolan</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manhatthien98/\">manhatthien98</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">Manuel Camargo</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani</a> · <a href=\"https://profiles.wordpress.org/maorb/\">maorb</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/pagelab/\">Marcio Duarte</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/leadclown/\">Marcus</a> · <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/mariohamann/\">mariohamann</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/bozzmedia/\">Marty</a> · <a href=\"https://profiles.wordpress.org/martythornley/\">MartyThornley</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/4thhubbard/\">Mary Hubbard</a> · <a href=\"https://profiles.wordpress.org/mat-lipe/\">Mat Lipe</a> · <a href=\"https://profiles.wordpress.org/mathiscode/\">mathiscode</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/pfefferle/\">Matthias Pfefferle</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/maxschmeling/\">Max Schmeling</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/mabfahad/\">Md Abdullah Al Fahad</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/ismail0071/\">MD ISMAIL</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/masummollaalhaz/\">Md Masum Molla Alhaz</a> · <a href=\"https://profiles.wordpress.org/obiplabon/\">Md Obidullah (obiPlabon)</a> · <a href=\"https://profiles.wordpress.org/wprashed/\">Md Rashed Hossain</a> · <a href=\"https://profiles.wordpress.org/sabbir20/\">Md Sabbir Hossain</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdmoreau/\">mdmoreau</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/immeet94/\">Meet Makadia</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/michaelkeck/\">Michael Keck</a> · <a href=\"https://profiles.wordpress.org/mnelson4/\">Michael Nelson</a> · <a href=\"https://profiles.wordpress.org/xmic/\">Michael Sumner</a> · <a href=\"https://profiles.wordpress.org/michaelreetz/\">michaelreetz</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/marktimemedia/\">Michelle Schulp Hunt</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mobius5150/\">Mike</a> · <a href=\"https://profiles.wordpress.org/mikefitzman/\">Mike Fitzpatrick</a> · <a href=\"https://profiles.wordpress.org/mikehansenme/\">Mike Hansen</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/firestar300/\">Milan Ricoul</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/369work/\">Miroku</a> · <a href=\"https://profiles.wordpress.org/missveronicatv/\">missveronica</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mkeck/\">mkeck</a> · <a href=\"https://profiles.wordpress.org/mlaetitia1986/\">mlaetitia1986</a> · <a href=\"https://profiles.wordpress.org/mleray/\">mleray</a> · <a href=\"https://profiles.wordpress.org/mleraygp/\">mleraygp</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/opurockey/\">Mohammad Rockeybul Alam</a> · <a href=\"https://profiles.wordpress.org/mohkatz/\">Mohammed Kateregga</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtg169/\">mtg169</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/sedmikrasky/\">Núria Nadal i Rovira</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">n8finch</a> · <a href=\"https://profiles.wordpress.org/vyasnaman/\">Naman Vyas</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Nasim Miah</a> · <a href=\"https://profiles.wordpress.org/naveendwivedi/\">Naveen Dwivedi</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/bugnumber9/\">Nazar Hotsa</a> · <a href=\"https://profiles.wordpress.org/nazmul111/\">Nazmul Hosen</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/nexbridge/\">nexbridge</a> · <a href=\"https://profiles.wordpress.org/nextendweb/\">Nextendweb</a> · <a href=\"https://profiles.wordpress.org/neychok/\">Neycho Kalaydzhiev</a> · <a href=\"https://profiles.wordpress.org/nickchomey/\">Nick</a> · <a href=\"https://profiles.wordpress.org/nickstarkloff/\">Nick</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nickbrazilian/\">nickbrazilian</a> · <a href=\"https://profiles.wordpress.org/nickjbedford/\">nickjbedford</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nickwilmot/\">nickwilmot</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nigelnelles/\">nigelnelles</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/nimeshatxecurify/\">Nimesh</a> · <a href=\"https://profiles.wordpress.org/ninomiho/\">Nino Mihovilic</a> · <a href=\"https://profiles.wordpress.org/ninos-ego/\">Ninos</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">Noel Santos</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/oferlaor/\">oferlaor</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/yasunocco/\">Okawa Yasuno</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/gabertronic/\">Ophelia Rose</a> · <a href=\"https://profiles.wordpress.org/optimizingmatters/\">Optimizing Matters</a> · <a href=\"https://profiles.wordpress.org/owi/\">owi</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/palak678/\">Palak Patel</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/techpartho/\">Partho Hore</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/patpiwo/\">Patrick Piwowarczyk</a> · <a href=\"https://profiles.wordpress.org/pryley/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulbonneau/\">Paul Bonneau</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/paulstanos/\">paulstanos</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedrofigueroa1989/\">Pedro Figueroa</a> · <a href=\"https://profiles.wordpress.org/peroks/\">Per Egil Roksvaag</a> · <a href=\"https://profiles.wordpress.org/peteringersoll/\">Peter Ingersoll</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philipjohn/\">Philip John</a> · <a href=\"https://profiles.wordpress.org/philsola/\">Philip Sola</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/piskvorky/\">piskvorky</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/poojapadamad/\">poojapadamad</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/prab18hat/\">prab18hat</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranjalpratapsingh/\">Pranjal Pratap Singh</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prasadgupte/\">prasadgupte</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/puggan/\">puggan</a> · <a href=\"https://profiles.wordpress.org/quentinr64600/\">quentinr64600</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/ralucastn/\">Raluca</a> · <a href=\"https://profiles.wordpress.org/superpoincare/\">Ramanan</a> · <a href=\"https://profiles.wordpress.org/ramiy/\">Rami Yushuvaev</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravichudasama01/\">Ravi Chudasama</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/rcrdortiz/\">rcrdortiz</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/espellcaste/\">Renato Alves</a> · <a href=\"https://profiles.wordpress.org/renishsurani/\">renishsurani</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/rezwanshiblu1952/\">Rezwan Shiblu</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/riadev/\">riadev</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rockfire/\">Richard Korthuis</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinatkhaziev/\">Rinat</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishabhwp/\">Rishabh Gupta</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/ristojovanovic/\">Risto Jovanovic</a> · <a href=\"https://profiles.wordpress.org/devrito/\">Ritoban</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/sanchothefat/\">Robert O’Rourke</a> · <a href=\"https://profiles.wordpress.org/robmcclel/\">Robmcclel</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/roelof/\">roelof</a> · <a href=\"https://profiles.wordpress.org/rollybueno/\">Rolly Bueno</a> · <a href=\"https://profiles.wordpress.org/ronak44/\">Ronak prajapati</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/rutvikbhambhi2004/\">Rutvik Bhambhi</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/skierpage/\">S Page</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/devsabbirahmed/\">Sabbir Sam</a> · <a href=\"https://profiles.wordpress.org/sachinrajcp123/\">SACHINRAJ CP</a> · <a href=\"https://profiles.wordpress.org/sahiljadhav1617/\">Sahil Jadhav</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sajjad67/\">Sajjad Hossain Sagor</a> · <a href=\"https://profiles.wordpress.org/sakibmoon/\">sakibmoon</a> · <a href=\"https://profiles.wordpress.org/samueljseay/\">Sam</a> · <a href=\"https://profiles.wordpress.org/sam_a/\">sam_a</a> · <a href=\"https://profiles.wordpress.org/samirmalpande/\">Samir Malpande</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/sjapaget/\">Samuel Paget</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sandeepdahiya/\">Sandeep Dahiya</a> · <a href=\"https://profiles.wordpress.org/sandipsinh007/\">Sandip Sinh</a> · <a href=\"https://profiles.wordpress.org/ourvalley/\">Sandy McFadden</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/tinkerbelly/\">sarah semark</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shsajalchowdhury/\">SH Sajal Chowdhury</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/iamshashank/\">Shashank Jain</a> · <a href=\"https://profiles.wordpress.org/shekh0109/\">Shashank Shekhar</a> · <a href=\"https://profiles.wordpress.org/sajib1223/\">Shazzad Hossain Khan</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">Sheri Grey</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreya0shrivastava/\">Shreya Shrivastava</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shyamgadde/\">Shyamsundar Gadde</a> · <a href=\"https://profiles.wordpress.org/sidharthpandita/\">sidharthpandita</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/shilpaashokan94/\">Silpa TA</a> · <a href=\"https://profiles.wordpress.org/simonefontana/\">simonefontana</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/maia12345/\">Sophie Dimitrov</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar01/\">Soyeb Salar</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spstrap/\">spstrap</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stankea/\">stankea</a> · <a href=\"https://profiles.wordpress.org/metodiew/\">Stanko Metodiev</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/hubersen/\">Stefan Pasch</a> · <a href=\"https://profiles.wordpress.org/stefanvelthuys/\">Stefan Velthuys</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephenharris/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sujansarkar/\">Sujan Sarkar</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/sunnykasera/\">sunnykasera</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva (a11n)</a> · <a href=\"https://profiles.wordpress.org/supernovia/\">supernovia</a> · <a href=\"https://profiles.wordpress.org/suzukube/\">SuzuKube</a> · <a href=\"https://profiles.wordpress.org/svedish/\">svedish</a> · <a href=\"https://profiles.wordpress.org/lordspace/\">Svetoslav Marinov</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/syhussaini/\">syhussaini</a> · <a href=\"https://profiles.wordpress.org/schwipps/\">T4ng</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/takuword/\">Takuro</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/tatof/\">tatof</a> · <a href=\"https://profiles.wordpress.org/tecnogaming/\">tecnogaming</a> · <a href=\"https://profiles.wordpress.org/mecaota/\">Tetsuro Higuchi</a> · <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/tsquez/\">ThemeAWESOME</a> · <a href=\"https://profiles.wordpress.org/themiked/\">theMikeD</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/tfrommen/\">Thorsten Frommen</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Krüss</a> · <a href=\"https://profiles.wordpress.org/timhavinga/\">Tim Havinga</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timotijhof/\">Timo Tijhof</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timotheemoulin/\">Timothée Moulin</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias Bäthge</a> · <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/traxus/\">traxus</a> · <a href=\"https://profiles.wordpress.org/sllimrovert/\">Trevor Mills</a> · <a href=\"https://profiles.wordpress.org/tristanleboss/\">tristanleboss</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tsteel/\">tsteel</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharbharti/\">Tushar Bharti</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tussendoor/\">Tussendoor B.V.</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshnevase/\">Umesh Nevase</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsavladani/\">Utsav Ladani</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/valentingrenier/\">Valentin Grenier</a> · <a href=\"https://profiles.wordpress.org/tsimshatsui/\">Vape tsimshatsui</a> · <a href=\"https://profiles.wordpress.org/vbbp/\">vbbp</a> · <a href=\"https://profiles.wordpress.org/sheldorofazeroth/\">Vedansh Mishra</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vidugupta/\">vidugupta</a> · <a href=\"https://profiles.wordpress.org/vijendrajat/\">Vijendra Jat</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/vishitshah/\">Vishit Shah</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/walterebert/\">Walter Ebert</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/websupporter/\">websupporter</a> · <a href=\"https://profiles.wordpress.org/webwrotter/\">webwrotter</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/widhy980/\">widhy980</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">wplmillet</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xerpa43/\">xerpa43</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yagniksangani/\">Yagnik Sangani</a> · <a href=\"https://profiles.wordpress.org/yashyadav247/\">Yash</a> · <a href=\"https://profiles.wordpress.org/getsyash/\">Yash B</a> · <a href=\"https://profiles.wordpress.org/yashjawale/\">Yash Jawale</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/yogieanamcara/\">YogieAnamCara</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">Zeel Thakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/lstraczynski/\">Łukasz Strączyński</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.9 en français</h3>\n\n\n\n<p>WordPress est un projet international et la version 6.9 est déjà complètement disponible dans plus de 30 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.9 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Bénard</a>, <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/wplmillet/\">wplmillet</a>, <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a>, <a href=\"https://profiles.wordpress.org/marineevain/\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a>, <a href=\"https://profiles.wordpress.org/barnemax/\">Maxime ETCHEBARNE</a>, <a href=\"https://profiles.wordpress.org/nuryko/\">Marianna</a>, <a href=\"https://profiles.wordpress.org/gaellebesson/\">gaellebesson</a>, <a href=\"https://profiles.wordpress.org/emillet/\">Elisabeth</a> et <a href=\"https://profiles.wordpress.org/bishoya/\">Bishoy.A</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-dots\" />\n\n\n\n<p class=\"has-small-font-size\">Article rédigé par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à&nbsp;<a href=\"https://profiles.wordpress.org/wolforg/\">Didier Demory</a>&nbsp;et&nbsp;<a href=\"https://profiles.wordpress.org/nlegagneur/\">xxx</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3411\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Nov 2025 12:31:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3383\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:431:\"Temps de lecture estimé&#160;:&#160; WordPress 6.9 comprend la résolution de plus de&#160;400 tickets sur Trac, dont&#160;125 améliorations et nouvelles fonctionnalités,&#160;plus de 250 corrections de bogues. Cette version comprend 35 tickets focalisés sur l’éditeur, 15 tickets focalisés sur l’admin WP et 45 sur les performances. Les modifications de la version 6.9 concernent&#160;55 composants du cœur du [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:56:\"https://make.wordpress.org/core/files/2025/10/drag-3.mp4\";s:6:\"length\";s:7:\"4330080\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://make.wordpress.org/test/files/2025/10/Hide-Block.mov\";s:6:\"length\";s:8:\"23505066\";s:4:\"type\";s:15:\"video/quicktime\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:56:\"https://make.wordpress.org/core/files/2025/10/drag-2.mp4\";s:6:\"length\";s:7:\"5447134\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:60265:\"\n<figure class=\"wp-block-image alignfull size-full\"><a href=\"https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques.png\"><img decoding=\"async\" width=\"1804\" height=\"962\" src=\"https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques.png\" alt=\"\" class=\"wp-image-3384\" srcset=\"https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques.png 1804w, https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques-300x160.png 300w, https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques-1024x546.png 1024w, https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques-768x410.png 768w, https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques-1536x819.png 1536w\" sizes=\"(max-width: 1804px) 100vw, 1804px\" /></a></figure>\n\n\n\n<div class=\"wp-block-group has-small-font-size is-content-justification-right is-nowrap is-layout-flex wp-container-core-group-is-layout-b315634e wp-block-group-is-layout-flex\">\n<p>Temps de lecture estimé&nbsp;:&nbsp;</p>\n\n\n<div class=\"wp-block-post-time-to-read\">12–17 minutes</div></div>\n\n\n\n<p>WordPress 6.9 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=priority&amp;order=priority&amp;max=500\">400 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.9&amp;group=component&amp;max=200&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">125 améliorations et nouvelles fonctionnalités</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.9&amp;group=component&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 250 corrections de bogues</a>. Cette version comprend <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;component=Editor&amp;milestone=6.9&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">35 tickets focalisés sur l’éditeur</a>, <a href=\"https://core.trac.wordpress.org/query?component=Administration&amp;milestone=6.9&amp;or&amp;focuses=~administration&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">15 tickets focalisés sur l’admin WP</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.9&amp;or&amp;status=closed&amp;component=Script+Loader&amp;milestone=6.9&amp;or&amp;status=closed&amp;component=Query&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">45 sur les performances</a>. Les modifications de la version 6.9 concernent&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.9&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">55 composants du cœur du CMS</a>, dont deux nouveaux composants (AI et Notes).</p>\n\n\n\n<p>Cette version comprend aussi&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=(label%3A%22%5BType%5D%20Enhancement%22%20AND%20is%3Aclosed)%20AND%20(milestone%3A%22Gutenberg%2020.4%22%20OR%20milestone%3A%22Gutenberg%2020.5%22%20OR%20milestone%3A%22Gutenberg%2020.6%22%20OR%20milestone%3A%22Gutenberg%2020.7%22%20OR%20milestone%3A%22Gutenberg%2020.8%22%20OR%20milestone%3A%22Gutenberg%2020.9%22%20OR%20milestone%3A%22Gutenberg%2021.0%22%20OR%20milestone%3A%22Gutenberg%2021.1%22%20OR%20milestone%3A%22Gutenberg%2021.2%22%20OR%20milestone%3A%22Gutenberg%2021.3%22%20OR%20milestone%3A%22Gutenberg%2021.4%22%20OR%20milestone%3A%22Gutenberg%2021.5%22%20OR%20milestone%3A%22Gutenberg%2021.6%22%20OR%20milestone%3A%22Gutenberg%2021.7%22%20OR%20milestone%3A%22Gutenberg%2021.8%22%20OR%20milestone%3A%22Gutenberg%2021.9%22%20OR%20milestone%3A%22Gutenberg%2022.0%22%20OR%20milestone%3A%22Gutenberg%2022.1%22)\">440 améliorations</a> et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=(label%3A%22%5BType%5D%20Bug%22%20AND%20is%3Aclosed)%20AND%20(milestone%3A%22Gutenberg%2020.4%22%20OR%20milestone%3A%22Gutenberg%2020.5%22%20OR%20milestone%3A%22Gutenberg%2020.6%22%20OR%20milestone%3A%22Gutenberg%2020.7%22%20OR%20milestone%3A%22Gutenberg%2020.8%22%20OR%20milestone%3A%22Gutenberg%2020.9%22%20OR%20milestone%3A%22Gutenberg%2021.0%22%20OR%20milestone%3A%22Gutenberg%2021.1%22%20OR%20milestone%3A%22Gutenberg%2021.2%22%20OR%20milestone%3A%22Gutenberg%2021.3%22%20OR%20milestone%3A%22Gutenberg%2021.4%22%20OR%20milestone%3A%22Gutenberg%2021.5%22%20OR%20milestone%3A%22Gutenberg%2021.6%22%20OR%20milestone%3A%22Gutenberg%2021.7%22%20OR%20milestone%3A%22Gutenberg%2021.8%22%20OR%20milestone%3A%22Gutenberg%2021.9%22%20OR%20milestone%3A%22Gutenberg%2022.0%22%20OR%20milestone%3A%22Gutenberg%2022.1%22)\">570 corrections de bogues</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-light-grey-2-color has-text-color has-background has-link-color wp-elements-cad2a17e334a7de448f5bc24abac31cd\" style=\"background:linear-gradient(135deg,rgb(53,10,128) 67%,rgb(244,237,234) 100%)\">Ce guide décrit les principaux changements techniques qui arrivent sur WordPress&nbsp;6.9, dont la sortie est prévue le 2 décembre 2025.</p>\n\n\n\n<p>Pour la première fois, cette version majeure sera rendue publique en <em>live</em> lors de l&rsquo;événement annuel <em>State of the Word</em> qui se tiendra cette année à San Francisco le 2 décembre.</p>\n\n\n\n<p class=\"has-purple-2-color has-text-color has-link-color wp-elements-414d58c89e9217ac699c7ae039abebf9\"><a href=\"https://make.wordpress.org/core/2025/11/26/6-9-release-day-timeline-shift-for-state-of-the-word/\">En savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.9</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-dots\" />\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p>Table des matières : </p>\n\n\n\n<nav aria-label=\"Table des matières\" class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#de-nouvelles-facons-de-collaborer\">De nouvelles façons de collaborer</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#les-notes-font-leur-entree\">Les Notes font leur entrée</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#updates-to-field-api-dataviews-and-dataforms-components\">Mise à jour de l’API « Field » et des composants « DataViews » et « DataForms »</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#improved-editing-tools-and-architecture\">Amélioration des outils d’édition</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#direct-drag-and-drop\">Glisser-déposer en direct</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#ability-to-hide-blocks-1\">Possibilité de masquer des blocs</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#iframe-integration-in-post-editor-1\">Intégration iframe de l’éditeur de contenu</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#streaming-block-parser\">Un nouvel outil pour traiter les blocs</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#new-blocks-and-block-improvements\">Nouveau blocs et améliorations des blocs existants</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#perform-calculations-using-π-in-the-math-block\">Un bloc d&rsquo;affichage des formules mathématiques</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#accordion-block-now-supports-anchors\">Du contenu repliable avec le bloc Accordéon</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#heading-block-css-specificity-fix\">Correction de la spécificité CSS du bloc Titre</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#new-improved-apis\">Nouvelles API et modifications des API existantes</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#meet-the-abilities-api\">Découvrez l’API « Abilities »</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#updates-to-interactivity-api\">Mise à jour de l’API « Interactivity »</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#html-api-updatesimproved-blocks-binding-api\">Mise à jour de l’API « HTML »</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#improved-block-binding-api\">Amélioration de l’API « Block Binding »</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#optimized-performance\">Optimisations des performances</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#modernizing-utf-8-support\">Modernisation du support d’UTF-8</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#updated-query-cache-handling\">Mise à jour de la gestion du cache des requêtes</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#remove-support-for-loading-assets-conditionally-for-ie\">Suppression du support du chargement conditionnel des ressources pour Internet Explorer</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#accessibility-updates\">Accessibilité</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#php-8-5-support\">Support de PHP 8.5</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#miscellaneous-developer-changes\">Autres changements techniques</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#miscellaneous-editor-changes\">Changements divers concernant l&rsquo;éditeur</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#updated-admin-menu-search-query\">Modification des requêtes de recherche du menu d&rsquo;administration</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#additional-support-for-https-in-url-escaping-functions\">Un support complémentaire de HTTPS dans les fonctions d&rsquo;échappement d&rsquo;URL</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#improved-email-handling-and-inline-image-support\">Amélioration de la gestion des e-mails et du support des images en ligne</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#travaux-lies-a-l-implementation-des-outils-ia-dans-wp-6-9\">Travaux liés à l&rsquo;implémentation des outils IA dans WP 6.9</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#php-ai-client\">Client PHP pour l&rsquo;implémentation d&rsquo;outils IA</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#mcp-adapter\">Adaptateur MCP</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#but-wait-there-is-more\">Attendez, ce n’est pas fini !</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</a></li></ol></nav>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-dots\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"de-nouvelles-facons-de-collaborer\">De nouvelles façons de collaborer</h2>\n\n\n\n<p>Créer et gérer du contenu avec WordPress 6.9 sera encore plus efficace grâce à de nouveaux outils et fonctionnalités qui encouragent la collaboration et simplifient l&rsquo;utilisation. Vous pouvez désormais ajouter des notes aux blocs et profiter de vues de données optimisées ainsi que d&rsquo;une palette de commandes intégrée à l’admin WP.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"les-notes-font-leur-entree\">Les Notes font leur entrée</h3>\n\n\n\n<p>Dans WordPress 6.9, les rédacteur·ices peuvent rédiger des notes et répondre directement aux notes ajoutées par d’autres au niveau de chaque bloc, ce qui permet aux équipes de collaborer, de suivre les modifications et de donner leur avis pendant le processus d&rsquo;édition. Les notes peuvent être résolues, modifiées et supprimées. Une notification par e-mail est envoyée à l&rsquo;auteur·ice de l&rsquo;article lorsqu&rsquo;une nouvelle note est ajoutée.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"s60Ci2rnYH\"><a href=\"https://make.wordpress.org/core/2025/11/15/notes-feature-in-wordpress-6-9/\">Notes feature in WordPress 6.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Notes feature in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/15/notes-feature-in-wordpress-6-9/embed/#?secret=DP6kJwS0eP#?secret=s60Ci2rnYH\" data-secret=\"s60Ci2rnYH\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"updates-to-field-api-dataviews-and-dataforms-components\">Mise à jour de l’API «&nbsp;Field&nbsp;» et des composants «&nbsp;DataViews&nbsp;» et «&nbsp;DataForms&nbsp;»</h3>\n\n\n\n<p>Cette version propose aussi une mise à jour de l’API «&nbsp;Field&nbsp;» et des composants «&nbsp;DataViews&nbsp;» et «&nbsp;DataForms&nbsp;»</p>\n\n\n\n<p>Dans l’<a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/#field-api\">API Field (champs)</a>,&nbsp;le&nbsp;paramètre <code>type</code>&nbsp;permet désormais d&rsquo;inclure 10 nouveaux types de champs, 11 contrôleurs de type <code>edit</code> qui permettent d&rsquo;indiquer des types de validation, plus de 16 opérateurs de filtrage, une option <code>readOnly</code> pour désactiver l&rsquo;édition des champs, et bien plus encore.</p>\n\n\n\n<p>Les modifications des fonctions du composant&nbsp;<a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/#dataviews\">DataViews (vues de données)</a>&nbsp;concernent des améliorations des modales et des actions basées sur l&rsquo;utilisation du texte, un défilement infini et la possibilité de construire des mises en page utilisant la fonctionnalité <code>children</code> pour tirer profit de la gestion interne des états des vues de données et de la logique de gestion des données. Les vues de données sont maintenant persistantes et sont gérées via le paquet&nbsp;<a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/#dataviews-persistence\"><code>@wordpress/views</code></a>. Le panneau de gestion des <code>DataForms</code> (formulaires de données) a été amélioré et d&rsquo;autres éléments ont été améliorés comme les mises en page <code>card</code> et <code>row</code> ainsi que la gestion des validations.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"0aGWCGMOJD\"><a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/\">DataViews, DataForm, et al. in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;DataViews, DataForm, et al. in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/embed/#?secret=XkaN1RVWhq#?secret=0aGWCGMOJD\" data-secret=\"0aGWCGMOJD\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"improved-editing-tools-and-architecture\">Amélioration des outils d’édition</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"direct-drag-and-drop\">Glisser-déposer en direct</h3>\n\n\n\n<p>Le <a href=\"https://make.wordpress.org/core/2025/10/28/gutenberg-21-9-october-22/#direct-drag-and-drop\">glisser-déposer</a>&nbsp;a été amélioré, avec la possibilité de <a href=\"https://github.com/WordPress/gutenberg/pull/67470\">directement déplacer des blocs à l&rsquo;intérieur de l&rsquo;éditeur</a> au lieu de devoir sélectionner le contrôleur de glisser-déposer.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls src=\"https://make.wordpress.org/core/files/2025/10/drag-3.mp4\"></video><figcaption class=\"wp-element-caption\">Ci-dessus une vidéo de démonstration du glisser-déposer dans l&rsquo;éditeur.</figcaption></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"ability-to-hide-blocks-1\">Possibilité de masquer des blocs</h3>\n\n\n\n<p>WordPress 6.9 permet de masquer et afficher des blocs d&rsquo;un simple clic.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls src=\"https://make.wordpress.org/test/files/2025/10/Hide-Block.mov\"></video><figcaption class=\"wp-element-caption\">Ci-dessus une vidéo de démonstration du masquage de blocs dans l&rsquo;éditeur.</figcaption></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"iframe-integration-in-post-editor-1\">Intégration iframe de l’éditeur de contenu</h3>\n\n\n\n<p>Il y a&nbsp;une <a href=\"https://make.wordpress.org/core/2021/06/29/blocks-in-an-iframed-template-editor/\">initiative en cours</a>&nbsp;pour placer l&rsquo;éditeur de contenu au sein d&rsquo;une&nbsp;<code>iframe</code>, et plusieurs modifications servent à préparer cette future implémentation&nbsp;:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Le&nbsp;<a href=\"https://github.com/WordPress/gutenberg/blob/trunk/schemas/json/block.json\">schéma <code>block.json</code></a>&nbsp;ne permet plus que d&rsquo;utiliser l’<code>apiVersion</code>&nbsp;<code>3</code>&nbsp;pour les nouveaux blocs ou les blocs modifiés</li>\n\n\n\n<li>Un avertissement sera affiché dans la console du navigateur lorsqu&rsquo;un bloc utilise les <code>apiVersion</code>&nbsp;<code>1</code>&nbsp;ou&nbsp;<code>2</code></li>\n</ol>\n\n\n\n<p>Ces modifications visent à aider les développeur·euses à migrer leurs blocs vers <code>apiVersion</code>&nbsp;3. L&rsquo;objectif est de complètement déplacer l’éditeur dans une <code>iframe</code> à partir de WordPress 7.0. Même si cette grosse modification est déjà prête, nous laissons donc un peu de temps aux personnes qui proposent des extensions WP pour mettre à niveau leurs développements.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"t6qkBt4uZq\"><a href=\"https://make.wordpress.org/core/2025/11/12/preparing-the-post-editor-for-full-iframe-integration/\">Preparing the Post Editor for Full iframe Integration</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Preparing the Post Editor for Full iframe Integration&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/12/preparing-the-post-editor-for-full-iframe-integration/embed/#?secret=iVv6lZOGtJ#?secret=t6qkBt4uZq\" data-secret=\"t6qkBt4uZq\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"streaming-block-parser\">Un nouvel outil pour traiter les blocs</h3>\n\n\n\n<p>WordPress 6.9 comprend un nouvel outil&nbsp;<code>WP_Block_Processor</code>&nbsp;pour scanner les structures des blocs contenus dans des documents HTML. Cette nouvelle classe permet de parcourir un document HTML pour analyser et ajuster les structures de ses blocs sans affecter le texte, de convertir des documents en un tableau imbriqué d&rsquo;informations concernant les blocs utilisés et d&rsquo;obtenir des tableaux JSON d&rsquo;attributs.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dlxl4wHiYQ\"><a href=\"https://make.wordpress.org/core/2025/11/19/introducing-the-streaming-block-parser-in-wordpress-6-9/\">Introducing the streaming block parser in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Introducing the streaming block parser in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/introducing-the-streaming-block-parser-in-wordpress-6-9/embed/#?secret=dbr2Knuzma#?secret=dlxl4wHiYQ\" data-secret=\"dlxl4wHiYQ\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"new-blocks-and-block-improvements\">Nouveau blocs et améliorations des blocs existants</h2>\n\n\n\n<p>La bibliothèque de blocs natifs a été enrichie de plusieurs nouveaux blocs&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Un bloc d&rsquo;affichage de formules mathématiques</li>\n\n\n\n<li>Un <a href=\"https://github.com/WordPress/gutenberg/pull/70720\">bloc de requête portant sur les termes de taxonomies</a></li>\n\n\n\n<li>Un bloc de lien vers les commentaires</li>\n\n\n\n<li>Un bloc servant à afficher un compteur des commentaires d&rsquo;un article</li>\n\n\n\n<li>Des améliorations des blocs Titre et Temps de lecture</li>\n</ul>\n\n\n\n<p>WP 6.9 contient aussi de nouvelles fonctionnalités d&rsquo;édition de texte comme le support de <code>fitText</code> qui permet de définir automatiquement la taille du texte en fonction des limites du conteneur dans lequel il s&rsquo;inscrit.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"perform-calculations-using-π-in-the-math-block\">Un bloc d&rsquo;affichage des formules mathématiques</h3>\n\n\n\n<p>Le&nbsp;<a href=\"https://github.com/WordPress/gutenberg/pull/72182\">nouveau bloc Math</a>&nbsp;ajoute le support du standard MathML et du rendu LaTeX pour l&rsquo;affichage de formules mathématiques, soit en tant que bloc indépendant, soit dans du texte en ligne pouvant être ajouté dans n&rsquo;importe quel champs de texte enrichi comme les tableaux, les titres ou encore les listes.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls src=\"https://make.wordpress.org/core/files/2025/10/drag-2.mp4\"></video><figcaption class=\"wp-element-caption\">Ci-dessus une vidéo de démonstration du bloc de d&rsquo;affichage des formules mathématiques.</figcaption></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"accordion-block-now-supports-anchors\">Du contenu repliable avec le bloc Accordéon</h3>\n\n\n\n<p>Le <a href=\"https://github.com/WordPress/gutenberg/issues/21584\">nouveau bloc Accordéon</a>&nbsp;de WP 6.9 peut être personnalisé à volonté. Un article dédié explique&nbsp;<a href=\"https://developer.wordpress.org/news/2025/10/styling-accordions-in-wordpress-6-9/\">comment mettre en forme le bloc Accordéon</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://developer.wordpress.org/news/files/2025/10/accordion-toggle-styled-1536x795.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"heading-block-css-specificity-fix\">Correction de la spécificité CSS du bloc Titre</h3>\n\n\n\n<p>WP 6.9 comprend une&nbsp;<a href=\"https://make.wordpress.org/core/2025/11/12/heading-block-css-specificity-fix-in-wordpress-6-9\">modification du sélecteur CSS utilisé pour les marges internes (<code>padding</code>) sur les titres avec arrière-plan</a>, qui est dorénavant ciblé avec les deux classes <code><strong>.</strong>wp-block-heading</code>&nbsp;et <code>.has-background</code>&nbsp;pour garantir que les personnalisations des marges n&rsquo;affectent que le bloc souhaité.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"4s3vlJO0cL\"><a href=\"https://make.wordpress.org/core/2025/11/12/heading-block-css-specificity-fix-in-wordpress-6-9/\">Heading Block CSS Specificity Fix in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Heading Block CSS Specificity Fix in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/12/heading-block-css-specificity-fix-in-wordpress-6-9/embed/#?secret=zG5lJIgvUv#?secret=4s3vlJO0cL\" data-secret=\"4s3vlJO0cL\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"new-improved-apis\">Nouvelles API et modifications des API existantes</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"meet-the-abilities-api\">Découvrez l’API «&nbsp;Abilities&nbsp;»</h3>\n\n\n\n<p>L’API «&nbsp;Abilities&nbsp;» permet au cœur de WordPress mais aussi aux développeur·euses de thèmes et d&rsquo;extensions d&rsquo;enregistrer leur fonctionnalités de façon unifiée, standardisée et dans un format programmatiquement lisible. L’API «&nbsp;Abilities&nbsp;» fait partie de l&rsquo;initiative plus large visant à&nbsp;<a href=\"https://make.wordpress.org/ai/2025/07/17/ai-building-blocks\">permettre la construction de blocs en passant par l’IA</a>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TOUP8yZWH0\"><a href=\"https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/\">Abilities API in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Abilities API in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/embed/#?secret=5HIq07RelF#?secret=TOUP8yZWH0\" data-secret=\"TOUP8yZWH0\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"updates-to-interactivity-api\">Mise à jour de l’API «&nbsp;Interactivity&nbsp;»</h3>\n\n\n\n<p>Dans WordPress 6.9, l’API de gestion des interactions offre désormais une manière standard d&rsquo;assigner des identifiants uniques aux directives de l’API, ce qui permet aux éléments du site de disposer de multiples directives similaires sans conflit.</p>\n\n\n\n<p>Les fonctions <code>getServerState(</code>) et&nbsp;<code>getServerContext()</code>&nbsp;ont été mises à jour et un nouvel algorithme optimise la gestion des scripts et des styles, offre une meilleure prise en charge des régions de routage dans les éléments interactifs, et ajoute un nouveau paramètre <code>attachTo</code>&nbsp;property qui agit comme un sélecteur CSS pointant sur l&rsquo;élément parent pour le rendu.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HncJjhFChJ\"><a href=\"https://make.wordpress.org/core/2025/11/12/changes-to-the-interactivity-api-in-wordpress-6-9/\">Changes to the Interactivity API in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Changes to the Interactivity API in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/12/changes-to-the-interactivity-api-in-wordpress-6-9/embed/#?secret=Y7kVvTbuT1#?secret=HncJjhFChJ\" data-secret=\"HncJjhFChJ\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"html-api-updatesimproved-blocks-binding-api\">Mise à jour de l’API «&nbsp;HTML&nbsp;»</h3>\n\n\n\n<p>L’API HTML a été fignolée, avec plusieurs corrections de bogues et améliorations. La méthode&nbsp;<code>WP_HTML_Processor::serialize_token()</code>est désormais publique, ce qui étend la sécurité de l’API au delà de la seule modification de code et la combinaison de code HTML, tandis que&nbsp;<code>set_modifiable_text()</code>&nbsp;rejette désormais les contenus des éléments <code>SCRIPT</code> qui pourraient compromettre sa fermeture normale.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"plqVJwX0cB\"><a href=\"https://make.wordpress.org/core/2025/11/21/updates-to-the-html-api-in-6-9/\">Updates to the HTML API in 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/21/updates-to-the-html-api-in-6-9/embed/#?secret=0EQBKJN8hF#?secret=plqVJwX0cB\" data-secret=\"plqVJwX0cB\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"improved-block-binding-api\">Amélioration de l’API «&nbsp;Block Binding&nbsp;»</h3>\n\n\n\n<p>L’interface de l’API Block Bindings a été rendue plus simple d&rsquo;utilisation avec la possibilité nouvelle de basculer entre les sources, et de rattacher ou détacher des attributs d&rsquo;un simple clic. Le nouveau filtre <code>block_bindings_supported_attributes_{$block_type}</code> facilite quant à lui la personnalisation de la manière dont les attributs des blocs se connectent à une source liée.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7HOG5iwH71\"><a href=\"https://make.wordpress.org/core/2025/11/12/block-bindings-improvements-in-wordpress-6-9/\">Block Bindings improvements in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block Bindings improvements in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/12/block-bindings-improvements-in-wordpress-6-9/embed/#?secret=Shct73Aisv#?secret=7HOG5iwH71\" data-secret=\"7HOG5iwH71\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"optimized-performance\">Optimisations des performances</h2>\n\n\n\n<p>WordPress 6.9 offre des améliorations significatives en termes de performances, ce qui optimise l&rsquo;expérience de chargement des sites pour les internautes. L&rsquo;amélioration du LCP (<em>Largest Contentful Paint</em>) est obtenue grâce à la mise en place des styles de blocs à la demande pour les thèmes classiques, la minification des styles de blocs et l&rsquo;augmentation de la limite des styles en ligne, réduisant ainsi le blocage du rendu. Le chemin de rendu critique («&nbsp;critical path&nbsp;») est décongestionné par la dépriorisation des scripts non critiques (par exemple, ceux des blocs interactifs ou de la détection des émojis) qui entraient en conflit avec le chargement de ressources comme l&rsquo;image de l&rsquo;élément considéré comme étant l&rsquo;élément LCP. La stabilité des pages est également améliorée en empêchant le bloc Vidéo de provoquer des décalages de mise en page (ce qui améliore la métrique CLS).</p>\n\n\n\n<p>Beaucoup d&rsquo;autres améliorations ont été faites, par exemple sur les requêtes en base de données, la gestion du cache, une meilleure gestion du CRON WP et des améliorations du tampon de rendu des modèles qui ouvre la porte à de nombreuses améliorations de performances qui étaient auparavant impossibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ijQE6fAipJ\"><a href=\"https://make.wordpress.org/core/2025/11/18/wordpress-6-9-frontend-performance-field-guide/\">WordPress 6.9 Frontend Performance Field Guide</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.9 Frontend Performance Field Guide&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/18/wordpress-6-9-frontend-performance-field-guide/embed/#?secret=1athSDczWJ#?secret=ijQE6fAipJ\" data-secret=\"ijQE6fAipJ\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"modernizing-utf-8-support\">Modernisation du support d’UTF-8</h3>\n\n\n\n<p>Un nouveau tunnel de repli écrit en PHP permet à WordPress 6.9 de traiter l’encodage du texte et la gestion d&rsquo;UTF-8 indépendamment de l&rsquo;environnement sur lequel tourne le site, ce qui apporte plus de cohérence entre les différents environnements sur lesquels votre site peut être installé, ce qui est notamment utile aux thèmes et extensions qui travaillent avec du contenu internationnalisé, ou avec les émojis.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ikru7pjb4g\"><a href=\"https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/\">Modernizing UTF-8 support in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Modernizing UTF-8 support in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/embed/#?secret=ggNMEISTIZ#?secret=ikru7pjb4g\" data-secret=\"ikru7pjb4g\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"updated-query-cache-handling\">Mise à jour de la gestion du cache des requêtes</h3>\n\n\n\n<p>La version 6.9 modifie la façon dont les clés de cache sont créées lorsque les requêtes mises en cache sont traitées dans <code>WP_Query</code>. Le cache objet persistant ne devrait pas être affecté, mais les développeurs et développeuses ainsi que les entreprises fournissant des services d&rsquo;hébergements sont invités à prendre en compte les modifications décrites dans cette note de développement, et à tirer parti des 4 nouvelles fonctions disponibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hbBdeytkdI\"><a href=\"https://make.wordpress.org/core/2025/11/17/consistent-cache-keys-for-query-groups-in-wordpress-6-9/\">Consistent Cache Keys for Query Groups in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Consistent Cache Keys for Query Groups in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/17/consistent-cache-keys-for-query-groups-in-wordpress-6-9/embed/#?secret=CGHgD2wunF#?secret=hbBdeytkdI\" data-secret=\"hbBdeytkdI\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"remove-support-for-loading-assets-conditionally-for-ie\">Suppression du support du chargement conditionnel des ressources pour Internet Explorer</h3>\n\n\n\n<p>WordPress 6.9 supprime le support du <a href=\"https://core.trac.wordpress.org/ticket/63821\">chargement conditionnel des scripts et styles pour IE avec les anciennes structures conditionnelles</a>. Tous les restes de cette ancienne manière de faire <a href=\"https://core.trac.wordpress.org/ticket/58836\">ont été supprimés du code des thèmes natifs</a>. Le code lié à <a href=\"https://core.trac.wordpress.org/ticket/62128\">Genericons a aussi été modifié</a>&nbsp;sur les thèmes qui utilisent cette police web.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HBt3XMYVWY\"><a href=\"https://make.wordpress.org/core/2025/11/19/legacy-internet-explorer-code-removed/\">Legacy Internet Explorer Code Removed</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Legacy Internet Explorer Code Removed&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/legacy-internet-explorer-code-removed/embed/#?secret=sxUtkYszkF#?secret=HBt3XMYVWY\" data-secret=\"HBt3XMYVWY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"accessibility-updates\">Accessibilité</h2>\n\n\n\n<p>WordPress 6.9 comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?focuses=~accessibility&amp;milestone=6.9&amp;group=type&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">10 améliorations et 23 corrections de bogues</a>&nbsp;focalisées sur l&rsquo;accessibilité. Il y a par exemple des améliorations des notifications destinées aux technologies d&rsquo;assistance, des améliorations de la sémantique du code et de la gestion du focus clavier, et une mise à niveau du contenu généré via CSS pour éviter que du contenu non pertinent ne soit interprété par les outils d&rsquo;assistance.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"oVjH0GCizX\"><a href=\"https://make.wordpress.org/core/2025/11/19/accessibility-improvements-in-wordpress-6-9/\">Accessibility Improvements in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Accessibility Improvements in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/accessibility-improvements-in-wordpress-6-9/embed/#?secret=446JdlkqcD#?secret=oVjH0GCizX\" data-secret=\"oVjH0GCizX\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"php-8-5-support\">Support de PHP 8.5</h2>\n\n\n\n<p>WordPress 6.9 propose un support en version beta de PHP 8.5. Toutes les incompatibilités connues, les avertissements et notifications ont été corrigées. Le support des anciennes versions (pour l&rsquo;instant jusqu&rsquo;à PHP 7.2) a été maintenu. Pour rappel, lorsque nous parlons de support en version beta, nous parlons des <a href=\"https://make.wordpress.org/core/2025/07/07/proposal-remove-the-beta-support-label-from-php-8-3-for-wordpress-6-8/\">versions de PHP qui sont utilisées par moins de 10% des sites web</a>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HHsVP4QXlf\"><a href=\"https://make.wordpress.org/core/2025/11/21/php-8-5-support-in-wordpress-6-9/\">PHP 8.5 support in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;PHP 8.5 support in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/21/php-8-5-support-in-wordpress-6-9/embed/#?secret=S9UuaRYhKT#?secret=HHsVP4QXlf\" data-secret=\"HHsVP4QXlf\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<p>D&rsquo;autres modifications concernent différentes facettes du cœur du CMS, comme les médias, la gestion multisite, de nouveaux crochets et filtres, etc.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"1N55zTf5W3\"><a href=\"https://make.wordpress.org/core/2025/11/17/miscellaneous-developer-focused-changes-in-6-9/\">Miscellaneous Developer-focused Changes in 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Developer-focused Changes in 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/17/miscellaneous-developer-focused-changes-in-6-9/embed/#?secret=ArJDoGk5Vd#?secret=1N55zTf5W3\" data-secret=\"1N55zTf5W3\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-editor-changes\">Changements divers concernant l&rsquo;éditeur</h3>\n\n\n\n<p>WP 6.9 apporte aussi un grand nombre de petites modifications de l&rsquo;éditeur de blocs.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"nHqf9JJVdo\"><a href=\"https://make.wordpress.org/core/2025/11/25/miscellaneous-editor-changes-in-wordpress-6-9/\">Miscellaneous Editor Changes in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Editor Changes in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/25/miscellaneous-editor-changes-in-wordpress-6-9/embed/#?secret=sSj6Lr777I#?secret=nHqf9JJVdo\" data-secret=\"nHqf9JJVdo\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"updated-admin-menu-search-query\">Modification des requêtes de recherche du menu d&rsquo;administration</h3>\n\n\n\n<p>Avec WordPress 6.9, la requête de recherche proposée par le menu d&rsquo;administration a changé, passant de&nbsp;<code>$_SERVER[\'QUERY_STRING\']</code>&nbsp;à&nbsp;<code>$_GET</code>. Cela rend le comportement de recherche plus prévisible et évite les problèmes liés à certaines chaines de requêtes. Les extensions qui surchargent cette recherche devront revoir leur façon de fonctionner pour prendre en compte ces changements.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"DC2ukqUl8S\"><a href=\"https://make.wordpress.org/core/2025/11/19/admin-menu-search-query-changed/\">Admin menu search query changed</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Admin menu search query changed&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/admin-menu-search-query-changed/embed/#?secret=yuPvIQjESb#?secret=DC2ukqUl8S\" data-secret=\"DC2ukqUl8S\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"additional-support-for-https-in-url-escaping-functions\">Un support complémentaire de HTTPS&nbsp;dans les fonctions d&rsquo;échappement d&rsquo;URL</h3>\n\n\n\n<p>Les fonctions&nbsp;<code>esc_url()</code>,&nbsp;<code>esc_url_raw()</code>&nbsp;et&nbsp;<code>sanitize_url()</code>&nbsp;peuvent maintenant être configurées pour préfixer par <code>https://</code>&nbsp;les URL qui ne proposent pas de schéma par défaut, lorsque le paramètre&nbsp;<code>$protocols</code>&nbsp;contient&nbsp;<code>\'https\'</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"0MhD0ifthp\"><a href=\"https://make.wordpress.org/core/2025/11/19/url-escaping-functions-can-support-https-as-the-default-protocol-in-wordpress-6-9/\">URL-escaping functions can support HTTPS as the default protocol in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;URL-escaping functions can support HTTPS as the default protocol in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/url-escaping-functions-can-support-https-as-the-default-protocol-in-wordpress-6-9/embed/#?secret=jGf9jBhCeM#?secret=0MhD0ifthp\" data-secret=\"0MhD0ifthp\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"improved-email-handling-and-inline-image-support\">Amélioration de la gestion des e-mails et du support des images en ligne</h3>\n\n\n\n<p>WordPress 6.9 introduit plusieurs modifications rendant le système d&rsquo;envoi d&rsquo;e-mails plus fiable et flexible. La fonction&nbsp;<code>wp_mail()</code>&nbsp;met maintenant en place l&rsquo;adresse d&rsquo;expédition de manière extensible, les en-têtes sont mieux protégés et l&rsquo;ensemble se repose davantage sur PHPMailer pour la prise en charge des types de contenus. De nombreux autres petits soucis présents depuis quelques temps ont aussi été résolus.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"xd0Bpq88VA\"><a href=\"https://make.wordpress.org/core/2025/11/18/more-reliable-email-in-wordpress-6-9/\">More-reliable email in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;More-reliable email in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/18/more-reliable-email-in-wordpress-6-9/embed/#?secret=y21eGjb1ze#?secret=xd0Bpq88VA\" data-secret=\"xd0Bpq88VA\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>Cette version ajoute aussi la prise en charge des images en ligne et embarquées dans les e-mails HTML, ce qui permet d&rsquo;envoyer des messages enrichis de médias sans avoir à utiliser des URL de sources externes. Les contenus e-mail qui utilisent des références basées sur <code>cid:</code>&nbsp;peuvent désormais afficher des images directement dans le corps de l&rsquo;e-mail.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wZZMOBpIHQ\"><a href=\"https://make.wordpress.org/core/2025/09/04/prettier-emails-supporting-inline-embedded-images/\">Prettier Emails: Supporting Inline Embedded Images</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Prettier Emails: Supporting Inline Embedded Images&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/09/04/prettier-emails-supporting-inline-embedded-images/embed/#?secret=n7ruDqZVQJ#?secret=wZZMOBpIHQ\" data-secret=\"wZZMOBpIHQ\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"travaux-lies-a-l-implementation-des-outils-ia-dans-wp-6-9\">Travaux liés à l&rsquo;implémentation des outils IA dans WP 6.9</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"php-ai-client\">Client PHP pour l&rsquo;implémentation d&rsquo;outils IA</h3>\n\n\n\n<p>Le <a href=\"https://github.com/WordPress/php-ai-client\">nouveau SDK client PHP destiné aux outils IA</a> facilite l&rsquo;intégration d&rsquo;IA dans les extensions WordPress et les projets PHP. L&rsquo;interface fonctionne avec tous les fournisseurs d&rsquo;IA et les développeurs et développeuses peuvent spécifier les fonctionnalités IA à inclure, leur fournisseur et le modèle à utiliser. Les identifiants sont centralisés et fonctionnent avec toutes les extensions compatibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-wordpress-ai wp-block-embed-wordpress-ai\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"e4MhX2H9Gt\"><a href=\"https://make.wordpress.org/ai/2025/07/17/php-ai-api/\">PHP AI Client</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;PHP AI Client&#8221; &#8212; WordPress AI\" src=\"https://make.wordpress.org/ai/2025/07/17/php-ai-api/embed/#?secret=n4QeTroMUh#?secret=e4MhX2H9Gt\" data-secret=\"e4MhX2H9Gt\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"mcp-adapter\">Adaptateur MCP</h3>\n\n\n\n<p>Le nouvel&nbsp;<a href=\"https://github.com/WordPress/mcp-adapter\">adaptateur MCP</a>&nbsp;utilise le&nbsp;<a href=\"https://modelcontextprotocol.io/\">Model Context Protocol</a>&nbsp;(MCP) pour standardiser les interactions de l&rsquo;applicatif WP avec les LLM, pour exposer les fonctionnalités de WordPress aux assistants IA et pour se connecter à d&rsquo;autres serveurs MCP. Cela permet à WordPress d&rsquo;agir à la fois comme serveur et comme client, en enregistrant ses fonctionnalités à travers l&rsquo;API «&nbsp;Abilities&nbsp;» ce qui permet aux assistants IA de les comprendre et de les utiliser, tout en intégrant cela avec d&rsquo;autres serveurs MCP ce qui rend possible de tirer parti d&rsquo;autres outils IA dans WordPress.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-wordpress-ai wp-block-embed-wordpress-ai\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"e6borTD1aD\"><a href=\"https://make.wordpress.org/ai/2025/07/17/mcp-adapter/\">MCP Adapter</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;MCP Adapter&#8221; &#8212; WordPress AI\" src=\"https://make.wordpress.org/ai/2025/07/17/mcp-adapter/embed/#?secret=CmJsm2zJFL#?secret=e6borTD1aD\" data-secret=\"e6borTD1aD\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"but-wait-there-is-more\">Attendez, ce n’est pas fini&nbsp;!</h2>\n\n\n\n<p>6.9 apporte bien plus encore&nbsp;!&nbsp;Plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">250 bogues ont été corrigés</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">123 améliorations et nouvelles fonctionnalités ont été implémentées</a>, et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">22 tâches diverses</a>&nbsp;ont été <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">marquées comme résolues dans WP 6.9</a>.</p>\n\n\n\n<p>Mentionnons notamment les tickets suivants&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>API «&nbsp;Abilities&nbsp;» : feuille de route pour WP 6.9 (<a href=\"https://github.com/WordPress/abilities-api/issues/83\">AI-83</a>)</li>\n\n\n\n<li>Accessibilité : correction du comportement des sous menus du bloc navigation (<a href=\"https://github.com/WordPress/gutenberg/issues/69834\">GB-69834</a>)</li>\n\n\n\n<li>Éditeur : bloc bouton &#8211; ajout de la section Élément HTML dans les réglages avancés (<a href=\"https://github.com/WordPress/gutenberg/pull/70139\">GB-70139</a>)</li>\n\n\n\n<li>Éditeur : activation de la Palette de Commandes partout sur le tableau de bord (<a href=\"https://github.com/WordPress/gutenberg/issues/58218\">GB-58218</a>)</li>\n\n\n\n<li>Éditeur : nouveaux blocs ajoutés dans la bibliothèque de blocs (<a href=\"https://github.com/WordPress/gutenberg/issues/71026\">GB-71026</a>)</li>\n\n\n\n<li>Éditeur : barre d&rsquo;outils &#8211;  ajustement des couleurs pour la prise en charge du mode sombre (<a href=\"https://github.com/WordPress/gutenberg/issues/66454\">GB-66454</a>)</li>\n\n\n\n<li>Accessibilité : remplacement des règles CSS dépréciées <code>speak</code>&nbsp;et&nbsp;<code>aural</code>&nbsp;(<a href=\"https://github.com/WordPress/gutenberg/pull/63603\">GB-63603</a>)</li>\n\n\n\n<li>Styles globaux : déplacement du bouton&nbsp;<code>Couleurs aléatoires</code>&nbsp;dans le panneau d&rsquo;édition de la palette de couleurs (<a href=\"https://github.com/WordPress/gutenberg/issues/66169\">GB-66169</a>)</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que la version 6.9 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.9.0/\">https://developer.wordpress.org/reference/since/6.9.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-style-serif has-light-grey-2-color has-text-color has-background has-link-color wp-elements-e19b82be4e2290f9a4720996c21421a5 is-layout-constrained wp-block-group-is-layout-constrained\" style=\"background:linear-gradient(135deg,rgb(53,10,128) 67%,rgb(244,237,234) 100%);padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50)\">\n<p class=\"is-style-serif has-light-grey-2-color has-text-color has-link-color wp-elements-bdd3ef48864355ea6c49d0c39359deba\">Que vous développiez des thèmes ou des extensions, pensez à <strong>tester et retester votre code</strong> pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em>&nbsp;de WordPress 6.9</a>.&nbsp;<br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du&nbsp;<a href=\"https://make.wordpress.org/core/2025/11/25/wordpress-6-9-field-guide/\">Field Guide&nbsp;de WP 6.9 (en anglais)</a>&nbsp;par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3383\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"Arrêt des mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"https://fr.wordpress.org/2025/07/11/arret-des-mises-a-jour-de-securite-pour-les-versions-4-1-a-4-6-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Jul 2025 09:26:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Securité\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3375\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"À compter de mi-juillet 2025, l&#8217;équipe de sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress. Ces versions ont été initialement publiées il y a plus de neuf ans et plus de 99 % des installations WordPress utilisent une version plus récente. La probabilité que [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1368:\"\n<p>À compter de mi-juillet 2025, l&rsquo;équipe de sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress.</p>\n\n\n\n<p>Ces versions ont été initialement publiées il y a plus de neuf ans et plus de 99 % des installations WordPress utilisent une version plus récente. La probabilité que cela affecte votre site est très faible.</p>\n\n\n\n<p>Pour vérifier que votre version de WordPress est à jour, connectez-vous au tableau de bord de votre site. Si votre version n&rsquo;est pas à jour, vous devriez voir un message proposant sa mise à jour. La version que vous utilisez est indiquée dans le widget « D&rsquo;un coup d&rsquo;œil » présent sur le tableau de bord.</p>\n\n\n\n<p>Pour rappel, <strong>la seule version de WordPress activement maintenue est la version majeure la plus récente</strong>. Les correctifs de sécurité ne sont portés vers les anciennes branches que par « courtoisie », les anciennes versions ne faisant pas l&rsquo;objet de corrections autres que de sécurité.</p>\n\n\n\n<p>Le blog « <bdo lang=\"en\" dir=\"ltr\">Make WordPress Security</bdo> » fournit plus de détails sur la <a href=\"https://make.wordpress.org/security/2025/06/18/security-updates-will-cease-for-wordpress-versions-4-1-through-4-6/\">procédure de fin de support de ces versions (en anglais)</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3375\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Rendez-vous à Bâle pour le WordCamp Europe 2025 !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://fr.wordpress.org/2025/04/28/rendez-vous-a-bale-pour-le-wordcamp-europe-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Apr 2025 08:39:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3362\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"Le WordCamp Europe 2025 se tiendra du 5 au 7 juin dans la magnifique ville de Bâle, en Suisse. Il réunira les passionné·e·s de WordPress et du logiciel libre, des développeuses et développeurs et des professionnels de notre écosystème provenant de tout le continent et même du monde entier ! Venez découvrir de nouvelles perspectives, engagez [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6355:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1024x538.jpg\" alt=\"\" class=\"wp-image-3363\" srcset=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1024x538.jpg 1024w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-300x158.jpg 300w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-768x403.jpg 768w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1536x806.jpg 1536w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image.jpg 1800w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Le WordCamp Europe 2025 se tiendra du 5 au 7 juin dans la magnifique ville de Bâle, en Suisse. Il réunira les passionné·e·s de WordPress et du logiciel libre, des développeuses et développeurs et des professionnels de notre écosystème provenant de tout le continent et même du monde entier !</p>\n\n\n\n<p>Venez découvrir de nouvelles perspectives, engagez des conversations avec les membres de la communauté WordPress, les entreprises et acteurs économiques innovants de notre écosystème au cours de trois jours de conférences, de réseautage et de contribution à WordPress.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Les places sont limitées : réservez la vôtre dès aujourd&rsquo;hui !</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://europe.wordcamp.org/2025/tickets/\">Réservez votre place (en anglais)</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Conférences et tables rondes</h2>\n\n\n\n<p>Cet évènement qui se tiendra les 6 et 7 juin 2025 proposera une <a href=\"https://europe.wordcamp.org/2025/schedule/\">série de conférences (en anglais)</a> qui porteront notamment sur des états des lieux de la stratégie des entreprise de l&rsquo;écosystème WordPress, le développement des nouvelles fonctionnalités du CMS, la défense du logiciel libre, l&rsquo;accessibilité, et bien plus encore.</p>\n\n\n\n<p>Pour celles et ceux qui souhaitent perfectionner leurs compétences, les présentations aborderont en profondeur des sujets tels que le SEO pour WordPress, l&rsquo;optimisation des performances, ou encore la conception et la production de sites assistée par l&rsquo;IA.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Séance de questions-réponses avec la direction du projet WordPress</h2>\n\n\n\n<p>Vous pourrez retrouver Mary Hubbard, directrice exécutive du projet WordPress, et Matt Mullenweg, co-fondateur de WordPress le 7 juin pour discuter de WordPress et de sa communauté.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Découvrez Bâle</h2>\n\n\n\n<p>Bâle est la troisième plus grande ville de Suisse. Elle est <a href=\"https://europe.wordcamp.org/2025/location/\">remplie de monuments historiques et culturels à découvrir (en anglais)</a>. Vous pouvez vous déplacer à Bâle et en faire l&rsquo;expérience par vous-même grâce à votre «&nbsp;<bdo lang=\"en\" dir=\"ltr\">BaselCard</bdo>&nbsp;», qui vous permet de monter dans tous les transports en commun de la ville. L&rsquo;équipe d&rsquo;organisation du WordCamp vous recommande fortement d’en profiter pour vous promener le long du Rhin&nbsp;!</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f6cf.png\" alt=\"🛏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/accommodation/\"> Trouver des logements à Bâle (en anglais)<br></a><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f68c.png\" alt=\"🚌\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/getting-around-in-basel/\"> En savoir plus sur la « <bdo lang=\"en\" dir=\"ltr\">BaselCard</bdo> » (en anglais)</a><br><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f4c5.png\" alt=\"📅\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Organisez votre WordCamp Europe !</strong> Découvrez le <a href=\"https://europe.wordcamp.org/2025/schedule/\">programme complet (en anglais)</a> et organisez votre séjour à Bâle !<br><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Assurez-vous de réserver votre <a href=\"https://europe.wordcamp.org/2025/tickets/\">ticket pour le WordCamp Europe 2025</a></strong> si vous ne l&rsquo;avez pas déjà fait !</p>\n\n\n\n<p>Suivez l&rsquo;actualité du WordCamp Europe sur <a href=\"https://bsky.app/profile/wordpress.org\">Bluesky</a>, <a href=\"https://instagram.com/wordpress/\">Instagram</a>, <a href=\"https://www.facebook.com/WordPress\">Facebook</a>, <a href=\"https://www.linkedin.com/company/wordpress/\">LinkedIn</a>, <a href=\"https://www.threads.net/@wordpress\">Threads</a>, <a href=\"https://mastodon.world/@wordpress\">Mastodon</a>  et <a href=\"https://twitter.com/WordPress\">X/Twitter</a> pour avoir des nouvelles en temps réel&nbsp;!</p>\n\n\n\n<p>N&rsquo;hésitez pas à relayer le message sur vos réseaux sociaux favoris : que vous soyez là le jour-J à Bâle ou que vous nous suiviez en ligne, partagez vos expériences avec les mots-dièse #WCEU et #WordPress sur tous les réseaux sociaux !</p>\n\n\n\n<p>Rendez-vous à Bâle pour le WordCamp Europe 2025&nbsp;! <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f1e8-1f1ed.png\" alt=\"🇨🇭\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3362\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 6.8 « Cecil »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://fr.wordpress.org/2025/04/15/wordpress-6-8-cecil/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Apr 2025 17:02:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3335\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:390:\"Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde de la musique. WordPress 6.8 «&#160;Cecil&#160;» rend hommage au légendaire pianiste et pionnier du jazz Cecil Taylor. De formation classique mais résolument anticonformiste, Cecil Taylor a ré-imaginé le piano comme un instrument de percussion, superposant les sons, explorant la [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:80564:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"535\" src=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1024x535.png\" alt=\"\" class=\"wp-image-3338\" srcset=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1024x535.png 1024w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-300x157.png 300w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-768x401.png 768w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1536x803.png 1536w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde de la musique. WordPress 6.8 «&nbsp;Cecil&nbsp;» rend hommage au légendaire pianiste et pionnier du jazz Cecil Taylor.</p>\n\n\n\n<p>De formation classique mais résolument anticonformiste, Cecil Taylor a ré-imaginé le piano comme un instrument de percussion, superposant les sons, explorant la polyphonie et associant différents rythmes pour créer un son à la fois chaotique et précis. Sa musique a été révolutionnaire, formant de l&rsquo;ordre dans le désordre et de l&rsquo;harmonie dans la dissonance.</p>\n\n\n\n<p>Cet esprit anime WordPress 6.8. Adoptez ses nouvelles fonctionnalités audacieuses avec la même curiosité et la même expérimentation qui ont défini la création musicale de Cecil.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.8&nbsp;!</h2>\n\n\n\n<p>WordPress 6.8 peaufine et optimise les outils que vous utilisez au quotidien, ce qui rend votre site plus rapide, plus sécurisé et plus facile à gérer. Le guide de styles propose désormais une mise en page structurée et fonctionne avec les thèmes classiques, vous offrant ainsi un meilleur contrôle sur les styles globaux. Le chargement spéculatif accélère la navigation en préchargeant les liens avant même que les internautes n&rsquo;y accèdent, tandis que le hachage <code>bcrypt</code> renforce automatiquement la sécurité des mots de passe. En coulisses, les optimisations de la base de données améliorent les performances, et un nouveau système d&rsquo;alerte de sécurité permet de prévenir les vulnérabilités avant qu&rsquo;elles ne deviennent problématiques.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\">Télécharger WordPress 6.8 «&nbsp;Cecil&nbsp;» en français (ZIP – 20 Mo)</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Une version peaufinée à la perfection</h2>\n\n\n\n<p>WordPress 6.8 améliore et affine les outils que vous utilisez tous les jours, rendant votre site plus rapide, plus sûr et plus facile à gérer.</p>\n\n\n\n<p>Le guide de styles a maintenant une mise en page structurée et fonctionne désormais avec les thèmes classiques, ce qui vous apporte plus de contrôle sur les styles globaux de votre site.</p>\n\n\n\n<p>Le chargement spéculatif accélère la navigation en préchargeant les liens avant que les internautes ne naviguent vers ceux-ci, tandis que le hachage via bcrypt renforce automatiquement la sécurité des mots de passe.</p>\n\n\n\n<p>Parallèlement, des optimisations de la base de données améliorent les performances, et un nouveau système d’avertissement de sécurité aide à prévenir les vulnérabilités avant qu’elles ne deviennent un problème.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Le guide de style fait peau neuve et s’enrichit de quelques nouvelles fonctionnalités</h3>\n\n\n\n<p>Le guide de styles présente une nouvelle mise en page structurée et des libellés plus clairs, pour faciliter encore plus la modification des couleurs, de la typographie et de presque tous les styles de votre site, en un seul endroit.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-01.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-01-300x300.png\" alt=\"\" class=\"wp-image-3339\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-01-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-01-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-01-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-01.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Amélioration de l’éditeur</h3>\n\n\n\n<p>Visualisez plus facilement vos options dans les vues de données et excluez les publications épinglées de la boucle de requête. De plus, l’éditeur propose de nombreuses améliorations qui simplifient la création de contenu.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-02.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-02-300x300.png\" alt=\"\" class=\"wp-image-3340\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-02-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-02-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-02-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-02.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Chargement quasi instantané des pages, grâce au chargement spéculatif</h3>\n\n\n\n<p>Dans WordPress 6.8, les pages se chargent plus rapidement que jamais. Lorsque vous ou tout internaute survolez ou cliquez sur un lien, WordPress peut précharger la page suivante pour une expérience plus fluide et quasi instantanée. Le système équilibre vitesse et efficacité, et vous pouvez contrôler son fonctionnement avec une extension ou votre propre code. Cette fonctionnalité fonctionne uniquement dans les navigateurs modernes&nbsp;; les anciens l’ignoreront simplement sans aucun impact.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-03.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-03-300x300.png\" alt=\"\" class=\"wp-image-3341\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-03-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-03-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-03-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-03.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Sécurité renforcée des mots de passe avec bcrypt</h3>\n\n\n\n<p>Les mots de passe sont désormais plus difficiles à déchiffrer grâce au hachage bcrypt, qui nécessite beaucoup plus de puissance de calcul pour être cassé. Cela renforce la sécurité globale, tout comme d‘autres améliorations de chiffrement dans WordPress. Vous n’avez rien à faire&nbsp;: tout se met à jour automatiquement.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-04.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-04-300x300.png\" alt=\"\" class=\"wp-image-3342\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-04-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-04-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-04-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-04.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 100 correctifs et améliorations en matière d’accessibilité touchent un large champ de l’expérience WordPress. Cette version inclut des correctifs pour chaque thème natif, des améliorations de la gestion des menus de navigation, de l’outil de personnalisation, et un étiquetage simplifié. L’éditeur de blocs bénéficie de plus de 70 améliorations concernant les blocs, les vues de données, et l’expérience globale des utilisateurs et utilisatrices.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Allégement de la base de données</h3>\n\n\n\n<p>Le travail se poursuit sur l‘optimisation de la génération des clés de cache dans la classe&nbsp;<code>WP_Query</code>. L‘objectif est, comme toujours, d‘améliorer les performances de votre site, dans ce cas en réduisant davantage la charge de votre base de données. Cela est particulièrement utile si vous avez beaucoup de trafic.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress&nbsp;6.8 propose de nombreuses corrections et améliorations de performances pour accélérer l’ensemble de votre site, de l’administration aux temps de chargement ressentis par les personnes qui visitent votre site. Au-delà du chargement spéculatif désormais intégré nativement, WordPress&nbsp;6.8 accorde une attention particulière à l’éditeur de blocs, à l’enregistrement des types de blocs et à la mise en cache des requêtes. N’attendez jamais plus de 50&nbsp;millisecondes entre chaque interaction. Dans WordPress&nbsp;6.8, l’API de gestion de l’interactivité constitue un premier pas vers cet objectif.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.8</h2>\n\n\n\n<p>Pour une vision complète de toutes les nouvelles fonctionnalités et améliorations de WordPress 6.8, vous pouvez <a href=\"https://wordpress.org/download/releases/6-8/\">consulter le site de démonstration des fonctionnalités (en anglais)</a>.</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em><bdo lang=\"en\" dir=\"ltr\">Learn WordPress</bdo></em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Learn</bdo></em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;évènements interactifs&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Notes de version de WordPress 6.8</h4>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-8/\">Lisez les notes de version de WordPress 6.8</a> pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Guide technique de WordPress 6.8 en français</h4>\n\n\n\n<p><a href=\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\">Explorez le guide des changements techniques de WordPress 6.8</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous permettent de construire votre site avec WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.8</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale :&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version :&nbsp;<a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a></li>\n\n\n\n<li>Direction technique :&nbsp;<a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>,&nbsp;<a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, and&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a></li>\n\n\n\n<li>Gestion de projet :&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Direction artistique :&nbsp;<a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a></li>\n\n\n\n<li>Responsable des performances :&nbsp;<a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a></li>\n\n\n\n<li>Direction des tests :&nbsp;<a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.8 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>900 personnes provenant de près de 70 pays différents</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 250 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.8 <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<div class=\"wp-block-group alignwide is-style-default is-content-justification-left is-nowrap is-layout-flex wp-container-core-group-is-layout-fc9f69e7 wp-block-group-is-layout-flex\">\n<p class=\"has-dark-blueberry-color has-lemon-3-background-color has-text-color has-background has-link-color has-extra-small-font-size wp-elements-70a077000b3aff2481eb0decd1e70b5e\"><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/hiabhaykulkarni/\">Abhay Kulkarni</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/adakaleh/\">AdaKaleh</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adhun/\">Adhun Anand</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/stromhalm/\">Adrian Jagusch</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/hemant-ahir/\">Ahir Hemant</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ahsankhan316/\">Ahsan Khan</a> · <a href=\"https://profiles.wordpress.org/aishwarryapande/\">Aishwarrya Pande</a> · <a href=\"https://profiles.wordpress.org/ajayghaghretiya1/\">Ajay Ghaghretiya</a> · <a href=\"https://profiles.wordpress.org/ajmaurya/\">Ajay Maurya</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/aks30498/\">aks30498</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexflorisca/\">Alex Florisca</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/albigdd/\">Alexander Bigga</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexschmitz/\">alexschmitz</a> · <a href=\"https://profiles.wordpress.org/alireyad/\">Ali Akbar Reyad</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/alpipego/\">alpipego</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/akrocks/\">Amaan Khan</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amimulihsanmahdi/\">Amimul Ihsan</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/ammarmassoud/\">Ammar Mohamed Fath Allah Abd-Elaaty Massoud</a> · <a href=\"https://profiles.wordpress.org/amolebonde/\">amolebonde</a> · <a href=\"https://profiles.wordpress.org/anandraj346/\">Anand Raj</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/bowedk/\">Andreas Pedersen</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewssanya/\">Andrew Ssanya</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/rilwis/\">Anh Tran</a> · <a href=\"https://profiles.wordpress.org/wpgurudev/\">Ankit Gade</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/ankitpatel1578/\">Ankit Patel</a> · <a href=\"https://profiles.wordpress.org/anmolverma404/\">Anmol Verma</a> · <a href=\"https://profiles.wordpress.org/annchichi/\">annchichi</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">annezazu</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arielmaidana/\">Ariel Maidana</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/arnoutblueshell/\">arnoutblueshell</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/auareyou/\">Au</a> · <a href=\"https://profiles.wordpress.org/autotutorial/\">autotutorial</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">BackuPs</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/bsutcliffe/\">Ben Sutcliffe</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/benniledl/\">Benedikt Ledl</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berislavgrgicak/\">Bero</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/albatross10/\">Bhavik Kalpesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">Bijit Deb</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a> · <a href=\"https://profiles.wordpress.org/bluantinoo/\">bluantinoo</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradleyt/\">Bradley Taylor</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/bpayton/\">Brandon Payton</a> · <a href=\"https://profiles.wordpress.org/brettsmason/\">brettsmason</a> · <a href=\"https://profiles.wordpress.org/brevilo/\">brevilo</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">Bronson Quick</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/burakkaptan/\">burak</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/calvinalkan/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cgastrell/\">cgastrell</a> · <a href=\"https://profiles.wordpress.org/charleslf/\">charleslf</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chintanmachhi207/\">chintanmachhi207</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/claudiulodro/\">Claudiu Lodromanean</a> · <a href=\"https://profiles.wordpress.org/codebymikey/\">codebymikey</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/colinleroy/\">colinleroy</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cbusquets1989/\">Cris Busquets</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/ctienshi/\">ctienshi</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/css31/\">Cyrille Sanson</a> · <a href=\"https://profiles.wordpress.org/daedalon/\">Daedalon</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/dalleyne/\">Damien Alleyne</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dpknauss/\">Dan Knauss</a> · <a href=\"https://profiles.wordpress.org/danht/\">danht</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danielpost/\">Daniel Post</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danielpataki/\">danielpataki</a> · <a href=\"https://profiles.wordpress.org/danielvann/\">danielvann</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/dhewercorus/\">Darren Hewer</a> · <a href=\"https://profiles.wordpress.org/davelo/\">Dave Loodts</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darnado/\">David Arnado</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dafargier/\">David FARGIER</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/david-innes/\">David Innes</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/daymobrew/\">daymobrew</a> · <a href=\"https://profiles.wordpress.org/deadduck169/\">deadduck169</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deeppatel8950/\">Deep Patel</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhavalkapadane/\">Dhaval Kapadane</a> · <a href=\"https://profiles.wordpress.org/dheeraj2995/\">Dheeraj Bhosale</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/dilipom13/\">dilip</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/diliphingarajiya/\">Dilip Hingarajiya</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dingguodong/\">DingGuodong</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divyeshk71/\">Divyesh_kakrecha</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/mediaformat/\">Django</a> · <a href=\"https://profiles.wordpress.org/dnnsjsk/\">dnnsjsk</a> · <a href=\"https://profiles.wordpress.org/doekenorg/\">Doeke Norg</a> · <a href=\"https://profiles.wordpress.org/dogee/\">dogee</a> · <a href=\"https://profiles.wordpress.org/domenicdenicola/\">domenicdenicola</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/dooperweb/\">dooperweb</a> · <a href=\"https://profiles.wordpress.org/dougwollison/\">Doug Wollison</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dwainm/\">Dwain Maralack</a> · <a href=\"https://profiles.wordpress.org/earthman100/\">Earthman Media</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eddystile/\">Eddy</a> · <a href=\"https://profiles.wordpress.org/cais/\">Edward Caissie</a> · <a href=\"https://profiles.wordpress.org/eceleste/\">efc</a> · <a href=\"https://profiles.wordpress.org/talksina/\">Elena Brescacin</a> · <a href=\"https://profiles.wordpress.org/elizaan36/\">elizaan36</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanuel Atsé</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/codekraft/\">Erik</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/finntown/\">finntown</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/franciscabusas22/\">Francis Cabusas</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/frankbiganski/\">Frank B.</a> · <a href=\"https://profiles.wordpress.org/frank-klein/\">Frank Klein</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/frkly/\">frkly</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/fxbenard/\">fxbenard</a> · <a href=\"https://profiles.wordpress.org/gaellebesson/\">gaellebesson</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/galibh/\">Galib Hayder</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/ghinamt/\">ghinamt</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuriani/\">giuriani</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/glynnquelch/\">Glynn Quelch</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/grgarside/\">grgarside</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/gencmedya/\">Halil Kaya</a> · <a href=\"https://profiles.wordpress.org/yahaly/\">Halyna Yampolska</a> · <a href=\"https://profiles.wordpress.org/hameem1102/\">Hameem Mahdad Kader</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">Hannes Leismann</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harrym/\">harrym</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hekuranredev/\">hekuranredev</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/hdkothari81/\">Hemant Kothari</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a> · <a href=\"https://profiles.wordpress.org/rvouill/\">Herve THOMAS</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">hideishi</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshhuptechweb/\">Hitesh Dhokai</a> · <a href=\"https://profiles.wordpress.org/hovhanneshovakimyan/\">Hovhannes Hovakimyan</a> · <a href=\"https://profiles.wordpress.org/hueitan/\">hueitan</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/hussain896/\">hussain896</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ilovecats7/\">ilovecats7</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/indithemes/\">indithemes</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/isuke01/\">Isu</a> · <a href=\"https://profiles.wordpress.org/ivankristianto/\">Ivan Kristianto</a> · <a href=\"https://profiles.wordpress.org/moxie/\">Jack</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/jopdop30/\">James Payne</a> · <a href=\"https://profiles.wordpress.org/imaginarymedia/\">James Robinson</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/jammycakes/\">jammycakes</a> · <a href=\"https://profiles.wordpress.org/lysyjan87/\">Jan Lysý</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/janusdev/\">janusdev</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/jdnd/\">jdnd</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/maverick3x6/\">Jeff Golenski</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jepperask/\">jepperask</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeremy80/\">jeremy80</a> · <a href=\"https://profiles.wordpress.org/jeremyroman/\">jeremyroman</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jartes/\">Joan Artes</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joecsmalley/\">joecsmalley</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes Jülg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/arrcorona/\">Jomar Jay</a> · <a href=\"https://profiles.wordpress.org/jomonthomaslobo1/\">Jomon Thomas Lobo</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/jongycastillo/\">Jong</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkilä</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnyauk/\">jonnyauk</a> · <a href=\"https://profiles.wordpress.org/joomskys/\">joomskys</a> · <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/blogitsolutions/\">Josef Seidl</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/joshuawold/\">Joshua Wold</a> · <a href=\"https://profiles.wordpress.org/jottevanger/\">jottevanger</a> · <a href=\"https://profiles.wordpress.org/jokanane/\">Jouni Kananen</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanbuis/\">juanbuis</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juanwp22/\">juanwp22</a> · <a href=\"https://profiles.wordpress.org/jules-colle/\">Jules Colle</a> · <a href=\"https://profiles.wordpress.org/julianmar/\">julianmar</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/juzar/\">Juzar</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kapasias/\">KAP ASIAs</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/karlgroves/\">karlgroves</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/keithdevon/\">keithdevon</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/ketanniruke/\">Ketan Niruke</a> · <a href=\"https://profiles.wordpress.org/patelketan/\">Ketan Patel</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevinleary.net</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kjroelke/\">KJ Roelke</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kohheepeace/\">kohheepeace</a> · <a href=\"https://profiles.wordpress.org/kmgalanakis/\">Konstantinos Galanakis</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupaly2k/\">Krupal Lakhia</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/laxman-prajapati/\">Laxman Prajapati</a> · <a href=\"https://profiles.wordpress.org/lcarevic/\">lcarevic</a> · <a href=\"https://profiles.wordpress.org/leecollings/\">Lee</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">lenasterg</a> · <a href=\"https://profiles.wordpress.org/leszeks/\">leszeks</a> · <a href=\"https://profiles.wordpress.org/leup/\">leup</a> · <a href=\"https://profiles.wordpress.org/levskipg/\">levskipg</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/louislaugesen/\">Louis</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/lovewpmu/\">lovewpmu</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/dreadlox/\">Lox</a> · <a href=\"https://profiles.wordpress.org/ltrihan/\">ltrihan</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/gadelhas/\">Mário Santos</a> · <a href=\"https://profiles.wordpress.org/maciejmackowiak/\">maciejmackowiak</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/magdarogier/\">Magda Rogier</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mp518/\">Mahesh Prajapati</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/maikelraow/\">maikelraow</a> · <a href=\"https://profiles.wordpress.org/travel_girl/\">Maja Benke</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/tomdxw/\">mallorydxw-old</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manojmaharrshi/\">Manoj Maharrshi</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/marchalyoan/\">marchalyoan</a> · <a href=\"https://profiles.wordpress.org/afmarchetti/\">Marchetti Design</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/nuryko/\">Marianna</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/marineevain/\">Marine EVAIN</a> · <a href=\"https://profiles.wordpress.org/nofearinc/\">Mario Peshev</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/mapk/\">Mark Uraine</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/immasud/\">Masud Rana</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu Paapst</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/iammattthomas/\">Matt (Thomas) Miklic</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/kinggmobb/\">Matthew</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/azouamauriac/\">Mauriac AZOUA</a> · <a href=\"https://profiles.wordpress.org/maximemeganck/\">Maxime Meganck</a> · <a href=\"https://profiles.wordpress.org/maximebj/\">maximebj</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/itsmhrahman/\">Md Hafijur Rahman</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/mehdi01/\">Md Mahdi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdibrahimk48/\">Md. Ibrahim Khalil</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/leeseoftbc/\">MelissaH</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/mdawaffe/\">Michael Adams (mdawaffe)</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/websiteredev/\">Michael Willman</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a> · <a href=\"https://profiles.wordpress.org/micromadness/\">micromadness</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mmtr86/\">Miguel Torres</a> · <a href=\"https://profiles.wordpress.org/mijotj/\">Mijo T J</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/milindmore22/\">Milind More</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/369work/\">miroku</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/modi2918/\">Modi Sahil</a> · <a href=\"https://profiles.wordpress.org/antwortzeit/\">modulbuero</a> · <a href=\"https://profiles.wordpress.org/aboelfotoh/\">Mohamed Aboelfotoh Mohamed</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/mojorob/\">mojorob</a> · <a href=\"https://profiles.wordpress.org/jucaduca/\">Morais Junior</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mr660/\">mr660</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtdkei/\">mt</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Muddassir Rahman Nasim</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/my1xt/\">My1</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">n8finch</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir</a> · <a href=\"https://profiles.wordpress.org/nandow/\">nandow</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nataliat2004/\">Natalia T</a> · <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a> · <a href=\"https://profiles.wordpress.org/navneet/\">navneet</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/mcqueen22/\">NerQuiles</a> · <a href=\"https://profiles.wordpress.org/krstarica/\">net</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/nickgalvez/\">nickgalvez</a> · <a href=\"https://profiles.wordpress.org/undefinedfr/\">Nicolas RIVIERE</a> · <a href=\"https://profiles.wordpress.org/nicolasleroy/\">nicolasleroy</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/snilesh/\">Nilesh Shiragave</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/mrtortai/\">Noam Eppel</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/jbkkd/\">Omer Korner</a> · <a href=\"https://profiles.wordpress.org/arzola/\">Oscar Arzola</a> · <a href=\"https://profiles.wordpress.org/groenroos/\">Oskari Groenroos</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">othernoel</a> · <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pampfelimetten/\">pampfelimetten</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/dparthj/\">Parth Dodiya</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/casiepa/\">Pascal Casier</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/eartboard/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/bbpaule/\">Paul English</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paullb/\">paullb</a> · <a href=\"https://profiles.wordpress.org/psrpinto/\">Paulo Pinto</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/creadordev/\">Pawan Kumar</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/peter8nss/\">peter8nss</a> · <a href=\"https://profiles.wordpress.org/peterdavehello/\">peterdavehello</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philliproth/\">philliproth</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pixlpirate/\">pixlpirate</a> · <a href=\"https://profiles.wordpress.org/podpirate/\">podpirate</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja Killekar (Muchandikar)</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prashant/\">prashant</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/contactprashantpp/\">Prashant Patil</a> · <a href=\"https://profiles.wordpress.org/prathamesh24/\">Prathamesh Shirke</a> · <a href=\"https://profiles.wordpress.org/prathameshbhagat1511/\">prathameshbhagat1511</a> · <a href=\"https://profiles.wordpress.org/pkbhatt/\">Pratik Bhatt</a> · <a href=\"https://profiles.wordpress.org/pratikgandhi/\">Pratik Gandhi</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/priyank9033/\">Priyank</a> · <a href=\"https://profiles.wordpress.org/pushpenderindia/\">Pushpender Singh</a> · <a href=\"https://profiles.wordpress.org/itsjonq/\">Q</a> · <a href=\"https://profiles.wordpress.org/qhaensler/\">qhaensler</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rahulsprajapati/\">Rahul Prajapati</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajat1192/\">Rajat Patel</a> · <a href=\"https://profiles.wordpress.org/raj198/\">Rajendra Patel</a> · <a href=\"https://profiles.wordpress.org/rajendrapatilraj/\">Rajendra Patil</a> · <a href=\"https://profiles.wordpress.org/rkradadiya/\">Rajesh Radadiya</a> · <a href=\"https://profiles.wordpress.org/rajeshrathodwp/\">Rajesh Rathod</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/redkite/\">redkite</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/rembem/\">Remco</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho</a> · <a href=\"https://profiles.wordpress.org/ooraiser69/\">Renz Jay Sanchez</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rkyburz/\">rkyburz</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/harmr/\">Robert Seyfriedsberger</a> · <a href=\"https://profiles.wordpress.org/robertstaddon/\">robertstaddon</a> · <a href=\"https://profiles.wordpress.org/robinmartijn/\">Robin Martijn</a> · <a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/rogierlankhorst/\">Rogier Lankhorst</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/rohjay/\">rohjay</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/lev0/\">Roy Orbitson</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roybellingan/\">roybellingan</a> · <a href=\"https://profiles.wordpress.org/rseigel/\">rseigel</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rudrakshigupta/\">Rudrakshi Gupta</a> · <a href=\"https://profiles.wordpress.org/rupesh5438/\">Rupesh Patil</a> · <a href=\"https://profiles.wordpress.org/rupw/\">rupw</a> · <a href=\"https://profiles.wordpress.org/ruturajraval2305/\">Ruturaj Raval</a> · <a href=\"https://profiles.wordpress.org/rvoigt/\">rvoigt</a> · <a href=\"https://profiles.wordpress.org/bookdude13/\">Ryan Fredlund</a> · <a href=\"https://profiles.wordpress.org/ryanhellyer/\">Ryan Hellyer</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/sabrineg/\">sabrineg</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/sagarlakhani/\">Sagar Lakhani</a> · <a href=\"https://profiles.wordpress.org/sagarprajapati/\">Sagar Prajapati</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sailpete/\">sailpete</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sallyruchman/\">sally</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/ranafge/\">Samsul Islam Rana</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/codexdemon/\">Sanyogg Shelar</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/infosatech/\">Sayan Datta</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/sbathompson/\">sbathompson</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Scott Arciszewski</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/seanlanglands/\">seanlanglands</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sergiogutierrez/\">sergiogutierrez</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/shraddhagore/\">Shraddha Gore</a> · <a href=\"https://profiles.wordpress.org/shreyashd21/\">shreyashd21</a> · <a href=\"https://profiles.wordpress.org/shub07/\">Shubham Kumar Bansal</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shulard/\">shulard</a> · <a href=\"https://profiles.wordpress.org/shyamkariya/\">Shyam Kariya</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">SirLouen</a> · <a href=\"https://profiles.wordpress.org/sjefen6/\">sjefen6</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/mslavco/\">Slavco Mihajloski</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar/\">soyeb salar</a> · <a href=\"https://profiles.wordpress.org/spencerfinnell/\">Spencer Finnell</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spmultidots/\">spmultidots</a> · <a href=\"https://profiles.wordpress.org/spncr/\">spncr</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stefahn/\">Stefan Seidner-Britting</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/stimul/\">stimul</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/stuartmcalpine/\">Stuart McAlpine</a> · <a href=\"https://profiles.wordpress.org/subodhrajpopat/\">Subodh Rajpopat</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sketchboy/\">SUHAS SUTAR</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/csesumonpro/\">Sumon Sarker</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/surajswalstar/\">Suraj Sutar</a> · <a href=\"https://profiles.wordpress.org/swalkinshaw/\">swalkinshaw</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/tschwarz-1/\">t.schwarz</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/gonom9/\">Taegon Kim</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/takayukister/\">Takayuki Miyoshi</a> · <a href=\"https://profiles.wordpress.org/takuword/\">takuword</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/th23/\">th23</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/thomaswm/\">thomaswm</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/tiagogoncalves/\">tiago</a> · <a href=\"https://profiles.wordpress.org/tigriweb/\">TigriWeb</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Krüss</a> · <a href=\"https://profiles.wordpress.org/tb1909/\">Tim Brathärig</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timwhitlock/\">Tim W</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tkama/\">Timur Kamaev</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias Bäthge</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tgsrvrs/\">Tom Gugel</a> · <a href=\"https://profiles.wordpress.org/tommusrhodus/\">Tom Rhodes</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/trushaamin/\">Trusha</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tyb/\">Ty</a> · <a href=\"https://profiles.wordpress.org/tysonlmao/\">tysonlmao</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utrenkner/\">utrenkner</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/vaibhavsweb/\">Vaibhav Singh Web</a> · <a href=\"https://profiles.wordpress.org/vaibhav2527/\">Vaibhav Tukaram Nawale</a> · <a href=\"https://profiles.wordpress.org/twvania/\">Vania</a> · <a href=\"https://profiles.wordpress.org/okvee/\">vee</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/fylgjur/\">Victoria – a11n</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/virgildia/\">Virgildia</a> · <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a> · <a href=\"https://profiles.wordpress.org/virginienacci/\">virginienacci</a> · <a href=\"https://profiles.wordpress.org/vishy-moghan/\">Vishy Moghan</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/vykesmac/\">vykesmac</a> · <a href=\"https://profiles.wordpress.org/wadowad/\">wadowad</a> · <a href=\"https://profiles.wordpress.org/pctevree/\">Web-Pepper</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/west7/\">Wes Theron</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/worldweb/\">World Web Technology</a> · <a href=\"https://profiles.wordpress.org/wpgerd/\">wpgerd</a> · <a href=\"https://profiles.wordpress.org/wwdes/\">wwdes</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xpurichan/\">xpurichan</a> · <a href=\"https://profiles.wordpress.org/yahil/\">Yahil Madakiya</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/yashrocz/\">Yash Kukreja</a> · <a href=\"https://profiles.wordpress.org/yellowafterlife/\">yellowafterlife</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/omaeyusuke/\">yuu</a> · <a href=\"https://profiles.wordpress.org/zaoyao/\">zaoyao</a> · <a href=\"https://profiles.wordpress.org/zargarov/\">Zargarov</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.8 en français</h3>\n\n\n\n<p>WordPress est un projet international et la version 6.8 est déjà complètement disponible dans plus de 40 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.8 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/fxbenard\">FX Benard</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>,&nbsp;<a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mumuu000\">mumuu000</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>,&nbsp;<a href=\"https://profiles.wordpress.org/rodrigoq\">rodrigoq</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>,&nbsp;<a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>,&nbsp;<a href=\"https://profiles.wordpress.org/translationsbyautomattic\">Translations by Automattic</a>, et&nbsp;<a href=\"https://profiles.wordpress.org/wptranslationsorg\">WP-Translations</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article rédigé par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\'https://profiles.wordpress.org/jdy68/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jdy68</a> et <a href=\'https://profiles.wordpress.org/nlegagneur/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nlegagneur</a> pour leur relecture.</p>\n\n\n\n<p><br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3335\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2025/03/28/guide-des-changements-techniques-de-wordpress-6-8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Mar 2025 07:53:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3310\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"Découvrez les changements techniques qui arrivent le 15 avril 2025 avec la version 6.8 de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:35094:\"\n<figure class=\"wp-block-image alignfull size-full\"><a href=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png\"><img loading=\"lazy\" decoding=\"async\" width=\"2156\" height=\"1084\" src=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png\" alt=\"\" class=\"wp-image-3312\" srcset=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png 2156w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-300x151.png 300w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-1024x515.png 1024w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-768x386.png 768w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-1536x772.png 1536w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-2048x1030.png 2048w\" sizes=\"auto, (max-width: 2156px) 100vw, 2156px\" /></a></figure>\n\n\n\n<div class=\"wp-block-group has-small-font-size is-content-justification-right is-nowrap is-layout-flex wp-container-core-group-is-layout-b315634e wp-block-group-is-layout-flex\">\n<p>Temps de lecture estimé&nbsp;:&nbsp;</p>\n\n\n<div class=\"wp-block-post-time-to-read\">6–9 minutes</div></div>\n\n\n\n<p>WordPress 6.8 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">300 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">104 améliorations et nouvelles fonctionnalités</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 170 corrections de bogues</a>. Cette version comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">23 tickets focalisés sur les performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">34 sur l’accessibilité</a>&nbsp;et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">16 sur la modernisation du code et la conformité aux standards de code</a>. Les modifications de la version 6.8 concernent&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">43 composants du cœur du CMS</a>.</p>\n\n\n\n<p>Cette version comprend aussi&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">387 améliorations</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">525 corrections de bogues</a>&nbsp;et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">70 améliorations d’accessibilité</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-charcoal-0-color has-text-color has-background has-link-color wp-elements-37003aee4fdc33a177f14a048ba187af\" style=\"background:linear-gradient(135deg,rgb(242,255,240) 0%,rgb(255,252,223) 50%,rgb(255,211,218) 100%)\">Ce guide décrit les principaux changements techniques qui arrivent sur WordPress&nbsp;6.8, dont la sortie est prévue le 15 avril 2025.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p class=\"has-pomegrade-1-color has-text-color has-link-color wp-elements-25a8d26d528a99d7724a8a001a372b5a\"><a href=\"https://make.wordpress.org/core/6-8/\">En savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.8</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>Une vaste gamme d&rsquo;améliorations concerne les performances, l&rsquo;expérience de développement et l’interface d&rsquo;édition générale. Cette version introduit de nouveaux outils comme le filtre <code>should_load_block_assets_on_demand</code> pour optimiser le chargement des ressources, un système d&rsquo;avertissement utilisable lorsque vous employez <code>useSelect</code>, et un système d&rsquo;enregistrement des blocs plus efficace. Elle contient aussi une mise à jour des outils de design disponibles pour chaque bloc, affine les composants de l&rsquo;interface et propose une série de changements divers qui améliorent la cohérence et l&rsquo;extensibilité de l&rsquo;éditeur. Ces changements contribuent à un flux de travail de développement plus fluide et à un environnement d&rsquo;édition plus adaptatif.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performances et chargement des ressources</h3>\n\n\n\n<p>De nouveaux outils aident les développeuses et les développeurs à créer des expériences d&rsquo;utilisation des blocs plus performantes. Un avertissement dans le crochet <code>useSelect</code> alerte lorsque les sélecteurs sont définis en ligne, un problème courant qui peut entraîner un recalcul du rendu inutile. Le filtre <code>should_load_block_assets_on_demand</code> offre un contrôle précis sur le fait que les ressources de bloc soient mises en file d&rsquo;attente globalement ou uniquement en cas de besoin, ce qui permet de réduire le CSS et le JavaScript inutilisés sur l&rsquo;interface <em>front</em>. Tous ces changements favorisent des flux de travail de développement plus efficaces et optimisés.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fhFlkFOCIl\"><a href=\"https://make.wordpress.org/core/2025/03/12/data-a-helpful-performance-warning-for-developers-in-the-useselect-hook/\">Data: A helpful performance warning for developers in the &#8216;useSelect&#8217; hook</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Data: A helpful performance warning for developers in the &#8216;useSelect&#8217; hook&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/data-a-helpful-performance-warning-for-developers-in-the-useselect-hook/embed/#?secret=450zF7Nret#?secret=fhFlkFOCIl\" data-secret=\"fhFlkFOCIl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hB2FZegD7B\"><a href=\"https://make.wordpress.org/core/2025/03/24/new-filter-should_load_block_assets_on_demand-in-6-8/\">New filter should_load_block_assets_on_demand in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New filter &lt;code&gt;should_load_block_assets_on_demand&lt;/code&gt; in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/24/new-filter-should_load_block_assets_on_demand-in-6-8/embed/#?secret=YjASEVzB2H#?secret=hB2FZegD7B\" data-secret=\"hB2FZegD7B\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-and-design-tool-registration\">Gestion des blocs et outils de personnalisation disponibles pour chaque bloc</h3>\n\n\n\n<p>Les améliorations apportées à l&rsquo;enregistrement des blocs et à la visibilité des outils de conception simplifient le développement pour l&rsquo;éditeur de blocs. Une approche plus efficace de l&rsquo;enregistrement des types de blocs réduit la surcharge liée au chargement des métadonnées des blocs, en particulier dans les environnements comportant de nombreux blocs personnalisés. En complément, nous avons sorti une nouvelle version de la liste des outils de personnalisation disponibles pour chaque bloc afin d’indiquer&nbsp;<strong>pour chaque outil de personnalisation les blocs qui le prennent en charge</strong>, offrant ainsi aux développeur·euses une vision plus claire des options disponibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"a3N8ljSVe9\"><a href=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/\">More efficient block type registration in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;More efficient block type registration in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/embed/#?secret=QzNxSOMj2W#?secret=a3N8ljSVe9\" data-secret=\"a3N8ljSVe9\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"DOAiQNo1bl\"><a href=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/\">Roster of design tools per block (WordPress 6.8 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.8 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/embed/#?secret=dsWOhWCruy#?secret=DOAiQNo1bl\" data-secret=\"DOAiQNo1bl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"editor-ui-and-component-updates\">Interface de l’éditeur et mise à jour des composants</h3>\n\n\n\n<p>Des modifications apportées à l&rsquo;interface de l&rsquo;éditeur améliorent la cohérence, la convivialité et l&rsquo;ergonomie des différents éléments qui le composent. Les mises à jour des composants d&rsquo;interface d&rsquo;utilisation de base, tels que les boutons et les principes de mise en page, alignent le style et les comportements sur la base du nouveau système de design de WordPress. D&rsquo;autres changements concernent une meilleure cohérence du balisage dans le bloc Navigation, une prévisualisation de contenu améliorée pour le bloc Groupe et une meilleure accessibilité pour les éléments d&rsquo;interface. Ces modifications contribuent à une expérience d&rsquo;édition plus soignée et prévisible.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hCtw3Sfz1F\"><a href=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/\">Updates to user-interface components in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to user-interface components in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/embed/#?secret=wgcNFOWlm3#?secret=hCtw3Sfz1F\" data-secret=\"hCtw3Sfz1F\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"KihoQxj7Gw\"><a href=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-block-editor-changes-in-wordpress-6-8/\">Miscellaneous Block Editor Changes in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Block Editor Changes in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-block-editor-changes-in-wordpress-6-8/embed/#?secret=H0oRlXN4zs#?secret=KihoQxj7Gw\" data-secret=\"KihoQxj7Gw\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"accessibility\">Accessibilité</h2>\n\n\n\n<p>Un large éventail d&rsquo;améliorations de l&rsquo;accessibilité de WordPress arrive avec la version&nbsp;6.8&nbsp;: amélioration de la navigation, de la clarté du balisage et de la prise en charge des lecteurs d&rsquo;écran dans l&rsquo;ensemble de l&rsquo;éditeur de blocs&nbsp;; amélioration de la classe <code>.screen-reader-text</code> qui offre désormais un comportement de focus plus cohérent entre les composants&nbsp;; tandis que des dizaines d&rsquo;autres améliorations concernent les structures de menu, les libellés des blocs, les infobulles et la sémantique de l&rsquo;interface. Ces changements créent une expérience d’utilisation plus inclusive et rapprochent WordPress des meilleures pratiques en matière d&rsquo;accessibilité.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"lLtdPQgH11\"><a href=\"https://make.wordpress.org/core/2025/03/25/accessibility-improvements-in-wordpress-6-8/\">Accessibility Improvements in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Accessibility Improvements in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/accessibility-improvements-in-wordpress-6-8/embed/#?secret=ByVi2u33L9#?secret=lLtdPQgH11\" data-secret=\"lLtdPQgH11\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"MY8vUHKQ6W\"><a href=\"https://make.wordpress.org/core/2025/03/20/changes-to-the-screen-reader-text-class-in-wordpress-6-8/\">Changes to the .screen-reader-text class in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Changes to the .screen-reader-text class in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/20/changes-to-the-screen-reader-text-class-in-wordpress-6-8/embed/#?secret=ip8giZeKP4#?secret=MY8vUHKQ6W\" data-secret=\"MY8vUHKQ6W\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"internationalization\">Internationalisation</h2>\n\n\n\n<p>Plusieurs améliorations ont été apportées aux outils et à l&rsquo;infrastructure d&rsquo;internationalisation afin d&rsquo;améliorer l&rsquo;expérience de traduction et de localisation. Les mises à jour comprennent l&rsquo;arrivée de nouvelles fonctions de traduction, des corrections de cohérence et une meilleure prise en charge des formes plurielles, ce qui facilite la création d&rsquo;extensions, de thèmes et d&rsquo;interfaces entièrement traduisibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"NqvcibLyGF\"><a href=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/\">Internationalization improvements in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/embed/#?secret=NBUGYYmhDo#?secret=NqvcibLyGF\" data-secret=\"NqvcibLyGF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance\">Performances</h2>\n\n\n\n<p>De nouveaux outils et des conseils aident les développeurs et développeuses à créer des interfaces plus rapides. La fonctionnalité de chargement spéculatif utilise l&rsquo;API <code>Speculation Rules</code> pour précharger ou pré-afficher les cibles des liens de navigation, améliorant ainsi la performance perçue par les utilisateurs finaux lors du clic sur un lien. De plus, des modifications de l&rsquo;API <code>Interactivity</code> permettront d&rsquo;écrire du code <em>front-end</em> plus efficace et plus évolutif.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HRsy4J27Eb\"><a href=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/\">Speculative Loading in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Speculative Loading in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/embed/#?secret=d8v7ZXJwkZ#?secret=HRsy4J27Eb\" data-secret=\"HRsy4J27Eb\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"49PtIbJHVl\"><a href=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/\">Interactivity API best practices in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Interactivity API best practices in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/embed/#?secret=CslBN8jmlU#?secret=49PtIbJHVl\" data-secret=\"49PtIbJHVl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"rest-api\">API REST</h2>\n\n\n\n<p>Les améliorations apportées à l&rsquo;API REST étendent sa flexibilité et son utilité pour les applications WordPress <em>headless</em> et découplées. Un nouveau filtre, <code>rest_menu_read_access</code>, permet aux développeur·euses de contrôler l&rsquo;accès public aux menus de navigation, aux éléments de menu et aux emplacements de menu via l&rsquo;API REST. Ce changement permet un contrôle plus précis des données de menu exposées via l&rsquo;API, ce qui permet de prendre en charge une gamme plus large de cas d&rsquo;utilisation.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"eCrEpoAbgB\"><a href=\"https://make.wordpress.org/core/2025/03/27/new-rest-api-filter-for-exposing-menus-publicly-in-wordpress-6-8/\">New REST API Filter for Exposing Menus Publicly in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New REST API Filter for Exposing Menus Publicly in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/27/new-rest-api-filter-for-exposing-menus-publicly-in-wordpress-6-8/embed/#?secret=TmRv4OhCL7#?secret=eCrEpoAbgB\" data-secret=\"eCrEpoAbgB\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"security\">Sécurité</h2>\n\n\n\n<p>La sécurité des mots de passe a été renforcée grâce à l&rsquo;introduction de <code>bcrypt</code> comme nouvel algorithme de hachage par défaut. Ce changement modernise le stockage des mots de passe de WordPress, offrant une meilleure résistance aux attaques par force brute et s&rsquo;alignant sur les meilleures pratiques actuelles de l&rsquo;industrie. Les mots de passe existants restent valides et seront re-hachés avec <code>bcrypt</code> lors de la prochaine connexion réussie de l&rsquo;utilisateur·ice.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"qVqP1W6BMg\"><a href=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/\">WordPress 6.8 will use bcrypt for password hashing</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.8 will use bcrypt for password hashing&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/embed/#?secret=avMfXAbxDn#?secret=qVqP1W6BMg\" data-secret=\"qVqP1W6BMg\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<p>Un ensemble de modifications plus petites améliore la cohérence, l&rsquo;extensibilité et l&rsquo;expérience de développement générale. Ces changements couvrent divers domaines du cœur WordPress, notamment la gestion des médias, le rendu de certains codes courts (<em>shortcodes</em>), l&rsquo;enregistrement des types de publications, la gestion des thèmes. Bien qu&rsquo;individuellement mineures, ces modifications reflètent les efforts continus pour moderniser notre CMS.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"6yMViHGi0o\"><a href=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-developer-changes-in-wordpress-6-8/\">Miscellaneous developer changes in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous developer changes in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-developer-changes-in-wordpress-6-8/embed/#?secret=8nTjG46eRo#?secret=6yMViHGi0o\" data-secret=\"6yMViHGi0o\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"but-wait-there-is-more\">Attendez, ce n’est pas fini&nbsp;!</h2>\n\n\n\n<p>WordPress 6.8 offre encore bien davantage&nbsp;!&nbsp;Plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">170 bogues</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">104 améliorations et nouvelles fonctionnalités</a>, et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">21 tâches diverses</a>&nbsp;ont été&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">clôturés dans WordPress 6.8</a>.&nbsp; Cette version va par exemple permettre d&rsquo;afficher les nouveaux emojis de la version 15.1 de la bibliothèque Twemoji pour les internautes qui ne peuvent pas les afficher nativement dans leur navigateur (exemple de nouvel emoji&nbsp;: <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f426-200d-1f525.png\" alt=\"🐦‍🔥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />).</p>\n\n\n\n<p>Voici quelques modifications notables&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Remplacement des chaînes « Add New {Item} » par « Add {Item} » partout sur l&rsquo;administration (<a href=\"https://core.trac.wordpress.org/ticket/61219\">ticket #61219</a>)</li>\n\n\n\n<li>Amélioration des chaînes traduisibles sur le thème Twenty Twenty-Five (<a href=\"https://core.trac.wordpress.org/ticket/62482\">ticket #62482</a>)</li>\n\n\n\n<li>Thèmes natifs&nbsp;: amélioration de l&rsquo;accessibilité du lien du titre du site (<a href=\"https://core.trac.wordpress.org/ticket/62895\">ticket #62895</a>)</li>\n\n\n\n<li>Gestion des dates&nbsp;: les réglages des dates obtiennent deux nouvelles options, <code>j.n.Y</code> et <code>d.m.Y</code> (<a href=\"https://core.trac.wordpress.org/ticket/55685\">#55685</a>)</li>\n\n\n\n<li>Contenus embarqués&nbsp;: ajout de Canva en tant que fournisseur oEmbed (<a href=\"https://core.trac.wordpress.org/ticket/58840\">ticket #58840</a>)</li>\n\n\n\n<li>API des métadonnées&nbsp;: renommage de l’action <code>setted_transient</code>&nbsp;en&nbsp;<code>set_transient</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/62849\">ticket #62849</a>)</li>\n\n\n\n<li>API REST&nbsp;: gestion des barres obliques de fin de chaînes dans&nbsp;<code>rest_preload_api_request</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/57048\">ticket #57048</a>)</li>\n\n\n\n<li>Sécurité&nbsp;: assurance explicite du caractère requis du module PHP&nbsp;<code>hash</code>&nbsp;et ajout de vérifications des prérequis lors de l&rsquo;installation et de la mise à jour (<a href=\"https://core.trac.wordpress.org/ticket/56017\">ticket #56017</a>)</li>\n\n\n\n<li>Mises à jour&nbsp;: suppression d&rsquo;une vérification inutile lors de la vérification des mises à jour lorsque la donnée est à jour (<a href=\"https://core.trac.wordpress.org/ticket/44118\">ticket #44118</a>)</li>\n\n\n\n<li>Widgets&nbsp;: ajout de la prise en charge des types de publications dans la fonction&nbsp;<code>get_calendar()</code>. Ces modifications introduisent également un nouveau filtre&nbsp;<code>get_calendar_args</code> (<a href=\"https://core.trac.wordpress.org/ticket/34093\">ticket #34093</a>)</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.8 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.8.0/\">https://developer.wordpress.org/reference/since/6.8.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-style-serif has-charcoal-0-color has-text-color has-background has-link-color wp-elements-b65007937b1cf3a6c667456985c6a68f is-layout-constrained wp-block-group-is-layout-constrained\" style=\"background:linear-gradient(135deg,rgb(242,255,240) 0%,rgb(255,252,223) 50%,rgb(255,211,218) 100%);padding-top:1em;padding-bottom:1em\">\n<p class=\"is-style-serif has-black-color has-text-color has-link-color wp-elements-acf16339b7757858691a26a725321228\">Que vous développiez des thèmes ou des extensions, pensez à <strong>tester et retester votre code</strong> pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em>&nbsp;de WordPress 6.8</a>.&nbsp;<br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du&nbsp;<a href=\"https://make.wordpress.org/core/2025/03/28/wordpress-6-8-field-guide/\">Field Guide&nbsp;de WP 6.8 (en anglais)</a>&nbsp;par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci <a href=\'https://profiles.wordpress.org/clementpolito/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>clementpolito</a>, <a href=\'https://profiles.wordpress.org/rainbowgeek/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rainbowgeek</a>, <a href=\'https://profiles.wordpress.org/reskatorfr/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>reskatorfr</a>, <a href=\'https://profiles.wordpress.org/jdy68/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jdy68</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3310\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.7 « Rollins »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://fr.wordpress.org/2024/11/12/wordpress-6-7-rollins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 23:14:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3255\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&#160;Rollins&#160;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&#8217;innovation et son approche de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:69268:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/11/Release-Edition-Featured-Image-1024x535.png\" alt=\"\" class=\"wp-image-18085\" /></figure>\n\n\n\n<p>Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&nbsp;Rollins&nbsp;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&rsquo;innovation et son approche de l&rsquo;expression musicale.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.7&nbsp;!</h2>\n\n\n\n<p>WordPress 6.7 introduit le nouveau thème <bdo lang=\"en\" dir=\"ltr\"><em>Twenty Twenty-Five</em></bdo>, qui offre une flexibilité de conception ultime pour tous les sites et blogs. Vous pourrez gérer la typographie de votre site comme jamais auparavant. Les nouvelles fonctionnalités de zoom arrière vous permettront de concevoir votre site avec une vue macroscopique pour prendre du recul sur les détails de votre projet.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\" target=\"_blank\" rel=\"noreferrer noopener\">Télécharger WordPress 6.7 «&nbsp;Rollins&nbsp;» en français (ZIP – 19,1 Mo)</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Présentation du nouveau thème <bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo></h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une infinité de possibilités sans complexité</p>\n</blockquote>\n\n\n\n<p><bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo> est un thème polyvalent, axé sur le design, qui vous permet de créer des sites époustouflants en toute simplicité. Personnalisez votre esthétisme grâce à un éventail d‘options de style, de compositions de blocs et de palettes de couleurs. Réduit à l‘essentiel, c‘est un thème qui peut vraiment évoluer avec vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-tt5-2.webp\" alt=\"\" style=\"object-fit:cover\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Obtenez une vue d’ensemble en dézoomant</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Explorez votre contenu sous un nouvel angle</p>\n</blockquote>\n\n\n\n<p>Modifiez et organisez des sections entières de votre contenu comme jamais auparavant. Une vue plus large de votre site vous permet d‘ajouter, de modifier, de mélanger ou de supprimer des compositions à votre guise. Laissez s‘exprimer l‘architecte qui est en vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-zoom-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Connectez des blocs et des champs personnalisés sans souci (et sans coder)</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une manière simplifiée de créer du contenu dynamique</p>\n</blockquote>\n\n\n\n<p>Cette fonctionnalité introduit une nouvelle interface pour connecter des blocs à des champs personnalisés. Cela vous donne le contrôle d’éléments dynamiques directement dans l’éditeur. Vous pouvez relier des blocs à des champs en quelques clics, ce qui améliore la flexibilité et l’efficacité de ces actions. Vos clients vont adorer ça.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-block-bindings-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Laissez s’exprimer votre passion pour la typographie</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Nouvelle section de styles, nouvelles possibilités</p>\n</blockquote>\n\n\n\n<p>Créez, modifiez, retirez et appliquez des préréglages de taille de police avec le dernier apport à l’interface des Styles. Surchargez le thème par défaut ou créez votre propre taille de police personnalisée, avec une typographie dynamique pour un redimensionnement responsive des polices. Prenez soin des détails&nbsp;!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-font-presets-2.png\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.7 propose d’importantes mises à jour en matière de performances, notamment un chargement plus rapide des compositions, des aperçus optimisés pour le composant des vues de données, une meilleure prise en charge de PHP 8 et plus, la suppression du code obsolète, des tailles automatiques pour les images en chargement différé, ainsi qu’un traitement plus efficace des balises dans l’API HTML.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 65 correctifs et améliorations d’accessibilité focalisées sur les aspects fondamentaux de l’expérience de WordPress, de l’amélioration des composants d’interface d’administration à la navigation clavier dans l’éditeur, en passant par des niveaux de titres plus accessibles dans les écrans de connexion et de meilleurs libellés.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.7</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Lisez les <a href=\"https://wordpress.org/support/wordpress-version/version-6-7/\">notes de version de WordPress 6.7</a> pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<p>Explorez le <a href=\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\">guide des changements techniques de WordPress 6.7</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous permettent de construire votre site avec WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.7</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version&nbsp;: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a></li>\n\n\n\n<li>Direction technique&nbsp;cœur&nbsp;: <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>,&nbsp;<a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a></li>\n\n\n\n<li>Gestion de projet côté cœur&nbsp;: <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a></li>\n\n\n\n<li>Gestion de projet côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>,&nbsp;<a href=\"https://wordpress.org/support/users/colorful-tones/\">Damon Cook</a></li>\n\n\n\n<li>Direction de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a></li>\n\n\n\n<li>Direction des tests&nbsp;: <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K. Gupta</a></li>\n\n\n\n<li>Direction artistique&nbsp;: <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a></li>\n\n\n\n<li>Direction des performances&nbsp;: <a href=\"https://profiles.wordpress.org/adamsilverstein/\"></a><a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Direction du design du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li>\n\n\n\n<li>Direction du développement du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.7 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>780 personnes provenant de tous les pays du monde</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 230 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.7 <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull is-style-short-text has-lemon-3-background-color has-background\" style=\"font-size:12px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/75thtrombone/\">75thtrombone</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aware/\">Aaron Ware</a> · <a href=\"https://profiles.wordpress.org/aatanasov/\">aatanasov</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/ababir/\">Abir</a> · <a href=\"https://profiles.wordpress.org/acafourek/\">acafourek</a> · <a href=\"https://profiles.wordpress.org/adamkheckler/\">Adam Heckler</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adamwood/\">Adam Wood</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/adrian2k7/\">Adrian</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/ah72king/\">ah72king</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akashdhawade/\">Akash Dhawade</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/alaminfirdows/\">Al-Amin Firdows</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/alessandrotesoro/\">Alessandro Tesoro</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alex27/\">alex27</a> · <a href=\"https://profiles.wordpress.org/digitalex11/\">Alexander Frank</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/harlet7/\">Alexandru Horeanu</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">alexcu21</a> · <a href=\"https://profiles.wordpress.org/ali7ali/\">Ali Ali</a> · <a href=\"https://profiles.wordpress.org/aliaghdam/\">aliaghdam</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amincharoliya/\">Amin Charoliya</a> · <a href=\"https://profiles.wordpress.org/amirthepiper/\">Amir Abbas</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/amjadr360/\">Amjad Ali</a> · <a href=\"https://profiles.wordpress.org/anthakkar08/\">Anand Thakkar</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andreiglingeanu/\">andreiglingeanu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankit k gupta/\">Ankit K. Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/the-ank/\">Ankur Vishwakarma</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/perezcarreno/\">Armando J. Perez Carreno</a> · <a href=\"https://profiles.wordpress.org/armandsdz/\">Armands</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/ambrosiawt/\">Art Smith</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/arypneta/\">arypneta</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/nmutua/\">Autumn</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/bjerke-johannessen/\">Bård Bjerke Johannessen</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/neoxx/\">Bernhard Riedl</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berubenic/\">berubenic</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai13/\">Bhavesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">bijit027</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/blindmikey/\">blindmikey</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdannikolic/\">Bogdan Nikolic</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/brentjettgmailcom/\">Brent Jett</a> · <a href=\"https://profiles.wordpress.org/brettshumaker/\">Brett Shumaker</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/bgosnell/\">Brian Gosnell</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/bridgetwes/\">bridgetwes</a> · <a href=\"https://profiles.wordpress.org/brobken/\">brobken</a> · <a href=\"https://profiles.wordpress.org/freibergergarcia/\">Bruno Freiberger Garcia</a> · <a href=\"https://profiles.wordpress.org/cambabutonono/\">Cambabutonono</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/carstenbach/\">Carsten Bach</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/mchirag2002/\">Chirag Mathur</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/eclare/\">Chris Trynkiewicz (Sukces Strony)</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/cfinke/\">Christopher Finke</a> · <a href=\"https://profiles.wordpress.org/ckanitz/\">Christopher Kanitz</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/craynor/\">craynor</a> · <a href=\"https://profiles.wordpress.org/creativethemeshq/\">creativethemeshq</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/da5f656f/\">da5f656f</a> · <a href=\"https://profiles.wordpress.org/xendo/\">Dademaru</a> · <a href=\"https://profiles.wordpress.org/daleharrison/\">daleharrison</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/colorful tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/itsdanny/\">Danny</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/d-signed/\">Dareth NHANG</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/daveagp/\">daveagp</a> · <a href=\"https://profiles.wordpress.org/fac3less/\">David</a> · <a href=\"https://profiles.wordpress.org/dballari/\">David Ballarin Prunera</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/davidhbrown/\">David Brown</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/davidgodleman10up/\">David Godleman</a> · <a href=\"https://profiles.wordpress.org/dhenriet/\">David Henriet</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/ddewan/\">ddewan</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a> · <a href=\"https://profiles.wordpress.org/dekadinious/\">Dekadinious</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dsmart/\">Derek Smart</a> · <a href=\"https://profiles.wordpress.org/deryck/\">Deryck</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/devspace/\">devspace</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divibanks/\">Divi Banks</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/djennez/\">djennez</a> · <a href=\"https://profiles.wordpress.org/cyberorca/\">Doni Kuntoro</a> · <a href=\"https://profiles.wordpress.org/dorzki/\">Dor Zuberi</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/eballeste/\">eballeste</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/beckej/\">Ed Beck</a> · <a href=\"https://profiles.wordpress.org/ejnwebmaster/\">ejnwebmaster</a> · <a href=\"https://profiles.wordpress.org/elfu98/\">elfu98</a> · <a href=\"https://profiles.wordpress.org/eliorivero/\">Elio Rivero</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/erichmond/\">Elliott Richmond</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanue ATSÉ</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/emmanuel78/\">emmanuel78</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/erikiva/\">erikiva</a> · <a href=\"https://profiles.wordpress.org/erikyo/\">erikyo</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/fahimmurshed/\">FahimMurshed</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/iamfarhan09/\">Farhan Ahmed</a> · <a href=\"https://profiles.wordpress.org/fayyazfayzi/\">Fayyaz</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fjorgemota/\">Fernando Jorge Mota (a11n)</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/fullworks/\">fullworks</a> · <a href=\"https://profiles.wordpress.org/gwallace87/\">Gale Wallace</a> · <a href=\"https://profiles.wordpress.org/gansbrest/\">gansbrest</a> · <a href=\"https://profiles.wordpress.org/garethelwell/\">Gareth Elwell</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gauravtiwari/\">Gaurav Tiwari</a> · <a href=\"https://profiles.wordpress.org/gauravsingh7/\">gauravsingh7</a> · <a href=\"https://profiles.wordpress.org/georgwordpress/\">Georg</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/germanfrelo/\">Germán Freixinós</a> · <a href=\"https://profiles.wordpress.org/gmariani405/\">gmariani405</a> · <a href=\"https://profiles.wordpress.org/graemef/\">GraemeF</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/greentreefrog/\">greentreefrog</a> · <a href=\"https://profiles.wordpress.org/greenworld/\">GreenWorld</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gyurmey/\">Gyurmey</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/halilesen/\">Halil ESEN</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardipparmar/\">Hardip Parmar</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/plaidharper/\">Harper Holsinger</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshvaishnav/\">harshvaishnav</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hectorjarquin/\">hectorjarquin</a> · <a href=\"https://profiles.wordpress.org/hedgefield/\">hedgefield</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hirschferkel/\">hirschferkel</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/htmgarcia/\">htmgarcia</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/kardi420/\">Ibrahim</a> · <a href=\"https://profiles.wordpress.org/ibrahimriaz/\">Ibrahim Riaz</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itapress/\">itapress</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jpstevens/\">Jack Stevens</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/smithjw1/\">Jacob Smith</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">jagirbahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/jtgreyd/\">Jakob Trost</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jamesosborne/\">James Osborne</a> · <a href=\"https://profiles.wordpress.org/jamesros161/\">James Rosado</a> · <a href=\"https://profiles.wordpress.org/jwgoedert/\">James Wesley Goedert</a> · <a href=\"https://profiles.wordpress.org/janpfeil/\">Jan Pfeil</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/jasonbahl/\">Jason Bahl</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javad2000/\">javad2000</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/jawadwp/\">Jawad Malik</a> · <a href=\"https://profiles.wordpress.org/topdownjimmy/\">Jay</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/drjosh07/\">jbrya029</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jenilk/\">Jenil Kanani</a> · <a href=\"https://profiles.wordpress.org/jennifarhat/\">Jennifer Farhat</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">Jerry Jones</a> · <a href=\"https://profiles.wordpress.org/skobe/\">Jesko Bendmann</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jetaldobariya1/\">jetaldobariya1</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jimmyh61/\">jimmyh61</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/lwangaman/\">JohnRDOrazio</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/elbsegler/\">Jonas</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnywatersbb/\">Jonny Waters</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josklever/\">Jos Klever</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jossnaz/\">Jossnaz</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/julianoe/\">julianoe</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/junedsabaliya/\">Juned Sabaliya</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kaavyaiyer/\">Kaavya Iyer (woo-hc)</a> · <a href=\"https://profiles.wordpress.org/arkenon/\">Kadim Gültekin</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kamran8176/\">Kamran Hussen</a> · <a href=\"https://profiles.wordpress.org/karan4word/\">Karan Gupta</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/kartikmehta/\">Kartik Mehta</a> · <a href=\"https://profiles.wordpress.org/kartik-suthar/\">Kartik Suthar</a> · <a href=\"https://profiles.wordpress.org/kbrownkd/\">kbrownkd (a11n)</a> · <a href=\"https://profiles.wordpress.org/keffr3n/\">Keffr3n</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/kellenmace/\">Kellen Mace</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/kevinb/\">Kevin Behrens</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kevinswalsh/\">kevinswalsh</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kisquian/\">kisquian</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kowsar89/\">Kowsar Hossain</a> · <a href=\"https://profiles.wordpress.org/kracked888/\">kracked888</a> · <a href=\"https://profiles.wordpress.org/krishneup/\">Krishna Neupane</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/gohelkunjan/\">Kunjan Gohel</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/mlaetitia/\">Lae</a> · <a href=\"https://profiles.wordpress.org/notlaura/\">Lara Schenck</a> · <a href=\"https://profiles.wordpress.org/lastsplash/\">lastsplash (a11n)</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/oncecoupled/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/laranz/\">Lawrence Joe</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/lifelightweb/\">lifelightweb</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/crixu/\">Lucas</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasbesch/\">lukasbesch</a> · <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/nadimcse/\">Mahmudul Haque Nadim</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/manbo/\">manbo</a> · <a href=\"https://profiles.wordpress.org/maneshtimilsina/\">Manesh Timilsina</a> · <a href=\"https://profiles.wordpress.org/targz-1/\">Manuel Schmalstieg</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/marianguas/\">María Anguas</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/mardroid/\">Marcel Tannich</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/iworks/\">Marcin Pietrzak</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/pereirinha/\">Marco Pereirinha</a> · <a href=\"https://profiles.wordpress.org/marcwieland95/\">marcwieland95</a> · <a href=\"https://profiles.wordpress.org/igreenie/\">Marek Železný</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">marybaum</a> · <a href=\"https://profiles.wordpress.org/mat_/\">mat_</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattormeeple/\">Matt Sherman</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/lonelyvegan/\">Matthew Riley MacPherson</a> · <a href=\"https://profiles.wordpress.org/kittmedia/\">Matthias Kittsteiner</a> · <a href=\"https://profiles.wordpress.org/mattraines/\">mattraines</a> · <a href=\"https://profiles.wordpress.org/maurodf/\">maurodf</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mcrisp1972/\">mcrisp1972</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/istiaqhossain/\">Md. Istiaq Hossain</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/iammehedi1/\">Mehedi Hassan</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/meteorlxy/\">meteorlxy</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a> · <a href=\"https://profiles.wordpress.org/michaelbourne/\">Michael Bourne</a> · <a href=\"https://profiles.wordpress.org/hrkhal/\">Michael James Ilett</a> · <a href=\"https://profiles.wordpress.org/michaelpick/\">michaelpick</a> · <a href=\"https://profiles.wordpress.org/michaelwp85/\">michaelwp85</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mielbu/\">Michelle Bulloch</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikeb8s/\">mikeb8s</a> · <a href=\"https://profiles.wordpress.org/mikeybinns/\">Mikey Binns</a> · <a href=\"https://profiles.wordpress.org/milamj/\">milamj</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mklusak/\">mklusak</a> · <a href=\"https://profiles.wordpress.org/mleathem/\">mleathem</a> · <a href=\"https://profiles.wordpress.org/mlf20/\">mlf20</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/morganestes/\">Morgan Estes</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mossy2100/\">mossy2100</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir a11n</a> · <a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a> · <a href=\"https://profiles.wordpress.org/nagpai/\">Nagesh Pai</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">Nate Finch</a> · <a href=\"https://profiles.wordpress.org/nateinaction/\">Nate Gay</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/nebojsajurcic/\">Nebojša Jurčić</a> · <a href=\"https://profiles.wordpress.org/nek285/\">nek285</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">neo2k23</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nickbohle/\">Nick Bohle</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nick_thegeek/\">Nick the Geek</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nurielmeni/\">nurielmeni</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/olivierlafleur/\">Olivier Lafleur</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/oscarhugopaz/\">Oscar Hugo Paz</a> · <a href=\"https://profiles.wordpress.org/prestonwordsworth/\">p15h</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/otakupahp/\">Pablo Hernández</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pamprn/\">Pamela Ribeiro</a> · <a href=\"https://profiles.wordpress.org/pander/\">pander</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/obrienlabs/\">Pat O’Brien</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a> · <a href=\"https://profiles.wordpress.org/paulwilde/\">Paul Wilde</a> · <a href=\"https://profiles.wordpress.org/paulcline/\">paulcline</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/perryrylance/\">perryrylance</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/pevogam/\">pevogam</a> · <a href=\"https://profiles.wordpress.org/mr2p/\">Phi Phan</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pgeorgiev/\">Plamen Georgiev</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/ppolo99/\">ppolo99</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranitdugad/\">Pranit Dugad</a> · <a href=\"https://profiles.wordpress.org/pratikkry/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/pwtyler/\">pwtyler</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/spanglishwebs/\">Rachel Winspear</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rafaelgalani/\">Rafael Gallani</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/rahmatgumilar/\">Rahmat Gumilar</a> · <a href=\"https://profiles.wordpress.org/rahulharpal/\">rahulharpal</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/shashwatahalder01/\">rajkumar shashwata halder</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ramswarup/\">Ramswarup Rathod</a> · <a href=\"https://profiles.wordpress.org/xyulex/\">Raul Martinez</a> · <a href=\"https://profiles.wordpress.org/rcneil/\">rcneil</a> · <a href=\"https://profiles.wordpress.org/realthemes/\">realthemes</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/reputeinfosystems/\">reputeinfosystems</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rhellewellgmailcom/\">Rick Hellewell</a> · <a href=\"https://profiles.wordpress.org/riddhipatel/\">Riddhi Patel</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rithik56/\">rithik56</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/robert-biswas/\">Robert Biswas</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/rocketworks/\">rocket.works – Dominik Friedrich</a> · <a href=\"https://profiles.wordpress.org/rodelgc/\">Rodel Calasagsag a11n</a> · <a href=\"https://profiles.wordpress.org/rghedin/\">Rodrigo</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roygbyte/\">roygbyte</a> · <a href=\"https://profiles.wordpress.org/royho/\">royho</a> · <a href=\"https://profiles.wordpress.org/rpf5573/\">rpf5573</a> · <a href=\"https://profiles.wordpress.org/rslee/\">rslee</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rleeson/\">Ryan Leeson</a> · <a href=\"https://profiles.wordpress.org/ryancurban/\">Ryan Urban</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sadmansh/\">sadmansh</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sahiladit/\">sahiladit</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/samtoohey93/\">Sam Toohey</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/samuelsilvapt/\">Samuel Silva</a> · <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarahricker/\">sarahricker</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/sauliusv/\">Saulius Vikerta</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scottculverhouse/\">scottculverhouse</a> · <a href=\"https://profiles.wordpress.org/seanavers/\">seanavers</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/kuuuzya/\">Sergey</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/zahardoc/\">Serhiy Zakharchenko</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/sharonaustin/\">Sharon Austin</a> · <a href=\"https://profiles.wordpress.org/sheulyshila/\">sheulyshila</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/showravhasan/\">Showrav Hasan</a> · <a href=\"https://profiles.wordpress.org/shreya0204/\">Shreya Agarwal</a> · <a href=\"https://profiles.wordpress.org/silaskoehler/\">Silas Köhler</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sophiegy/\">Sophie – a11n</a> · <a href=\"https://profiles.wordpress.org/souptik/\">Souptik Datta</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/thompsonsj/\">Steven Thompson</a> · <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a> · <a href=\"https://profiles.wordpress.org/styleshit/\">styleshit</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">Sunil Prajapati</a> · <a href=\"https://profiles.wordpress.org/quadthemes/\">Sunny</a> · <a href=\"https://profiles.wordpress.org/superchlorine/\">superchlorine</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/jannathsyeda/\">Syeda Fahima Jannath</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Takahashi Fumiki</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanvirul/\">Tanvirul Haque</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tdrayson/\">tdrayson</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tmanoilov/\">tmanoilov</a> · <a href=\"https://profiles.wordpress.org/toastercookie/\">toastercookie</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/thomasdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomhine/\">tomhine</a> · <a href=\"https://profiles.wordpress.org/tomllobet/\">tomllobet</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">valer1e</a> · <a href=\"https://profiles.wordpress.org/vertisoft/\">vertisoft</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">vipulpatil</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">vrishabhsk</a> · <a href=\"https://profiles.wordpress.org/wbdv/\">wbdv</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/webwurm/\">webwurm</a> · <a href=\"https://profiles.wordpress.org/wesrapyd/\">wesrapyd</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williamalexander/\">William Alexander</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/wpeople/\">WPeople</a> · <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a> · <a href=\"https://profiles.wordpress.org/wzieba/\">wzieba</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/collet/\">Yann</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/ytfeldrawkcab/\">ytfeLdrawkcaB</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yukinobu/\">Yukinobu Asakawa</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/zackkrida/\">Zack Krida</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zitaruksergij/\">zitaruksergij</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.7 en français</h2>\n\n\n\n<p>WordPress est un projet international et la version 6.7 est déjà complètement disponible dans plus de 40 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.7 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/xibe\">Xavier Borderie</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/dfi42\">dfi42</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">Laetitia de Perthuis</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/firestar300\">Milan Ricoul</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>, <a href=\"https://profiles.wordpress.org/phoenix13\">phoenix13</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, et <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article traduit par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\"https://profiles.wordpress.org/laboiteare/\">Renaud Pacouil</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Oct 2024 10:49:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3243\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:436:\"WordPress 6.7 comprend la résolution de plus de&#160;300 tickets sur Trac, dont&#160;87 améliorations et nouvelles fonctionnalités, plus de 200 corrections de bogues. cette version comprend&#160;23 tickets focalisés sur les performances,&#160;21 sur l’accessibilité et&#160;12 sur la modernisation du code et la conformité aux standards de code. Les modifications de 6.7 s’étalent sur&#160;38 composants du cœur du [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:28154:\"\n<figure class=\"wp-block-image alignfull size-large is-style-serif wp-elements-f590cfee42cfa860d05ec74ddea8b4ef\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\"><a href=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"515\" src=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png\" alt=\"\" class=\"wp-image-3244\" srcset=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png 1024w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-300x151.png 300w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-768x386.png 768w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1536x772.png 1536w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-2048x1029.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>WordPress 6.7 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=milestone&amp;order=priority\">300 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">87 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 200 corrections de bogues</a>. cette version comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">23 tickets focalisés sur les performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">21 sur l’accessibilité</a> et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">12 sur la modernisation du code et la conformité aux standards de code</a>. Les modifications de 6.7 s’étalent sur&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">38 composants du cœur du CMS</a>.</p>\n\n\n\n<p>Cette version comprend aussi <a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">445 améliorations</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">464 corrections de bogues</a> et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">55 améliorations d’accessibilité</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-ca39a6cbb68f24eb2fca5cc30331b23f\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.7, dont la sortie est prévue le 12 novembre 2024.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/6-7/\">Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.7, consultez cette page.</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Block-Editor\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>WordPress 6.7 implémente 8 versions de Gutenberg &#8211; <a href=\"https://make.wordpress.org/core/2024/06/20/whats-new-in-gutenberg-18-6/\">18.6</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/04/whats-new-in-gutenberg-18-7-03-july/\">18.7</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/17/whats-new-in-gutenberg-18-8-17-july/\">18.8</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/31/whats-new-in-gutenberg-18-9-31-july/#:~:text=In%20a%20recurring%20effort%20to,Links%2C%20and%20Term%20Description%20blocks.\">18.9</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/14/whats-new-in-gutenberg-19-0-14-august/\">19.0</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/28/whats-new-in-gutenberg-19-1-28-august/\">19.1</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/12/what-is-new-in-gutenberg-19-2-11-september/\">19.2</a> et&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/25/whats-new-in-gutenberg-19-3-25-september/\">19.3</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Changements techniques</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"UyWJ3kHEmz\"><a href=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/\">Post Editor iframing with meta boxes in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Post Editor iframing with meta boxes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/embed/#?secret=tSMGBJfYjQ#?secret=UyWJ3kHEmz\" data-secret=\"UyWJ3kHEmz\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"jF8mPpPXlS\"><a href=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/\">Block Bindings: Improvements to the Editor Experience in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block Bindings: Improvements to the Editor Experience in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/embed/#?secret=LyXnzsvvCL#?secret=jF8mPpPXlS\" data-secret=\"jF8mPpPXlS\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"G8lRmWqAor\"><a href=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/\">Updates to Block Hooks in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Block Hooks in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/embed/#?secret=J4XDYs3pSJ#?secret=G8lRmWqAor\" data-secret=\"G8lRmWqAor\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"h00792iEep\"><a href=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/\">Updates to user-interface components in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to user-interface components in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/embed/#?secret=TCajqUjanO#?secret=h00792iEep\" data-secret=\"h00792iEep\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"react\">Changements concernant les outils de design dans l’éditeur</h3>\n\n\n\n<p>Nous avons poursuivi l’effort de consolidation des outils de design et plusieurs blocs prennent désormais en charge davantage de fonctionnalités de mise en page et de mise en forme.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"obfs4hTFIv\"><a href=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/\">Roster of design tools per block (WordPress 6.7 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.7 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/embed/#?secret=3D3EUMW9w6#?secret=obfs4hTFIv\" data-secret=\"obfs4hTFIv\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-block-editor-changes\">Autres modifications concernant l’éditeur</h3>\n\n\n\n<p>D&rsquo;autres modifications diverses ont été listées dans des notes de développement dédiées&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"Mh1YE1VTiU\"><a href=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/\">Extending the Preview Dropdown Menu in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Extending the Preview Dropdown Menu in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/embed/#?secret=ViTZEpwoUq#?secret=Mh1YE1VTiU\" data-secret=\"Mh1YE1VTiU\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5T9ubgS9pA\"><a href=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/\">Miscellaneous Block Editor Changes in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Block Editor Changes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/embed/#?secret=45jLTa4za3#?secret=5T9ubgS9pA\" data-secret=\"5T9ubgS9pA\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">API de gestion des interactions et modules de script</h2>\n\n\n\n<p>WordPress 6.7 comprend des mises à jour de l’API <code>Interactivity</code>, comme par exemple une nouvelle façon d’interagir avec les changements d’état côté serveur dans la navigation côté client. Les mises à jour des modules <code>Script</code>s comprennent des améliorations du chargement des scripts existants en tant que dépendances.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"N7suow7aP5\"><a href=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/\">Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/embed/#?secret=XXyFFljgkB#?secret=N7suow7aP5\" data-secret=\"N7suow7aP5\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"64ynOvr7Ew\"><a href=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/\">Updates to Script Modules in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Script Modules in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/embed/#?secret=6Cxd5rFVoy#?secret=64ynOvr7Ew\" data-secret=\"64ynOvr7Ew\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"html-api\">API HTML</h2>\n\n\n\n<p>WordPress 6.7 comprend plusieurs mises à jour de l&rsquo;API <code>HTML</code>. Plusieurs fonctionnalités majeures sont sorties ainsi qu&rsquo;un amélioration conséquente de l&rsquo;utilisabilité du processeur HTML.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"kbJtxPGfqW\"><a href=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/\">Updates to the HTML API in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/embed/#?secret=34UZ0w1coA#?secret=kbJtxPGfqW\" data-secret=\"kbJtxPGfqW\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h2>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/query?component=I18N&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Diverses améliorations de l&rsquo;internationalisation</a> sont disponibles avec WordPress 6.7&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hQXSqWJGem\"><a href=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/\">Internationalization improvements in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/embed/#?secret=eFPqVd4tTO#?secret=hQXSqWJGem\" data-secret=\"hQXSqWJGem\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance\">Performances</h2>\n\n\n\n<p>WordPress 6.7 apporte aussi plusieurs améliorations focalisées sur les performances, telles qu&rsquo;une nouvelle façon de déclarer les blocs utilisant des fichiers PHP générés pour contrecarrer les goulots d&rsquo;étranglement liés au chargement et au parcours des fichiers JSON.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"8oQC5S3C02\"><a href=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/\">New block type registration APIs to improve performance in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New block type registration APIs to improve performance in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/embed/#?secret=XzjPRUchA9#?secret=8oQC5S3C02\" data-secret=\"8oQC5S3C02\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7r05WrUm18\"><a href=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/\">Auto Sizes for Lazy Loaded Images in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Auto Sizes for Lazy Loaded Images in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/embed/#?secret=wpQMBPVn0N#?secret=7r05WrUm18\" data-secret=\"7r05WrUm18\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fmwVz6LB0l\"><a href=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/\">New Plugin Template Registration API in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Plugin Template Registration API in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/embed/#?secret=rHnFsEBoL1#?secret=fmwVz6LB0l\" data-secret=\"fmwVz6LB0l\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zeZlu13TM1\"><a href=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/\">Automatic conversion of HEIC images to JPEG in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Automatic conversion of HEIC images to JPEG in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/embed/#?secret=9ECwfO9e5P#?secret=zeZlu13TM1\" data-secret=\"zeZlu13TM1\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.7 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.7.0/\">https://developer.wordpress.org/reference/since/6.7.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-87f312e26bd4a386f9cdeec66ae58d52\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser <a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension « <em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em> »</a> sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em> de WordPress 6.7</a>. <br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/10/23/wordpress-6-7-field-guide/\">Field Guide de WP 6.7 (en anglais)</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Benard</a> et <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3243\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Nouveau programme de mentorat pour la contribution à WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://fr.wordpress.org/2024/08/21/nouveau-programme-de-mentorat-pour-la-contribution-a-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2024 09:34:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:18:\"mentorship program\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:389:\"Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre. Mais c’est quoi exactement ce programme&#160;? Il s’agit du troisième programme organisé par l’équipe Community afin de faciliter [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6506:\"\n<p>Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Mais c’est quoi exactement ce programme&nbsp;?</h2>\n\n\n\n<p>Il s’agit du troisième programme organisé par l’équipe <a href=\"https://make.wordpress.org/community/\">Community</a> afin de faciliter l’intégration de nouvelles personnes aux <a href=\"https://make.wordpress.org/\">diverses équipe de contribution</a>.</p>\n\n\n\n<p>Ce programme met en place de petites équipes avec un mentor et des mentoré·e·s qui travaillent ensemble sur un projet proposé par le mentor lors de sa candidature.</p>\n\n\n\n<p>Les organisateurs répartissent donc les contributeurs/contributrices selon les souhaits qu&rsquo;ils/elles ont définis lors de leur candidature.</p>\n\n\n\n<p>Tout au long du programme, le/la mentor prend en charge l&rsquo;équipe de mentoré·e·s pour avancer le projet qu&rsquo;il/elle a proposé, et quelques réunions en visio sont proposées par les organisateurs.</p>\n\n\n\n<p>Si vous souhaitez débuter la contribution à WordPress mais ne savez pas comment, ni par où commencer, alors ce programme est parfait pour vous en tant que mentoré·e.&nbsp; Vous serez guidé·e tout au long du programme par des mentors et pourrez ainsi obtenir toutes les informations nécessaires à une contribution efficace.<br>Et si vous contribuez déjà et souhaitez transmettre vos connaissances à d’autres personnes alors participez au programme en tant que mentor ! Ce sera l’occasion d’accueillir de nouvelles personnes dans vos équipes respectives.</p>\n\n\n\n<p>Cette cohorte est synchronisée avec la sortie de la version 6.7 afin de permettre aux participants, qui rejoignent l’équipe Core ou celle du développement du thème Twenty Twenty-Five, de contribuer spécifiquement à cette version de WordPress. Mais, la contribution à WordPress ne se résumant pas à son code, vous avez aussi l’opportunité de rejoindre des équipes de contribution non liées au code telles que Communauté (organisation d’évènements et encadrement des équipes), Design, Documentation, Formation, etc.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Qui peut candidater ?</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Pour les mentoré·e·s : toute personne souhaitant débuter la contribution à WordPress, ou encore contribuer à d’autres équipes que celle(s) où il/elle contribue déjà.</li>\n\n\n\n<li>Pour les mentors : toute personne ayant déjà un peu d’expérience dans la contribution WordPress.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Comment rejoindre le programme ?</h2>\n\n\n\n<p>Pour rejoindre le programme, il faut remplir un petit formulaire :</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSd6faivlMZzyiq1sx_78fvnw7-JOshZMZcIO6BTp-B7TuM2ww/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentoré·e</a></div>\n\n\n\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSfDzRRrIDJcQcVF0m3I16-RfwrjmXBHboxCC5Rx0OHatK_EBQ/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentor</a></div>\n</div>\n\n\n\n<p>Mais <strong>attention date limite des candidatures</strong> : </p>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-vivid-red-background-color has-text-color has-background has-link-color wp-elements-18846e5805f4ed69ba3dc19961036bd1\" style=\"margin-top:var(--wp--preset--spacing--10);margin-right:var(--wp--preset--spacing--10);margin-bottom:var(--wp--preset--spacing--10);margin-left:var(--wp--preset--spacing--10);padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\">le 26 août 2024</p>\n\n\n\n<p>Vous serez ensuite recontacté·e.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contribuer dans votre langue</h2>\n\n\n\n<p>Ce 3<sup>e</sup> programme propose une nouveauté : selon le projet auquel vous participerez, vous aurez peut être l’opportunité de contribuer en français, puisque des équipes par locale vont être constituées.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Plus d&rsquo;informations</h2>\n\n\n\n<p>Retrouvez plus d&rsquo;informations sur le programme dans cet article (en anglais) :</p>\n\n\n\n<figure class=\"wp-block-embed aligncenter is-type-wp-embed is-provider-wordpress-org-project wp-block-embed-wordpress-org-project\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TOusFk6YKX\"><a href=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/\">WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors&#8221; &#8212; WordPress.org Project\" src=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/embed/#?secret=93CdKWMRfW#?secret=TOusFk6YKX\" data-secret=\"TOusFk6YKX\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-purple-2-background-color has-text-color has-background has-link-color has-extra-large-font-size wp-elements-ce3e97f8976a3a3f44d47b605fc66a4f\" style=\"margin-top:var(--wp--preset--spacing--30);margin-right:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30);margin-left:var(--wp--preset--spacing--30);padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\">On compte sur vous pour vous inscrire nombreux et nombreuses à ce programme !<br>Si vous n’avez jamais contribué c’est l’occasion rêvée de commencer, si vous contribuez déjà et souhaitez rejoindre de nouvelles équipes ce programme est fait pour vous !</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fr.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096031\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 13 Jan 2026 10:04:07 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Sat, 10 Jan 2026 23:18:11 GMT\";s:4:\"link\";s:61:\"<https://fr.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}s:5:\"build\";i:1760643936;s:21:\"cache_expiration_time\";i:1768341847;s:23:\"__cache_expiration_time\";i:1768341847;}", "off");
INSERT INTO `wp_options` VALUES("1905", "_site_transient_timeout_feed_b0b1001e5bc3fbacad8b49ec075d19a5", "1768341847", "off");
INSERT INTO `wp_options` VALUES("1906", "_site_transient_feed_b0b1001e5bc3fbacad8b49ec075d19a5", "a:6:{s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"feed\";a:1:{i:0;a:6:{s:4:\"data\";s:126:\"\n    \n    \n    \n    \n    \n    \n\n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"subtitle\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:43:\"https://fluxplanet.wpfr.net/feed/wp-planet/\";s:3:\"rel\";s:4:\"self\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://fluxplanet.wpfr.net/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2026-01-13T10:03:49+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"\n        WP RSS Aggregator\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"uri\";s:27:\"https://wprssaggregator.com\";s:7:\"version\";s:7:\"4.23.13\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"entry\";a:10:{i:0;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://blog.o2switch.fr/probleme-emails-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"E-mails WordPress qui ne partent plus après la mise à jour 6.9 : comment y remédier\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:51:\"https://blog.o2switch.fr/probleme-emails-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-12T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-12T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:203:\"Après une mise à jour (comme WordPress 6.9), il arrive que les e-mails ne partent plus. Dans cet article, on explique pourquoi et comment rétablir un envoi fiable, sans tomber dans les fausses pistes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:217:\"\n        Après une mise à jour (comme WordPress 6.9), il arrive que les e-mails ne partent plus. Dans cet article, on explique pourquoi et comment rétablir un envoi fiable, sans tomber dans les fausses pistes.\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Éric Martin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://blog.o2switch.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"O2switch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:1;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://whodunit.consulting/tout-savoir-sur-le-bloc-accordeon-de-wordpress-6-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Tout savoir sur le bloc Accordéon de WordPress 6.9\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:79:\"https://whodunit.consulting/tout-savoir-sur-le-bloc-accordeon-de-wordpress-6-9/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-08T07:29:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-08T07:29:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:288:\"WordPress 6.9 introduit un nouveau bloc Accordéon, suite à une forte demande des usagers du CMS. Voici un article en mode question-réponse sur cette nouvelle fonctionnalité.\nL’article Tout savoir sur le bloc Accordéon de WordPress 6.9 est apparu en premier sur Whodunit Consulting.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:26507:\"\n        <figure class=\"wp-block-post-featured-image\"><img width=\"1600\" height=\"960\" src=\"https://whodunit.consulting/wp-content/uploads/2025/10/bloc-accordeon-wordpress-6.9.png\" class=\"attachment-post-thumbnail size-post-thumbnail wp-post-image\" alt=\"\" style=\"object-fit:cover\" //></figure>\n\n\n<h2 class=\"wp-block-heading\">À quoi ressemble le bloc accordéon de WP 6.9&nbsp;?</h2>\n\n\n\n<p>Petite mise en abîme ici, puisque pour vous montrer à quoi ressemble ce nouveau bloc accordéon, autant l&rsquo;utiliser directement&nbsp;!</p>\n\n\n\n<p>Les sections qui suivent montrent le rendu par défaut du bloc accordéon. La section d&rsquo;après montre quant à elle un exemple de bloc accordéon mis en forme via CSS.</p>\n\n\n\n<p>Mais ce ne sont pas de faux contenus de démo. C&rsquo;est tout simplement le contenu de cet article qui est rangé dans ces blocs, alors n&rsquo;hésitez pas à déplier ces éléments pour en voir les contenus&nbsp;<code>:-)</code></p>\n\n\n\n<div data-wp-context=\"{ &quot;autoclose&quot;: true, &quot;accordionItems&quot;: [] }\" data-wp-interactive=\"core/accordion\" role=\"group\" class=\"wp-block-accordion is-layout-flow wp-block-accordion-is-layout-flow\">\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-1&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading has-medium-font-size\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-1-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-1\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-title\">Pourquoi WordPress 6.9 ajoute un nouveau bloc accordéon&nbsp;?</span><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-1\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-1-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>C&rsquo;est vrai qu&rsquo;il existe déjà le bloc «&nbsp;Détails&nbsp;» qui permet de générer des panneaux de contenus masqués puis dépliables au clic sur leur intitulé.</p>\n\n\n\n<p>Mais un composant de type «&nbsp;Accordéon&nbsp;» est assez différent&nbsp;: le principe c&rsquo;est que les panneaux de l&rsquo;accordéon sont liés ensembles à l&rsquo;intérieur d&rsquo;un groupe, à l&rsquo;inverse du composant «&nbsp;Détail&nbsp;» où chaque panneau est totalement indépendant des autres.</p>\n\n\n\n<p>Souvent, on fera d&rsquo;ailleurs en sorte que lorsqu&rsquo;un élément est sélectionné, les autres sections vont se replier, ce qui donne à ce composant son aspect d&rsquo;accordéon.</p>\n</div>\n</div>\n\n\n\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-2&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading has-medium-font-size\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-2-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-2\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-title\">Le bloc accordéon de WP 6.9 est il accessible&nbsp;?</span><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-2\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-2-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>Oui. Des rôles ARIA ont été ajoutées à ce composant afin de standardiser le code source généré.</p>\n\n\n\n<p>Le conteneur global dispose d&rsquo;un rôle <code>group</code> et les panneaux du bloc portent un rôle <code>region</code>. Des attributs ARIA permettent également de faciliter l&rsquo;usage de ce bloc pour les technologies d&rsquo;assistance. Ainsi, le titre de section comprend des attributs <code>aria-expanded</code>, <code>aria-controls</code> se rapportant au panneau dépliable et à son état, tandis que celui-ci comprend un attribut <code>aria-labelledby</code> permettant de le rattacher à son titre.</p>\n\n\n\n<p>On y retrouve donc finalement toutes les recommandations du motif de conception «&nbsp;accordion&nbsp;» proposé par le W3C <sup data-fn=\"892f0416-b38a-49d9-94f5-8963b9352748\" class=\"fn\"><a id=\"892f0416-b38a-49d9-94f5-8963b9352748-link\" href=\"#892f0416-b38a-49d9-94f5-8963b9352748\">1</a></sup>.</p>\n</div>\n</div>\n\n\n\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-3&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading has-medium-font-size\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-3-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-3\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-title\">Quels sont les réglages du bloc accordéon&nbsp;?</span><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-3\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-3-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>Il est possible de définir les niveaux de titres à utiliser pour les titres de section de votre accordéon. C&rsquo;est cependant un poil caché&nbsp;: ne cherchez pas ce réglage au niveau de chaque titre de section, il faut se positionner au niveau du bloc accordéon lui même et le réglage de niveau de titre à utiliser est disponible dans la barre de formatage du bloc&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-image size-full has-custom-border is-style-default\"><img width=\"888\" height=\"718\" src=\"https://whodunit.consulting/wp-content/uploads/2025/10/wordpress-6.9-bloc-accordeon.png\" alt=\"Au niveau de la barre de formatage du bloc accordéon de WordPress 6.9, la quatrième option de la barre permet de définir le niveau de titre à appliquer aux titres de sections du bloc\" class=\"wp-image-4719\" style=\"border-width:1px;border-top-left-radius:5px;border-top-right-radius:5px;border-bottom-left-radius:5px;border-bottom-right-radius:5px\" //></figure>\n\n\n\n<p>Il est aussi possible de définir les comportements généraux du bloc&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Le réglage «&nbsp;Fermer automatiquement&nbsp;» permet de fermer automatiquement les autres panneaux lorsque l&rsquo;un des panneaux est affiché.</li>\n\n\n\n<li>Le réglage «&nbsp;Afficher l’icône&nbsp;» permet d&rsquo;afficher l’icône proposée nativement (et surchargeable en CSS) dans le bouton de dépliement.</li>\n\n\n\n<li>Le réglage «&nbsp;Position de l&rsquo;icône&nbsp;» permet d&rsquo;afficher l&rsquo;icône à droite ou à gauche du titre.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full has-custom-border\"><img width=\"538\" height=\"570\" src=\"https://whodunit.consulting/wp-content/uploads/2025/11/Capture-decran-2025-11-20-a-23.40.02.png\" alt=\"Sur le bloc Accordéon disponible avec WordPress 6.9, 3 réglages sont disponibles. Ceux-ci sont décrits dans le texte qui précède cette image.\" class=\"has-border-color wp-image-4855\" style=\"border-color:#6D3AB0;border-width:1px;border-top-left-radius:5px;border-top-right-radius:5px;border-bottom-left-radius:5px;border-bottom-right-radius:5px\" //></figure>\n</div>\n</div>\n\n\n\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-4&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading has-medium-font-size\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-4-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-4\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-title\">Peut-on facilement modifier les styles du bloc accordéon de WordPress&nbsp;?</span><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-4\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-4-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>Pour pouvoir styler correctement un bloc, il est important de connaître sa structure.</p>\n\n\n\n<p>Voici à quoi ressemble notre bloc accordéon lors de l&rsquo;enregistrement de la page en base de données&nbsp;:</p>\n\n\n\n<pre class=\"wp-block-code\" style=\"font-size:0.75rem\"><code>&lt;!-- wp:accordion --&gt;\n&lt;div role=\"group\" class=\"wp-block-accordion\"&gt;\n	&lt;!-- wp:accordion-item --&gt;\n	&lt;div class=\"wp-block-accordion-item\"&gt;\n		&lt;!-- wp:accordion-heading --&gt;\n		&lt;h3 class=\"wp-block-accordion-heading\"&gt;\n			&lt;button class=\"wp-block-accordion-heading__toggle\"&gt;\n				&lt;span class=\"wp-block-accordion-heading__toggle-title\"&gt;\n					Un titre de section\n				&lt;/span&gt;\n				&lt;span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\"&gt;+&lt;/span&gt;\n			&lt;/button&gt;\n		&lt;/h3&gt;\n		&lt;!-- /wp:accordion-heading --&gt;\n\n		&lt;!-- wp:accordion-panel --&gt;\n		&lt;div role=\"region\" class=\"wp-block-accordion-panel\"&gt;\n			&lt;!-- wp:paragraph --&gt;\n			&lt;p&gt;Mon texte.&lt;/p&gt;\n			&lt;!-- /wp:paragraph --&gt;\n		&lt;/div&gt;\n		&lt;!-- /wp:accordion-panel --&gt;\n	&lt;/div&gt;\n	&lt;!-- /wp:accordion-item --&gt;\n&lt;/div&gt;\n&lt;!-- /wp:accordion --&gt;</code></pre>\n\n\n\n<p>Si l&rsquo;on décortique un peu ce code, on voit que les classes suivantes sont utilisées pour la structuration du bloc&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><code>wp-block-accordion</code> : le conteneur principal du bloc</li>\n\n\n\n<li><code>wp-block-accordion-item</code> : le conteneur de chaque élément de notre accordéon, puis à l&rsquo;intérieur : \n<ul class=\"wp-block-list\">\n<li><code>wp-block-accordion-heading</code> : le titre de section de l&rsquo;élément</li>\n\n\n\n<li><code>wp-block-accordion-heading__toggle</code> : le bouton qui contient le texte du titre de section\n<ul class=\"wp-block-list\">\n<li><code>wp-block-accordion-heading__toggle-title</code> : un wrapper autour du titre textuel seul</li>\n\n\n\n<li><code>wp-block-accordion-heading__toggle-icon</code> : le wrapper autour du petit élément «&nbsp;+&nbsp;» affiché par défaut à droite du titre, afin de pouvoir le cibler et le modifier</li>\n</ul>\n</li>\n</ul>\n</li>\n</ul>\n\n\n\n<p>Cette structure claire permet de cibler assez précisemment chaque item via CSS afin d&rsquo;appliquer des styles personnalisés.</p>\n</div>\n</div>\n</div>\n\n\n\n<p>Dans la section suivante, nous verrons les limites actuelles de ce bloc dans la version Beta 1 de WordPress 6.9, mises en forme au sein d&rsquo;un exemple de bloc accordéon stylé via CSS.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Limites actuelles du bloc Accordéon dans WP 6.9</h2>\n\n\n\n<p>Dans cette section, nous abordons les limites du bloc tel qu&rsquo;il est prévu pour WOrdPress 6.9 dont la sortie a eu lieu le 2 décembre 2025.</p>\n\n\n\n<p>Le bloc accordéon utilisé dans cette section est surchargé en CSS afin de proposer une implémentation visuelle différente du bloc, à titre d&rsquo;exemple.</p>\n\n\n\n<div data-wp-context=\"{ &quot;autoclose&quot;: true, &quot;accordionItems&quot;: [] }\" data-wp-interactive=\"core/accordion\" role=\"group\" class=\"wp-block-accordion customized-accordion is-layout-flow wp-block-accordion-is-layout-flow\">\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-5&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-5-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-5\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span><span class=\"wp-block-accordion-heading__toggle-title\">Le bloc accordéon de WP 6.9 demande un peu de pratique avant de savoir bien l&rsquo;utiliser en <bdo lang=\"en\" dir=\"ltr\">back-office</bdo></span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-5\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-5-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>Si le bloc est dès aujourd&rsquo;hui fonctionnel, son utilisation demande une petite montée en compétence avant de pouvoir le manier avec dextérité en back-office.</p>\n\n\n\n<p>C&rsquo;est globalement le cas de tous les blocs imbriqués (<em><bdo lang=\"en\" dir=\"ltr\">nested blocks</bdo></em>)&nbsp;: l&rsquo;insertion de blocs à l&rsquo;intérieur du conteneur nécessite souvent de revenir au bloc parent avant de pouvoir insérer le contenu que l&rsquo;on souhaite.</p>\n\n\n\n<p>Idem lorsque l&rsquo;on souhaite accéder aux réglages généraux du bloc, il faut revenir au bloc parent ce qui n&rsquo;est pas spécialement évident en cliquant sur les éléments du bloc.</p>\n\n\n\n<p>Pour revenir facilement au bloc parent, pensez à utiliser un maximum le fil d&rsquo;ariane des blocs disponibles en pied de page de l&rsquo;écran de l&rsquo;éditeur. Il est très utile pour remonter dans la hiérarchie d&rsquo;un ensemble de blocs imbriqués.</p>\n\n\n\n<p>À noter que l&rsquo;utilisation du bloc via un lecteur d&rsquo;écran est presque un poil plus aisée que visuellement, car l&rsquo;éditeur propose pas mal de raccourcis destinés à faciliter son usage pour les gens qui utilisent des technologies d&rsquo;assistance.</p>\n</div>\n</div>\n\n\n\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-6&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-6-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-6\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span><span class=\"wp-block-accordion-heading__toggle-title\">Le support des ancres demande un peu de code <bdo lang=\"en\" dir=\"ltr\">custom</bdo></span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-6\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-6-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>Il n&rsquo;est pas facilement possible de faire un lien ancre vers une section de l&rsquo;accordéon qui mène vers son contenu déplié. Enfin si, c&rsquo;est techniquement possible évidemment, mais cela nécessite un peu de JS pour déplier le panneau de section correspondant dans le cas où le lien contient une ancre vers l&rsquo;élément de l&rsquo;accordéon.</p>\n\n\n\n<p>Par défaut, les ancres fonctionnent correctement puisqu&rsquo;elles renvoient bien vers la section courante. Mais le panneau reste replié. Ce serait bien qu&rsquo;un comportement JS natif puisse s&rsquo;assurer de déplier le contenu correspondant.</p>\n\n\n\n<p>C&rsquo;est par exemple le cas si je fais un lien vers un critère sur le site officiel du Référentiel Général d&rsquo;Amélioration de l&rsquo;Accessibilité. Exemple avec <a href=\"https://accessibilite.numerique.gouv.fr/methode/criteres-et-tests/#fr-9.1\">un lien vers le test 9.1.1 du critère 9.1</a>&nbsp;: la section correspondante est bien dépliée automatiquement.</p>\n\n\n\n<p>Pour cela, il faudra (pour l&rsquo;instant) ajouter un peu de JS à votre thème&nbsp;!</p>\n\n\n\n<p>Dans cet article, j&rsquo;ai mis en œuvre un petit script qui permet de déplier le panneau s&rsquo;il est ciblé dans l&rsquo;URL : <a href=\"https://whodunit.consulting/?p=4697#accordion-item-7-panel\" target=\"_blank\" rel=\"noreferrer noopener\">cliquer sur ce lien pour tester une ancre (cela rechargera la page dans un nouvel onglet et dépliera le panneau ciblé)</a>.</p>\n\n\n\n<p>Voici le code JS associé&nbsp;: </p>\n\n\n\n<pre class=\"wp-block-code\" style=\"font-size:0.6rem\"><code>&lt;script&gt;\n(function() {\n	function highlightAndOpenAccordion() {\n		const previouslyHighlighted = document.querySelector(\'.accordion-item-highlighted\');\n		if (previouslyHighlighted) {\n			previouslyHighlighted.classList.remove(\'accordion-item-highlighted\');\n		}\n		const hash = window.location.hash;\n		if (!hash) return;\n	 		try {\n				const targetPanel = document.querySelector(hash);\n				if (targetPanel &amp;&amp; targetPanel.matches(\'.wp-block-accordion-panel\')) {\n					const targetSection = targetPanel.closest(\'.wp-block-accordion-item\');\n					if (!targetSection) return;\n						targetSection.classList.add(\'accordion-item-highlighted\');\n						const button = targetSection.querySelector(\'.wp-block-accordion-heading__toggle\');\n						if (button) {\n							const isExpanded = button.getAttribute(\'aria-expanded\') === \'true\';\n							if (!isExpanded) {\n								button.setAttribute(\'aria-expanded\', true);\n							}\n						}\n					setTimeout(() =&gt; {\n						targetPanel.removeAttribute( \'inert\' );\n						targetSection.scrollIntoView({ behavior: \'smooth\', block: \'start\' });\n					}, 100); \n				}\n			} catch (e) {\n				console.warn(\"Anchor not found:\", e);\n		}\n	}\n	document.addEventListener(\'DOMContentLoaded\', highlightAndOpenAccordion);\n	window.addEventListener(\'hashchange\', highlightAndOpenAccordion);\n})();\n&lt;/script&gt;</code></pre>\n</div>\n</div>\n\n\n\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-7&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-7-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-7\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span><span class=\"wp-block-accordion-heading__toggle-title\">Le support des notes de bas de page ne fonctionne pas vraiment</span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-7\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-7-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>C&rsquo;est un corrolaire du point précédent&nbsp;: si l&rsquo;on souhaite faire un lien-ancre vers un texte situé à l&rsquo;intérieur du contenu d&rsquo;un panneau de notre accordéon, alors le lien est bien fonctionnel, mais si le panneau est fermé, alors on ne voit pas ce texte.</p>\n\n\n\n<p>Pour illustrer ce bug, descendez en bas de cet article et cliquez sur n&rsquo;importe quelle note de bas de page&nbsp;: vous arriverez sur une section refermée sans avoir moyen de l&rsquo;ouvrir si vous utilisez par exemple la navigation clavier ou n&rsquo;importe quelle technologie d&rsquo;assistance. Cela est aussi gênant si vous utiliser la navigation visuelle classique bien entendu.</p>\n</div>\n</div>\n\n\n\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-8&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-8-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-8\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span><span class=\"wp-block-accordion-heading__toggle-title\">Point SEO&nbsp;: le bloc accordéon n&rsquo;est pas un bloc FAQ</span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-8\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-8-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>Le bloc Accordéon est un bloc intéressant lorsque l&rsquo;on a une longue liste de questions-réponses qu&rsquo;on souhaite pouvoir déplier-replier facilement. Cela permet d&rsquo;avoir plus facilement une vue globale de la page lorsque les questions sont toutes repliées.</p>\n\n\n\n<p>Cependant, le bloc accordéon ne contient aucun balisage sémantique, comme par exemple les schémas standards FAQpage <sup data-fn=\"92bf14e0-6ce2-40d3-8ae7-7e12fb5ba494\" class=\"fn\"><a id=\"92bf14e0-6ce2-40d3-8ae7-7e12fb5ba494-link\" href=\"#92bf14e0-6ce2-40d3-8ae7-7e12fb5ba494\">2</a></sup> ou QApage <sup data-fn=\"3e8c05d1-1855-4042-a417-b9467951bfdf\" class=\"fn\"><a id=\"3e8c05d1-1855-4042-a417-b9467951bfdf-link\" href=\"#3e8c05d1-1855-4042-a417-b9467951bfdf\">3</a></sup> proposés sur schema.org.</p>\n\n\n\n<p>Ces schémas (ou «&nbsp;données structurées&nbsp;») ont pour objectif de proposer un balisage sémantique interprétable par les agents utilisateurs tels que les technologies d&rsquo;assistance, mais ils sont plus connus pour leur capacité à aider les moteurs d&rsquo;indexation à correctement interpréter votre contenu.</p>\n\n\n\n<p>Google en est friand et recommande leur implémentation <sup data-fn=\"d3426e02-7b7d-47f2-914f-46d8a51676c0\" class=\"fn\"><a href=\"#d3426e02-7b7d-47f2-914f-46d8a51676c0\" id=\"d3426e02-7b7d-47f2-914f-46d8a51676c0-link\">4</a></sup>, et c&rsquo;est aussi le cas des moteurs d&rsquo;indexation utilisés par les IA.</p>\n\n\n\n<p>Dans une optique GEO (pour <em><bdo lang=\"en\" dir=\"ltr\">Generative Engine Optimization</bdo></em>, soit optimisation pour les moteurs d&rsquo;indexation des IA génératives), les pages contenant des FAQ sont hyper importantes. C&rsquo;est une évidence puisque les IA ont globalement pour objectif de répondre à des questions en langage naturel. Quoi de mieux qu&rsquo;une page présentant un balisage sémantique en mode questions-réponses pour cela&nbsp;?</p>\n\n\n\n<p>Tout cela n&rsquo;est pas prévu par le bloc natif Accordéon pour une bonne et simple raison&nbsp;: il s&rsquo;agit d&rsquo;un bloc générique qui n&rsquo;a pas vocation à ajouter la moindre sémantique sur vos contenus&nbsp;: il doit être utilisable pour n&rsquo;importe quel contenu même s&rsquo;il ne s&rsquo;agit pas de questions-réponses.</p>\n\n\n\n<p>Il est cependant tout à fait possible d&rsquo;ajouter ces données structurées au bloc Accordéon natif. Ça demande cependant un peu de développement et je propose d&rsquo;en parler dans un prochain article.</p>\n</div>\n</div>\n</div>\n\n\n\n<p>Voilà, j&rsquo;espère que cet article vous en aura appris un peu plus sur le fonctionnement du bloc Accordéon qui est arrivé avec WordPress&nbsp;6.9.</p>\n\n\n\n<p>Si vous voulez suivre les dernières étapes du développement de cette nouvelle version de WP, vous pouvez <a href=\"https://make.wordpress.org/core/\">consulter le blog officiel <bdo lang=\"en\" dir=\"ltr\">Make/Core</bdo></a> sur lequel nous partageons régulièrement les avancées techniques du CMS. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" //>\n\n\n\n<h2 class=\"wp-block-heading has-small-font-size\">Notes et références</h2>\n\n\n<ol class=\"wp-block-footnotes\"><li id=\"892f0416-b38a-49d9-94f5-8963b9352748\">Voir <a href=\"https://www.w3.org/WAI/ARIA/apg/patterns/accordion/examples/accordion/\">l&rsquo;exemple d&rsquo;implémentation du motif « accordion » sur le site « ARIA Authoring Practices Guide (APG) » du W3C</a> <a href=\"#892f0416-b38a-49d9-94f5-8963b9352748-link\" aria-label=\"Aller à la note de bas de page 1\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/21a9.png\" alt=\"↩\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //>︎</a></li><li id=\"92bf14e0-6ce2-40d3-8ae7-7e12fb5ba494\">Voir le <a href=\"https://schema.org/FAQPage\">schéma FAQpage sur schema.org</a> <a href=\"#92bf14e0-6ce2-40d3-8ae7-7e12fb5ba494-link\" aria-label=\"Aller à la note de bas de page 2\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/21a9.png\" alt=\"↩\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //>︎</a></li><li id=\"3e8c05d1-1855-4042-a417-b9467951bfdf\">Voir le <a href=\"https://schema.org/QAPage\">schéma QApage sur schema.org</a> <a href=\"#3e8c05d1-1855-4042-a417-b9467951bfdf-link\" aria-label=\"Aller à la note de bas de page 3\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/21a9.png\" alt=\"↩\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //>︎</a></li><li id=\"d3426e02-7b7d-47f2-914f-46d8a51676c0\">Voir par exemple la <a href=\"https://developers.google.com/search/docs/appearance/structured-data/faqpage?hl=fr\">documentation de Google concernant la mise en place de données structurées pour les pages de FAQ</a> <a href=\"#d3426e02-7b7d-47f2-914f-46d8a51676c0-link\" aria-label=\"Aller à la note de bas de page 4\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/21a9.png\" alt=\"↩\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //>︎</a></li></ol><p>L’article <a href=\"https://whodunit.consulting/tout-savoir-sur-le-bloc-accordeon-de-wordpress-6-9/\">Tout savoir sur le bloc Accordéon de WordPress 6.9</a> est apparu en premier sur <a href=\"https://whodunit.consulting\">Whodunit Consulting</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Jean-Baptiste Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://whodunit.consulting/category/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Whodunit Consulting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:2;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wpfr.net/journee-de-contribution-du-wordcamp-nice-2026-presentation-des-tables-episode-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Journée de Contribution Nice 2026 : présentation des tables – épisode n°1 !\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:97:\"https://wpfr.net/journee-de-contribution-du-wordcamp-nice-2026-presentation-des-tables-episode-1/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-07T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-07T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:373:\"Ça vous aura peut-être échappé, entre la fin des projets 2025, les diverses festivités de fin d’année, les congés de rigueur… mais les inscriptions sont ouvertes pour la journée de contribution du WordCamp Nice 2026 !  Après vous être bien reposés, nous vous invitons à vous projeter sur cette nouvelle année pleine de promesses, de nouveauxLire la suite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:5111:\"\n        \n<p class=\"has-medium-font-size\">Ça vous aura peut-être échappé, entre la fin des projets 2025, les diverses festivités de fin d’année, les congés de rigueur… mais <a href=\"https://wpfr.net/journee-de-contribution-nice-2026-les-inscriptions-sont-ouvertes/\"><strong>les inscriptions sont ouvertes pour la journée de contribution du WordCamp Nice 2026</strong></a>&nbsp;!&nbsp;</p>\n\n\n\n<p class=\"has-medium-font-size\">Après vous être bien reposés, nous vous invitons à vous projeter sur cette nouvelle année pleine de promesses, de nouveaux événements, de retrouvailles… bref, pleine de WordPress !</p>\n\n\n\n<p class=\"has-medium-font-size\">Pour rappel, la Journée de Contribution a lieu <strong>la veille du WordCamp Nice</strong>, soit <strong>le 5 mars 2026</strong>.&nbsp;</p>\n\n\n\n<p class=\"has-medium-font-size\">Pour vous aider à vous projeter et finir de vous convaincre de nous rejoindre, nous allons publier ces prochains jours quelques informations sur les tables de contribution prévues… Préparez-vous !&nbsp;</p>\n\n\n\n<p class=\"has-medium-font-size\">Et pour commencer, deux premières tables pour ce teasing de début d’année !</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" //>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"table-contribution-a-la-pattern-library\"><strong>Table «&nbsp;Contribution à la Pattern library&nbsp;»</strong></h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p class=\"has-medium-font-size\">À cette table, pas besoin de connaître une langue étrangère, de savoir coder ou transférer des fichiers. On va créer ensemble des compositions Gutenberg et les soumettre via formulaire à <a href=\"http://wordpress.org/\">WordPress.org</a>.</p>\n\n\n\n<p class=\"has-medium-font-size\">Si vous ne maitrisez pas Gutenberg, ce n&rsquo;est pas grave, vous apprendrez et pourrez être force de proposition dans les choix de compositions à créer.</p>\n\n\n\n<p class=\"has-medium-font-size\">Vous apprendrez entre autres à créer une composition « passe-partout », responsive et utile.<br>Et si nos compositions ne sont pas acceptées, elles viendront pourquoi pas compléter une librairie française de compositions libre d&rsquo;accès.</p>\n<cite><strong>Eddy BOELS</strong></cite></blockquote>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" //>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"table-coeur-de-wordpress\"><strong>Table «&nbsp;Cœur de WordPress&nbsp;»</strong></h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p class=\"has-medium-font-size\">Ta mission si tu l&rsquo;acceptes est d&rsquo;apprendre à contribuer au logiciel que tu utilises au quotidien. Nul besoin d&rsquo;être développeur ou développeuse pour contribuer&nbsp;! </p>\n\n\n\n<p class=\"has-medium-font-size\">Durant cette journée :</p>\n\n\n\n<ul class=\"wp-block-list has-medium-font-size\">\n<li>On te guidera sur l&rsquo;installation de l&rsquo;environement de développement.</li>\n\n\n\n<li>On te montrera comment proposer un correctif.</li>\n\n\n\n<li>On t&rsquo;expliquera comment fonctionne le Core (nul besoin d’être dev)</li>\n\n\n\n<li>Tu apprendras aussi à remonter un bug (ah ben la non plus !)</li>\n\n\n\n<li>Tu pourras même tester des correctifs déjà codés (et pour ça toujours pas besoin d&rsquo;être dev).</li>\n</ul>\n\n\n\n<p class=\"has-medium-font-size\">Surtout, tu auras la joie et le bonheur de partager une journée avec des gens cools (même si certains ou certaines sont développeurs ou développeuses :p )</p>\n<cite><strong>Sébastien SERRE et Antoine SIRVEN</strong></cite></blockquote>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" //>\n\n\n\n<p class=\"has-medium-font-size\">Alors ? Tenté ? <a href=\"https://framaforms.org/inscription-contributeur-journee-de-contribution-nice-1764833418\">Les inscriptions sont par ici</a>, et si tu ne trouves pas ta place dans ces 2 tables, reste à l’écoute car d’autres articles arrivent pour présenter les autres tables !&nbsp;</p>\n\n\n\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-16018d1d wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-white-color has-vivid-cyan-blue-background-color has-text-color has-background has-link-color has-medium-font-size has-text-align-center has-custom-font-size wp-element-button\" href=\"https://framaforms.org/inscription-contributeur-journee-de-contribution-nice-1764833418\" target=\"_blank\" rel=\"noreferrer noopener\">Je m’inscris</a></div>\n</div>\n\n\n\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-medium-font-size\">Tu souhaites proposer et animer une autre table ? C’est toujours possible, n’hésite pas à <a href=\"mailto:contribution@wpfr.net\">nous envoyer un mail pour en discuter</a>.&nbsp;</p>\n\n\n\n<p class=\"has-text-align-right has-medium-font-size\"><em>Les organisateurs de la Journée de Contribution</em></p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://wpfr.net/actualites/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:3;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wpmarmite.com/creer-images-ia-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Comment créer des images avec l’IA dans WordPress : le tutoriel complet\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:48:\"https://wpmarmite.com/creer-images-ia-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-06T08:00:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-06T08:00:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:446:\"Vous en avez assez de gaspiller un budget conséquent dans des banques d’images impersonnelles que vos concurrents utilisent déjà massivement sur leurs propres sites ? Apprenez enfin comment créer des images avec l’IA dans WordPress pour concevoir des visuels sur mesure et...\nComment créer des images avec l’IA dans WordPress : le tutoriel complet est un article de WPMarmite, le blog qui vous aide à tirer le meilleur de WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:817:\"\n        <p><img width=\"1500\" height=\"830\" src=\"https://wpmarmite.com/wp-content/uploads/2025/11/formation-ia-intelligence-artificelle.webp\" class=\"attachment-full size-full wp-post-image\" alt=\"Les meilleures formations IA\" //></p>\n<p>Vous en avez assez de gaspiller un budget conséquent dans des banques d&#8217;images impersonnelles que vos concurrents utilisent déjà massivement sur leurs propres sites&nbsp;? Apprenez enfin comment&nbsp;créer des images avec l&#8217;IA dans WordPress pour concevoir des visuels sur mesure et...</p>\n<p><a href=\"https://wpmarmite.com/creer-images-ia-wordpress/\">Comment créer des images avec l&#8217;IA dans WordPress : le tutoriel complet</a> est un article de <a href=\"https://wpmarmite.com\">WPMarmite</a>, le blog qui vous aide à tirer le meilleur de WordPress.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Équipe WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://feedpress.me/WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Marmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:4;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://kinsta.com/fr/blog/echelle-sites-wordpress-complexes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"Comment Kinsta aide les développeurs à gérer des sites WordPress complexes à grande échelle\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:61:\"https://kinsta.com/fr/blog/echelle-sites-wordpress-complexes/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-05T07:49:28.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-05T07:49:28.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:344:\"Gérer des sites WordPress complexes signifie gérer des architectures lourdes en extensions, des milliers d’utilisateurs simultanés et des clients qui attendent des performances constantes. Lorsque vous ...\nThe post Comment Kinsta aide les développeurs à gérer des sites WordPress complexes à grande échelle appeared first on Kinsta®.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:489:\"\n        <p>Gérer des sites WordPress complexes signifie gérer des architectures lourdes en extensions, des milliers d&#8217;utilisateurs simultanés et des clients qui attendent des performances constantes. Lorsque vous ...</p>\n<p>The post <a href=\"https://kinsta.com/fr/blog/echelle-sites-wordpress-complexes/\">Comment Kinsta aide les développeurs à gérer des sites WordPress complexes à grande échelle</a> appeared first on <a href=\"https://kinsta.com/fr\">Kinsta®</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joel Olawanle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://kinsta.com/fr/sujets/developpement-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Kinsta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:5;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://beapi.fr/blog/securite-wordpress-comprendre-les-failles-pour-mieux-les-maitriser/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Sécurité WordPress : comprendre les failles pour mieux les maîtriser\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:89:\"https://beapi.fr/blog/securite-wordpress-comprendre-les-failles-pour-mieux-les-maitriser/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-12-10T10:59:20.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-12-10T10:59:20.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:497:\"1. Démystifier les failles : un phénomène parfois mal interprété « 8 millions de cyberattaques contre des sites WordPress », « Une faille critique dans un plugin populaire », «Cette vulnérabilité expose 400 000 sites »… Si vous suivez de l’actualité tech, vous avez forcément croisé ce type d’alertes. Le mot faille intervient dès qu’une vulnérabilité technique […]\nThe post Sécurité WordPress : comprendre les failles pour mieux les maîtriser appeared first on .\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:16726:\"\n        \n<h2 class=\"wp-block-heading\">1. Démystifier les failles : un phénomène parfois mal interprété</h2>\n\n\n\n<p>« <em>8 millions de cyberattaques contre des sites WordPress</em> », « <em>Une faille critique dans un plugin populaire</em> », «<em>Cette vulnérabilité expose 400 000 sites</em> »…</p>\n\n\n\n<p>Si vous suivez de l’actualité tech, vous avez forcément croisé ce type d’alertes.</p>\n\n\n\n<p>Le mot <em>faille</em> intervient dès qu’une vulnérabilité technique est identifiée. Un mot chargé, anxiogène, qui suggère souvent une menace imminente. Pourtant, la présence de failles n’a rien d’exceptionnel : c’est le fonctionnement naturel de tout écosystème numérique vivant.</p>\n\n\n\n<p>Les usages évoluent, les dépendances changent et les menaces progressent. Une faille n’est pas forcément un signe de faiblesse : <strong>c’est un signal, qui rappelle qu’une plateforme doit être maintenue, surveillée et régulièrement mise à jour.</strong></p>\n\n\n\n<p>Ce n’est donc pas exceptionnel, même si cela reste un sujet important ! En effet, une faille ignorée peut avoir des conséquences bien réelles qui dépassent le cadre technique, touchant directement à la performance et la réputation de l’entreprise et  pouvant entrainer :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>une interruption de service, </li>\n\n\n\n<li>une perte SEO si le site est compromis,</li>\n\n\n\n<li>des risques RGPD en cas de fuite de données,</li>\n\n\n\n<li>ou une atteinte durable à l’image de marque.</li>\n</ul>\n\n\n\n<p><strong>C’est précisément pour cela que la capacité à identifier, prioriser et corriger une faille est un enjeu déterminant.</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">2. De quoi parle-t-on exactement ?</h2>\n\n\n\n<p>Une faille de sécurité correspond à une vulnérabilité dans le code, la configuration ou les accès d’un système. Elle signale qu’un point pourrait être exploité.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Une faille</strong> est une vulnérabilité potentielle ;</li>\n\n\n\n<li><strong>Un risque est une faille appréciée au regard du contexte réel</strong> (type de site, données traitées, exposition du service&#8230; ;</li>\n\n\n\n<li><strong>Un incident</strong> correspond à la situation dans laquelle cette faille est effectivement exploitée.</li>\n</ul>\n\n\n\n<p><strong>C’est là que la notion de contexte devient déterminante.</strong></p>\n\n\n\n<p>Pour évaluer la gravité réelle d’une vulnérabilité, les experts s’appuient sur le standard international CVSS, qui attribue une note selon la facilité d’exploitation et l’impact potentiel. Mais cette note reste théorique.</p>\n\n\n\n<p>Deux plateformes confrontées à la même faille n’auront pas le même niveau de risque &#8211; parfois certaines vulnérabilités pourtant sévèrement notées ne sont exploitables que dans des conditions très spécifiques (un contexte projet particulier, un paramétrage serveur précis…), ce qui rend leur exploitation réelle peu probable.</p>\n\n\n\n<h4 class=\"wp-block-heading\">La seule évaluation véritablement pertinente est celle qui croise la vulnérabilité avec la réalité opérationnelle du projet.</h4>\n\n\n\n<p>C&rsquo;est précisément cette lecture contextualisée qui évite les réactions intempestives, tout en garantissant que les failles réellement critiques soient identifiées et traitées en priorité.</p>\n\n\n\n<h2 class=\"wp-block-heading\">3. WordPress est-il moins sécurisé qu’une autre technologie ? Un mythe à déconstruire</h2>\n\n\n\n<p>La réputation de WordPress en matière de sécurité reste encore teintée par son histoire. À ses débuts, le CMS servait surtout à créer des blogs personnels, souvent installés sans hébergement adapté, sans maintenance et sans véritable gouvernance technique. Cette image lui colle encore à la peau, alors même que l’écosystème a profondément évolué.</p>\n\n\n\n<p>Aujourd’hui, WordPress propulse plus de 40 % du web, y compris des plateformes gouvernementales, des portails à fort trafic ou des projets aux exigences de sécurité élevées. Son code est examiné en continu, audité plus que n’importe quel autre CMS, et les correctifs sont publiés très vite (parfois en moins de 48 heures pour une faille critique.)</p>\n\n\n\n<h3 class=\"wp-block-heading\">Dans l’univers WordPress, les principales sources de vulnérabilité sont bien identifiées :</h3>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Le noyau WordPress</strong> </h4>\n\n\n\n<p>Les failles du core sont rares, et elles sont corrigées rapidement. Le CMS bénéficie d’une équipe sécurité dédiée et d’un code source totalement ouvert, analysé en continu par des milliers de développeurs.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Les extensions et les thèmes tiers</strong> </h4>\n\n\n\n<p>C’est ici que se concentre l’essentiel des vulnérabilités : plus de 96 % des failles recensées concernent des extensions tierces &#8211; projets abandonnés, dépendances non maintenues, qualité parfois douteuse…</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Les configurations serveur et administrateur</strong> </h4>\n\n\n\n<p>Une clé API laissée en clair, un accès FTP ouvert, un répertoire exposé… Ces erreurs de configuration, généralement invisibles, créent pourtant de véritables points d’entrée.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Le facteur humain</strong> </h4>\n\n\n\n<p>Mots de passe faibles, pas d’authentification à deux facteurs, multiplication des comptes administrateurs&#8230; Dans de nombreux incidents, la vulnérabilité ne vient pas du code, mais des usages.</p>\n\n\n\n<p></p>\n\n\n\n<p>Ainsi, dans la grande majorité des incidents, la responsabilité n’incombe pas au CMS lui-même, mais à l’écosystème dans lequel il évolue. Un dernier point, souvent mal compris, mérite d’être souligné :</p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>Si l’on découvre tant de failles dans l’écosystème WordPress, ce n’est pas qu’il est moins sécurisé : c&rsquo;est qu’il est davantage étudié. Son code ouvert est inspecté et audité en continu par des milliers de développeurs.</p></blockquote></figure>\n\n\n\n<p>Le fameux « quand on cherche, on trouve » (ce qui est précisément un signe de bonne santé pour un projet open source.) Ce modèle de transparence crée un effort collectif permanent : détection précoce, documentation rapide, correctifs publiés publiquement et amélioration continue.</p>\n\n\n\n<p>Cette dynamique ne fragilise pas WordPress, <strong>elle renforce sa sécurité dans le temps</strong>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">4. Le facteur déterminant : une gouvernance solide</h2>\n\n\n\n<p>La sécurité d’une plateforme ne dépend jamais uniquement de la technologie sur laquelle elle repose. Deux projets utilisant WordPress, Drupal ou une solution propriétaire peuvent proposer des niveaux de sécurité radicalement différents. La différence se joue <strong>dans la manière dont la plateforme est pilotée, entretenue et structurée dans le temps</strong>. </p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>Une gouvernance solide n’empêche pas les failles d’exister. En revanche, elle crée les conditions pour les détecter tôt, les corriger vite et éviter qu’une vulnérabilité mineure ne devienne un incident majeur.</p></blockquote></figure>\n\n\n\n<p>Cette gouvernance repose sur plusieurs piliers complémentaires :</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Un cadre clair pour la maintenance et la prise de décision</strong></h4>\n\n\n\n<p>Revue de code régulière, TMA structurée, responsabilités définies, documentation mise à jour… Ces éléments évitent les angles morts et garantissent que les décisions techniques ne reposent jamais sur l’intuition ou l’urgence.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Une gestion rigoureuse des accès</strong></h4>\n\n\n\n<p>Rôles attribués avec précision, authentification à deux facteurs, rotation des mots de passe, procédures pour les comptes temporaires… Une bonne gestion des accès protège autant qu’un correctif de sécurité, et parfois davantage.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Une stack technique maîtrisée</strong></h4>\n\n\n\n<p>Un hébergement sécurisé, des sauvegardes fiables, une supervision active, un environnement de préproduction pour tester sereinement : ce socle technique conditionne la capacité d’une plateforme à résister, absorber, puis corriger un incident sans rupture.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Une coordination fluide entre les équipes</strong></h4>\n\n\n\n<p>Développeurs, RUN et équipes métier partagent une vision commune du niveau de risque acceptable, des priorités et des actions à mener lorsqu’une alerte survient. Cette coopération est souvent la frontière entre un incident contenu et une crise durable.</p>\n\n\n\n<p>C’est cette culture, plus que la technologie en elle-même, qui fait la différence entre un site qui « fonctionne » et une plateforme réellement fiable.</p>\n\n\n\n<h2 class=\"wp-block-heading\">5. Anticiper, détecter, corriger : une sécurité pilotée</h2>\n\n\n\n<p>En matière de sécurité, tout se joue dans la méthode : repérer tôt, analyser correctement et agir sans précipitation.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Une veille active pour ne rien laisser passer</h3>\n\n\n\n<p>Une bonne pratique consiste à s’appuyer sur plusieurs niveaux :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>des outils spécialisés</strong> (Patchstack, WPScan, Wordfence), qui identifient et recensent les vulnérabilités et les classent selon leur criticité ;</li>\n\n\n\n<li><strong>la communauté open source</strong>, souvent la plus rapide à remonter un comportement suspect ou à proposer un correctif ;</li>\n\n\n\n<li><strong>une veille interne,</strong> où les équipes documentent les alertes et partagent leurs retours d’expérience.</li>\n</ul>\n\n\n\n<p>Cette approche croisée propose une vision étendue de l’écosystème, du plugin le plus répandu à la dépendance la plus discrète.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Du signal à la correction</h3>\n\n\n\n<p>Lorsqu’une faille est détectée, l’objectif est d&rsquo;agir sans bloquer le reste du projet. C’est là qu&rsquo;un bon process devient essentiel. </p>\n\n\n\n<p>Chez Be API, une séquence éprouvée s’enclenche automatiquement :</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>Détection automatisée via les outils de veille </strong></li>\n\n\n\n<li><strong>Création d’un ticket pour assurer la traçabilité </strong></li>\n\n\n\n<li><strong>Analyse et classification interne </strong></li>\n\n\n\n<li><strong>Évaluation technique : cause, impact, options possibles </strong></li>\n\n\n\n<li><strong>Information du client, avec un message clair et contextualisé </strong></li>\n\n\n\n<li><strong>Correctif et tests en préproduction</strong> </li>\n\n\n\n<li><strong>Déploiement et vérification finale</strong>.</li>\n</ol>\n\n\n\n<p>Cette méthodologie garantit une action rapide et proportionnée.</p>\n\n\n\n<h3 class=\"wp-block-heading\">L’importance de la contextualisation</h3>\n\n\n\n<p>Comme mentionné plus haut, aucune corrélation directe n&rsquo;existe entre le score théorique d’une faille et l’urgence d’agir. Une vulnérabilité classée « critique » peut s’avérer sans conséquence sur un site peu exposé, et une faille mineure peut devenir problématique selon son contexte réel d’usage.</p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>D’où l’importance de ne jamais se fier uniquement à l’outil : ce sont les humains qui, en connaissant le projet, peuvent évaluer ce qui doit être traité immédiatement et ce qui relève du suivi classique.</p></blockquote></figure>\n\n\n\n<p>Chaque cas est discuté : faut-il patcher manuellement ou remplacer une extension obsolète ? Peut-on déployer immédiatement ou faut-il une recette complète ? La mise à jour est-elle compatible avec un contexte métier particulier ?</p>\n\n\n\n<p>Ces arbitrages se font en équipe, en croisant les expertises techniques, fonctionnelles et métier. </p>\n\n\n\n<h3 class=\"wp-block-heading\">La communication comme gage de confiance</h3>\n\n\n\n<p>Corriger une faille est une chose. Communiquer correctement autour de cet événement en est une autre. Une communication claire et factuelle évite les inquiétudes inutiles et crée un cadre de confiance avec le client.</p>\n\n\n\n<p>Les informations transmises sont :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Claires</strong> : pas de jargon technique sans explication.</li>\n\n\n\n<li><strong>Contextualisées</strong> : ce qui est concerné, ce qui ne l’est pas, ce qui a été fait.</li>\n\n\n\n<li><strong>Responsables</strong> : pas d&rsquo;alarmisme, pas de minimisation.</li>\n</ul>\n\n\n\n<p>Une faille bien encadrée n’abîme pas la relation client, et pour cause, <strong>la sécurité n’est pas un sujet tabou</strong>, mais un engagement assumé de transparence et de rigueur.</p>\n\n\n\n<h2 class=\"wp-block-heading\">6. Maintenance, mises à jour et prévention</h2>\n\n\n\n<p>La sécurité évolue, au même titre que les technologies, les usages, les dépendances, etc&#8230; Ce n&rsquo;est pas projet que l’on initie, puis clôture : <strong>c’est un processus continu, un engagement du quotidien.</strong></p>\n\n\n\n<p>Pour conserver un niveau de protection optimal, deux types de mises à jour doivent être mises en place :</p>\n\n\n\n<h4 class=\"wp-block-heading\">1. Les montées de version structurantes (souvent annuelles)</h4>\n\n\n\n<p>Elles modernisent le socle, intègrent les évolutions majeures du CMS, assurent la compatibilité avec les nouvelles API et permettent de remettre la plateforme à niveau.</p>\n\n\n\n<p>Elles sont essentielles pour éviter les écarts trop importants, qui finissent par bloquer l’accès à certains correctifs et évolutions.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>2. Les mises à jour de sécurité régulières</strong></h4>\n\n\n\n<p>Plus légères mais tout aussi indispensables, elles corrigent les vulnérabilités dès qu’elles sont publiées et évitent que les risques ne s’accumulent dans le temps. Ignorer ces mises à jour de sécurité, c’est comme négliger l’entretien d’une voiture : tout fonctionne… jusqu’au moment où un détail finit par provoquer l’incident que l’on aurait pu éviter.</p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>Ces deux types de mises à jour s’inscrivent dans une approche plus large : la <strong>maintenance préventive</strong>. Elle repose sur une supervision globale de la plateforme, un suivi automatisé des anomalies et des interventions dès les premiers signaux faibles. </p></blockquote></figure>\n\n\n\n<p>Enfin, assurer la sécurité d’un site n’est pas le rôle d’une seule personne, ni même d’un seul métier. <strong>C’est une chaîne de responsabilités </strong>qui mobilise plusieurs expertises :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Les développeurs</strong>, qui produisent un code propre, auditable et maintenable.</li>\n\n\n\n<li><strong>Les équipes de maintenance</strong>, qui supervisent, maintiennent et documentent les évolutions dans le temps.</li>\n\n\n\n<li><strong>L’équipe métier</strong>, qui apporte le contexte nécessaire pour prendre les bonnes décisions.</li>\n</ul>\n\n\n\n<p>C&rsquo;est ce dialogue continu qui garantit un niveau de sécurité stable, sans freiner la capacité d’évolution.</p>\n\n\n\n<h2 class=\"wp-block-heading\">7. En conclusion : la sécurité est un engagement, partagé et continu</h2>\n\n\n\n<p><strong>Aucun site n’est totalement dépourvu de failles : l’enjeu n’est donc pas de viser l’infaillibilité, mais de s’assurer que la plateforme dispose de garde-fous solides, d’une gouvernance claire et d’une maintenance structurée</strong>.</p>\n\n\n\n<p>C’est un travail continu, qui repose autant sur des pratiques éprouvées que sur la coordination des équipes, la qualité du code et une culture commune de la vigilance. </p>\n\n\n\n<h3 class=\"wp-block-heading\">👉 Vous avez un doute sur le niveau de sécurité de votre plateforme WordPress ?</h3>\n\n\n\n<p>Prenez 30 minutes avec un expert sécurité Be API !</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://beapi.fr/contact/\">Réserver un appel gratuit</a></div>\n</div>\n<p>The post <a href=\"https://beapi.fr/blog/securite-wordpress-comprendre-les-failles-pour-mieux-les-maitriser/\">Sécurité WordPress : comprendre les failles pour mieux les maîtriser</a> appeared first on <a href=\"https://beapi.fr\"></a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Alizée Ragoin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://beapi.fr/blog/categories/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BeAPI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:6;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://www.youtube.com/watch?v=r3ym5-pRxrk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"J’ai testé WordPress 6.9 pendant 2 heures : Voici ce que j’ai retenu.\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:43:\"https://www.youtube.com/watch?v=r3ym5-pRxrk\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-12-05T09:30:18.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-12-05T09:30:18.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:540:\"WordPress 6.9 est officiellement disponible depuis le 2 décembre 2024 ! Dans cette vidéo, je te fais découvrir TOUTES les nouveautés : les nouveaux blocs (accordéon, formules mathématiques, temps de lecture), les améliorations collaboratives, les optimisations de performance et bien plus encore. Tu vas pouvoir tester en direct chaque fonctionnalité et comprendre comment les intégrer […]\nL’article J’ai testé WordPress 6.9 pendant 2 heures : Voici ce que j’ai retenu. est apparu en premier sur Agence WordPress Whodunit.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:677:\"\n        <p>WordPress 6.9 est officiellement disponible depuis le 2 décembre 2024 ! Dans cette vidéo, je te fais découvrir TOUTES les nouveautés : les nouveaux blocs (accordéon, formules mathématiques, temps de lecture), les améliorations collaboratives, les optimisations de performance et bien plus encore. Tu vas pouvoir tester en direct chaque fonctionnalité et comprendre comment les intégrer [&#8230;]</p>\n<p>L’article <a href=\"https://www.youtube.com/watch?v=r3ym5-pRxrk\">J&rsquo;ai testé WordPress 6.9 pendant 2 heures : Voici ce que j&rsquo;ai retenu.</a> est apparu en premier sur <a href=\"https://www.whodunit.fr\">Agence WordPress Whodunit</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Eddy BOELS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://www.whodunit.fr/videos/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Whodunit Videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:7;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://www.youtube.com/watch?v=VMoxycnBtBc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"Crée ton site WordPress en 20 minutes avec Ollie Pro (FSE facile)\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:43:\"https://www.youtube.com/watch?v=VMoxycnBtBc\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-21T14:21:16.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-21T14:21:16.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:490:\"Découvre Ollie Pro, le meilleur thème pour débuter avec le Full Site Editing (FSE) sur WordPress ! Dans ce tutoriel complet, je te montre comment créer un site WordPress moderne sans avoir peur du FSE. Avec Ollie Pro, tu bénéficies d’un Wizard intuitif, de dizaines de compositions prêtes à l’emploi, et d’extensions puissantes pour aller […]\nL’article Crée ton site WordPress en 20 minutes avec Ollie Pro (FSE facile) est apparu en premier sur Agence WordPress Whodunit.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:631:\"\n        <p>Découvre Ollie Pro, le meilleur thème pour débuter avec le Full Site Editing (FSE) sur WordPress ! Dans ce tutoriel complet, je te montre comment créer un site WordPress moderne sans avoir peur du FSE. Avec Ollie Pro, tu bénéficies d&#8217;un Wizard intuitif, de dizaines de compositions prêtes à l&#8217;emploi, et d&#8217;extensions puissantes pour aller [&#8230;]</p>\n<p>L’article <a href=\"https://www.youtube.com/watch?v=VMoxycnBtBc\">Crée ton site WordPress en 20 minutes avec Ollie Pro (FSE facile)</a> est apparu en premier sur <a href=\"https://www.whodunit.fr\">Agence WordPress Whodunit</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Eddy BOELS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://www.whodunit.fr/videos/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Whodunit Videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:8;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://holdmywp.com/benchmark-hosterra/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Hosterra – Test de performance pour WordPress, Benchmark\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:40:\"https://holdmywp.com/benchmark-hosterra/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-20T11:09:32.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-20T11:09:32.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:147:\"Pour un avoir un aperçu clair des performances réelles d\'un hébergement Hosterra, j\'ai testé chaque offre avec l\'outil Hosting Benchmark Tools.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:16952:\"\n        \n<p>Hosterra est un hébergeur que j&rsquo;ai découvert au <a href=\"https://bretagne.wordcamp.org/2024/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Wordcamp Bretagne\">Wordcamp Bretagne</a> à Rennes en 2024, où j&rsquo;ai rencontré <a href=\"https://pierre.lannoy.fr/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Pierre Lannoy\">Pierre Lannoy</a> qui venait nous parler <a href=\"https://wordpress.tv/2024/11/02/dites-non-au-green-washing-hebergez-reellement-ecoresponsable/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"d\'hébergement écoresponsable\">d&rsquo;hébergement écoresponsable</a>. Aujourd&rsquo;hui, Hosterra est l&rsquo;hébergeur que je recommande à mes clients et avec lequel je travaille pour <a href=\"https://holdmywp.com/maintenance-wordpress/\" title=\"Maintenance WordPress\">mon service de maintenance et d&rsquo;hébergement WordPress</a>.</p>\n\n\n\n<p>Une seule offre d&rsquo;hébergement web testée ici pour le moment, celle que j&rsquo;utilise : l&rsquo;<strong>hébergement mutualisé Hosterra</strong>. Pour un avoir un aperçu clair des performances réelles, j&rsquo;ai testé l&rsquo;offre avec l&rsquo;outil <strong>Hosting Benchmark Tools</strong>. Comme pour les <a href=\"https://holdmywp.com/hebergement-wordpress/\" title=\"Hébergement WordPress\">autres benchmarks réalisés</a>, l&rsquo;instance WordPress testée est vierge avec le même thème, les mêmes extensions et seule sur son hébergement.</p>\n\n\n\n<p>La promesse : <a href=\"https://hosterra.eu/fr/store/shared-hosting/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"un hébergement performant et écoresponsable\"><em>un hébergement performant et tout en étant écoresponsable</em></a>. Voyons ça.</p>\n\n\n<h2 class=\"wp-block-heading\" id=\"approche-et-methodologie-devaluation-dun-hebergement-wordpress\">Approche et méthodologie d&rsquo;évaluation d&rsquo;un hébergement WordPress</h2>\n\n<h3 class=\"wp-block-heading\" id=\"objectif\">Objectif</h3>\n\n\n<p>Cette publication n&rsquo;est pas une énième copie des listes de caractéristiques longues comme le bras affichées sur les pages de vente des hébergeurs, mais un focus sur ce qui compte pour faire un <a href=\"https://holdmywp.com/maintenance-wordpress/\" title=\"Maintenance WordPress\">bon hébergement WordPress</a> : <strong>Performance</strong>, <strong>Efficience</strong>, <strong>Robustesse</strong>.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"unites-de-mesure\">Unités de mesure</h3>\n\n\n<p>Soyons honnêtes, quels que soient les hébergeurs, c&rsquo;est toujours la guerre des gros chiffres, quand on compare les offres, on jongle entre les Bytes, les Octets et les Bits (C&rsquo;est assez classique sur l&rsquo;affichage de la bande passante). Sur cette publication en français, <strong>je convertis les valeurs en Octets</strong> pour éviter les confusions.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"renouvellement\">Renouvellement</h3>\n\n\n<p>Les tarifs affichés reflètent le coût annuel en cas de renouvellement standard, sans tenir compte des promotions ponctuelles ou des réductions d’entrée. L&rsquo;objectif ici étant d’évaluer le coût réel de l’<strong>hébergement</strong> sur le moyen et long terme, après la première année. En optant pour un engagement pluriannuel (2, 3 ans ou plus), certains hébergeurs proposent des tarifs mensuels réduits, ce qui peut diminuer le coût global sur la durée. Le tarif annuel TTC indiqué, correspond dans cet article à un renouvellement effectué une fois par an.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"consommation-annoncee-efficacite-energetique\">Consommation annoncée / efficacité énergétique</h3>\n\n\n<p>Les hébergeurs web communiquent de plus en plus sur leurs <strong>démarches écologiques</strong>. Entre les promesses de compensation carbone, les datacenters « verts », les labels et touti quanti&#8230; on tombe vite dans le <strong>greenwashing</strong>. Les annonces se concentrent souvent sur l’empreinte carbone, l’utilisation d’énergies renouvelables ou l’optimisation des infrastructures, mais rarement sur l’impact réel d’un hébergement web au quotidien. <strong>Corréler les performances mesurées sur une instance WordPress avec sa consommation en eau et électricité</strong> (bien entendu, non produite par des énergies fossiles) me semble une bonne approche.</p>\n\n\n\n<div class=\"wp-block-group has-border-color has-yellow-border-color has-fg-2-color has-bg-1-background-color has-text-color has-background has-link-color has-small-font-size wp-elements-b292714650cbbe2c27f65af0a6b0ee6b has-global-padding is-layout-constrained wp-container-core-group-is-layout-52009084 wp-block-group-is-layout-constrained\" style=\"border-width:1px;border-radius:2px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><h4 class=\"wp-block-heading has-yellow-color has-text-color has-link-color wp-elements-1b6bd9551751042e5dbe4a9ce2cfa726\" id=\"a-propos-de-la-consommation-annoncee\"><strong>À propos de la consommation annoncée</strong></h4>\n\n\n<p class=\"has-link-color wp-elements-cdee002ef592420c9270a4ab43045d7a\">L&rsquo;hébergement étant mutualisé, les ressources sont partagées entre plusieurs instances. La consommation indiquée correspond à celle de l&rsquo;ensemble du serveur, qu&rsquo;elle soit utilisée seule ou partagée avec d&rsquo;autres comptes. En raison des ressources importantes du serveur, la consommation annuelle annoncée est plus élevée que <a href=\"https://hosterra.eu/fr/store/web-hosting/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"celle des VPS\">celle des VPS</a>. Il revient donc à Hosterra de gérer le nombre de comptes par serveur afin d&rsquo;optimiser l&rsquo;utilisation des ressources tout en maintenant de bonnes performances.</p>\n</div>\n\n\n<h3 class=\"wp-block-heading\" id=\"instance-wordpress-testee\">Instance WordPress testée</h3>\n\n\n<p>Un <strong>site WordPress</strong> sur une formule d&rsquo;hébergement web.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Thème installé actif : <a href=\"https://wordpress.org/themes/generatepress/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"GeneratePress\">GeneratePress</a>.</li>\n\n\n\n<li>Extensions actives : <a href=\"https://wordpress.org/plugins/wpbenchmark/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Hosting Benchmark tool\">Hosting Benchmark tool</a> et <a href=\"https://wordpress.org/plugins/sqlite-object-cache/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"SQLite Object Cache\">SQLite Object Cache</a>.</li>\n\n\n\n<li>Cache objet testé : <a href=\"https://www.php.net/manual/fr/book.apcu.php\" target=\"_blank\" rel=\"noopener nofollow\" title=\"APCu\">APCu</a>.</li>\n\n\n\n<li>PHP : 8.3</li>\n</ul>\n\n\n<h2 class=\"wp-block-heading\" id=\"glossaire\">Glossaire</h2>\n\n\n<p>Petit <strong>glossaire</strong> de base du jargon des <strong>hébergeurs web</strong>.</p>\n\n\n\n<details id=\"glossaire\" class=\"wp-block-details relative has-border-color has-bg-2-border-color has-bg-0-color has-fg-0-background-color has-text-color has-background has-link-color has-medium-font-size wp-elements-6ed834d03b843f14565b81a28df5af88 is-layout-flow wp-container-core-details-is-layout-8a368f38 wp-block-details-is-layout-flow\" style=\"border-width:1px\" open><summary>Consulter le glossaire</summary>\n<div class=\"wp-block-group has-fg-1-color has-bg-1-background-color has-text-color has-background has-link-color has-small-font-size wp-elements-9c7e403135cbcea857d775f42012469b has-global-padding is-layout-constrained wp-container-core-group-is-layout-5bc31a47 wp-block-group-is-layout-constrained\" style=\"border-top-color:var(--wp--preset--color--bg-2);border-top-width:1px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--50)\">\n<ul class=\"wp-block-list\">\n<li><strong>RAM</strong> : Mémoire vive permettant de stocker temporairement les données utilisées par les applications pour un accès rapide.</li>\n\n\n\n<li><strong>CPU</strong> : Unité centrale de traitement, le cerveau du serveur qui exécute les instructions et traite les données.</li>\n\n\n\n<li><strong>vCPU</strong> : CPU virtuel, partie d’un processeur physique allouée à une machine virtuelle pour simuler un processeur dédié.</li>\n\n\n\n<li><strong>NVMe</strong> : Protocole de stockage haute performance pour les disques SSD, optimisé pour réduire la latence et augmenter le débit.</li>\n\n\n\n<li><strong>IO</strong> : Entrées/Sorties (Input/Output), mesure la capacité du serveur à lire/écrire des données sur le disque ou le réseau.</li>\n\n\n\n<li><strong>Bande passante</strong> : Volume maximal de données transférables entre le serveur et les utilisateurs sur une période donnée, souvent exprimé en Gbit/s ou Mo/s.</li>\n\n\n\n<li><strong>Hébergement mutualisé</strong> : Solution où plusieurs sites partagent les ressources d’un même serveur.</li>\n\n\n\n<li><strong>Hébergement VPS</strong> : Serveur privé virtuel offrant des ressources dédiées (CPU, RAM, stockage) au sein d’un serveur physique partagé.</li>\n</ul>\n</div>\n</details>\n\n\n<h2 class=\"wp-block-heading\" id=\"offre-dhebergement-testee\">Offre d&rsquo;hébergement testée</h2>\n\n<h3 class=\"wp-block-heading\" id=\"hosterra-one\">Hosterra One</h3>\n\n<h4 class=\"wp-block-heading\" id=\"informations-sur-loffre\">Informations sur l&rsquo;offre</h4>\n\n\n<ul class=\"wp-block-list\">\n<li>Type d&rsquo;hébergement : Mutualisé</li>\n\n\n\n<li>Tarif au renouvellement annuel (1 mois gratuit inclus) : 75,9€ HT | <strong> 91,08 € TTC</strong></li>\n\n\n\n<li>Consommation annuelle annoncée : <strong>⚡️Électricité &lt; 200 kWh/an</strong>, <strong>🫧Eau &lt; 6.5 l/an</strong></li>\n</ul>\n\n\n<h4 class=\"wp-block-heading\" id=\"ressources-annoncees\">Ressources annoncées</h4>\n\n\n<figure class=\"wp-block-flexible-table-block-table is-scroll-on-pc\"><table class=\"has-fixed-layout is-stacked-on-mobile\"><thead><tr><th>CPU</th><th>Mémoire vive</th><th>Stockage</th><th>Lecture/écriture</th><th>Bande passante</th></tr></thead><tbody><tr><td>8 vCPU</td><td>32 Go RAM</td><td>10 Go sur NVMe</td><td>I/O 256 Mo/s</td><td>125 Mo/s</td></tr></tbody></table></figure>\n\n\n<h4 class=\"wp-block-heading\" id=\"performances-mesurees\">Performances mesurées</h4>\n\n\n<figure class=\"wp-block-flexible-table-block-table is-scroll-on-pc is-scroll-on-mobile\"><table class=\"\"><thead><tr><th>Type</th><th>Fonction</th><th style=\"width:80px\">Score /10</th><th>Temps / Vitesse</th></tr></thead><tbody><tr><td rowspan=\"5\">CPU &amp; Memory</td><td>Operations with large text data</td><td style=\"background-color:#299c29;color:#ffffff\">10</td><td>2.2 sec</td></tr><tr><td>Random binary data operations</td><td style=\"background-color:#7dc516;color:#ffffff\">8.17</td><td>7.2 sec</td></tr><tr><td>Recursive mathematical calculations</td><td style=\"color:#ffffff;background-color:#f88d36\">4.71</td><td>10.9 sec</td></tr><tr><td>Iterative mathematical calculations</td><td style=\"background-color:#299c29;color:#ffffff\">9.34</td><td>1.8 sec</td></tr><tr><td>Floating point operations</td><td style=\"color:#ffffff;background-color:#c3d519\">6.37</td><td>3.6 sec</td></tr><tr><td rowspan=\"3\">Filesystem</td><td>Filesystem write ability</td><td style=\"color:#ffffff;background-color:#81d519\">7.1</td><td>2.9 sec<br>~351 Mo/s</td></tr><tr><td>Local file copy and access speed</td><td style=\"color:#ffffff;background-color:#81d519\">7.79</td><td>2.9 sec<br>~350 Mo/s</td></tr><tr><td>Small file IO test</td><td style=\"color:#ffffff;background-color:#299c29\">9.82</td><td>0.2 sec<br>~473 Mo/s</td></tr><tr><td rowspan=\"3\">Database</td><td>Importing large amount of data to database</td><td style=\"color:#ffffff;background-color:#7dc516\">8.23</td><td>2.4 sec</td></tr><tr><td>Simple queries on single table</td><td style=\"color:#ffffff;background-color:#299c29\">9.54</td><td>0.9 sec</td></tr><tr><td>Complex database queries on multiple tables</td><td style=\"background-color:#81d519;color:#ffffff\">7.59</td><td>3.4 sec</td></tr><tr><td rowspan=\"4\">Object cache</td><td>Persistent object cache enabled</td><td style=\"background-color:#299c29;color:#ffffff\">10</td><td>0 sec</td></tr><tr><td>Persistent object cache write</td><td style=\"color:#ffffff;background-color:#299c29\">10</td><td>0.5 sec</td></tr><tr><td>Persistent object cache read</td><td style=\"background-color:#81d519;color:#ffffff\">7.82</td><td>9.2 sec</td></tr><tr><td>Persistent object cache mixed usage</td><td style=\"color:#ffffff;background-color:#299c29\">10</td><td>1.3 sec</td></tr><tr><td rowspan=\"8\">WordPress core</td><td>Shortcode processing</td><td style=\"color:#ffffff;background-color:#81d519\">7.28</td><td>3.7 sec</td></tr><tr><td>WordPress Hooks</td><td style=\"color:#ffffff;background-color:#7dc516\">8.05</td><td>4.9 sec</td></tr><tr><td>WordPress option manipulation</td><td style=\"color:#ffffff;background-color:#299c29\">9.44</td><td>1.6 sec</td></tr><tr><td>REGEX string processing</td><td style=\"color:#ffffff;background-color:#7dc516\">8.2</td><td>4.6 sec</td></tr><tr><td>Taxonomy benchmark</td><td style=\"color:#ffffff;background-color:#81d519\">7.33</td><td>2.7 sec</td></tr><tr><td>Object capability benchmark</td><td style=\"color:#ffffff;background-color:#81d519\">7.03</td><td>3 sec</td></tr><tr><td>Content filtering</td><td style=\"color:#ffffff;background-color:#c3d519\">6.48</td><td>5 sec</td></tr><tr><td>JSON manipulations</td><td style=\"color:#ffffff;background-color:#7dc516\">8.71</td><td>2.1 sec</td></tr><tr><td>Network</td><td>Network download speed test</td><td style=\"color:#ffffff;background-color:#299c29\">10</td><td>0.9 sec<br>~84 Mo/s</td></tr></tbody><tfoot><tr><td colspan=\"2\">Your server score</td><td colspan=\"2\" style=\"text-align:center;color:#ffffff;background-color:#7dc516\">8.2</td></tr></tfoot></table><figcaption style=\"padding:10px 0;text-align:center\">Tableau des performances mesurées sur l&rsquo;offre <a href=\"https://hosterra.eu/fr/store/shared-hosting/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Hosterra One\">Hosterra One</a> avec un cache objet APCu</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><img width=\"1042\" height=\"1385\" src=\"https://holdmywp.com/wp-content/uploads/2025/11/benchmark-hosterra-one-min.webp\" alt=\"Capture d\'écran du test de mesure de performances sur l\'offre Hosterra One avec un cache objet APCu, le nom de domaine de l\'instance WordPress de test a été masqué.\" class=\"wp-image-6358\" //><figcaption class=\"wp-element-caption\">Capture d&rsquo;écran du test de mesure de performances sur l&rsquo;offre <strong>Hosterra One</strong> avec un cache objet <strong>APCu</strong>, le nom de domaine de l&rsquo;instance WordPress de test a été masqué.</figcaption></figure>\n\n\n<h2 class=\"wp-block-heading\" id=\"bilan-du-test\">Bilan du test</h2>\n\n\n<figure class=\"wp-block-flexible-table-block-table is-scroll-on-pc is-scroll-on-mobile\"><table class=\"is-stacked-on-mobile\"><thead><tr><th>Offre</th><th>Type hébergement</th><th>Tarif annuel TTC</th><th>Consommation annuelle annoncée</th><th>Meilleur Score/10</th></tr></thead><tbody><tr><td>Hosterra One</td><td>Mutualisé</td><td>91,08 € TTC</td><td>⚡️&lt; 200 kWh/an<br>🫧&lt; 6.5 l/an</td><td style=\"background-color:#7dc516;color:#ffffff\">8.2</td></tr></tbody><tfoot><tr><td colspan=\"5\" style=\"text-align:center;font-size:14px\">Source des informations : Fournisseur d&rsquo;hébergement + résultats des tests ci-dessus.<br>Dernière mise à jour : novembre 2025.</td></tr></tfoot></table><figcaption style=\"text-align:center;padding-top:10px;padding-bottom:10px\">Tableau comparatif des offres<br>		d&rsquo;hébergement Hosterra : type d&rsquo;hébergement, Tarif annuel TTC, consommation annuelle annoncée,  Meilleur score obtenu sur 10</figcaption></figure>\n\n\n<h2 class=\"wp-block-heading\" id=\"sources\">Sources</h2>\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://hosterra.eu/fr/store/shared-hosting/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://hosterra.eu/fr/store/shared-hosting/</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/plugins/wpbenchmark/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://wordpress.org/plugins/wpbenchmark/</a></li>\n\n\n\n<li><a href=\"https://wpbenchmark.io/improve-wordpress-speed/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://wpbenchmark.io/improve-wordpress-speed/</a></li>\n\n\n\n<li><a href=\"https://kinsta.com/fr/blog/hebergement-mutualise-vs-hebergement-dedie/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://kinsta.com/fr/blog/hebergement-mutualise-vs-hebergement-dedie/</a></li>\n\n\n\n<li><a href=\"https://datacampus.fr/2023/01/24/technologies-stockage-donnees/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://datacampus.fr/2023/01/24/technologies-stockage-donnees/</a></li>\n</ul>\n\n<p><a href=\"https://holdmywp.com/benchmark-hosterra/\">Source</a></p>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Quentin Le Duff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://holdmywp.com/tag/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"HoldMyWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:9;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://blog.o2switch.fr/ajouter-code-personnalise-wordpress-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Comment ajouter du code personnalisé dans WordPress (sans tout casser) en 2025\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:66:\"https://blog.o2switch.fr/ajouter-code-personnalise-wordpress-2025/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-12T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-12T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:264:\"Vous souhaitez ajouter un bout de code dans votre site WordPress sans risquer la fameuse page blanche ? Découvrez les bonnes pratiques pour personnaliser votre site en toute sécurité, avec les méthodes adaptées en 2025 : thème enfant, snippets et mu-plugins.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:278:\"\n        Vous souhaitez ajouter un bout de code dans votre site WordPress sans risquer la fameuse page blanche ? Découvrez les bonnes pratiques pour personnaliser votre site en toute sécurité, avec les méthodes adaptées en 2025 : thème enfant, snippets et mu-plugins.\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Éric Martin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://blog.o2switch.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"O2switch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:512;s:7:\"headers\";a:11:{s:4:\"date\";s:29:\"Tue, 13 Jan 2026 10:04:06 GMT\";s:12:\"content-type\";s:20:\"application/atom+xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:4:\"link\";s:64:\"<https://fluxplanet.wpfr.net/wp-json/>; rel=\"https://api.w.org/\"\";s:13:\"cache-control\";s:35:\"no-cache, no-store, must-revalidate\";s:6:\"pragma\";s:8:\"no-cache\";s:7:\"expires\";s:1:\"0\";s:13:\"last-modified\";s:29:\"Tue, 22 Jul 2025 21:51:07 GMT\";s:4:\"etag\";s:36:\"W/\"072268436a8b47633210153ceb845bac\"\";s:6:\"server\";s:22:\"o2switch-PowerBoost-v3\";s:16:\"content-encoding\";s:4:\"gzip\";}s:5:\"build\";i:1760643936;s:21:\"cache_expiration_time\";i:1768341847;s:23:\"__cache_expiration_time\";i:1768341847;}", "off");
INSERT INTO `wp_options` VALUES("1907", "_transient_timeout_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "1768341847", "off");
INSERT INTO `wp_options` VALUES("1908", "_transient_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2026/01/10/arret-support-php-version-72-73/\'>Arrêt du support des versions 7.2 et 7.3 de PHP</a></li><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2025/12/02/wordpress-6-9-gene/\'>WordPress 6.9 « Gene »</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://blog.o2switch.fr/probleme-emails-wordpress/\'>E-mails WordPress qui ne partent plus après la mise à jour 6.9 : comment y remédier</a></li><li><a class=\'rsswidget\' href=\'https://whodunit.consulting/tout-savoir-sur-le-bloc-accordeon-de-wordpress-6-9/\'>Tout savoir sur le bloc Accordéon de WordPress 6.9</a></li><li><a class=\'rsswidget\' href=\'https://wpfr.net/journee-de-contribution-du-wordcamp-nice-2026-presentation-des-tables-episode-1/\'>Journée de Contribution Nice 2026 : présentation des tables – épisode n°1 !</a></li></ul></div>", "off");
INSERT INTO `wp_options` VALUES("1909", "_transient_timeout_stellarwp_auth_url_kadence_blocks", "1768386554", "off");
INSERT INTO `wp_options` VALUES("1910", "_transient_stellarwp_auth_url_kadence_blocks", "https://www.kadencewp.com/account-auth/", "off");
INSERT INTO `wp_options` VALUES("1923", "_transient_timeout_gslogo_ncc3xqapu", "1768387252", "off");
INSERT INTO `wp_options` VALUES("1924", "_transient_gslogo_ncc3xqapu", "a:83:{s:5:\"posts\";s:2:\"-1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderby\";s:4:\"date\";s:12:\"filter_order\";s:3:\"ASC\";s:14:\"filter_orderby\";s:4:\"name\";s:10:\"gs_l_title\";s:3:\"off\";s:9:\"title_tag\";s:2:\"h3\";s:15:\"gs_l_link_logos\";s:2:\"on\";s:16:\"include_category\";a:0:{}s:11:\"include_tag\";a:0:{}s:17:\"include_extra_one\";a:0:{}s:17:\"include_extra_two\";a:0:{}s:19:\"include_extra_three\";a:0:{}s:18:\"include_extra_four\";a:0:{}s:18:\"include_extra_five\";a:0:{}s:16:\"exclude_category\";a:0:{}s:11:\"exclude_tag\";a:0:{}s:17:\"exclude_extra_one\";a:0:{}s:17:\"exclude_extra_two\";a:0:{}s:19:\"exclude_extra_three\";a:0:{}s:18:\"exclude_extra_four\";a:0:{}s:18:\"exclude_extra_five\";a:0:{}s:9:\"gs_l_ctrl\";s:3:\"off\";s:13:\"gs_l_ctrl_pos\";s:6:\"bottom\";s:9:\"gs_l_pagi\";s:2:\"on\";s:17:\"gs_l_pagi_dynamic\";s:2:\"on\";s:15:\"gs_l_play_pause\";s:3:\"off\";s:13:\"gs_l_inf_loop\";s:2:\"on\";s:16:\"gs_l_slider_stop\";s:3:\"off\";s:12:\"gs_l_tooltip\";s:3:\"off\";s:22:\"gs_l_tooltip_placement\";s:3:\"top\";s:24:\"gs_l_tooltip_bgcolor_one\";s:7:\"#ff5f6d\";s:24:\"gs_l_tooltip_bgcolor_two\";s:7:\"#ffc371\";s:22:\"gs_l_tooltip_textcolor\";s:4:\"#fff\";s:15:\"gs_l_all_filter\";s:2:\"on\";s:16:\"gs_secondary_img\";s:3:\"off\";s:16:\"gs_l_slide_speed\";s:3:\"500\";s:16:\"gs_l_autop_pause\";s:4:\"3000\";s:10:\"gs_l_theme\";s:7:\"slider1\";s:14:\"filter_enabled\";s:3:\"off\";s:19:\"gs_logo_filter_type\";s:13:\"normal-filter\";s:18:\"gs_logo_pagination\";s:3:\"off\";s:15:\"pagination_type\";s:17:\"normal-pagination\";s:13:\"initial_items\";s:1:\"6\";s:13:\"logo_per_page\";s:1:\"6\";s:14:\"load_per_click\";s:1:\"3\";s:8:\"per_load\";s:1:\"3\";s:16:\"load_button_text\";s:9:\"Load More\";s:24:\"gs_l_s2_border_thickness\";s:2:\"50\";s:22:\"gs_l_s2_gradient_start\";s:7:\"#003729\";s:20:\"gs_l_s2_gradient_end\";s:7:\"#1f9e74\";s:14:\"gs_l_rb_border\";s:17:\"1px,solid,#000000\";s:21:\"gs_l_rb_border_radius\";s:11:\"10,10,10,10\";s:26:\"gs_l_rb_hover_shadow_color\";s:7:\"#1d202f\";s:28:\"gs_l_rb_hover_shadow_control\";s:8:\"6,6,15,0\";s:10:\"image_size\";s:6:\"medium\";s:23:\"custom_image_size_width\";s:0:\"\";s:24:\"custom_image_size_height\";s:0:\"\";s:22:\"custom_image_size_crop\";s:9:\"hard-crop\";s:12:\"gs_l_clkable\";s:6:\"_blank\";s:13:\"gs_l_is_autop\";s:2:\"on\";s:20:\"gs_reverse_direction\";s:3:\"off\";s:12:\"image_filter\";s:4:\"none\";s:18:\"hover_image_filter\";s:4:\"none\";s:10:\"gs_l_align\";s:6:\"center\";s:11:\"gs_l_margin\";s:2:\"10\";s:13:\"gs_l_min_logo\";s:1:\"4\";s:13:\"gs_l_tab_logo\";s:1:\"3\";s:13:\"gs_l_mob_logo\";s:1:\"1\";s:14:\"gs_l_move_logo\";s:1:\"1\";s:19:\"gs_logo_filter_name\";s:3:\"All\";s:20:\"gs_logo_filter_align\";s:6:\"center\";s:8:\"show_cat\";s:3:\"off\";s:17:\"gs_l_show_content\";s:3:\"off\";s:24:\"gs_l_content_limit_count\";s:2:\"80\";s:23:\"gs_l_content_limit_type\";s:5:\"chars\";s:17:\"gs_l_show_excerpt\";s:3:\"off\";s:24:\"gs_l_excerpt_limit_count\";s:2:\"20\";s:23:\"gs_l_excerpt_limit_type\";s:5:\"words\";s:19:\"gs_l_read_more_text\";s:9:\"Read More\";s:17:\"row_heading_image\";s:5:\"Image\";s:16:\"row_heading_name\";s:4:\"Name\";s:16:\"row_heading_desc\";s:11:\"Description\";}", "off");
INSERT INTO `wp_options` VALUES("1927", "_transient_timeout_gslogo_uzhbubb1u", "1768387304", "off");
INSERT INTO `wp_options` VALUES("1928", "_transient_gslogo_uzhbubb1u", "a:83:{s:5:\"posts\";s:2:\"-1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderby\";s:4:\"date\";s:12:\"filter_order\";s:3:\"ASC\";s:14:\"filter_orderby\";s:4:\"name\";s:10:\"gs_l_title\";s:3:\"off\";s:9:\"title_tag\";s:2:\"h3\";s:15:\"gs_l_link_logos\";s:2:\"on\";s:16:\"include_category\";a:0:{}s:11:\"include_tag\";a:0:{}s:17:\"include_extra_one\";a:0:{}s:17:\"include_extra_two\";a:0:{}s:19:\"include_extra_three\";a:0:{}s:18:\"include_extra_four\";a:0:{}s:18:\"include_extra_five\";a:0:{}s:16:\"exclude_category\";a:0:{}s:11:\"exclude_tag\";a:0:{}s:17:\"exclude_extra_one\";a:0:{}s:17:\"exclude_extra_two\";a:0:{}s:19:\"exclude_extra_three\";a:0:{}s:18:\"exclude_extra_four\";a:0:{}s:18:\"exclude_extra_five\";a:0:{}s:9:\"gs_l_ctrl\";s:3:\"off\";s:13:\"gs_l_ctrl_pos\";s:6:\"bottom\";s:9:\"gs_l_pagi\";s:2:\"on\";s:17:\"gs_l_pagi_dynamic\";s:2:\"on\";s:15:\"gs_l_play_pause\";s:3:\"off\";s:13:\"gs_l_inf_loop\";s:2:\"on\";s:16:\"gs_l_slider_stop\";s:3:\"off\";s:12:\"gs_l_tooltip\";s:3:\"off\";s:22:\"gs_l_tooltip_placement\";s:3:\"top\";s:24:\"gs_l_tooltip_bgcolor_one\";s:7:\"#ff5f6d\";s:24:\"gs_l_tooltip_bgcolor_two\";s:7:\"#ffc371\";s:22:\"gs_l_tooltip_textcolor\";s:4:\"#fff\";s:15:\"gs_l_all_filter\";s:2:\"on\";s:16:\"gs_secondary_img\";s:3:\"off\";s:16:\"gs_l_slide_speed\";s:3:\"500\";s:16:\"gs_l_autop_pause\";s:4:\"3000\";s:10:\"gs_l_theme\";s:7:\"slider1\";s:14:\"filter_enabled\";s:3:\"off\";s:19:\"gs_logo_filter_type\";s:13:\"normal-filter\";s:18:\"gs_logo_pagination\";s:3:\"off\";s:15:\"pagination_type\";s:17:\"normal-pagination\";s:13:\"initial_items\";s:1:\"6\";s:13:\"logo_per_page\";s:1:\"6\";s:14:\"load_per_click\";s:1:\"3\";s:8:\"per_load\";s:1:\"3\";s:16:\"load_button_text\";s:9:\"Load More\";s:24:\"gs_l_s2_border_thickness\";s:2:\"50\";s:22:\"gs_l_s2_gradient_start\";s:7:\"#003729\";s:20:\"gs_l_s2_gradient_end\";s:7:\"#1f9e74\";s:14:\"gs_l_rb_border\";s:17:\"1px,solid,#000000\";s:21:\"gs_l_rb_border_radius\";s:11:\"10,10,10,10\";s:26:\"gs_l_rb_hover_shadow_color\";s:7:\"#1d202f\";s:28:\"gs_l_rb_hover_shadow_control\";s:8:\"6,6,15,0\";s:10:\"image_size\";s:6:\"medium\";s:23:\"custom_image_size_width\";s:0:\"\";s:24:\"custom_image_size_height\";s:0:\"\";s:22:\"custom_image_size_crop\";s:9:\"hard-crop\";s:12:\"gs_l_clkable\";s:6:\"_blank\";s:13:\"gs_l_is_autop\";s:2:\"on\";s:20:\"gs_reverse_direction\";s:3:\"off\";s:12:\"image_filter\";s:4:\"none\";s:18:\"hover_image_filter\";s:4:\"none\";s:10:\"gs_l_align\";s:6:\"center\";s:11:\"gs_l_margin\";s:2:\"10\";s:13:\"gs_l_min_logo\";s:1:\"4\";s:13:\"gs_l_tab_logo\";s:1:\"3\";s:13:\"gs_l_mob_logo\";s:1:\"1\";s:14:\"gs_l_move_logo\";s:1:\"1\";s:19:\"gs_logo_filter_name\";s:3:\"All\";s:20:\"gs_logo_filter_align\";s:6:\"center\";s:8:\"show_cat\";s:3:\"off\";s:17:\"gs_l_show_content\";s:3:\"off\";s:24:\"gs_l_content_limit_count\";s:2:\"80\";s:23:\"gs_l_content_limit_type\";s:5:\"chars\";s:17:\"gs_l_show_excerpt\";s:3:\"off\";s:24:\"gs_l_excerpt_limit_count\";s:2:\"20\";s:23:\"gs_l_excerpt_limit_type\";s:5:\"words\";s:19:\"gs_l_read_more_text\";s:9:\"Read More\";s:17:\"row_heading_image\";s:5:\"Image\";s:16:\"row_heading_name\";s:4:\"Name\";s:16:\"row_heading_desc\";s:11:\"Description\";}", "off");
INSERT INTO `wp_options` VALUES("1941", "_transient_timeout_gslogo_jn7piyypu", "1768387377", "off");
INSERT INTO `wp_options` VALUES("1942", "_transient_gslogo_jn7piyypu", "a:83:{s:5:\"posts\";s:2:\"-1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderby\";s:4:\"date\";s:12:\"filter_order\";s:3:\"ASC\";s:14:\"filter_orderby\";s:4:\"name\";s:10:\"gs_l_title\";s:3:\"off\";s:9:\"title_tag\";s:2:\"h3\";s:15:\"gs_l_link_logos\";s:2:\"on\";s:16:\"include_category\";a:0:{}s:11:\"include_tag\";a:0:{}s:17:\"include_extra_one\";a:0:{}s:17:\"include_extra_two\";a:0:{}s:19:\"include_extra_three\";a:0:{}s:18:\"include_extra_four\";a:0:{}s:18:\"include_extra_five\";a:0:{}s:16:\"exclude_category\";a:0:{}s:11:\"exclude_tag\";a:0:{}s:17:\"exclude_extra_one\";a:0:{}s:17:\"exclude_extra_two\";a:0:{}s:19:\"exclude_extra_three\";a:0:{}s:18:\"exclude_extra_four\";a:0:{}s:18:\"exclude_extra_five\";a:0:{}s:9:\"gs_l_ctrl\";s:3:\"off\";s:13:\"gs_l_ctrl_pos\";s:6:\"bottom\";s:9:\"gs_l_pagi\";s:2:\"on\";s:17:\"gs_l_pagi_dynamic\";s:2:\"on\";s:15:\"gs_l_play_pause\";s:3:\"off\";s:13:\"gs_l_inf_loop\";s:2:\"on\";s:16:\"gs_l_slider_stop\";s:3:\"off\";s:12:\"gs_l_tooltip\";s:3:\"off\";s:22:\"gs_l_tooltip_placement\";s:3:\"top\";s:24:\"gs_l_tooltip_bgcolor_one\";s:7:\"#ff5f6d\";s:24:\"gs_l_tooltip_bgcolor_two\";s:7:\"#ffc371\";s:22:\"gs_l_tooltip_textcolor\";s:4:\"#fff\";s:15:\"gs_l_all_filter\";s:2:\"on\";s:16:\"gs_secondary_img\";s:3:\"off\";s:16:\"gs_l_slide_speed\";s:3:\"500\";s:16:\"gs_l_autop_pause\";s:4:\"3000\";s:10:\"gs_l_theme\";s:7:\"slider1\";s:14:\"filter_enabled\";s:3:\"off\";s:19:\"gs_logo_filter_type\";s:13:\"normal-filter\";s:18:\"gs_logo_pagination\";s:3:\"off\";s:15:\"pagination_type\";s:17:\"normal-pagination\";s:13:\"initial_items\";s:1:\"6\";s:13:\"logo_per_page\";s:1:\"6\";s:14:\"load_per_click\";s:1:\"3\";s:8:\"per_load\";s:1:\"3\";s:16:\"load_button_text\";s:9:\"Load More\";s:24:\"gs_l_s2_border_thickness\";s:2:\"50\";s:22:\"gs_l_s2_gradient_start\";s:7:\"#003729\";s:20:\"gs_l_s2_gradient_end\";s:7:\"#1f9e74\";s:14:\"gs_l_rb_border\";s:17:\"1px,solid,#000000\";s:21:\"gs_l_rb_border_radius\";s:11:\"10,10,10,10\";s:26:\"gs_l_rb_hover_shadow_color\";s:7:\"#1d202f\";s:28:\"gs_l_rb_hover_shadow_control\";s:8:\"6,6,15,0\";s:10:\"image_size\";s:6:\"medium\";s:23:\"custom_image_size_width\";s:0:\"\";s:24:\"custom_image_size_height\";s:0:\"\";s:22:\"custom_image_size_crop\";s:9:\"hard-crop\";s:12:\"gs_l_clkable\";s:6:\"_blank\";s:13:\"gs_l_is_autop\";s:2:\"on\";s:20:\"gs_reverse_direction\";s:3:\"off\";s:12:\"image_filter\";s:4:\"none\";s:18:\"hover_image_filter\";s:4:\"none\";s:10:\"gs_l_align\";s:6:\"center\";s:11:\"gs_l_margin\";s:2:\"10\";s:13:\"gs_l_min_logo\";s:1:\"1\";s:13:\"gs_l_tab_logo\";s:1:\"1\";s:13:\"gs_l_mob_logo\";s:1:\"1\";s:14:\"gs_l_move_logo\";s:1:\"1\";s:19:\"gs_logo_filter_name\";s:3:\"All\";s:20:\"gs_logo_filter_align\";s:6:\"center\";s:8:\"show_cat\";s:3:\"off\";s:17:\"gs_l_show_content\";s:3:\"off\";s:24:\"gs_l_content_limit_count\";s:2:\"80\";s:23:\"gs_l_content_limit_type\";s:5:\"chars\";s:17:\"gs_l_show_excerpt\";s:3:\"off\";s:24:\"gs_l_excerpt_limit_count\";s:2:\"20\";s:23:\"gs_l_excerpt_limit_type\";s:5:\"words\";s:19:\"gs_l_read_more_text\";s:9:\"Read More\";s:17:\"row_heading_image\";s:5:\"Image\";s:16:\"row_heading_name\";s:4:\"Name\";s:16:\"row_heading_desc\";s:11:\"Description\";}", "off");
INSERT INTO `wp_options` VALUES("1959", "_transient_timeout_gslogo_oaubau0gq", "1768387484", "off");
INSERT INTO `wp_options` VALUES("1960", "_transient_gslogo_oaubau0gq", "a:83:{s:5:\"posts\";s:2:\"-1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderby\";s:4:\"date\";s:12:\"filter_order\";s:3:\"ASC\";s:14:\"filter_orderby\";s:4:\"name\";s:10:\"gs_l_title\";s:3:\"off\";s:9:\"title_tag\";s:2:\"h3\";s:15:\"gs_l_link_logos\";s:2:\"on\";s:16:\"include_category\";a:0:{}s:11:\"include_tag\";a:0:{}s:17:\"include_extra_one\";a:0:{}s:17:\"include_extra_two\";a:0:{}s:19:\"include_extra_three\";a:0:{}s:18:\"include_extra_four\";a:0:{}s:18:\"include_extra_five\";a:0:{}s:16:\"exclude_category\";a:0:{}s:11:\"exclude_tag\";a:0:{}s:17:\"exclude_extra_one\";a:0:{}s:17:\"exclude_extra_two\";a:0:{}s:19:\"exclude_extra_three\";a:0:{}s:18:\"exclude_extra_four\";a:0:{}s:18:\"exclude_extra_five\";a:0:{}s:9:\"gs_l_ctrl\";s:3:\"off\";s:13:\"gs_l_ctrl_pos\";s:6:\"bottom\";s:9:\"gs_l_pagi\";s:2:\"on\";s:17:\"gs_l_pagi_dynamic\";s:2:\"on\";s:15:\"gs_l_play_pause\";s:3:\"off\";s:13:\"gs_l_inf_loop\";s:2:\"on\";s:16:\"gs_l_slider_stop\";s:3:\"off\";s:12:\"gs_l_tooltip\";s:3:\"off\";s:22:\"gs_l_tooltip_placement\";s:3:\"top\";s:24:\"gs_l_tooltip_bgcolor_one\";s:7:\"#ff5f6d\";s:24:\"gs_l_tooltip_bgcolor_two\";s:7:\"#ffc371\";s:22:\"gs_l_tooltip_textcolor\";s:4:\"#fff\";s:15:\"gs_l_all_filter\";s:2:\"on\";s:16:\"gs_secondary_img\";s:3:\"off\";s:16:\"gs_l_slide_speed\";s:3:\"500\";s:16:\"gs_l_autop_pause\";s:4:\"3000\";s:10:\"gs_l_theme\";s:7:\"slider1\";s:14:\"filter_enabled\";s:3:\"off\";s:19:\"gs_logo_filter_type\";s:13:\"normal-filter\";s:18:\"gs_logo_pagination\";s:3:\"off\";s:15:\"pagination_type\";s:17:\"normal-pagination\";s:13:\"initial_items\";s:1:\"6\";s:13:\"logo_per_page\";s:1:\"6\";s:14:\"load_per_click\";s:1:\"3\";s:8:\"per_load\";s:1:\"3\";s:16:\"load_button_text\";s:9:\"Load More\";s:24:\"gs_l_s2_border_thickness\";s:2:\"50\";s:22:\"gs_l_s2_gradient_start\";s:7:\"#003729\";s:20:\"gs_l_s2_gradient_end\";s:7:\"#1f9e74\";s:14:\"gs_l_rb_border\";s:17:\"1px,solid,#000000\";s:21:\"gs_l_rb_border_radius\";s:11:\"10,10,10,10\";s:26:\"gs_l_rb_hover_shadow_color\";s:7:\"#1d202f\";s:28:\"gs_l_rb_hover_shadow_control\";s:8:\"6,6,15,0\";s:10:\"image_size\";s:6:\"medium\";s:23:\"custom_image_size_width\";s:0:\"\";s:24:\"custom_image_size_height\";s:0:\"\";s:22:\"custom_image_size_crop\";s:9:\"hard-crop\";s:12:\"gs_l_clkable\";s:6:\"_blank\";s:13:\"gs_l_is_autop\";s:2:\"on\";s:20:\"gs_reverse_direction\";s:3:\"off\";s:12:\"image_filter\";s:4:\"none\";s:18:\"hover_image_filter\";s:4:\"none\";s:10:\"gs_l_align\";s:6:\"center\";s:11:\"gs_l_margin\";s:2:\"30\";s:13:\"gs_l_min_logo\";s:1:\"1\";s:13:\"gs_l_tab_logo\";s:1:\"1\";s:13:\"gs_l_mob_logo\";s:1:\"1\";s:14:\"gs_l_move_logo\";s:1:\"1\";s:19:\"gs_logo_filter_name\";s:3:\"All\";s:20:\"gs_logo_filter_align\";s:6:\"center\";s:8:\"show_cat\";s:3:\"off\";s:17:\"gs_l_show_content\";s:3:\"off\";s:24:\"gs_l_content_limit_count\";s:2:\"80\";s:23:\"gs_l_content_limit_type\";s:5:\"chars\";s:17:\"gs_l_show_excerpt\";s:3:\"off\";s:24:\"gs_l_excerpt_limit_count\";s:2:\"20\";s:23:\"gs_l_excerpt_limit_type\";s:5:\"words\";s:19:\"gs_l_read_more_text\";s:9:\"Read More\";s:17:\"row_heading_image\";s:5:\"Image\";s:16:\"row_heading_name\";s:4:\"Name\";s:16:\"row_heading_desc\";s:11:\"Description\";}", "off");
INSERT INTO `wp_options` VALUES("1966", "_transient_timeout_gslogo_tu5s78o6f", "1768387914", "off");
INSERT INTO `wp_options` VALUES("1967", "_transient_gslogo_tu5s78o6f", "a:83:{s:5:\"posts\";s:2:\"-1\";s:5:\"order\";s:4:\"DESC\";s:7:\"orderby\";s:4:\"date\";s:12:\"filter_order\";s:3:\"ASC\";s:14:\"filter_orderby\";s:4:\"name\";s:10:\"gs_l_title\";s:3:\"off\";s:9:\"title_tag\";s:2:\"h3\";s:15:\"gs_l_link_logos\";s:2:\"on\";s:16:\"include_category\";a:0:{}s:11:\"include_tag\";a:0:{}s:17:\"include_extra_one\";a:0:{}s:17:\"include_extra_two\";a:0:{}s:19:\"include_extra_three\";a:0:{}s:18:\"include_extra_four\";a:0:{}s:18:\"include_extra_five\";a:0:{}s:16:\"exclude_category\";a:0:{}s:11:\"exclude_tag\";a:0:{}s:17:\"exclude_extra_one\";a:0:{}s:17:\"exclude_extra_two\";a:0:{}s:19:\"exclude_extra_three\";a:0:{}s:18:\"exclude_extra_four\";a:0:{}s:18:\"exclude_extra_five\";a:0:{}s:9:\"gs_l_ctrl\";s:3:\"off\";s:13:\"gs_l_ctrl_pos\";s:6:\"bottom\";s:9:\"gs_l_pagi\";s:2:\"on\";s:17:\"gs_l_pagi_dynamic\";s:2:\"on\";s:15:\"gs_l_play_pause\";s:3:\"off\";s:13:\"gs_l_inf_loop\";s:2:\"on\";s:16:\"gs_l_slider_stop\";s:3:\"off\";s:12:\"gs_l_tooltip\";s:3:\"off\";s:22:\"gs_l_tooltip_placement\";s:3:\"top\";s:24:\"gs_l_tooltip_bgcolor_one\";s:7:\"#ff5f6d\";s:24:\"gs_l_tooltip_bgcolor_two\";s:7:\"#ffc371\";s:22:\"gs_l_tooltip_textcolor\";s:4:\"#fff\";s:15:\"gs_l_all_filter\";s:2:\"on\";s:16:\"gs_secondary_img\";s:3:\"off\";s:16:\"gs_l_slide_speed\";s:3:\"500\";s:16:\"gs_l_autop_pause\";s:4:\"3000\";s:10:\"gs_l_theme\";s:7:\"slider1\";s:14:\"filter_enabled\";s:3:\"off\";s:19:\"gs_logo_filter_type\";s:13:\"normal-filter\";s:18:\"gs_logo_pagination\";s:3:\"off\";s:15:\"pagination_type\";s:17:\"normal-pagination\";s:13:\"initial_items\";s:1:\"6\";s:13:\"logo_per_page\";s:1:\"6\";s:14:\"load_per_click\";s:1:\"3\";s:8:\"per_load\";s:1:\"3\";s:16:\"load_button_text\";s:9:\"Load More\";s:24:\"gs_l_s2_border_thickness\";s:2:\"50\";s:22:\"gs_l_s2_gradient_start\";s:7:\"#003729\";s:20:\"gs_l_s2_gradient_end\";s:7:\"#1f9e74\";s:14:\"gs_l_rb_border\";s:17:\"1px,solid,#000000\";s:21:\"gs_l_rb_border_radius\";s:11:\"10,10,10,10\";s:26:\"gs_l_rb_hover_shadow_color\";s:7:\"#1d202f\";s:28:\"gs_l_rb_hover_shadow_control\";s:8:\"6,6,15,0\";s:10:\"image_size\";s:6:\"medium\";s:23:\"custom_image_size_width\";s:0:\"\";s:24:\"custom_image_size_height\";s:0:\"\";s:22:\"custom_image_size_crop\";s:9:\"hard-crop\";s:12:\"gs_l_clkable\";s:6:\"_blank\";s:13:\"gs_l_is_autop\";s:2:\"on\";s:20:\"gs_reverse_direction\";s:3:\"off\";s:12:\"image_filter\";s:4:\"none\";s:18:\"hover_image_filter\";s:4:\"none\";s:10:\"gs_l_align\";s:6:\"center\";s:11:\"gs_l_margin\";s:2:\"10\";s:13:\"gs_l_min_logo\";s:1:\"4\";s:13:\"gs_l_tab_logo\";s:1:\"3\";s:13:\"gs_l_mob_logo\";s:1:\"2\";s:14:\"gs_l_move_logo\";s:1:\"1\";s:19:\"gs_logo_filter_name\";s:3:\"All\";s:20:\"gs_logo_filter_align\";s:6:\"center\";s:8:\"show_cat\";s:3:\"off\";s:17:\"gs_l_show_content\";s:3:\"off\";s:24:\"gs_l_content_limit_count\";s:2:\"80\";s:23:\"gs_l_content_limit_type\";s:5:\"chars\";s:17:\"gs_l_show_excerpt\";s:3:\"off\";s:24:\"gs_l_excerpt_limit_count\";s:2:\"20\";s:23:\"gs_l_excerpt_limit_type\";s:5:\"words\";s:19:\"gs_l_read_more_text\";s:9:\"Read More\";s:17:\"row_heading_image\";s:5:\"Image\";s:16:\"row_heading_name\";s:4:\"Name\";s:16:\"row_heading_desc\";s:11:\"Description\";}", "off");
INSERT INTO `wp_options` VALUES("1987", "_site_transient_timeout_wp_font_collection_url_https://s.w.org/images/fonts/wp-6.9/collections/google-fonts-with-preview.json", "1768400447", "off");
INSERT INTO `wp_options` VALUES("1988", "_site_transient_wp_font_collection_url_https://s.w.org/images/fonts/wp-6.9/collections/google-fonts-with-preview.json", "a:1:{s:13:\"font_families\";a:1896:{i:0;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"ABeeZee\";s:10:\"fontFamily\";s:19:\"ABeeZee, sans-serif\";s:4:\"slug\";s:7:\"abeezee\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/abeezee/v23/esDR31xSG-6AGleN6teukbcHCpE.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"ABeeZee\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/abeezee/abeezee-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:76:\"https://fonts.gstatic.com/s/abeezee/v23/esDT31xSG-6AGleN2tCkkJUCGpG-GQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"ABeeZee\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/abeezee/abeezee-400-italic.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/abeezee/abeezee.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:1;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:13:\"ADLaM Display\";s:10:\"fontFamily\";s:26:\"\"ADLaM Display\", system-ui\";s:4:\"slug\";s:13:\"adlam-display\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/adlamdisplay/v1/KFOhCnGXkPOLlhx6jD8_b1ZECsTYkYBPY3o.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"ADLaM Display\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/adlam-display/adlam-display-400-normal.svg\";}}s:7:\"preview\";s:76:\"https://s.w.org/images/fonts/wp-6.9/previews/adlam-display/adlam-display.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:2;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:11:\"AR One Sans\";s:10:\"fontFamily\";s:25:\"\"AR One Sans\", sans-serif\";s:4:\"slug\";s:11:\"ar-one-sans\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/aronesans/v6/TUZezwhrmbFp0Srr_tH6fv6RcUejHO_u7GF5aXfv-U2QzBLF6gslWn_9DWg3no5mBF4.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"AR One Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/ar-one-sans/ar-one-sans-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/aronesans/v6/TUZezwhrmbFp0Srr_tH6fv6RcUejHO_u7GF5aXfv-U2QzBLF6gslWk39DWg3no5mBF4.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"AR One Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/ar-one-sans/ar-one-sans-500-normal.svg\";}i:2;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/aronesans/v6/TUZezwhrmbFp0Srr_tH6fv6RcUejHO_u7GF5aXfv-U2QzBLF6gslWqH6DWg3no5mBF4.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"AR One Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/ar-one-sans/ar-one-sans-600-normal.svg\";}i:3;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/aronesans/v6/TUZezwhrmbFp0Srr_tH6fv6RcUejHO_u7GF5aXfv-U2QzBLF6gslWpj6DWg3no5mBF4.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"AR One Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/ar-one-sans/ar-one-sans-700-normal.svg\";}}s:7:\"preview\";s:72:\"https://s.w.org/images/fonts/wp-6.9/previews/ar-one-sans/ar-one-sans.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:3;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:4:\"Abel\";s:10:\"fontFamily\";s:16:\"Abel, sans-serif\";s:4:\"slug\";s:4:\"abel\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:66:\"https://fonts.gstatic.com/s/abel/v18/MwQ5bhbm2POE6V1LPJp6qGI.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Abel\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/abel/abel-400-normal.svg\";}}s:7:\"preview\";s:58:\"https://s.w.org/images/fonts/wp-6.9/previews/abel/abel.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:4;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:12:\"Abhaya Libre\";s:10:\"fontFamily\";s:21:\"\"Abhaya Libre\", serif\";s:4:\"slug\";s:12:\"abhaya-libre\";s:8:\"fontFace\";a:5:{i:0;a:5:{s:3:\"src\";s:84:\"https://fonts.gstatic.com/s/abhayalibre/v18/e3tmeuGtX-Co5MNzeAOqinEgfkPWovdU4w.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Abhaya Libre\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/abhaya-libre/abhaya-libre-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/abhayalibre/v18/e3t5euGtX-Co5MNzeAOqinEYj2ryr9xI6oYtBA.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Abhaya Libre\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/abhaya-libre/abhaya-libre-500-normal.svg\";}i:2;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/abhayalibre/v18/e3t5euGtX-Co5MNzeAOqinEYo23yr9xI6oYtBA.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Abhaya Libre\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/abhaya-libre/abhaya-libre-600-normal.svg\";}i:3;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/abhayalibre/v18/e3t5euGtX-Co5MNzeAOqinEYx2zyr9xI6oYtBA.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Abhaya Libre\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/abhaya-libre/abhaya-libre-700-normal.svg\";}i:4;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/abhayalibre/v18/e3t5euGtX-Co5MNzeAOqinEY22_yr9xI6oYtBA.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Abhaya Libre\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/abhaya-libre/abhaya-libre-800-normal.svg\";}}s:7:\"preview\";s:74:\"https://s.w.org/images/fonts/wp-6.9/previews/abhaya-libre/abhaya-libre.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:5;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Aboreto\";s:10:\"fontFamily\";s:18:\"Aboreto, system-ui\";s:4:\"slug\";s:7:\"aboreto\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:72:\"https://fonts.gstatic.com/s/aboreto/v2/5DCXAKLhwDDQ4N8blKHeA2yuxSY.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Aboreto\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/aboreto/aboreto-400-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/aboreto/aboreto.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:6;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:13:\"Abril Fatface\";s:10:\"fontFamily\";s:26:\"\"Abril Fatface\", system-ui\";s:4:\"slug\";s:13:\"abril-fatface\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/abrilfatface/v25/zOL64pLDlL1D99S8g8PtiKchm-VsjOLhZBY.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Abril Fatface\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/abril-fatface/abril-fatface-400-normal.svg\";}}s:7:\"preview\";s:76:\"https://s.w.org/images/fonts/wp-6.9/previews/abril-fatface/abril-fatface.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:7;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:14:\"Abyssinica SIL\";s:10:\"fontFamily\";s:23:\"\"Abyssinica SIL\", serif\";s:4:\"slug\";s:14:\"abyssinica-sil\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:87:\"https://fonts.gstatic.com/s/abyssinicasil/v9/oY1H8ezOqK7iI3rK_45WKoc8J6UcBFOVAXuI.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Abyssinica SIL\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/abyssinica-sil/abyssinica-sil-400-normal.svg\";}}s:7:\"preview\";s:78:\"https://s.w.org/images/fonts/wp-6.9/previews/abyssinica-sil/abyssinica-sil.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:8;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:8:\"Aclonica\";s:10:\"fontFamily\";s:20:\"Aclonica, sans-serif\";s:4:\"slug\";s:8:\"aclonica\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:75:\"https://fonts.gstatic.com/s/aclonica/v25/K2FyfZJVlfNNSEBXGb7WCI6oBjLz.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Aclonica\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/aclonica/aclonica-400-normal.svg\";}}s:7:\"preview\";s:66:\"https://s.w.org/images/fonts/wp-6.9/previews/aclonica/aclonica.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:9;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:4:\"Acme\";s:10:\"fontFamily\";s:16:\"Acme, sans-serif\";s:4:\"slug\";s:4:\"acme\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:66:\"https://fonts.gstatic.com/s/acme/v27/RrQfboBx-C5_bxjLb23lzLk.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Acme\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/acme/acme-400-normal.svg\";}}s:7:\"preview\";s:58:\"https://s.w.org/images/fonts/wp-6.9/previews/acme/acme.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:10;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:5:\"Actor\";s:10:\"fontFamily\";s:17:\"Actor, sans-serif\";s:4:\"slug\";s:5:\"actor\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:68:\"https://fonts.gstatic.com/s/actor/v18/wEOzEBbCkc5cO3ehXygtUMIO.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Actor\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/actor/actor-400-normal.svg\";}}s:7:\"preview\";s:60:\"https://s.w.org/images/fonts/wp-6.9/previews/actor/actor.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:11;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Adamina\";s:10:\"fontFamily\";s:14:\"Adamina, serif\";s:4:\"slug\";s:7:\"adamina\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/adamina/v22/j8_r6-DH1bjoc-dwu-_eETl4Bno.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Adamina\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/adamina/adamina-400-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/adamina/adamina.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:12;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:10:\"Advent Pro\";s:10:\"fontFamily\";s:24:\"\"Advent Pro\", sans-serif\";s:4:\"slug\";s:10:\"advent-pro\";s:8:\"fontFace\";a:18:{i:0;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/adventpro/v33/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLQyJPSZoonw1aBA.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/adventpro/v33/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLwyNPSZoonw1aBA.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/adventpro/v33/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLHSNPSZoonw1aBA.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/adventpro/v33/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLQyNPSZoonw1aBA.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/adventpro/v33/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLcSNPSZoonw1aBA.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/adventpro/v33/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLnSRPSZoonw1aBA.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/adventpro/v33/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLpCRPSZoonw1aBA.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/adventpro/v33/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpLwyRPSZoonw1aBA.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-800-normal.svg\";}i:8;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/adventpro/v33/V8mqoQfxVT4Dvddr_yOwrzaFxV7JtdQgFqXdUAQrGp_zgX5sWCpL6iRPSZoonw1aBA.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-900-normal.svg\";}i:9;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/adventpro/v33/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2CnDpApvQhKBH4C.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-100-italic.svg\";}i:10;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/adventpro/v33/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2AnD5ApvQhKBH4C.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-200-italic.svg\";}i:11;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/adventpro/v33/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2D5D5ApvQhKBH4C.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-300-italic.svg\";}i:12;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/adventpro/v33/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2CnD5ApvQhKBH4C.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-400-italic.svg\";}i:13;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/adventpro/v33/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2CVD5ApvQhKBH4C.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-500-italic.svg\";}i:14;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/adventpro/v33/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2B5CJApvQhKBH4C.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-600-italic.svg\";}i:15;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/adventpro/v33/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2BACJApvQhKBH4C.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-700-italic.svg\";}i:16;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/adventpro/v33/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2AnCJApvQhKBH4C.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-800-italic.svg\";}i:17;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/adventpro/v33/V8mkoQfxVT4Dvddr_yOwhT-3Jr6w5kKOEbAVEvZiKGAr6BX29i1ei2AOCJApvQhKBH4C.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Advent Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro-900-italic.svg\";}}s:7:\"preview\";s:70:\"https://s.w.org/images/fonts/wp-6.9/previews/advent-pro/advent-pro.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:13;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:6:\"Afacad\";s:10:\"fontFamily\";s:18:\"Afacad, sans-serif\";s:4:\"slug\";s:6:\"afacad\";s:8:\"fontFace\";a:8:{i:0;a:5:{s:3:\"src\";s:87:\"https://fonts.gstatic.com/s/afacad/v3/6NUK8FKMIQOGaw6wjYT7ZHG_zsBBfhXtWmU08mCgdfM.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Afacad\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad/afacad-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:87:\"https://fonts.gstatic.com/s/afacad/v3/6NUK8FKMIQOGaw6wjYT7ZHG_zsBBfiftWmU08mCgdfM.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Afacad\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad/afacad-500-normal.svg\";}i:2;a:5:{s:3:\"src\";s:87:\"https://fonts.gstatic.com/s/afacad/v3/6NUK8FKMIQOGaw6wjYT7ZHG_zsBBfsvqWmU08mCgdfM.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Afacad\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad/afacad-600-normal.svg\";}i:3;a:5:{s:3:\"src\";s:87:\"https://fonts.gstatic.com/s/afacad/v3/6NUK8FKMIQOGaw6wjYT7ZHG_zsBBfvLqWmU08mCgdfM.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Afacad\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad/afacad-700-normal.svg\";}i:4;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/afacad/v3/6NUI8FKMIQOGaw6ahLYEvBjUVG5Ga92usiM-80KlZfNfuw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:6:\"Afacad\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad/afacad-400-italic.svg\";}i:5;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/afacad/v3/6NUI8FKMIQOGaw6ahLYEvBjUVG5Ga92ugCM-80KlZfNfuw.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:6:\"Afacad\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad/afacad-500-italic.svg\";}i:6;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/afacad/v3/6NUI8FKMIQOGaw6ahLYEvBjUVG5Ga92ubCQ-80KlZfNfuw.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:6:\"Afacad\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad/afacad-600-italic.svg\";}i:7;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/afacad/v3/6NUI8FKMIQOGaw6ahLYEvBjUVG5Ga92uVSQ-80KlZfNfuw.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:6:\"Afacad\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad/afacad-700-italic.svg\";}}s:7:\"preview\";s:62:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad/afacad.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:14;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:11:\"Afacad Flux\";s:10:\"fontFamily\";s:25:\"\"Afacad Flux\", sans-serif\";s:4:\"slug\";s:11:\"afacad-flux\";s:8:\"fontFace\";a:9:{i:0;a:5:{s:3:\"src\";s:115:\"https://fonts.gstatic.com/s/afacadflux/v4/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edsUwWZaFqQsJr67E.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Afacad Flux\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad-flux/afacad-flux-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:115:\"https://fonts.gstatic.com/s/afacadflux/v4/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edscwXZaFqQsJr67E.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Afacad Flux\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad-flux/afacad-flux-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:115:\"https://fonts.gstatic.com/s/afacadflux/v4/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edsRIXZaFqQsJr67E.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Afacad Flux\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad-flux/afacad-flux-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:115:\"https://fonts.gstatic.com/s/afacadflux/v4/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edsUwXZaFqQsJr67E.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Afacad Flux\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad-flux/afacad-flux-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:115:\"https://fonts.gstatic.com/s/afacadflux/v4/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edsX4XZaFqQsJr67E.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Afacad Flux\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad-flux/afacad-flux-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:115:\"https://fonts.gstatic.com/s/afacadflux/v4/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edsZIQZaFqQsJr67E.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Afacad Flux\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad-flux/afacad-flux-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:115:\"https://fonts.gstatic.com/s/afacadflux/v4/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edsasQZaFqQsJr67E.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Afacad Flux\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad-flux/afacad-flux-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:115:\"https://fonts.gstatic.com/s/afacadflux/v4/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edscwQZaFqQsJr67E.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Afacad Flux\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad-flux/afacad-flux-800-normal.svg\";}i:8;a:5:{s:3:\"src\";s:115:\"https://fonts.gstatic.com/s/afacadflux/v4/9oRgNYYQryMlneUPykRmTuH4ET0fri4I5rJVT_CWHKDZnskVK5edseUQZaFqQsJr67E.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Afacad Flux\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad-flux/afacad-flux-900-normal.svg\";}}s:7:\"preview\";s:72:\"https://s.w.org/images/fonts/wp-6.9/previews/afacad-flux/afacad-flux.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:15;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:8:\"Agbalumo\";s:10:\"fontFamily\";s:19:\"Agbalumo, system-ui\";s:4:\"slug\";s:8:\"agbalumo\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:74:\"https://fonts.gstatic.com/s/agbalumo/v6/55xvey5uMdT2N37KZcMAirl08KDJ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Agbalumo\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/agbalumo/agbalumo-400-normal.svg\";}}s:7:\"preview\";s:66:\"https://s.w.org/images/fonts/wp-6.9/previews/agbalumo/agbalumo.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:16;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:8:\"Agdasima\";s:10:\"fontFamily\";s:20:\"Agdasima, sans-serif\";s:4:\"slug\";s:8:\"agdasima\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:74:\"https://fonts.gstatic.com/s/agdasima/v5/PN_zRfyxp2f1fUCgAMg_rzjb_-Da.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Agdasima\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/agdasima/agdasima-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:78:\"https://fonts.gstatic.com/s/agdasima/v5/PN_0Rfyxp2f1fUCgAPCGgBzW1PzTz2Mi.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Agdasima\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/agdasima/agdasima-700-normal.svg\";}}s:7:\"preview\";s:66:\"https://s.w.org/images/fonts/wp-6.9/previews/agdasima/agdasima.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:17;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:11:\"Agu Display\";s:10:\"fontFamily\";s:24:\"\"Agu Display\", system-ui\";s:4:\"slug\";s:11:\"agu-display\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:98:\"https://fonts.gstatic.com/s/agudisplay/v3/iJWXBXKbbi6BeMC1_RX7qF_V5E7aciGRRWUwX4ftlK9LM6y8Zg.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Agu Display\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/agu-display/agu-display-400-normal.svg\";}}s:7:\"preview\";s:72:\"https://s.w.org/images/fonts/wp-6.9/previews/agu-display/agu-display.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:18;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:15:\"Aguafina Script\";s:10:\"fontFamily\";s:26:\"\"Aguafina Script\", cursive\";s:4:\"slug\";s:15:\"aguafina-script\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:91:\"https://fonts.gstatic.com/s/aguafinascript/v24/If2QXTv_ZzSxGIO30LemWEOmt1bHr84pgicOrg.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:15:\"Aguafina Script\";s:7:\"preview\";s:91:\"https://s.w.org/images/fonts/wp-6.9/previews/aguafina-script/aguafina-script-400-normal.svg\";}}s:7:\"preview\";s:80:\"https://s.w.org/images/fonts/wp-6.9/previews/aguafina-script/aguafina-script.svg\";}s:10:\"categories\";a:1:{i:0;s:11:\"handwriting\";}}i:19;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:6:\"Akatab\";s:10:\"fontFamily\";s:18:\"Akatab, sans-serif\";s:4:\"slug\";s:6:\"akatab\";s:8:\"fontFace\";a:6:{i:0;a:5:{s:3:\"src\";s:70:\"https://fonts.gstatic.com/s/akatab/v9/VuJwdNrK3Z7gqJEPXYz5NIh-YA.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Akatab\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/akatab/akatab-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:74:\"https://fonts.gstatic.com/s/akatab/v9/VuJzdNrK3Z7gqJE3rKXdOaNiaRpFvg.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Akatab\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/akatab/akatab-500-normal.svg\";}i:2;a:5:{s:3:\"src\";s:74:\"https://fonts.gstatic.com/s/akatab/v9/VuJzdNrK3Z7gqJE3gKLdOaNiaRpFvg.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Akatab\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/akatab/akatab-600-normal.svg\";}i:3;a:5:{s:3:\"src\";s:74:\"https://fonts.gstatic.com/s/akatab/v9/VuJzdNrK3Z7gqJE35KPdOaNiaRpFvg.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Akatab\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/akatab/akatab-700-normal.svg\";}i:4;a:5:{s:3:\"src\";s:74:\"https://fonts.gstatic.com/s/akatab/v9/VuJzdNrK3Z7gqJE3-KDdOaNiaRpFvg.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Akatab\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/akatab/akatab-800-normal.svg\";}i:5;a:5:{s:3:\"src\";s:74:\"https://fonts.gstatic.com/s/akatab/v9/VuJzdNrK3Z7gqJE33KHdOaNiaRpFvg.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Akatab\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/akatab/akatab-900-normal.svg\";}}s:7:\"preview\";s:62:\"https://s.w.org/images/fonts/wp-6.9/previews/akatab/akatab.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:20;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:14:\"Akaya Kanadaka\";s:10:\"fontFamily\";s:27:\"\"Akaya Kanadaka\", system-ui\";s:4:\"slug\";s:14:\"akaya-kanadaka\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/akayakanadaka/v18/N0bM2S5CPO5oOQqvazoRRb-8-PfUS5VBBSSF.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Akaya Kanadaka\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/akaya-kanadaka/akaya-kanadaka-400-normal.svg\";}}s:7:\"preview\";s:78:\"https://s.w.org/images/fonts/wp-6.9/previews/akaya-kanadaka/akaya-kanadaka.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:21;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:16:\"Akaya Telivigala\";s:10:\"fontFamily\";s:29:\"\"Akaya Telivigala\", system-ui\";s:4:\"slug\";s:16:\"akaya-telivigala\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/akayatelivigala/v28/lJwc-oo_iG9wXqU3rCTD395tp0uifdfdsIH0YH8.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:16:\"Akaya Telivigala\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/akaya-telivigala/akaya-telivigala-400-normal.svg\";}}s:7:\"preview\";s:82:\"https://s.w.org/images/fonts/wp-6.9/previews/akaya-telivigala/akaya-telivigala.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:22;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Akronim\";s:10:\"fontFamily\";s:18:\"Akronim, system-ui\";s:4:\"slug\";s:7:\"akronim\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/akronim/v23/fdN-9sqWtWZZlHRp-gVxkFYN-a8.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Akronim\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/akronim/akronim-400-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/akronim/akronim.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:23;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:6:\"Akshar\";s:10:\"fontFamily\";s:18:\"Akshar, sans-serif\";s:4:\"slug\";s:6:\"akshar\";s:8:\"fontFace\";a:5:{i:0;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/akshar/v17/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSSgFy9WY94XsnPc.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Akshar\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/akshar/akshar-300-normal.svg\";}i:1;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/akshar/v17/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSXYFy9WY94XsnPc.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Akshar\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/akshar/akshar-400-normal.svg\";}i:2;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/akshar/v17/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSUQFy9WY94XsnPc.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Akshar\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/akshar/akshar-500-normal.svg\";}i:3;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/akshar/v17/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSagCy9WY94XsnPc.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Akshar\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/akshar/akshar-600-normal.svg\";}i:4;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/akshar/v17/Yq6I-LyHWTfz9rGoqDaUbHvhkAUsSZECy9WY94XsnPc.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Akshar\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/akshar/akshar-700-normal.svg\";}}s:7:\"preview\";s:62:\"https://s.w.org/images/fonts/wp-6.9/previews/akshar/akshar.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:24;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:6:\"Aladin\";s:10:\"fontFamily\";s:17:\"Aladin, system-ui\";s:4:\"slug\";s:6:\"aladin\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:71:\"https://fonts.gstatic.com/s/aladin/v26/ZgNSjPJFPrvJV5f17Cf4pGT2Ng.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Aladin\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/aladin/aladin-400-normal.svg\";}}s:7:\"preview\";s:62:\"https://s.w.org/images/fonts/wp-6.9/previews/aladin/aladin.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:25;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:9:\"Alan Sans\";s:10:\"fontFamily\";s:23:\"\"Alan Sans\", sans-serif\";s:4:\"slug\";s:9:\"alan-sans\";s:8:\"fontFace\";a:7:{i:0;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alansans/v1/zOLt4pbDmq5Eu6ebjMSx4sywa339j__gfIHoxyV1jBwiRr0.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Alan Sans\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/alan-sans/alan-sans-300-normal.svg\";}i:1;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alansans/v1/zOLt4pbDmq5Eu6ebjMSx4sywa339j__gfN_oxyV1jBwiRr0.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Alan Sans\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/alan-sans/alan-sans-400-normal.svg\";}i:2;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alansans/v1/zOLt4pbDmq5Eu6ebjMSx4sywa339j__gfO3oxyV1jBwiRr0.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Alan Sans\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/alan-sans/alan-sans-500-normal.svg\";}i:3;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alansans/v1/zOLt4pbDmq5Eu6ebjMSx4sywa339j__gfAHvxyV1jBwiRr0.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Alan Sans\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/alan-sans/alan-sans-600-normal.svg\";}i:4;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alansans/v1/zOLt4pbDmq5Eu6ebjMSx4sywa339j__gfDjvxyV1jBwiRr0.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Alan Sans\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/alan-sans/alan-sans-700-normal.svg\";}i:5;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alansans/v1/zOLt4pbDmq5Eu6ebjMSx4sywa339j__gfF_vxyV1jBwiRr0.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Alan Sans\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/alan-sans/alan-sans-800-normal.svg\";}i:6;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alansans/v1/zOLt4pbDmq5Eu6ebjMSx4sywa339j__gfHbvxyV1jBwiRr0.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Alan Sans\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/alan-sans/alan-sans-900-normal.svg\";}}s:7:\"preview\";s:68:\"https://s.w.org/images/fonts/wp-6.9/previews/alan-sans/alan-sans.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:26;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:5:\"Alata\";s:10:\"fontFamily\";s:17:\"Alata, sans-serif\";s:4:\"slug\";s:5:\"alata\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:68:\"https://fonts.gstatic.com/s/alata/v12/PbytFmztEwbIofe_xKcRQEOX.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Alata\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/alata/alata-400-normal.svg\";}}s:7:\"preview\";s:60:\"https://s.w.org/images/fonts/wp-6.9/previews/alata/alata.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:27;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:6:\"Alatsi\";s:10:\"fontFamily\";s:18:\"Alatsi, sans-serif\";s:4:\"slug\";s:6:\"alatsi\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:71:\"https://fonts.gstatic.com/s/alatsi/v14/TK3iWkUJAxQ2nLNGGzUHte5fKg.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Alatsi\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/alatsi/alatsi-400-normal.svg\";}}s:7:\"preview\";s:62:\"https://s.w.org/images/fonts/wp-6.9/previews/alatsi/alatsi.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:28;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:11:\"Albert Sans\";s:10:\"fontFamily\";s:25:\"\"Albert Sans\", sans-serif\";s:4:\"slug\";s:11:\"albert-sans\";s:8:\"fontFace\";a:18:{i:0;a:5:{s:3:\"src\";s:98:\"https://fonts.gstatic.com/s/albertsans/v4/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHq5L_qY32TxAj1g.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:98:\"https://fonts.gstatic.com/s/albertsans/v4/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHK5P_qY32TxAj1g.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:98:\"https://fonts.gstatic.com/s/albertsans/v4/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSH9ZP_qY32TxAj1g.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:98:\"https://fonts.gstatic.com/s/albertsans/v4/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHq5P_qY32TxAj1g.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:98:\"https://fonts.gstatic.com/s/albertsans/v4/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHmZP_qY32TxAj1g.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:98:\"https://fonts.gstatic.com/s/albertsans/v4/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHdZT_qY32TxAj1g.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:98:\"https://fonts.gstatic.com/s/albertsans/v4/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHTJT_qY32TxAj1g.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:98:\"https://fonts.gstatic.com/s/albertsans/v4/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHK5T_qY32TxAj1g.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-800-normal.svg\";}i:8;a:5:{s:3:\"src\";s:98:\"https://fonts.gstatic.com/s/albertsans/v4/i7dZIFdwYjGaAMFtZd_QA3xXSKZqhr-TenSHApT_qY32TxAj1g.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-900-normal.svg\";}i:9;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/albertsans/v4/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9AX7of3bRUz1r5t.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-100-italic.svg\";}i:10;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/albertsans/v4/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9CX74f3bRUz1r5t.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-200-italic.svg\";}i:11;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/albertsans/v4/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9BJ74f3bRUz1r5t.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-300-italic.svg\";}i:12;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/albertsans/v4/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9AX74f3bRUz1r5t.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-400-italic.svg\";}i:13;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/albertsans/v4/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9Al74f3bRUz1r5t.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-500-italic.svg\";}i:14;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/albertsans/v4/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9DJ6If3bRUz1r5t.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-600-italic.svg\";}i:15;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/albertsans/v4/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9Dw6If3bRUz1r5t.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-700-italic.svg\";}i:16;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/albertsans/v4/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9CX6If3bRUz1r5t.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-800-italic.svg\";}i:17;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/albertsans/v4/i7dfIFdwYjGaAMFtZd_QA1Zeelmy79QJ1HOSY9C-6If3bRUz1r5t.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Albert Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans-900-italic.svg\";}}s:7:\"preview\";s:72:\"https://s.w.org/images/fonts/wp-6.9/previews/albert-sans/albert-sans.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:29;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Aldrich\";s:10:\"fontFamily\";s:19:\"Aldrich, sans-serif\";s:4:\"slug\";s:7:\"aldrich\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/aldrich/v22/MCoTzAn-1s3IGyJMZaUS3pP5H_E.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Aldrich\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/aldrich/aldrich-400-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/aldrich/aldrich.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:30;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:4:\"Alef\";s:10:\"fontFamily\";s:16:\"Alef, sans-serif\";s:4:\"slug\";s:4:\"alef\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:66:\"https://fonts.gstatic.com/s/alef/v24/FeVfS0NQpLYgrjdbC5FxxbU.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Alef\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/alef/alef-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:70:\"https://fonts.gstatic.com/s/alef/v24/FeVQS0NQpLYglo50L5xa2bxii28.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Alef\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/alef/alef-700-normal.svg\";}}s:7:\"preview\";s:58:\"https://s.w.org/images/fonts/wp-6.9/previews/alef/alef.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:31;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:8:\"Alegreya\";s:10:\"fontFamily\";s:15:\"Alegreya, serif\";s:4:\"slug\";s:8:\"alegreya\";s:8:\"fontFace\";a:12:{i:0;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alegreya/v39/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNG9hUI-aCisSGVrw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Alegreya\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya/alegreya-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alegreya/v39/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGxBUI-aCisSGVrw.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Alegreya\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya/alegreya-500-normal.svg\";}i:2;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alegreya/v39/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGKBII-aCisSGVrw.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Alegreya\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya/alegreya-600-normal.svg\";}i:3;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alegreya/v39/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGERII-aCisSGVrw.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Alegreya\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya/alegreya-700-normal.svg\";}i:4;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alegreya/v39/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGdhII-aCisSGVrw.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Alegreya\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya/alegreya-800-normal.svg\";}i:5;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alegreya/v39/4UacrEBBsBhlBjvfkQjt71kZfyBzPgNGXxII-aCisSGVrw.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Alegreya\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya/alegreya-900-normal.svg\";}i:6;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/alegreya/v39/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlbgv6qjkySFr9V9.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:8:\"Alegreya\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya/alegreya-400-italic.svg\";}i:7;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/alegreya/v39/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlbSv6qjkySFr9V9.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:8:\"Alegreya\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya/alegreya-500-italic.svg\";}i:8;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/alegreya/v39/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlY-uKqjkySFr9V9.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:8:\"Alegreya\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya/alegreya-600-italic.svg\";}i:9;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/alegreya/v39/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlYHuKqjkySFr9V9.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:8:\"Alegreya\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya/alegreya-700-italic.svg\";}i:10;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/alegreya/v39/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlZguKqjkySFr9V9.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:8:\"Alegreya\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya/alegreya-800-italic.svg\";}i:11;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/alegreya/v39/4UaSrEBBsBhlBjvfkSLk3abBFkvpkARTPlZJuKqjkySFr9V9.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:8:\"Alegreya\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya/alegreya-900-italic.svg\";}}s:7:\"preview\";s:66:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya/alegreya.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:32;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:11:\"Alegreya SC\";s:10:\"fontFamily\";s:20:\"\"Alegreya SC\", serif\";s:4:\"slug\";s:11:\"alegreya-sc\";s:8:\"fontFace\";a:10:{i:0;a:5:{s:3:\"src\";s:81:\"https://fonts.gstatic.com/s/alegreyasc/v26/taiOGmRtCJ62-O0HhNEa-a6t05E5abe_.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alegreya SC\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sc/alegreya-sc-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:84:\"https://fonts.gstatic.com/s/alegreyasc/v26/taiMGmRtCJ62-O0HhNEa-Z6q2ZAbbKe_DGs.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alegreya SC\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sc/alegreya-sc-400-italic.svg\";}i:2;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/alegreyasc/v26/taiTGmRtCJ62-O0HhNEa-ZZc-rU0Qqu2FXKD.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alegreya SC\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sc/alegreya-sc-500-normal.svg\";}i:3;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/alegreyasc/v26/taiRGmRtCJ62-O0HhNEa-Z6q4WEySKqUEGKDBz4.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alegreya SC\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sc/alegreya-sc-500-italic.svg\";}i:4;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/alegreyasc/v26/taiTGmRtCJ62-O0HhNEa-ZYU_LU0Qqu2FXKD.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alegreya SC\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sc/alegreya-sc-700-normal.svg\";}i:5;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/alegreyasc/v26/taiRGmRtCJ62-O0HhNEa-Z6q4Sk0SKqUEGKDBz4.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alegreya SC\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sc/alegreya-sc-700-italic.svg\";}i:6;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/alegreyasc/v26/taiTGmRtCJ62-O0HhNEa-ZYI_7U0Qqu2FXKD.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alegreya SC\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sc/alegreya-sc-800-normal.svg\";}i:7;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/alegreyasc/v26/taiRGmRtCJ62-O0HhNEa-Z6q4TU3SKqUEGKDBz4.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alegreya SC\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sc/alegreya-sc-800-italic.svg\";}i:8;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/alegreyasc/v26/taiTGmRtCJ62-O0HhNEa-ZYs_rU0Qqu2FXKD.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alegreya SC\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sc/alegreya-sc-900-normal.svg\";}i:9;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/alegreyasc/v26/taiRGmRtCJ62-O0HhNEa-Z6q4RE2SKqUEGKDBz4.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alegreya SC\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sc/alegreya-sc-900-italic.svg\";}}s:7:\"preview\";s:72:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sc/alegreya-sc.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:33;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:13:\"Alegreya Sans\";s:10:\"fontFamily\";s:27:\"\"Alegreya Sans\", sans-serif\";s:4:\"slug\";s:13:\"alegreya-sans\";s:8:\"fontFace\";a:14:{i:0;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUt9_-1phKLFgshYDvh6Vwt5TltvWdShm5bsg.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:91:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUv9_-1phKLFgshYDvh6Vwt7V9V3G1TpGtLsgu7.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-100-italic.svg\";}i:2;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUu9_-1phKLFgshYDvh6Vwt5fFPmEh8imdCqxI.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUo9_-1phKLFgshYDvh6Vwt7V9VFE92i0VHuxKiBA.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-300-italic.svg\";}i:4;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUz9_-1phKLFgshYDvh6Vwt3VhnvEVXlm4.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-400-normal.svg\";}i:5;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUt9_-1phKLFgshYDvh6Vwt7V9tvWdShm5bsg.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-400-italic.svg\";}i:6;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUu9_-1phKLFgshYDvh6Vwt5alOmEh8imdCqxI.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-500-normal.svg\";}i:7;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUo9_-1phKLFgshYDvh6Vwt7V9VTE52i0VHuxKiBA.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-500-italic.svg\";}i:8;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUu9_-1phKLFgshYDvh6Vwt5eFImEh8imdCqxI.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-700-normal.svg\";}i:9;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUo9_-1phKLFgshYDvh6Vwt7V9VBEh2i0VHuxKiBA.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-700-italic.svg\";}i:10;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUu9_-1phKLFgshYDvh6Vwt5f1LmEh8imdCqxI.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-800-normal.svg\";}i:11;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUo9_-1phKLFgshYDvh6Vwt7V9VGEt2i0VHuxKiBA.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-800-italic.svg\";}i:12;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUu9_-1phKLFgshYDvh6Vwt5dlKmEh8imdCqxI.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-900-normal.svg\";}i:13;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/alegreyasans/v26/5aUo9_-1phKLFgshYDvh6Vwt7V9VPEp2i0VHuxKiBA.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Alegreya Sans\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans-900-italic.svg\";}}s:7:\"preview\";s:76:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans/alegreya-sans.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:34;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:16:\"Alegreya Sans SC\";s:10:\"fontFamily\";s:30:\"\"Alegreya Sans SC\", sans-serif\";s:4:\"slug\";s:16:\"alegreya-sans-sc\";s:8:\"fontFace\";a:14:{i:0;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGn4-RGJqfMvt7P8FUr0Q1j-Hf1Dipl9w5FPYtmMg.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:97:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGl4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdlgREH452Mvds.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-100-italic.svg\";}i:2;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1DuJH0iFrMYJ_K-4.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdXiZhMKB6O-51OA.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-300-italic.svg\";}i:4;a:5:{s:3:\"src\";s:92:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGh4-RGJqfMvt7P8FUr0Q1j-Hf1Nktv9ixALYs.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-400-normal.svg\";}i:5;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGn4-RGJqfMvt7P8FUr0Q1j-Hf1Bkxl9w5FPYtmMg.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-400-italic.svg\";}i:6;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1DrpG0iFrMYJ_K-4.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-500-normal.svg\";}i:7;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdBidhMKB6O-51OA.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-500-italic.svg\";}i:8;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1DvJA0iFrMYJ_K-4.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-700-normal.svg\";}i:9;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdTiFhMKB6O-51OA.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-700-italic.svg\";}i:10;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1Du5D0iFrMYJ_K-4.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-800-normal.svg\";}i:11;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxdUiJhMKB6O-51OA.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-800-italic.svg\";}i:12;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGm4-RGJqfMvt7P8FUr0Q1j-Hf1DspC0iFrMYJ_K-4.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-900-normal.svg\";}i:13;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alegreyasanssc/v24/mtGk4-RGJqfMvt7P8FUr0Q1j-Hf1BkxddiNhMKB6O-51OA.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:16:\"Alegreya Sans SC\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc-900-italic.svg\";}}s:7:\"preview\";s:82:\"https://s.w.org/images/fonts/wp-6.9/previews/alegreya-sans-sc/alegreya-sans-sc.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:35;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:4:\"Aleo\";s:10:\"fontFamily\";s:11:\"Aleo, serif\";s:4:\"slug\";s:4:\"aleo\";s:8:\"fontFace\";a:18:{i:0;a:5:{s:3:\"src\";s:83:\"https://fonts.gstatic.com/s/aleo/v16/c4m61nF8G8_s6gHhIOX0IYBo_KJ3G2P4HI4qCBtJ.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:83:\"https://fonts.gstatic.com/s/aleo/v16/c4m61nF8G8_s6gHhIOX0IYBo_KL3GmP4HI4qCBtJ.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:83:\"https://fonts.gstatic.com/s/aleo/v16/c4m61nF8G8_s6gHhIOX0IYBo_KIpGmP4HI4qCBtJ.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:83:\"https://fonts.gstatic.com/s/aleo/v16/c4m61nF8G8_s6gHhIOX0IYBo_KJ3GmP4HI4qCBtJ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:83:\"https://fonts.gstatic.com/s/aleo/v16/c4m61nF8G8_s6gHhIOX0IYBo_KJFGmP4HI4qCBtJ.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:83:\"https://fonts.gstatic.com/s/aleo/v16/c4m61nF8G8_s6gHhIOX0IYBo_KKpHWP4HI4qCBtJ.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:83:\"https://fonts.gstatic.com/s/aleo/v16/c4m61nF8G8_s6gHhIOX0IYBo_KKQHWP4HI4qCBtJ.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:83:\"https://fonts.gstatic.com/s/aleo/v16/c4m61nF8G8_s6gHhIOX0IYBo_KL3HWP4HI4qCBtJ.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-800-normal.svg\";}i:8;a:5:{s:3:\"src\";s:83:\"https://fonts.gstatic.com/s/aleo/v16/c4m61nF8G8_s6gHhIOX0IYBo_KLeHWP4HI4qCBtJ.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-900-normal.svg\";}i:9;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/aleo/v16/c4m81nF8G8_swAjT3z2dShrG-7e_WYu_Fo8IDQtJbok.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-100-italic.svg\";}i:10;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/aleo/v16/c4m81nF8G8_swAjT3z2dShrG-7e_WQu-Fo8IDQtJbok.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-200-italic.svg\";}i:11;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/aleo/v16/c4m81nF8G8_swAjT3z2dShrG-7e_WdW-Fo8IDQtJbok.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-300-italic.svg\";}i:12;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/aleo/v16/c4m81nF8G8_swAjT3z2dShrG-7e_WYu-Fo8IDQtJbok.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-400-italic.svg\";}i:13;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/aleo/v16/c4m81nF8G8_swAjT3z2dShrG-7e_Wbm-Fo8IDQtJbok.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-500-italic.svg\";}i:14;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/aleo/v16/c4m81nF8G8_swAjT3z2dShrG-7e_WVW5Fo8IDQtJbok.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-600-italic.svg\";}i:15;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/aleo/v16/c4m81nF8G8_swAjT3z2dShrG-7e_WWy5Fo8IDQtJbok.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-700-italic.svg\";}i:16;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/aleo/v16/c4m81nF8G8_swAjT3z2dShrG-7e_WQu5Fo8IDQtJbok.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-800-italic.svg\";}i:17;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/aleo/v16/c4m81nF8G8_swAjT3z2dShrG-7e_WSK5Fo8IDQtJbok.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Aleo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo-900-italic.svg\";}}s:7:\"preview\";s:58:\"https://s.w.org/images/fonts/wp-6.9/previews/aleo/aleo.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:36;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:10:\"Alex Brush\";s:10:\"fontFamily\";s:21:\"\"Alex Brush\", cursive\";s:4:\"slug\";s:10:\"alex-brush\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:79:\"https://fonts.gstatic.com/s/alexbrush/v23/SZc83FzrJKuqFbwMKk6EtUf57DtOmCc.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Alex Brush\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/alex-brush/alex-brush-400-normal.svg\";}}s:7:\"preview\";s:70:\"https://s.w.org/images/fonts/wp-6.9/previews/alex-brush/alex-brush.svg\";}s:10:\"categories\";a:1:{i:0;s:11:\"handwriting\";}}i:37;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:10:\"Alexandria\";s:10:\"fontFamily\";s:22:\"Alexandria, sans-serif\";s:4:\"slug\";s:10:\"alexandria\";s:8:\"fontFace\";a:9:{i:0;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alexandria/v6/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9r7T6bCHJ8BRq0b.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Alexandria\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/alexandria/alexandria-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alexandria/v6/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9p7TqbCHJ8BRq0b.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Alexandria\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/alexandria/alexandria-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alexandria/v6/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9qlTqbCHJ8BRq0b.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Alexandria\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/alexandria/alexandria-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alexandria/v6/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9r7TqbCHJ8BRq0b.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Alexandria\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/alexandria/alexandria-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alexandria/v6/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9rJTqbCHJ8BRq0b.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Alexandria\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/alexandria/alexandria-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alexandria/v6/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9olSabCHJ8BRq0b.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Alexandria\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/alexandria/alexandria-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alexandria/v6/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9ocSabCHJ8BRq0b.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Alexandria\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/alexandria/alexandria-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alexandria/v6/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9p7SabCHJ8BRq0b.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Alexandria\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/alexandria/alexandria-800-normal.svg\";}i:8;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/alexandria/v6/UMBCrPdDqW66y0Y2usFeQCH18mulUxBvI9pSSabCHJ8BRq0b.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Alexandria\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/alexandria/alexandria-900-normal.svg\";}}s:7:\"preview\";s:70:\"https://s.w.org/images/fonts/wp-6.9/previews/alexandria/alexandria.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:38;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:13:\"Alfa Slab One\";s:10:\"fontFamily\";s:26:\"\"Alfa Slab One\", system-ui\";s:4:\"slug\";s:13:\"alfa-slab-one\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/alfaslabone/v21/6NUQ8FmMKwSEKjnm5-4v-4Jh6dBretWvYmE.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Alfa Slab One\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alfa-slab-one/alfa-slab-one-400-normal.svg\";}}s:7:\"preview\";s:76:\"https://s.w.org/images/fonts/wp-6.9/previews/alfa-slab-one/alfa-slab-one.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:39;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:5:\"Alice\";s:10:\"fontFamily\";s:12:\"Alice, serif\";s:4:\"slug\";s:5:\"alice\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:68:\"https://fonts.gstatic.com/s/alice/v21/OpNCnoEEmtHa6FcMpA_chzJ0.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Alice\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/alice/alice-400-normal.svg\";}}s:7:\"preview\";s:60:\"https://s.w.org/images/fonts/wp-6.9/previews/alice/alice.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:40;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:5:\"Alike\";s:10:\"fontFamily\";s:12:\"Alike, serif\";s:4:\"slug\";s:5:\"alike\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:68:\"https://fonts.gstatic.com/s/alike/v22/HI_EiYEYI6BIoEjESZXAQ4-d.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Alike\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/alike/alike-400-normal.svg\";}}s:7:\"preview\";s:60:\"https://s.w.org/images/fonts/wp-6.9/previews/alike/alike.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:41;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:13:\"Alike Angular\";s:10:\"fontFamily\";s:22:\"\"Alike Angular\", serif\";s:4:\"slug\";s:13:\"alike-angular\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/alikeangular/v27/3qTrojWunjGQtEBlIcwMbSoI3kY6bB7FKjE.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Alike Angular\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/alike-angular/alike-angular-400-normal.svg\";}}s:7:\"preview\";s:76:\"https://s.w.org/images/fonts/wp-6.9/previews/alike-angular/alike-angular.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:42;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:8:\"Alkalami\";s:10:\"fontFamily\";s:15:\"Alkalami, serif\";s:4:\"slug\";s:8:\"alkalami\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:74:\"https://fonts.gstatic.com/s/alkalami/v8/zOL_4pfDmqRL95WXi5eOw8BMuvhH.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Alkalami\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/alkalami/alkalami-400-normal.svg\";}}s:7:\"preview\";s:66:\"https://s.w.org/images/fonts/wp-6.9/previews/alkalami/alkalami.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:43;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Alkatra\";s:10:\"fontFamily\";s:18:\"Alkatra, system-ui\";s:4:\"slug\";s:7:\"alkatra\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/alkatra/v5/r05EGLZA5qhCYsyJbuChFuK48Medzngmu7cKrNDVemxE.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Alkatra\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/alkatra/alkatra-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/alkatra/v5/r05EGLZA5qhCYsyJbuChFuK48MedzngUu7cKrNDVemxE.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Alkatra\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/alkatra/alkatra-500-normal.svg\";}i:2;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/alkatra/v5/r05EGLZA5qhCYsyJbuChFuK48Medznj4vLcKrNDVemxE.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Alkatra\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/alkatra/alkatra-600-normal.svg\";}i:3;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/alkatra/v5/r05EGLZA5qhCYsyJbuChFuK48MedznjBvLcKrNDVemxE.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Alkatra\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/alkatra/alkatra-700-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/alkatra/alkatra.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:44;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:5:\"Allan\";s:10:\"fontFamily\";s:16:\"Allan, system-ui\";s:4:\"slug\";s:5:\"allan\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:68:\"https://fonts.gstatic.com/s/allan/v26/ea8XadU7WuTxEtbzP9SF8nZE.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Allan\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/allan/allan-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:72:\"https://fonts.gstatic.com/s/allan/v26/ea8aadU7WuTxEu5KEPCI2WpNgEKU.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Allan\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/allan/allan-700-normal.svg\";}}s:7:\"preview\";s:60:\"https://s.w.org/images/fonts/wp-6.9/previews/allan/allan.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:45;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Allerta\";s:10:\"fontFamily\";s:19:\"Allerta, sans-serif\";s:4:\"slug\";s:7:\"allerta\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/allerta/v19/TwMO-IAHRlkbx940UnQdSQqO5uY.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Allerta\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/allerta/allerta-400-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/allerta/allerta.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:46;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:15:\"Allerta Stencil\";s:10:\"fontFamily\";s:29:\"\"Allerta Stencil\", sans-serif\";s:4:\"slug\";s:15:\"allerta-stencil\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:91:\"https://fonts.gstatic.com/s/allertastencil/v24/HTx0L209KT-LmIE9N7OR6eiycOeF_jz313DuvQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:15:\"Allerta Stencil\";s:7:\"preview\";s:91:\"https://s.w.org/images/fonts/wp-6.9/previews/allerta-stencil/allerta-stencil-400-normal.svg\";}}s:7:\"preview\";s:80:\"https://s.w.org/images/fonts/wp-6.9/previews/allerta-stencil/allerta-stencil.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:47;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Allison\";s:10:\"fontFamily\";s:16:\"Allison, cursive\";s:4:\"slug\";s:7:\"allison\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/allison/v13/X7nl4b88AP2nkbvZOCOQ4MTgAgk.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Allison\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/allison/allison-400-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/allison/allison.svg\";}s:10:\"categories\";a:1:{i:0;s:11:\"handwriting\";}}i:48;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:6:\"Allura\";s:10:\"fontFamily\";s:15:\"Allura, cursive\";s:4:\"slug\";s:6:\"allura\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:71:\"https://fonts.gstatic.com/s/allura/v23/9oRPNYsQpS4zjuAPiQIXPtrrGA.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Allura\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/allura/allura-400-normal.svg\";}}s:7:\"preview\";s:62:\"https://s.w.org/images/fonts/wp-6.9/previews/allura/allura.svg\";}s:10:\"categories\";a:1:{i:0;s:11:\"handwriting\";}}i:49;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Almarai\";s:10:\"fontFamily\";s:19:\"Almarai, sans-serif\";s:4:\"slug\";s:7:\"almarai\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:77:\"https://fonts.gstatic.com/s/almarai/v19/tssoApxBaigK_hnnS_anhn2coq72sXg.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Almarai\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/almarai/almarai-300-normal.svg\";}i:1;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/almarai/v19/tsstApxBaigK_hnnc1-PonC3vqc.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Almarai\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/almarai/almarai-400-normal.svg\";}i:2;a:5:{s:3:\"src\";s:77:\"https://fonts.gstatic.com/s/almarai/v19/tssoApxBaigK_hnnS-aghn2coq72sXg.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Almarai\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/almarai/almarai-700-normal.svg\";}i:3;a:5:{s:3:\"src\";s:77:\"https://fonts.gstatic.com/s/almarai/v19/tssoApxBaigK_hnnS_qjhn2coq72sXg.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Almarai\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/almarai/almarai-800-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/almarai/almarai.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:50;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:8:\"Almendra\";s:10:\"fontFamily\";s:15:\"Almendra, serif\";s:4:\"slug\";s:8:\"almendra\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:75:\"https://fonts.gstatic.com/s/almendra/v28/H4ckBXKAlMnTn0CskyY_wr-wg763.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Almendra\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/almendra/almendra-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:78:\"https://fonts.gstatic.com/s/almendra/v28/H4ciBXKAlMnTn0CskxY4yL6Shq63czE.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:8:\"Almendra\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/almendra/almendra-400-italic.svg\";}i:2;a:5:{s:3:\"src\";s:79:\"https://fonts.gstatic.com/s/almendra/v28/H4cjBXKAlMnTn0Cskx6G7Zu9qKK-aihq.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Almendra\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/almendra/almendra-700-normal.svg\";}i:3;a:5:{s:3:\"src\";s:82:\"https://fonts.gstatic.com/s/almendra/v28/H4chBXKAlMnTn0CskxY48Ae9oqOcbzhqDtg.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:8:\"Almendra\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/almendra/almendra-700-italic.svg\";}}s:7:\"preview\";s:66:\"https://s.w.org/images/fonts/wp-6.9/previews/almendra/almendra.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:51;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:16:\"Almendra Display\";s:10:\"fontFamily\";s:29:\"\"Almendra Display\", system-ui\";s:4:\"slug\";s:16:\"almendra-display\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/almendradisplay/v33/0FlPVOGWl1Sb4O3tETtADHRRlZhzXSreTyer338.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:16:\"Almendra Display\";s:7:\"preview\";s:93:\"https://s.w.org/images/fonts/wp-6.9/previews/almendra-display/almendra-display-400-normal.svg\";}}s:7:\"preview\";s:82:\"https://s.w.org/images/fonts/wp-6.9/previews/almendra-display/almendra-display.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:52;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:11:\"Almendra SC\";s:10:\"fontFamily\";s:20:\"\"Almendra SC\", serif\";s:4:\"slug\";s:11:\"almendra-sc\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:81:\"https://fonts.gstatic.com/s/almendrasc/v31/Iure6Yx284eebowr7hbyTZZMprVA4XQ0.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Almendra SC\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/almendra-sc/almendra-sc-400-normal.svg\";}}s:7:\"preview\";s:72:\"https://s.w.org/images/fonts/wp-6.9/previews/almendra-sc/almendra-sc.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:53;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:11:\"Alumni Sans\";s:10:\"fontFamily\";s:25:\"\"Alumni Sans\", sans-serif\";s:4:\"slug\";s:11:\"alumni-sans\";s:8:\"fontFace\";a:18:{i:0;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9OO5QrVsJ3C8qng.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9uO9QrVsJ3C8qng.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9Zu9QrVsJ3C8qng.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9OO9QrVsJ3C8qng.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9Cu9QrVsJ3C8qng.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd95uhQrVsJ3C8qng.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd93-hQrVsJ3C8qng.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9uOhQrVsJ3C8qng.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-800-normal.svg\";}i:8;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpHtKqkOwdO2aOIwhWudEWpx_zq_Xna-Xd9kehQrVsJ3C8qng.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-900-normal.svg\";}i:9;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Ky46lEI_io6npfB.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-100-italic.svg\";}i:10;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kw461EI_io6npfB.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-200-italic.svg\";}i:11;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kzm61EI_io6npfB.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-300-italic.svg\";}i:12;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Ky461EI_io6npfB.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-400-italic.svg\";}i:13;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8KyK61EI_io6npfB.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-500-italic.svg\";}i:14;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kxm7FEI_io6npfB.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-600-italic.svg\";}i:15;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kxf7FEI_io6npfB.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-700-italic.svg\";}i:16;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8Kw47FEI_io6npfB.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-800-italic.svg\";}i:17;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/alumnisans/v20/nwpBtKqkOwdO2aOIwhWudG-g9QMylBJAV3Bo8KwR7FEI_io6npfB.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Alumni Sans\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans-900-italic.svg\";}}s:7:\"preview\";s:72:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans/alumni-sans.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:54;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:26:\"Alumni Sans Collegiate One\";s:10:\"fontFamily\";s:40:\"\"Alumni Sans Collegiate One\", sans-serif\";s:4:\"slug\";s:26:\"alumni-sans-collegiate-one\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:113:\"https://fonts.gstatic.com/s/alumnisanscollegiateone/v7/MQpB-XChK8G5CtmK_AuGxQrdNvPSXkn0RM-XqjWWhjdfyDiPw2ta.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Alumni Sans Collegiate One\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-collegiate-one/alumni-sans-collegiate-one-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/alumnisanscollegiateone/v7/MQpD-XChK8G5CtmK_AuGxQrdNvPSXkn0RM-XqjWWhgdYwjmtxntaDFU.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Alumni Sans Collegiate One\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-collegiate-one/alumni-sans-collegiate-one-400-italic.svg\";}}s:7:\"preview\";s:102:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-collegiate-one/alumni-sans-collegiate-one.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:55;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:22:\"Alumni Sans Inline One\";s:10:\"fontFamily\";s:35:\"\"Alumni Sans Inline One\", system-ui\";s:4:\"slug\";s:22:\"alumni-sans-inline-one\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:104:\"https://fonts.gstatic.com/s/alumnisansinlineone/v7/RrQBbpJx9zZ3IXTBOASKp5gJAetBdaihcjbpD3UZcr7xbYw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:22:\"Alumni Sans Inline One\";s:7:\"preview\";s:105:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-inline-one/alumni-sans-inline-one-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:107:\"https://fonts.gstatic.com/s/alumnisansinlineone/v7/RrQDbpJx9zZ3IXTBOASKp5gJAetBdaihcjbpP3ITc5z0fYxcrQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:22:\"Alumni Sans Inline One\";s:7:\"preview\";s:105:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-inline-one/alumni-sans-inline-one-400-italic.svg\";}}s:7:\"preview\";s:94:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-inline-one/alumni-sans-inline-one.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:56;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:21:\"Alumni Sans Pinstripe\";s:10:\"fontFamily\";s:35:\"\"Alumni Sans Pinstripe\", sans-serif\";s:4:\"slug\";s:21:\"alumni-sans-pinstripe\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/alumnisanspinstripe/v8/ZgNNjOFFPq_AUJD1umyS30W-Xub8zD1ObhezZ7VIpcDA5w.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:21:\"Alumni Sans Pinstripe\";s:7:\"preview\";s:103:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-pinstripe/alumni-sans-pinstripe-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:105:\"https://fonts.gstatic.com/s/alumnisanspinstripe/v8/ZgNDjOFFPq_AUJD1umyS30W-Xub8zD1ObheDYL9Jh8XQ5_cY.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:21:\"Alumni Sans Pinstripe\";s:7:\"preview\";s:103:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-pinstripe/alumni-sans-pinstripe-400-italic.svg\";}}s:7:\"preview\";s:92:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-pinstripe/alumni-sans-pinstripe.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:57;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:14:\"Alumni Sans SC\";s:10:\"fontFamily\";s:28:\"\"Alumni Sans SC\", sans-serif\";s:4:\"slug\";s:14:\"alumni-sans-sc\";s:8:\"fontFace\";a:18:{i:0;a:5:{s:3:\"src\";s:104:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdIteaLxWhcKfbBlLNQ.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:104:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdIte6L1WhcKfbBlLNQ.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:104:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdIteNr1WhcKfbBlLNQ.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:104:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdIteaL1WhcKfbBlLNQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:104:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdIteWr1WhcKfbBlLNQ.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:104:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdItetrpWhcKfbBlLNQ.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:104:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdItej7pWhcKfbBlLNQ.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:104:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdIte6LpWhcKfbBlLNQ.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-800-normal.svg\";}i:8;a:5:{s:3:\"src\";s:104:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GfYaxzVjArrOeNFYbCvkZ8C28IyGwp26UHdItewbpWhcKfbBlLNQ.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-900-normal.svg\";}i:9;a:5:{s:3:\"src\";s:106:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP6-wsieThxbNRJQ.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-100-italic.svg\";}i:10;a:5:{s:3:\"src\";s:106:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP4-w8ieThxbNRJQ.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-200-italic.svg\";}i:11;a:5:{s:3:\"src\";s:106:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP7gw8ieThxbNRJQ.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-300-italic.svg\";}i:12;a:5:{s:3:\"src\";s:106:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP6-w8ieThxbNRJQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-400-italic.svg\";}i:13;a:5:{s:3:\"src\";s:106:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP6Mw8ieThxbNRJQ.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-500-italic.svg\";}i:14;a:5:{s:3:\"src\";s:106:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP5gxMieThxbNRJQ.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-600-italic.svg\";}i:15;a:5:{s:3:\"src\";s:106:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP5ZxMieThxbNRJQ.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-700-italic.svg\";}i:16;a:5:{s:3:\"src\";s:106:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP4-xMieThxbNRJQ.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-800-italic.svg\";}i:17;a:5:{s:3:\"src\";s:106:\"https://fonts.gstatic.com/s/alumnisanssc/v3/Y4GdYaxzVjArrOeNFYbCvkZ8C0UB-pPxss6d2oxLoP4XxMieThxbNRJQ.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Alumni Sans SC\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc-900-italic.svg\";}}s:7:\"preview\";s:78:\"https://s.w.org/images/fonts/wp-6.9/previews/alumni-sans-sc/alumni-sans-sc.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:58;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:8:\"Amarante\";s:10:\"fontFamily\";s:19:\"Amarante, system-ui\";s:4:\"slug\";s:8:\"amarante\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:75:\"https://fonts.gstatic.com/s/amarante/v30/xMQXuF1KTa6EvGx9bq-yC3rAmD-b.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Amarante\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/amarante/amarante-400-normal.svg\";}}s:7:\"preview\";s:66:\"https://s.w.org/images/fonts/wp-6.9/previews/amarante/amarante.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:59;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:8:\"Amaranth\";s:10:\"fontFamily\";s:20:\"Amaranth, sans-serif\";s:4:\"slug\";s:8:\"amaranth\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:75:\"https://fonts.gstatic.com/s/amaranth/v19/KtkuALODe433f0j1zPnHF9GqwnzW.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Amaranth\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/amaranth/amaranth-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:78:\"https://fonts.gstatic.com/s/amaranth/v19/KtkoALODe433f0j1zMnAHdCIx2zWD4I.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:8:\"Amaranth\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/amaranth/amaranth-400-italic.svg\";}i:2;a:5:{s:3:\"src\";s:79:\"https://fonts.gstatic.com/s/amaranth/v19/KtkpALODe433f0j1zMF-OPWn6WDfFpuc.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Amaranth\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/amaranth/amaranth-700-normal.svg\";}i:3;a:5:{s:3:\"src\";s:82:\"https://fonts.gstatic.com/s/amaranth/v19/KtkrALODe433f0j1zMnAJWmn42H9E4ucRY8.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:8:\"Amaranth\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/amaranth/amaranth-700-italic.svg\";}}s:7:\"preview\";s:66:\"https://s.w.org/images/fonts/wp-6.9/previews/amaranth/amaranth.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:60;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:9:\"Amatic SC\";s:10:\"fontFamily\";s:20:\"\"Amatic SC\", cursive\";s:4:\"slug\";s:9:\"amatic-sc\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:77:\"https://fonts.gstatic.com/s/amaticsc/v28/TUZyzwprpvBS1izr_vO0CO6ecZQf1A.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Amatic SC\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/amatic-sc/amatic-sc-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:81:\"https://fonts.gstatic.com/s/amaticsc/v28/TUZ3zwprpvBS1izr_vOMscG6fL8D3WTy-A.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Amatic SC\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/amatic-sc/amatic-sc-700-normal.svg\";}}s:7:\"preview\";s:68:\"https://s.w.org/images/fonts/wp-6.9/previews/amatic-sc/amatic-sc.svg\";}s:10:\"categories\";a:1:{i:0;s:11:\"handwriting\";}}i:61;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:9:\"Amethysta\";s:10:\"fontFamily\";s:16:\"Amethysta, serif\";s:4:\"slug\";s:9:\"amethysta\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:78:\"https://fonts.gstatic.com/s/amethysta/v17/rP2Fp2K15kgb_F3ibfWIHTWCBl0O8Q.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Amethysta\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/amethysta/amethysta-400-normal.svg\";}}s:7:\"preview\";s:68:\"https://s.w.org/images/fonts/wp-6.9/previews/amethysta/amethysta.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:62;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:5:\"Amiko\";s:10:\"fontFamily\";s:17:\"Amiko, sans-serif\";s:4:\"slug\";s:5:\"amiko\";s:8:\"fontFace\";a:3:{i:0;a:5:{s:3:\"src\";s:68:\"https://fonts.gstatic.com/s/amiko/v15/WwkQxPq1DFK04tqgc17MMZgJ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Amiko\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/amiko/amiko-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:72:\"https://fonts.gstatic.com/s/amiko/v15/WwkdxPq1DFK04uJ9XXrBGoQAUco5.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Amiko\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/amiko/amiko-600-normal.svg\";}i:2;a:5:{s:3:\"src\";s:72:\"https://fonts.gstatic.com/s/amiko/v15/WwkdxPq1DFK04uIZXHrBGoQAUco5.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Amiko\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/amiko/amiko-700-normal.svg\";}}s:7:\"preview\";s:60:\"https://s.w.org/images/fonts/wp-6.9/previews/amiko/amiko.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:63;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:5:\"Amiri\";s:10:\"fontFamily\";s:12:\"Amiri, serif\";s:4:\"slug\";s:5:\"amiri\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:68:\"https://fonts.gstatic.com/s/amiri/v30/J7aRnpd8CGxBHqUsvrIw74NL.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Amiri\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/amiri/amiri-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:71:\"https://fonts.gstatic.com/s/amiri/v30/J7afnpd8CGxBHpUrtLMS6pNLAjk.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:5:\"Amiri\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/amiri/amiri-400-italic.svg\";}i:2;a:5:{s:3:\"src\";s:72:\"https://fonts.gstatic.com/s/amiri/v30/J7acnpd8CGxBHp2VkZY9xJ9CGyAa.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Amiri\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/amiri/amiri-700-normal.svg\";}i:3;a:5:{s:3:\"src\";s:75:\"https://fonts.gstatic.com/s/amiri/v30/J7aanpd8CGxBHpUrjAo9zp5gHjAavCA.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:5:\"Amiri\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/amiri/amiri-700-italic.svg\";}}s:7:\"preview\";s:60:\"https://s.w.org/images/fonts/wp-6.9/previews/amiri/amiri.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:64;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:11:\"Amiri Quran\";s:10:\"fontFamily\";s:20:\"\"Amiri Quran\", serif\";s:4:\"slug\";s:11:\"amiri-quran\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:81:\"https://fonts.gstatic.com/s/amiriquran/v19/_Xmo-Hk0rD6DbUL4_vH8Zq5o7Cycsu-2.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Amiri Quran\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/amiri-quran/amiri-quran-400-normal.svg\";}}s:7:\"preview\";s:72:\"https://s.w.org/images/fonts/wp-6.9/previews/amiri-quran/amiri-quran.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:65;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:5:\"Amita\";s:10:\"fontFamily\";s:14:\"Amita, cursive\";s:4:\"slug\";s:5:\"amita\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:68:\"https://fonts.gstatic.com/s/amita/v20/HhyaU5si9Om7PQlqAfSKEZZL.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Amita\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/amita/amita-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:72:\"https://fonts.gstatic.com/s/amita/v20/HhyXU5si9Om7PTHTLtCHOopCTKkI.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Amita\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/amita/amita-700-normal.svg\";}}s:7:\"preview\";s:60:\"https://s.w.org/images/fonts/wp-6.9/previews/amita/amita.svg\";}s:10:\"categories\";a:1:{i:0;s:11:\"handwriting\";}}i:66;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Anaheim\";s:10:\"fontFamily\";s:19:\"Anaheim, sans-serif\";s:4:\"slug\";s:7:\"anaheim\";s:8:\"fontFace\";a:5:{i:0;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/anaheim/v17/8vIX7w042Wp87g4Gy0_24JbCiPrl-h5sLqrAIkJQb7zU.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anaheim\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anaheim/anaheim-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/anaheim/v17/8vIX7w042Wp87g4Gy0_24JbCiPrl-h5eLqrAIkJQb7zU.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anaheim\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anaheim/anaheim-500-normal.svg\";}i:2;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/anaheim/v17/8vIX7w042Wp87g4Gy0_24JbCiPrl-h6yKarAIkJQb7zU.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anaheim\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anaheim/anaheim-600-normal.svg\";}i:3;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/anaheim/v17/8vIX7w042Wp87g4Gy0_24JbCiPrl-h6LKarAIkJQb7zU.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anaheim\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anaheim/anaheim-700-normal.svg\";}i:4;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/anaheim/v17/8vIX7w042Wp87g4Gy0_24JbCiPrl-h7sKarAIkJQb7zU.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anaheim\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anaheim/anaheim-800-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/anaheim/anaheim.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:67;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:12:\"Ancizar Sans\";s:10:\"fontFamily\";s:26:\"\"Ancizar Sans\", sans-serif\";s:4:\"slug\";s:12:\"ancizar-sans\";s:8:\"fontFace\";a:18:{i:0;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMyzipBpcu30AZbUY.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMy7ioBpcu30AZbUY.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMy2aoBpcu30AZbUY.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMyzioBpcu30AZbUY.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMywqoBpcu30AZbUY.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMy-avBpcu30AZbUY.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMy9-vBpcu30AZbUY.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMy7ivBpcu30AZbUY.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-800-normal.svg\";}i:8;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC1zPYtHY2vX3wj8IbE7PxeWXCAxfsUebXFMy5GvBpcu30AZbUY.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-900-normal.svg\";}i:9;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDr7tAk3mIcfUZgBQ.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-100-italic.svg\";}i:10;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDrbtEk3mIcfUZgBQ.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-200-italic.svg\";}i:11;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDrsNEk3mIcfUZgBQ.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-300-italic.svg\";}i:12;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDr7tEk3mIcfUZgBQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-400-italic.svg\";}i:13;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDr3NEk3mIcfUZgBQ.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-500-italic.svg\";}i:14;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDrMNYk3mIcfUZgBQ.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-600-italic.svg\";}i:15;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDrCdYk3mIcfUZgBQ.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-700-italic.svg\";}i:16;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDrbtYk3mIcfUZgBQ.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-800-italic.svg\";}i:17;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/ancizarsans/v8/fC11PYtHY2vX3wj8IbE7Pxe8VRLOpqx1999L3vDrR9Yk3mIcfUZgBQ.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:12:\"Ancizar Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans-900-italic.svg\";}}s:7:\"preview\";s:74:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-sans/ancizar-sans.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:68;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:13:\"Ancizar Serif\";s:10:\"fontFamily\";s:22:\"\"Ancizar Serif\", serif\";s:4:\"slug\";s:13:\"ancizar-serif\";s:8:\"fontFace\";a:14:{i:0;a:5:{s:3:\"src\";s:102:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN2H_fAVtYfaQ_ao.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-300-normal.svg\";}i:1;a:5:{s:3:\"src\";s:102:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN3Z_fAVtYfaQ_ao.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-400-normal.svg\";}i:2;a:5:{s:3:\"src\";s:102:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN3r_fAVtYfaQ_ao.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-500-normal.svg\";}i:3;a:5:{s:3:\"src\";s:102:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN0H-vAVtYfaQ_ao.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-600-normal.svg\";}i:4;a:5:{s:3:\"src\";s:102:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN0--vAVtYfaQ_ao.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-700-normal.svg\";}i:5;a:5:{s:3:\"src\";s:102:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN1Z-vAVtYfaQ_ao.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-800-normal.svg\";}i:6;a:5:{s:3:\"src\";s:102:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_lRfmxrmD9dEi_Qbtf91W1xPPTOqu-ZIAJUN1w-vAVtYfaQ_ao.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-900-normal.svg\";}i:7;a:5:{s:3:\"src\";s:105:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvkZTv4b4Ruao7Y0.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-300-italic.svg\";}i:8;a:5:{s:3:\"src\";s:105:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvhhTv4b4Ruao7Y0.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-400-italic.svg\";}i:9;a:5:{s:3:\"src\";s:105:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvipTv4b4Ruao7Y0.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-500-italic.svg\";}i:10;a:5:{s:3:\"src\";s:105:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvsZUv4b4Ruao7Y0.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-600-italic.svg\";}i:11;a:5:{s:3:\"src\";s:105:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvv9Uv4b4Ruao7Y0.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-700-italic.svg\";}i:12;a:5:{s:3:\"src\";s:105:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvphUv4b4Ruao7Y0.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-800-italic.svg\";}i:13;a:5:{s:3:\"src\";s:105:\"https://fonts.gstatic.com/s/ancizarserif/v8/PN_nRfmxrmD9dEi_Qbtf91W17vrhxXPXDxqnV8gRvrFUv4b4Ruao7Y0.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Ancizar Serif\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif-900-italic.svg\";}}s:7:\"preview\";s:76:\"https://s.w.org/images/fonts/wp-6.9/previews/ancizar-serif/ancizar-serif.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:69;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:10:\"Andada Pro\";s:10:\"fontFamily\";s:19:\"\"Andada Pro\", serif\";s:4:\"slug\";s:10:\"andada-pro\";s:8:\"fontFace\";a:10:{i:0;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/andadapro/v24/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DPJBY8ZFLzvIt2S.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Andada Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/andada-pro/andada-pro-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/andadapro/v24/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DP7BY8ZFLzvIt2S.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Andada Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/andada-pro/andada-pro-500-normal.svg\";}i:2;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/andadapro/v24/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DMXAo8ZFLzvIt2S.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Andada Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/andada-pro/andada-pro-600-normal.svg\";}i:3;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/andadapro/v24/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DMuAo8ZFLzvIt2S.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Andada Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/andada-pro/andada-pro-700-normal.svg\";}i:4;a:5:{s:3:\"src\";s:96:\"https://fonts.gstatic.com/s/andadapro/v24/HhyEU5Qi9-SuOEhPe4LtKoVCuWGURPcg3DNJAo8ZFLzvIt2S.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Andada Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/andada-pro/andada-pro-800-normal.svg\";}i:5;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/andadapro/v24/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRmdfHr3NJ82Stjw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Andada Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/andada-pro/andada-pro-400-italic.svg\";}i:6;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/andadapro/v24/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRlVfHr3NJ82Stjw.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Andada Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/andada-pro/andada-pro-500-italic.svg\";}i:7;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/andadapro/v24/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRrlYHr3NJ82Stjw.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Andada Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/andada-pro/andada-pro-600-italic.svg\";}i:8;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/andadapro/v24/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRoBYHr3NJ82Stjw.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Andada Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/andada-pro/andada-pro-700-italic.svg\";}i:9;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/andadapro/v24/HhyGU5Qi9-SuOEhPe4LtAIxwRrn9L22O2yYBRudYHr3NJ82Stjw.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Andada Pro\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/andada-pro/andada-pro-800-italic.svg\";}}s:7:\"preview\";s:70:\"https://s.w.org/images/fonts/wp-6.9/previews/andada-pro/andada-pro.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:70;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:6:\"Andika\";s:10:\"fontFamily\";s:18:\"Andika, sans-serif\";s:4:\"slug\";s:6:\"andika\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:71:\"https://fonts.gstatic.com/s/andika/v27/mem_Ya6iyW-LwqgAaLwRWrwGVA.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Andika\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/andika/andika-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/andika/v27/mem9Ya6iyW-Lwqgwb7YQeLkWVNBt.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:6:\"Andika\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/andika/andika-400-italic.svg\";}i:2;a:5:{s:3:\"src\";s:75:\"https://fonts.gstatic.com/s/andika/v27/mem8Ya6iyW-Lwqg40ZM1V5caXcl0Aw.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Andika\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/andika/andika-700-normal.svg\";}i:3;a:5:{s:3:\"src\";s:77:\"https://fonts.gstatic.com/s/andika/v27/mem6Ya6iyW-Lwqgwb46pV50bf8xkA76a.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:6:\"Andika\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/andika/andika-700-italic.svg\";}}s:7:\"preview\";s:62:\"https://s.w.org/images/fonts/wp-6.9/previews/andika/andika.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:71;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:11:\"Anek Bangla\";s:10:\"fontFamily\";s:25:\"\"Anek Bangla\", sans-serif\";s:4:\"slug\";s:11:\"anek-bangla\";s:8:\"fontFace\";a:8:{i:0;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anekbangla/v16/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofm9YIoIg56yyvt0.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Bangla\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-bangla/anek-bangla-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anekbangla/v16/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofu9ZIoIg56yyvt0.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Bangla\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-bangla/anek-bangla-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anekbangla/v16/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3OfjFZIoIg56yyvt0.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Bangla\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-bangla/anek-bangla-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anekbangla/v16/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofm9ZIoIg56yyvt0.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Bangla\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-bangla/anek-bangla-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anekbangla/v16/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofl1ZIoIg56yyvt0.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Bangla\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-bangla/anek-bangla-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anekbangla/v16/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3OfrFeIoIg56yyvt0.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Bangla\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-bangla/anek-bangla-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anekbangla/v16/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3OfoheIoIg56yyvt0.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Bangla\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-bangla/anek-bangla-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anekbangla/v16/_gPW1R38qTExHg-17BhM6n66QhabMYB0fBKONtHhRSIUIre5mq3Ofu9eIoIg56yyvt0.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Bangla\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-bangla/anek-bangla-800-normal.svg\";}}s:7:\"preview\";s:72:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-bangla/anek-bangla.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:72;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:15:\"Anek Devanagari\";s:10:\"fontFamily\";s:29:\"\"Anek Devanagari\", sans-serif\";s:4:\"slug\";s:15:\"anek-devanagari\";s:8:\"fontFace\";a:8:{i:0;a:5:{s:3:\"src\";s:125:\"https://fonts.gstatic.com/s/anekdevanagari/v17/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLDtk-9iFk0LjZ7E.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:15:\"Anek Devanagari\";s:7:\"preview\";s:91:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-devanagari/anek-devanagari-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:125:\"https://fonts.gstatic.com/s/anekdevanagari/v17/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLBtku9iFk0LjZ7E.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:15:\"Anek Devanagari\";s:7:\"preview\";s:91:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-devanagari/anek-devanagari-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:125:\"https://fonts.gstatic.com/s/anekdevanagari/v17/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLCzku9iFk0LjZ7E.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:15:\"Anek Devanagari\";s:7:\"preview\";s:91:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-devanagari/anek-devanagari-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:125:\"https://fonts.gstatic.com/s/anekdevanagari/v17/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLDtku9iFk0LjZ7E.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:15:\"Anek Devanagari\";s:7:\"preview\";s:91:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-devanagari/anek-devanagari-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:125:\"https://fonts.gstatic.com/s/anekdevanagari/v17/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLDfku9iFk0LjZ7E.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:15:\"Anek Devanagari\";s:7:\"preview\";s:91:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-devanagari/anek-devanagari-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:125:\"https://fonts.gstatic.com/s/anekdevanagari/v17/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLAzle9iFk0LjZ7E.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:15:\"Anek Devanagari\";s:7:\"preview\";s:91:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-devanagari/anek-devanagari-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:125:\"https://fonts.gstatic.com/s/anekdevanagari/v17/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLAKle9iFk0LjZ7E.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:15:\"Anek Devanagari\";s:7:\"preview\";s:91:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-devanagari/anek-devanagari-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:125:\"https://fonts.gstatic.com/s/anekdevanagari/v17/jVyo7nP0CGrUsxB-QiRgw0NlLaVt_QUAkYxLRoCL23mlh20ZVHOMAWbgHLBtle9iFk0LjZ7E.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:15:\"Anek Devanagari\";s:7:\"preview\";s:91:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-devanagari/anek-devanagari-800-normal.svg\";}}s:7:\"preview\";s:80:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-devanagari/anek-devanagari.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:73;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:13:\"Anek Gujarati\";s:10:\"fontFamily\";s:27:\"\"Anek Gujarati\", sans-serif\";s:4:\"slug\";s:13:\"anek-gujarati\";s:8:\"fontFace\";a:8:{i:0;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgujarati/v17/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0F5G7xkKgB7Lm7g.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gujarati\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gujarati/anek-gujarati-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgujarati/v17/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0l5C7xkKgB7Lm7g.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gujarati\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gujarati/anek-gujarati-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgujarati/v17/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0SZC7xkKgB7Lm7g.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gujarati\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gujarati/anek-gujarati-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgujarati/v17/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0F5C7xkKgB7Lm7g.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gujarati\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gujarati/anek-gujarati-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgujarati/v17/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0JZC7xkKgB7Lm7g.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gujarati\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gujarati/anek-gujarati-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgujarati/v17/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0yZe7xkKgB7Lm7g.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gujarati\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gujarati/anek-gujarati-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgujarati/v17/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-08Je7xkKgB7Lm7g.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gujarati\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gujarati/anek-gujarati-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgujarati/v17/l7g_bj5oysqknvkCo2T_8FuiIRBA7lncQUmbIBEtPKiYYQhRwyBxCD-0l5e7xkKgB7Lm7g.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gujarati\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gujarati/anek-gujarati-800-normal.svg\";}}s:7:\"preview\";s:76:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gujarati/anek-gujarati.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:74;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:13:\"Anek Gurmukhi\";s:10:\"fontFamily\";s:27:\"\"Anek Gurmukhi\", sans-serif\";s:4:\"slug\";s:13:\"anek-gurmukhi\";s:8:\"fontFace\";a:8:{i:0;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgurmukhi/v13/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbd5ppWa41H6DjbA.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gurmukhi\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gurmukhi/anek-gurmukhi-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgurmukhi/v13/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkb95tpWa41H6DjbA.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gurmukhi\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gurmukhi/anek-gurmukhi-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgurmukhi/v13/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbKZtpWa41H6DjbA.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gurmukhi\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gurmukhi/anek-gurmukhi-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgurmukhi/v13/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbd5tpWa41H6DjbA.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gurmukhi\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gurmukhi/anek-gurmukhi-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgurmukhi/v13/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbRZtpWa41H6DjbA.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gurmukhi\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gurmukhi/anek-gurmukhi-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgurmukhi/v13/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbqZxpWa41H6DjbA.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gurmukhi\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gurmukhi/anek-gurmukhi-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgurmukhi/v13/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkbkJxpWa41H6DjbA.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gurmukhi\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gurmukhi/anek-gurmukhi-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:121:\"https://fonts.gstatic.com/s/anekgurmukhi/v13/0QIAMXRO_YSkA0quVLY79JnHybfeEOrXCa9Dmd9Ql6a6R_vEMc5TaLkb95xpWa41H6DjbA.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anek Gurmukhi\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gurmukhi/anek-gurmukhi-800-normal.svg\";}}s:7:\"preview\";s:76:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-gurmukhi/anek-gurmukhi.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:75;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:12:\"Anek Kannada\";s:10:\"fontFamily\";s:26:\"\"Anek Kannada\", sans-serif\";s:4:\"slug\";s:12:\"anek-kannada\";s:8:\"fontFace\";a:8:{i:0;a:5:{s:3:\"src\";s:118:\"https://fonts.gstatic.com/s/anekkannada/v15/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dFDEAuhVReA1oef.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Anek Kannada\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-kannada/anek-kannada-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:118:\"https://fonts.gstatic.com/s/anekkannada/v15/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dHDEQuhVReA1oef.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Anek Kannada\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-kannada/anek-kannada-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:118:\"https://fonts.gstatic.com/s/anekkannada/v15/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dEdEQuhVReA1oef.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Anek Kannada\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-kannada/anek-kannada-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:118:\"https://fonts.gstatic.com/s/anekkannada/v15/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dFDEQuhVReA1oef.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Anek Kannada\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-kannada/anek-kannada-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:118:\"https://fonts.gstatic.com/s/anekkannada/v15/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dFxEQuhVReA1oef.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Anek Kannada\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-kannada/anek-kannada-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:118:\"https://fonts.gstatic.com/s/anekkannada/v15/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dGdFguhVReA1oef.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Anek Kannada\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-kannada/anek-kannada-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:118:\"https://fonts.gstatic.com/s/anekkannada/v15/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dGkFguhVReA1oef.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Anek Kannada\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-kannada/anek-kannada-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:118:\"https://fonts.gstatic.com/s/anekkannada/v15/raxcHiCNvNMKe1CKFsINYFlgkEIwGa8nL6ruWJg1j--h8pvBKSiw4dHDFguhVReA1oef.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Anek Kannada\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-kannada/anek-kannada-800-normal.svg\";}}s:7:\"preview\";s:74:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-kannada/anek-kannada.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:76;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:10:\"Anek Latin\";s:10:\"fontFamily\";s:24:\"\"Anek Latin\", sans-serif\";s:4:\"slug\";s:10:\"anek-latin\";s:8:\"fontFace\";a:8:{i:0;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/aneklatin/v11/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PuR7EZLNClWL3kgw.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Latin\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-latin/anek-latin-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/aneklatin/v11/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3Pux7AZLNClWL3kgw.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Latin\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-latin/anek-latin-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/aneklatin/v11/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PuGbAZLNClWL3kgw.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Latin\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-latin/anek-latin-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/aneklatin/v11/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PuR7AZLNClWL3kgw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Latin\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-latin/anek-latin-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/aneklatin/v11/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PudbAZLNClWL3kgw.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Latin\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-latin/anek-latin-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/aneklatin/v11/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PumbcZLNClWL3kgw.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Latin\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-latin/anek-latin-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/aneklatin/v11/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3PuoLcZLNClWL3kgw.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Latin\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-latin/anek-latin-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/aneklatin/v11/co3pmWZulTRoU4a8dqrWiajBS5ByUkvdrluH-xWG5uJTY4x-L3Pux7cZLNClWL3kgw.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Latin\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-latin/anek-latin-800-normal.svg\";}}s:7:\"preview\";s:70:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-latin/anek-latin.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:77;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:14:\"Anek Malayalam\";s:10:\"fontFamily\";s:28:\"\"Anek Malayalam\", sans-serif\";s:4:\"slug\";s:14:\"anek-malayalam\";s:8:\"fontFace\";a:8:{i:0;a:5:{s:3:\"src\";s:123:\"https://fonts.gstatic.com/s/anekmalayalam/v18/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUZu_HM_5PDO71Qs.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Anek Malayalam\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-malayalam/anek-malayalam-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:123:\"https://fonts.gstatic.com/s/anekmalayalam/v18/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTURu-HM_5PDO71Qs.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Anek Malayalam\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-malayalam/anek-malayalam-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:123:\"https://fonts.gstatic.com/s/anekmalayalam/v18/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUcW-HM_5PDO71Qs.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Anek Malayalam\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-malayalam/anek-malayalam-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:123:\"https://fonts.gstatic.com/s/anekmalayalam/v18/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUZu-HM_5PDO71Qs.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Anek Malayalam\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-malayalam/anek-malayalam-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:123:\"https://fonts.gstatic.com/s/anekmalayalam/v18/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUam-HM_5PDO71Qs.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Anek Malayalam\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-malayalam/anek-malayalam-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:123:\"https://fonts.gstatic.com/s/anekmalayalam/v18/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUUW5HM_5PDO71Qs.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Anek Malayalam\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-malayalam/anek-malayalam-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:123:\"https://fonts.gstatic.com/s/anekmalayalam/v18/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTUXy5HM_5PDO71Qs.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Anek Malayalam\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-malayalam/anek-malayalam-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:123:\"https://fonts.gstatic.com/s/anekmalayalam/v18/6qLjKZActRTs_mZAJUZWWkhke0nYa_vC8_Azq3-gP1SReZeOtqQuDVUTURu5HM_5PDO71Qs.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Anek Malayalam\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-malayalam/anek-malayalam-800-normal.svg\";}}s:7:\"preview\";s:78:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-malayalam/anek-malayalam.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:78;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:9:\"Anek Odia\";s:10:\"fontFamily\";s:23:\"\"Anek Odia\", sans-serif\";s:4:\"slug\";s:9:\"anek-odia\";s:8:\"fontFace\";a:8:{i:0;a:5:{s:3:\"src\";s:111:\"https://fonts.gstatic.com/s/anekodia/v17/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnmZf63jXZAtm_es.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Anek Odia\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-odia/anek-odia-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:111:\"https://fonts.gstatic.com/s/anekodia/v17/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnkZfq3jXZAtm_es.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Anek Odia\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-odia/anek-odia-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:111:\"https://fonts.gstatic.com/s/anekodia/v17/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnnHfq3jXZAtm_es.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Anek Odia\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-odia/anek-odia-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:111:\"https://fonts.gstatic.com/s/anekodia/v17/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnmZfq3jXZAtm_es.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Anek Odia\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-odia/anek-odia-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:111:\"https://fonts.gstatic.com/s/anekodia/v17/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnmrfq3jXZAtm_es.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Anek Odia\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-odia/anek-odia-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:111:\"https://fonts.gstatic.com/s/anekodia/v17/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnlHea3jXZAtm_es.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Anek Odia\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-odia/anek-odia-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:111:\"https://fonts.gstatic.com/s/anekodia/v17/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnl-ea3jXZAtm_es.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Anek Odia\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-odia/anek-odia-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:111:\"https://fonts.gstatic.com/s/anekodia/v17/TK3PWkoJARApz5UCd345tuevwwQX0CwsoYkAWgWYevAauivBUnkZea3jXZAtm_es.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Anek Odia\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-odia/anek-odia-800-normal.svg\";}}s:7:\"preview\";s:68:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-odia/anek-odia.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:79;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:10:\"Anek Tamil\";s:10:\"fontFamily\";s:24:\"\"Anek Tamil\", sans-serif\";s:4:\"slug\";s:10:\"anek-tamil\";s:8:\"fontFace\";a:8:{i:0;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/anektamil/v18/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNQiZ6rov4oegjOQ.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Tamil\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-tamil/anek-tamil-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/anektamil/v18/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNwid6rov4oegjOQ.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Tamil\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-tamil/anek-tamil-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/anektamil/v18/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNHCd6rov4oegjOQ.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Tamil\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-tamil/anek-tamil-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/anektamil/v18/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNQid6rov4oegjOQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Tamil\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-tamil/anek-tamil-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/anektamil/v18/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNcCd6rov4oegjOQ.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Tamil\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-tamil/anek-tamil-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/anektamil/v18/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNnCB6rov4oegjOQ.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Tamil\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-tamil/anek-tamil-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/anektamil/v18/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNpSB6rov4oegjOQ.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Tamil\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-tamil/anek-tamil-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:114:\"https://fonts.gstatic.com/s/anektamil/v18/XLYJIZH2bYJHGYtPGSbUB8JKTp-_9n55SsLHW0WZez6TjtkDu3uNwiB6rov4oegjOQ.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Anek Tamil\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-tamil/anek-tamil-800-normal.svg\";}}s:7:\"preview\";s:70:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-tamil/anek-tamil.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:80;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:11:\"Anek Telugu\";s:10:\"fontFamily\";s:25:\"\"Anek Telugu\", sans-serif\";s:4:\"slug\";s:11:\"anek-telugu\";s:8:\"fontFace\";a:8:{i:0;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anektelugu/v13/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i13y-_oEiG2ep10_8.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Telugu\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-telugu/anek-telugu-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anektelugu/v13/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i136--oEiG2ep10_8.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Telugu\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-telugu/anek-telugu-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anektelugu/v13/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i133G-oEiG2ep10_8.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Telugu\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-telugu/anek-telugu-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anektelugu/v13/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i13y--oEiG2ep10_8.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Telugu\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-telugu/anek-telugu-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anektelugu/v13/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i13x2-oEiG2ep10_8.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Telugu\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-telugu/anek-telugu-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anektelugu/v13/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i13_G5oEiG2ep10_8.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Telugu\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-telugu/anek-telugu-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anektelugu/v13/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i138i5oEiG2ep10_8.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Telugu\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-telugu/anek-telugu-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:116:\"https://fonts.gstatic.com/s/anektelugu/v13/LhWLMVrUNvsddMtYGCx4FcVWOjlwE1WgXdoJ-5XHMl2DkooGK7i136-5oEiG2ep10_8.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Anek Telugu\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-telugu/anek-telugu-800-normal.svg\";}}s:7:\"preview\";s:72:\"https://s.w.org/images/fonts/wp-6.9/previews/anek-telugu/anek-telugu.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:81;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:6:\"Angkor\";s:10:\"fontFamily\";s:17:\"Angkor, system-ui\";s:4:\"slug\";s:6:\"angkor\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:71:\"https://fonts.gstatic.com/s/angkor/v35/H4cmBXyAlsPdnlb-9yw-4Lqggw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Angkor\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/angkor/angkor-400-normal.svg\";}}s:7:\"preview\";s:62:\"https://s.w.org/images/fonts/wp-6.9/previews/angkor/angkor.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:82;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:13:\"Annapurna SIL\";s:10:\"fontFamily\";s:22:\"\"Annapurna SIL\", serif\";s:4:\"slug\";s:13:\"annapurna-sil\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/annapurnasil/v2/yYLv0hDY0f2iu9tPmRWtllid8NZ9dZT_PZs.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Annapurna SIL\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/annapurna-sil/annapurna-sil-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/annapurnasil/v2/yYLy0hDY0f2iu9tPmRWtllidyG9SUZnUIZJ008A.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Annapurna SIL\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/annapurna-sil/annapurna-sil-700-normal.svg\";}}s:7:\"preview\";s:76:\"https://s.w.org/images/fonts/wp-6.9/previews/annapurna-sil/annapurna-sil.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:83;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:24:\"Annie Use Your Telescope\";s:10:\"fontFamily\";s:35:\"\"Annie Use Your Telescope\", cursive\";s:4:\"slug\";s:24:\"annie-use-your-telescope\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/annieuseyourtelescope/v20/daaLSS4tI2qYYl3Jq9s_Hu74xwktnlKxH6osGVGjkTfB3UUVZA.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:24:\"Annie Use Your Telescope\";s:7:\"preview\";s:109:\"https://s.w.org/images/fonts/wp-6.9/previews/annie-use-your-telescope/annie-use-your-telescope-400-normal.svg\";}}s:7:\"preview\";s:98:\"https://s.w.org/images/fonts/wp-6.9/previews/annie-use-your-telescope/annie-use-your-telescope.svg\";}s:10:\"categories\";a:1:{i:0;s:11:\"handwriting\";}}i:84;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:13:\"Anonymous Pro\";s:10:\"fontFamily\";s:26:\"\"Anonymous Pro\", monospace\";s:4:\"slug\";s:13:\"anonymous-pro\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/anonymouspro/v22/rP2Bp2a15UIB7Un-bOeISG3pLlk89CH98Ko.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anonymous Pro\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anonymous-pro/anonymous-pro-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/anonymouspro/v22/rP2fp2a15UIB7Un-bOeISG3pHl429QP44Kqr2Q.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Anonymous Pro\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anonymous-pro/anonymous-pro-400-italic.svg\";}i:2;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/anonymouspro/v22/rP2cp2a15UIB7Un-bOeISG3pFuAT0CzW7KOywKo.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Anonymous Pro\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anonymous-pro/anonymous-pro-700-normal.svg\";}i:3;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/anonymouspro/v22/rP2ap2a15UIB7Un-bOeISG3pHl4OTCzc7YG30KqB9Q.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:13:\"Anonymous Pro\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/anonymous-pro/anonymous-pro-700-italic.svg\";}}s:7:\"preview\";s:76:\"https://s.w.org/images/fonts/wp-6.9/previews/anonymous-pro/anonymous-pro.svg\";}s:10:\"categories\";a:1:{i:0;s:9:\"monospace\";}}i:85;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:4:\"Anta\";s:10:\"fontFamily\";s:16:\"Anta, sans-serif\";s:4:\"slug\";s:4:\"anta\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:65:\"https://fonts.gstatic.com/s/anta/v1/gyBzhwQ3KsIyZFkxPFimIo0.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Anta\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/anta/anta-400-normal.svg\";}}s:7:\"preview\";s:58:\"https://s.w.org/images/fonts/wp-6.9/previews/anta/anta.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:86;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:5:\"Antic\";s:10:\"fontFamily\";s:17:\"Antic, sans-serif\";s:4:\"slug\";s:5:\"antic\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:68:\"https://fonts.gstatic.com/s/antic/v20/TuGfUVB8XY5DRaZOodgzydtk.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Antic\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/antic/antic-400-normal.svg\";}}s:7:\"preview\";s:60:\"https://s.w.org/images/fonts/wp-6.9/previews/antic/antic.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:87;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:12:\"Antic Didone\";s:10:\"fontFamily\";s:21:\"\"Antic Didone\", serif\";s:4:\"slug\";s:12:\"antic-didone\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:84:\"https://fonts.gstatic.com/s/anticdidone/v17/RWmPoKKX6u8sp8fIWdnDKqDirIsGBGBzCw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Antic Didone\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/antic-didone/antic-didone-400-normal.svg\";}}s:7:\"preview\";s:74:\"https://s.w.org/images/fonts/wp-6.9/previews/antic-didone/antic-didone.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:88;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:10:\"Antic Slab\";s:10:\"fontFamily\";s:19:\"\"Antic Slab\", serif\";s:4:\"slug\";s:10:\"antic-slab\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:79:\"https://fonts.gstatic.com/s/anticslab/v17/bWt97fPFfRzkCa9Jlp6IWcdWXW5p5Qo.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Antic Slab\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/antic-slab/antic-slab-400-normal.svg\";}}s:7:\"preview\";s:70:\"https://s.w.org/images/fonts/wp-6.9/previews/antic-slab/antic-slab.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:89;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:5:\"Anton\";s:10:\"fontFamily\";s:17:\"Anton, sans-serif\";s:4:\"slug\";s:5:\"anton\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:68:\"https://fonts.gstatic.com/s/anton/v27/1Ptgg87LROyAm0Kx8i4gS7lu.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Anton\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/anton/anton-400-normal.svg\";}}s:7:\"preview\";s:60:\"https://s.w.org/images/fonts/wp-6.9/previews/anton/anton.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:90;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:8:\"Anton SC\";s:10:\"fontFamily\";s:22:\"\"Anton SC\", sans-serif\";s:4:\"slug\";s:8:\"anton-sc\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/antonsc/v1/4UaBrEBBsgltGn71sxLjzanB44N1.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Anton SC\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/anton-sc/anton-sc-400-normal.svg\";}}s:7:\"preview\";s:66:\"https://s.w.org/images/fonts/wp-6.9/previews/anton-sc/anton-sc.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:91;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Antonio\";s:10:\"fontFamily\";s:19:\"Antonio, sans-serif\";s:4:\"slug\";s:7:\"antonio\";s:8:\"fontFace\";a:7:{i:0;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/antonio/v22/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVxx8BtNY2DwSXlM.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Antonio\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/antonio/antonio-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/antonio/v22/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVzx8RtNY2DwSXlM.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Antonio\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/antonio/antonio-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/antonio/v22/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVwv8RtNY2DwSXlM.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Antonio\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/antonio/antonio-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/antonio/v22/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVxx8RtNY2DwSXlM.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Antonio\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/antonio/antonio-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/antonio/v22/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVxD8RtNY2DwSXlM.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Antonio\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/antonio/antonio-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/antonio/v22/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVyv9htNY2DwSXlM.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Antonio\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/antonio/antonio-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/antonio/v22/gNMbW3NwSYq_9WD34ngK5F8vR8T0PVyW9htNY2DwSXlM.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Antonio\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/antonio/antonio-700-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/antonio/antonio.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:92;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Anuphan\";s:10:\"fontFamily\";s:19:\"Anuphan, sans-serif\";s:4:\"slug\";s:7:\"anuphan\";s:8:\"fontFace\";a:7:{i:0;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/anuphan/v6/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZCkY9A4hGmW927Gu.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anuphan\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anuphan/anuphan-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/anuphan/v6/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZCmY9Q4hGmW927Gu.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anuphan\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anuphan/anuphan-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/anuphan/v6/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZClG9Q4hGmW927Gu.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anuphan\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anuphan/anuphan-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/anuphan/v6/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZCkY9Q4hGmW927Gu.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anuphan\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anuphan/anuphan-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/anuphan/v6/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZCkq9Q4hGmW927Gu.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anuphan\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anuphan/anuphan-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/anuphan/v6/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZCnG8g4hGmW927Gu.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anuphan\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anuphan/anuphan-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:89:\"https://fonts.gstatic.com/s/anuphan/v6/2sDBZGxYgY7LkLT0s2Yrm5UhuLoIZCn_8g4hGmW927Gu.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anuphan\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anuphan/anuphan-700-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/anuphan/anuphan.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:93;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Anybody\";s:10:\"fontFamily\";s:18:\"Anybody, system-ui\";s:4:\"slug\";s:7:\"anybody\";s:8:\"fontFace\";a:18:{i:0;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/anybody/v13/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4J12HPq8XD_nBPpQ.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/anybody/v13/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JV2DPq8XD_nBPpQ.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/anybody/v13/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JiWDPq8XD_nBPpQ.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/anybody/v13/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4J12DPq8XD_nBPpQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/anybody/v13/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4J5WDPq8XD_nBPpQ.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/anybody/v13/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JCWfPq8XD_nBPpQ.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/anybody/v13/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JMGfPq8XD_nBPpQ.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/anybody/v13/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JV2fPq8XD_nBPpQ.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-800-normal.svg\";}i:8;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/anybody/v13/VuJbdNvK2Ib2ppdWYq311GH32hxIv0sd5grncSUi2F_Wim4JfmfPq8XD_nBPpQ.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-900-normal.svg\";}i:9;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/anybody/v13/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyMn7M_C3HVfpcHY.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-100-italic.svg\";}i:10;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/anybody/v13/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyOn7c_C3HVfpcHY.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-200-italic.svg\";}i:11;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/anybody/v13/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyN57c_C3HVfpcHY.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-300-italic.svg\";}i:12;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/anybody/v13/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyMn7c_C3HVfpcHY.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-400-italic.svg\";}i:13;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/anybody/v13/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyMV7c_C3HVfpcHY.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-500-italic.svg\";}i:14;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/anybody/v13/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyP56s_C3HVfpcHY.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-600-italic.svg\";}i:15;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/anybody/v13/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyPA6s_C3HVfpcHY.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-700-italic.svg\";}i:16;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/anybody/v13/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyOn6s_C3HVfpcHY.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-800-italic.svg\";}i:17;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/anybody/v13/VuJddNvK2Ib2ppdWSKTHN4GOiYrmuF7VpPiuQ9r6sTRMJGkcHyOO6s_C3HVfpcHY.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Anybody\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody-900-italic.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/anybody/anybody.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:94;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:11:\"Aoboshi One\";s:10:\"fontFamily\";s:20:\"\"Aoboshi One\", serif\";s:4:\"slug\";s:11:\"aoboshi-one\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:81:\"https://fonts.gstatic.com/s/aoboshione/v13/Gg8xN5kXaAXtHQrFxwl10ysOBmZX_UEg.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Aoboshi One\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/aoboshi-one/aoboshi-one-400-normal.svg\";}}s:7:\"preview\";s:72:\"https://s.w.org/images/fonts/wp-6.9/previews/aoboshi-one/aoboshi-one.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:95;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:6:\"Arapey\";s:10:\"fontFamily\";s:13:\"Arapey, serif\";s:4:\"slug\";s:6:\"arapey\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:71:\"https://fonts.gstatic.com/s/arapey/v17/-W__XJn-UDDA2RC6YtAcZkIzeg.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Arapey\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/arapey/arapey-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/arapey/v17/-W_9XJn-UDDA2RCKZdodREcjeo0k.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:6:\"Arapey\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/arapey/arapey-400-italic.svg\";}}s:7:\"preview\";s:62:\"https://s.w.org/images/fonts/wp-6.9/previews/arapey/arapey.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:96;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Arbutus\";s:10:\"fontFamily\";s:14:\"Arbutus, serif\";s:4:\"slug\";s:7:\"arbutus\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/arbutus/v30/NaPYcZ7dG_5J3poob9dtryO8fMU.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Arbutus\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/arbutus/arbutus-400-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/arbutus/arbutus.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:97;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:12:\"Arbutus Slab\";s:10:\"fontFamily\";s:21:\"\"Arbutus Slab\", serif\";s:4:\"slug\";s:12:\"arbutus-slab\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:84:\"https://fonts.gstatic.com/s/arbutusslab/v17/oY1Z8e7OuLXkJGbXtr5ba7ZVbq8dJlaFAQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Arbutus Slab\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/arbutus-slab/arbutus-slab-400-normal.svg\";}}s:7:\"preview\";s:74:\"https://s.w.org/images/fonts/wp-6.9/previews/arbutus-slab/arbutus-slab.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:98;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:19:\"Architects Daughter\";s:10:\"fontFamily\";s:30:\"\"Architects Daughter\", cursive\";s:4:\"slug\";s:19:\"architects-daughter\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:100:\"https://fonts.gstatic.com/s/architectsdaughter/v20/KtkxAKiDZI_td1Lkx62xHZHDtgO_Y-bvfYtq4szgE-Q.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:19:\"Architects Daughter\";s:7:\"preview\";s:99:\"https://s.w.org/images/fonts/wp-6.9/previews/architects-daughter/architects-daughter-400-normal.svg\";}}s:7:\"preview\";s:88:\"https://s.w.org/images/fonts/wp-6.9/previews/architects-daughter/architects-daughter.svg\";}s:10:\"categories\";a:1:{i:0;s:11:\"handwriting\";}}i:99;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Archivo\";s:10:\"fontFamily\";s:19:\"Archivo, sans-serif\";s:4:\"slug\";s:7:\"archivo\";s:8:\"fontFace\";a:18:{i:0;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/archivo/v25/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTNDJp9R1oJ0vyVQ.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/archivo/v25/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTtDNp9R1oJ0vyVQ.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/archivo/v25/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTajNp9R1oJ0vyVQ.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/archivo/v25/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTNDNp9R1oJ0vyVQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/archivo/v25/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTBjNp9R1oJ0vyVQ.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/archivo/v25/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTT6jRp9R1oJ0vyVQ.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/archivo/v25/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTT0zRp9R1oJ0vyVQ.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/archivo/v25/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTtDRp9R1oJ0vyVQ.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-800-normal.svg\";}i:8;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/archivo/v25/k3k6o8UDI-1M0wlSV9XAw6lQkqWY8Q82sJaRE-NWIDdgffTTnTRp9R1oJ0vyVQ.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-900-normal.svg\";}i:9;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/archivo/v25/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HCBshdpBU7iVdxQ.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-100-italic.svg\";}i:10;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/archivo/v25/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HABsxdpBU7iVdxQ.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-200-italic.svg\";}i:11;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/archivo/v25/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HDfsxdpBU7iVdxQ.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-300-italic.svg\";}i:12;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/archivo/v25/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HCBsxdpBU7iVdxQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-400-italic.svg\";}i:13;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/archivo/v25/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HCzsxdpBU7iVdxQ.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-500-italic.svg\";}i:14;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/archivo/v25/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HBftBdpBU7iVdxQ.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-600-italic.svg\";}i:15;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/archivo/v25/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HBmtBdpBU7iVdxQ.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-700-italic.svg\";}i:16;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/archivo/v25/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HABtBdpBU7iVdxQ.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-800-italic.svg\";}i:17;a:5:{s:3:\"src\";s:110:\"https://fonts.gstatic.com/s/archivo/v25/k3k8o8UDI-1M0wlSfdzyIEkpwTM29hr-8mTYIRyOSVz60_PG_HAotBdpBU7iVdxQ.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Archivo\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo-900-italic.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo/archivo.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:100;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:13:\"Archivo Black\";s:10:\"fontFamily\";s:27:\"\"Archivo Black\", sans-serif\";s:4:\"slug\";s:13:\"archivo-black\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/archivoblack/v23/HTxqL289NzCGg4MzN6KJ7eW6OY6P_x7yx3A.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:13:\"Archivo Black\";s:7:\"preview\";s:87:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo-black/archivo-black-400-normal.svg\";}}s:7:\"preview\";s:76:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo-black/archivo-black.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:101;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:14:\"Archivo Narrow\";s:10:\"fontFamily\";s:28:\"\"Archivo Narrow\", sans-serif\";s:4:\"slug\";s:14:\"archivo-narrow\";s:8:\"fontFace\";a:8:{i:0;a:5:{s:3:\"src\";s:106:\"https://fonts.gstatic.com/s/archivonarrow/v35/tss5ApVBdCYD5Q7hcxTE1ArZ0Zz8oY2KRmwvKhhvLFGKoXOtFCQ76Q.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Archivo Narrow\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo-narrow/archivo-narrow-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:106:\"https://fonts.gstatic.com/s/archivonarrow/v35/tss5ApVBdCYD5Q7hcxTE1ArZ0Zz8oY2KRmwvKhhvHlGKoXOtFCQ76Q.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Archivo Narrow\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo-narrow/archivo-narrow-500-normal.svg\";}i:2;a:5:{s:3:\"src\";s:106:\"https://fonts.gstatic.com/s/archivonarrow/v35/tss5ApVBdCYD5Q7hcxTE1ArZ0Zz8oY2KRmwvKhhv8laKoXOtFCQ76Q.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Archivo Narrow\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo-narrow/archivo-narrow-600-normal.svg\";}i:3;a:5:{s:3:\"src\";s:106:\"https://fonts.gstatic.com/s/archivonarrow/v35/tss5ApVBdCYD5Q7hcxTE1ArZ0Zz8oY2KRmwvKhhvy1aKoXOtFCQ76Q.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Archivo Narrow\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo-narrow/archivo-narrow-700-normal.svg\";}i:4;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/archivonarrow/v35/tss7ApVBdCYD5Q7hcxTE1ArZ0bb1k3JSLwe1hB965BJi53msNiEr6T6Y.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Archivo Narrow\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo-narrow/archivo-narrow-400-italic.svg\";}i:5;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/archivonarrow/v35/tss7ApVBdCYD5Q7hcxTE1ArZ0bb1k3JSLwe1hB965BJQ53msNiEr6T6Y.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Archivo Narrow\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo-narrow/archivo-narrow-500-italic.svg\";}i:6;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/archivonarrow/v35/tss7ApVBdCYD5Q7hcxTE1ArZ0bb1k3JSLwe1hB965BK84HmsNiEr6T6Y.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Archivo Narrow\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo-narrow/archivo-narrow-600-italic.svg\";}i:7;a:5:{s:3:\"src\";s:108:\"https://fonts.gstatic.com/s/archivonarrow/v35/tss7ApVBdCYD5Q7hcxTE1ArZ0bb1k3JSLwe1hB965BKF4HmsNiEr6T6Y.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Archivo Narrow\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo-narrow/archivo-narrow-700-italic.svg\";}}s:7:\"preview\";s:78:\"https://s.w.org/images/fonts/wp-6.9/previews/archivo-narrow/archivo-narrow.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:102;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:15:\"Are You Serious\";s:10:\"fontFamily\";s:26:\"\"Are You Serious\", cursive\";s:4:\"slug\";s:15:\"are-you-serious\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/areyouserious/v14/ll8kK2GVSSr-PtjQ5nONVcNn4306gD9nCGRayg.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:15:\"Are You Serious\";s:7:\"preview\";s:91:\"https://s.w.org/images/fonts/wp-6.9/previews/are-you-serious/are-you-serious-400-normal.svg\";}}s:7:\"preview\";s:80:\"https://s.w.org/images/fonts/wp-6.9/previews/are-you-serious/are-you-serious.svg\";}s:10:\"categories\";a:1:{i:0;s:11:\"handwriting\";}}i:103;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:10:\"Aref Ruqaa\";s:10:\"fontFamily\";s:19:\"\"Aref Ruqaa\", serif\";s:4:\"slug\";s:10:\"aref-ruqaa\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:79:\"https://fonts.gstatic.com/s/arefruqaa/v26/WwkbxPW1E165rajQKDulEIUiVNo5xNY.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Aref Ruqaa\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/aref-ruqaa/aref-ruqaa-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:83:\"https://fonts.gstatic.com/s/arefruqaa/v26/WwkYxPW1E165rajQKDulKDwNcNcS2N_7Bdk.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Aref Ruqaa\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/aref-ruqaa/aref-ruqaa-700-normal.svg\";}}s:7:\"preview\";s:70:\"https://s.w.org/images/fonts/wp-6.9/previews/aref-ruqaa/aref-ruqaa.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:104;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:14:\"Aref Ruqaa Ink\";s:10:\"fontFamily\";s:23:\"\"Aref Ruqaa Ink\", serif\";s:4:\"slug\";s:14:\"aref-ruqaa-ink\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:87:\"https://fonts.gstatic.com/s/arefruqaaink/v11/1q2fY5WOGUFlt84GTOkP6Kdx72TkVIGpgnxL.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Aref Ruqaa Ink\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/aref-ruqaa-ink/aref-ruqaa-ink-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:91:\"https://fonts.gstatic.com/s/arefruqaaink/v11/1q2cY5WOGUFlt84GTOkP6Kdx71xde6WkqWBCyxWn.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Aref Ruqaa Ink\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/aref-ruqaa-ink/aref-ruqaa-ink-700-normal.svg\";}}s:7:\"preview\";s:78:\"https://s.w.org/images/fonts/wp-6.9/previews/aref-ruqaa-ink/aref-ruqaa-ink.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:105;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:5:\"Arima\";s:10:\"fontFamily\";s:16:\"Arima, system-ui\";s:4:\"slug\";s:5:\"arima\";s:8:\"fontFace\";a:7:{i:0;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/arima/v7/neIWzCqmt4Aup_qE1nFWqxI1RZX1YTE-oAGOyYw2fw.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Arima\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arima/arima-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/arima/v7/neIWzCqmt4Aup_qE1nFWqxI1RZX14TA-oAGOyYw2fw.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Arima\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arima/arima-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/arima/v7/neIWzCqmt4Aup_qE1nFWqxI1RZX1PzA-oAGOyYw2fw.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Arima\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arima/arima-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/arima/v7/neIWzCqmt4Aup_qE1nFWqxI1RZX1YTA-oAGOyYw2fw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Arima\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arima/arima-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/arima/v7/neIWzCqmt4Aup_qE1nFWqxI1RZX1UzA-oAGOyYw2fw.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Arima\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arima/arima-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/arima/v7/neIWzCqmt4Aup_qE1nFWqxI1RZX1vzc-oAGOyYw2fw.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Arima\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arima/arima-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/arima/v7/neIWzCqmt4Aup_qE1nFWqxI1RZX1hjc-oAGOyYw2fw.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Arima\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arima/arima-700-normal.svg\";}}s:7:\"preview\";s:60:\"https://s.w.org/images/fonts/wp-6.9/previews/arima/arima.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:106;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:5:\"Arimo\";s:10:\"fontFamily\";s:17:\"Arimo, sans-serif\";s:4:\"slug\";s:5:\"arimo\";s:8:\"fontFace\";a:8:{i:0;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/arimo/v35/P5sfzZCDf9_T_3cV7NCUECyoxNk37cxsAhDAVQI4aA.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Arimo\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arimo/arimo-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/arimo/v35/P5sfzZCDf9_T_3cV7NCUECyoxNk338xsAhDAVQI4aA.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Arimo\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arimo/arimo-500-normal.svg\";}i:2;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/arimo/v35/P5sfzZCDf9_T_3cV7NCUECyoxNk3M8tsAhDAVQI4aA.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Arimo\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arimo/arimo-600-normal.svg\";}i:3;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/arimo/v35/P5sfzZCDf9_T_3cV7NCUECyoxNk3CstsAhDAVQI4aA.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Arimo\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arimo/arimo-700-normal.svg\";}i:4;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/arimo/v35/P5sdzZCDf9_T_10c3i9MeUcyat4iJY-ERBrBdwcoaKww.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:5:\"Arimo\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arimo/arimo-400-italic.svg\";}i:5;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/arimo/v35/P5sdzZCDf9_T_10c3i9MeUcyat4iJY-2RBrBdwcoaKww.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:5:\"Arimo\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arimo/arimo-500-italic.svg\";}i:6;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/arimo/v35/P5sdzZCDf9_T_10c3i9MeUcyat4iJY9aQxrBdwcoaKww.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:5:\"Arimo\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arimo/arimo-600-italic.svg\";}i:7;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/arimo/v35/P5sdzZCDf9_T_10c3i9MeUcyat4iJY9jQxrBdwcoaKww.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:5:\"Arimo\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/arimo/arimo-700-italic.svg\";}}s:7:\"preview\";s:60:\"https://s.w.org/images/fonts/wp-6.9/previews/arimo/arimo.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:107;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:8:\"Arizonia\";s:10:\"fontFamily\";s:17:\"Arizonia, cursive\";s:4:\"slug\";s:8:\"arizonia\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:75:\"https://fonts.gstatic.com/s/arizonia/v23/neIIzCemt4A5qa7mv6WDHK06UY30.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Arizonia\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/arizonia/arizonia-400-normal.svg\";}}s:7:\"preview\";s:66:\"https://s.w.org/images/fonts/wp-6.9/previews/arizonia/arizonia.svg\";}s:10:\"categories\";a:1:{i:0;s:11:\"handwriting\";}}i:108;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:6:\"Armata\";s:10:\"fontFamily\";s:18:\"Armata, sans-serif\";s:4:\"slug\";s:6:\"armata\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:71:\"https://fonts.gstatic.com/s/armata/v21/gokvH63_HV5jQ-E9kT53Q2u_mQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Armata\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/armata/armata-400-normal.svg\";}}s:7:\"preview\";s:62:\"https://s.w.org/images/fonts/wp-6.9/previews/armata/armata.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:109;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Arsenal\";s:10:\"fontFamily\";s:19:\"Arsenal, sans-serif\";s:4:\"slug\";s:7:\"arsenal\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/arsenal/v13/wXKrE3kQtZQ4pF3D11rWAewrhXY.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Arsenal\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/arsenal/arsenal-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:76:\"https://fonts.gstatic.com/s/arsenal/v13/wXKpE3kQtZQ4pF3D513cAM4ulXYrtA.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Arsenal\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/arsenal/arsenal-400-italic.svg\";}i:2;a:5:{s:3:\"src\";s:77:\"https://fonts.gstatic.com/s/arsenal/v13/wXKuE3kQtZQ4pF3D7-P5JeEAmX8yrdk.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Arsenal\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/arsenal/arsenal-700-normal.svg\";}i:3;a:5:{s:3:\"src\";s:80:\"https://fonts.gstatic.com/s/arsenal/v13/wXKsE3kQtZQ4pF3D513kueEKmF03vdnKjw.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:7:\"Arsenal\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/arsenal/arsenal-700-italic.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/arsenal/arsenal.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:110;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:10:\"Arsenal SC\";s:10:\"fontFamily\";s:24:\"\"Arsenal SC\", sans-serif\";s:4:\"slug\";s:10:\"arsenal-sc\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:78:\"https://fonts.gstatic.com/s/arsenalsc/v1/x3dlckLHea6e5BEtsfxiXN8ssybsHQI.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Arsenal SC\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/arsenal-sc/arsenal-sc-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:81:\"https://fonts.gstatic.com/s/arsenalsc/v1/x3dnckLHea6e5BEtsfxibNgmsgTpDQIrGg.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Arsenal SC\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/arsenal-sc/arsenal-sc-400-italic.svg\";}i:2;a:5:{s:3:\"src\";s:82:\"https://fonts.gstatic.com/s/arsenalsc/v1/x3dmckLHea6e5BEtsfxiZGYDlyvHAQsyA2Y.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Arsenal SC\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/arsenal-sc/arsenal-sc-700-normal.svg\";}i:3;a:5:{s:3:\"src\";s:85:\"https://fonts.gstatic.com/s/arsenalsc/v1/x3d4ckLHea6e5BEtsfxibNgeCyvNACk3E2YljQ.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:10:\"Arsenal SC\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/arsenal-sc/arsenal-sc-700-italic.svg\";}}s:7:\"preview\";s:70:\"https://s.w.org/images/fonts/wp-6.9/previews/arsenal-sc/arsenal-sc.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:111;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:8:\"Artifika\";s:10:\"fontFamily\";s:15:\"Artifika, serif\";s:4:\"slug\";s:8:\"artifika\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:75:\"https://fonts.gstatic.com/s/artifika/v22/VEMyRoxzronptCuxu6Wo5jDtreOL.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:8:\"Artifika\";s:7:\"preview\";s:77:\"https://s.w.org/images/fonts/wp-6.9/previews/artifika/artifika-400-normal.svg\";}}s:7:\"preview\";s:66:\"https://s.w.org/images/fonts/wp-6.9/previews/artifika/artifika.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:112;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:4:\"Arvo\";s:10:\"fontFamily\";s:11:\"Arvo, serif\";s:4:\"slug\";s:4:\"arvo\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:66:\"https://fonts.gstatic.com/s/arvo/v23/tDbD2oWUg0MKmSUa7Lzr7vs.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Arvo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/arvo/arvo-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:69:\"https://fonts.gstatic.com/s/arvo/v23/tDbN2oWUg0MKqSIQ7Z7u_vvijQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Arvo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/arvo/arvo-400-italic.svg\";}i:2;a:5:{s:3:\"src\";s:70:\"https://fonts.gstatic.com/s/arvo/v23/tDbM2oWUg0MKoZw1yLHA8vL7lAE.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Arvo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/arvo/arvo-700-normal.svg\";}i:3;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/arvo/v23/tDbO2oWUg0MKqSIoVLHK89D-hAHkGg.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Arvo\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/arvo/arvo-700-italic.svg\";}}s:7:\"preview\";s:58:\"https://s.w.org/images/fonts/wp-6.9/previews/arvo/arvo.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:113;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:4:\"Arya\";s:10:\"fontFamily\";s:16:\"Arya, sans-serif\";s:4:\"slug\";s:4:\"arya\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:66:\"https://fonts.gstatic.com/s/arya/v21/ga6CawNG-HJd9UP1-beqdFE.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Arya\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/arya/arya-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:70:\"https://fonts.gstatic.com/s/arya/v21/ga6NawNG-HJdzfra3bqBaFg3dRE.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Arya\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/arya/arya-700-normal.svg\";}}s:7:\"preview\";s:58:\"https://s.w.org/images/fonts/wp-6.9/previews/arya/arya.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:114;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:4:\"Asap\";s:10:\"fontFamily\";s:16:\"Asap, sans-serif\";s:4:\"slug\";s:4:\"asap\";s:8:\"fontFace\";a:18:{i:0;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/asap/v34/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYkqQsK2OXoA7Glw.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/asap/v34/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYEqUsK2OXoA7Glw.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/asap/v34/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYzKUsK2OXoA7Glw.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/asap/v34/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYkqUsK2OXoA7Glw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/asap/v34/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYoKUsK2OXoA7Glw.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/asap/v34/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYTKIsK2OXoA7Glw.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/asap/v34/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYdaIsK2OXoA7Glw.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/asap/v34/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYEqIsK2OXoA7Glw.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-800-normal.svg\";}i:8;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/asap/v34/KFOOCniXp96a4Tc2DaTeuDAoKsE617JFc49knOIYdjTYO6IsK2OXoA7Glw.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-900-normal.svg\";}i:9;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/asap/v34/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWubEbGmWggvWl0Qn.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-100-italic.svg\";}i:10;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/asap/v34/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuZEbWmWggvWl0Qn.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-200-italic.svg\";}i:11;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/asap/v34/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuaabWmWggvWl0Qn.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-300-italic.svg\";}i:12;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/asap/v34/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWubEbWmWggvWl0Qn.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-400-italic.svg\";}i:13;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/asap/v34/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWub2bWmWggvWl0Qn.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-500-italic.svg\";}i:14;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/asap/v34/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuYaammWggvWl0Qn.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-600-italic.svg\";}i:15;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/asap/v34/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuYjammWggvWl0Qn.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-700-italic.svg\";}i:16;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/asap/v34/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuZEammWggvWl0Qn.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-800-italic.svg\";}i:17;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/asap/v34/KFOMCniXp96ayz4E7kSn66aGLdTylUAMQXC89YmC2DPNWuZtammWggvWl0Qn.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"Asap\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap-900-italic.svg\";}}s:7:\"preview\";s:58:\"https://s.w.org/images/fonts/wp-6.9/previews/asap/asap.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:115;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:14:\"Asap Condensed\";s:10:\"fontFamily\";s:28:\"\"Asap Condensed\", sans-serif\";s:4:\"slug\";s:14:\"asap-condensed\";s:8:\"fontFace\";a:16:{i:0;a:5:{s:3:\"src\";s:92:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxieypY1o9NHyXh3WvSbGSggdO9DSWlBgGqgp-pO.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-200-normal.svg\";}i:1;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxiYypY1o9NHyXh3WvSbGSggdOeJUIFFimuCovpOkXA.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-200-italic.svg\";}i:2;a:5:{s:3:\"src\";s:92:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxieypY1o9NHyXh3WvSbGSggdO8nSmlBgGqgp-pO.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxiYypY1o9NHyXh3WvSbGSggdOeJUOVGimuCovpOkXA.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-300-italic.svg\";}i:4;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxidypY1o9NHyXh3WvSbGSggdNeOYk1Mq3ap.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-400-normal.svg\";}i:5;a:5:{s:3:\"src\";s:91:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxifypY1o9NHyXh3WvSbGSggdOeJaExurmapvvM.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-400-italic.svg\";}i:6;a:5:{s:3:\"src\";s:92:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxieypY1o9NHyXh3WvSbGSggdO9_S2lBgGqgp-pO.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-500-normal.svg\";}i:7;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxiYypY1o9NHyXh3WvSbGSggdOeJUL1HimuCovpOkXA.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-500-italic.svg\";}i:8;a:5:{s:3:\"src\";s:92:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxieypY1o9NHyXh3WvSbGSggdO9TTGlBgGqgp-pO.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-600-normal.svg\";}i:9;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxiYypY1o9NHyXh3WvSbGSggdOeJUJFAimuCovpOkXA.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-600-italic.svg\";}i:10;a:5:{s:3:\"src\";s:92:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxieypY1o9NHyXh3WvSbGSggdO83TWlBgGqgp-pO.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-700-normal.svg\";}i:11;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxiYypY1o9NHyXh3WvSbGSggdOeJUPVBimuCovpOkXA.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-700-italic.svg\";}i:12;a:5:{s:3:\"src\";s:92:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxieypY1o9NHyXh3WvSbGSggdO8rTmlBgGqgp-pO.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-800-normal.svg\";}i:13;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxiYypY1o9NHyXh3WvSbGSggdOeJUOlCimuCovpOkXA.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-800-italic.svg\";}i:14;a:5:{s:3:\"src\";s:92:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxieypY1o9NHyXh3WvSbGSggdO8PT2lBgGqgp-pO.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-900-normal.svg\";}i:15;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/asapcondensed/v18/pxiYypY1o9NHyXh3WvSbGSggdOeJUM1DimuCovpOkXA.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:14:\"Asap Condensed\";s:7:\"preview\";s:89:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed-900-italic.svg\";}}s:7:\"preview\";s:78:\"https://s.w.org/images/fonts/wp-6.9/previews/asap-condensed/asap-condensed.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:116;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:4:\"Asar\";s:10:\"fontFamily\";s:11:\"Asar, serif\";s:4:\"slug\";s:4:\"asar\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:66:\"https://fonts.gstatic.com/s/asar/v24/sZlLdRyI6TBIXkMQDLlTW6E.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Asar\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asar/asar-400-normal.svg\";}}s:7:\"preview\";s:58:\"https://s.w.org/images/fonts/wp-6.9/previews/asar/asar.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:117;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:9:\"Asimovian\";s:10:\"fontFamily\";s:21:\"Asimovian, sans-serif\";s:4:\"slug\";s:9:\"asimovian\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:77:\"https://fonts.gstatic.com/s/asimovian/v2/oY1c8evOub78P2XN94MXD_5xY4QBLw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Asimovian\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/asimovian/asimovian-400-normal.svg\";}}s:7:\"preview\";s:68:\"https://s.w.org/images/fonts/wp-6.9/previews/asimovian/asimovian.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:118;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:5:\"Asset\";s:10:\"fontFamily\";s:16:\"Asset, system-ui\";s:4:\"slug\";s:5:\"asset\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:68:\"https://fonts.gstatic.com/s/asset/v30/SLXGc1na-mM4cWIjRJqExst1.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:5:\"Asset\";s:7:\"preview\";s:71:\"https://s.w.org/images/fonts/wp-6.9/previews/asset/asset-400-normal.svg\";}}s:7:\"preview\";s:60:\"https://s.w.org/images/fonts/wp-6.9/previews/asset/asset.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:119;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:9:\"Assistant\";s:10:\"fontFamily\";s:21:\"Assistant, sans-serif\";s:4:\"slug\";s:9:\"assistant\";s:8:\"fontFace\";a:7:{i:0;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/assistant/v24/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtmZnEGSf3qGuvM4.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Assistant\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/assistant/assistant-200-normal.svg\";}i:1;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/assistant/v24/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtrhnEGSf3qGuvM4.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Assistant\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/assistant/assistant-300-normal.svg\";}i:2;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/assistant/v24/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtuZnEGSf3qGuvM4.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Assistant\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/assistant/assistant-400-normal.svg\";}i:3;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/assistant/v24/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQttRnEGSf3qGuvM4.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Assistant\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/assistant/assistant-500-normal.svg\";}i:4;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/assistant/v24/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtjhgEGSf3qGuvM4.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Assistant\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/assistant/assistant-600-normal.svg\";}i:5;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/assistant/v24/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtgFgEGSf3qGuvM4.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Assistant\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/assistant/assistant-700-normal.svg\";}i:6;a:5:{s:3:\"src\";s:95:\"https://fonts.gstatic.com/s/assistant/v24/2sDPZGJYnIjSi6H75xkZZE1I0yCmYzzQtmZgEGSf3qGuvM4.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Assistant\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/assistant/assistant-800-normal.svg\";}}s:7:\"preview\";s:68:\"https://s.w.org/images/fonts/wp-6.9/previews/assistant/assistant.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:120;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:9:\"Asta Sans\";s:10:\"fontFamily\";s:23:\"\"Asta Sans\", sans-serif\";s:4:\"slug\";s:9:\"asta-sans\";s:8:\"fontFace\";a:6:{i:0;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/astasans/v3/XoH32Y74XaWovvhMb0c3tN_dRqdT9zveo6r_mVzvqYRoVr0.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Asta Sans\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/asta-sans/asta-sans-300-normal.svg\";}i:1;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/astasans/v3/XoH32Y74XaWovvhMb0c3tN_dRqdT9zveo_T_mVzvqYRoVr0.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Asta Sans\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/asta-sans/asta-sans-400-normal.svg\";}i:2;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/astasans/v3/XoH32Y74XaWovvhMb0c3tN_dRqdT9zveo8b_mVzvqYRoVr0.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Asta Sans\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/asta-sans/asta-sans-500-normal.svg\";}i:3;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/astasans/v3/XoH32Y74XaWovvhMb0c3tN_dRqdT9zveoyr4mVzvqYRoVr0.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Asta Sans\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/asta-sans/asta-sans-600-normal.svg\";}i:4;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/astasans/v3/XoH32Y74XaWovvhMb0c3tN_dRqdT9zveoxP4mVzvqYRoVr0.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Asta Sans\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/asta-sans/asta-sans-700-normal.svg\";}i:5;a:5:{s:3:\"src\";s:93:\"https://fonts.gstatic.com/s/astasans/v3/XoH32Y74XaWovvhMb0c3tN_dRqdT9zveo3T4mVzvqYRoVr0.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Asta Sans\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/asta-sans/asta-sans-800-normal.svg\";}}s:7:\"preview\";s:68:\"https://s.w.org/images/fonts/wp-6.9/previews/asta-sans/asta-sans.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:121;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Astloch\";s:10:\"fontFamily\";s:18:\"Astloch, system-ui\";s:4:\"slug\";s:7:\"astloch\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/astloch/v27/TuGRUVJ8QI5GSeUjq9kRzMtkH1Q.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Astloch\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/astloch/astloch-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:77:\"https://fonts.gstatic.com/s/astloch/v27/TuGUUVJ8QI5GSeUjk2A-6MZPA10xLMQ.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Astloch\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/astloch/astloch-700-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/astloch/astloch.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:122;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:4:\"Asul\";s:10:\"fontFamily\";s:11:\"Asul, serif\";s:4:\"slug\";s:4:\"asul\";s:8:\"fontFace\";a:2:{i:0;a:5:{s:3:\"src\";s:66:\"https://fonts.gstatic.com/s/asul/v22/VuJ-dNjKxYr46fYFXK78JIg.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Asul\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asul/asul-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:70:\"https://fonts.gstatic.com/s/asul/v22/VuJxdNjKxYr40U8qeKPXOIFneRo.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Asul\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/asul/asul-700-normal.svg\";}}s:7:\"preview\";s:58:\"https://s.w.org/images/fonts/wp-6.9/previews/asul/asul.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:123;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:6:\"Athiti\";s:10:\"fontFamily\";s:18:\"Athiti, sans-serif\";s:4:\"slug\";s:6:\"athiti\";s:8:\"fontFace\";a:6:{i:0;a:5:{s:3:\"src\";s:75:\"https://fonts.gstatic.com/s/athiti/v14/pe0sMISdLIZIv1wAxDNyB_2-C99ycg.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Athiti\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/athiti/athiti-200-normal.svg\";}i:1;a:5:{s:3:\"src\";s:75:\"https://fonts.gstatic.com/s/athiti/v14/pe0sMISdLIZIv1wAoDByB_2-C99ycg.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Athiti\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/athiti/athiti-300-normal.svg\";}i:2;a:5:{s:3:\"src\";s:71:\"https://fonts.gstatic.com/s/athiti/v14/pe0vMISdLIZIv1w4CRhWCtaiAg.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Athiti\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/athiti/athiti-400-normal.svg\";}i:3;a:5:{s:3:\"src\";s:75:\"https://fonts.gstatic.com/s/athiti/v14/pe0sMISdLIZIv1wA-DFyB_2-C99ycg.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Athiti\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/athiti/athiti-500-normal.svg\";}i:4;a:5:{s:3:\"src\";s:75:\"https://fonts.gstatic.com/s/athiti/v14/pe0sMISdLIZIv1wA1DZyB_2-C99ycg.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Athiti\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/athiti/athiti-600-normal.svg\";}i:5;a:5:{s:3:\"src\";s:75:\"https://fonts.gstatic.com/s/athiti/v14/pe0sMISdLIZIv1wAsDdyB_2-C99ycg.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Athiti\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/athiti/athiti-700-normal.svg\";}}s:7:\"preview\";s:62:\"https://s.w.org/images/fonts/wp-6.9/previews/athiti/athiti.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:124;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:21:\"Atkinson Hyperlegible\";s:10:\"fontFamily\";s:35:\"\"Atkinson Hyperlegible\", sans-serif\";s:4:\"slug\";s:21:\"atkinson-hyperlegible\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:105:\"https://fonts.gstatic.com/s/atkinsonhyperlegible/v12/9Bt23C1KxNDXMspQ1lPyU89-1h6ONRlW45GE4JgpewSSbQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:21:\"Atkinson Hyperlegible\";s:7:\"preview\";s:103:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible/atkinson-hyperlegible-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:107:\"https://fonts.gstatic.com/s/atkinsonhyperlegible/v12/9Bt43C1KxNDXMspQ1lPyU89-1h6ONRlW45G055IoWQGCbUWn.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:21:\"Atkinson Hyperlegible\";s:7:\"preview\";s:103:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible/atkinson-hyperlegible-400-italic.svg\";}i:2;a:5:{s:3:\"src\";s:109:\"https://fonts.gstatic.com/s/atkinsonhyperlegible/v12/9Bt73C1KxNDXMspQ1lPyU89-1h6ONRlW45G8WbcNdi-OZFy-FA.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:21:\"Atkinson Hyperlegible\";s:7:\"preview\";s:103:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible/atkinson-hyperlegible-700-normal.svg\";}i:3;a:5:{s:3:\"src\";s:111:\"https://fonts.gstatic.com/s/atkinsonhyperlegible/v12/9Bt93C1KxNDXMspQ1lPyU89-1h6ONRlW45G056qRdiWPRlmuFH24.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:21:\"Atkinson Hyperlegible\";s:7:\"preview\";s:103:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible/atkinson-hyperlegible-700-italic.svg\";}}s:7:\"preview\";s:92:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible/atkinson-hyperlegible.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:125;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:26:\"Atkinson Hyperlegible Mono\";s:10:\"fontFamily\";s:40:\"\"Atkinson Hyperlegible Mono\", sans-serif\";s:4:\"slug\";s:26:\"atkinson-hyperlegible-mono\";s:8:\"fontFace\";a:14:{i:0;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZnNeiCCkb2qzelw.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-200-normal.svg\";}i:1;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZQteiCCkb2qzelw.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-300-normal.svg\";}i:2;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZHNeiCCkb2qzelw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-400-normal.svg\";}i:3;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZLteiCCkb2qzelw.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-500-normal.svg\";}i:4;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZwtCiCCkb2qzelw.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-600-normal.svg\";}i:5;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZ-9CiCCkb2qzelw.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-700-normal.svg\";}i:6;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssNAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiyihrK15gZ4k_SaZnNCiCCkb2qzelw.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-800-normal.svg\";}i:7;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JTKTiMa-KnOlxYs.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-200-italic.svg\";}i:8;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JQUTiMa-KnOlxYs.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-300-italic.svg\";}i:9;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JRKTiMa-KnOlxYs.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-400-italic.svg\";}i:10;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JR4TiMa-KnOlxYs.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-500-italic.svg\";}i:11;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JSUSSMa-KnOlxYs.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-600-italic.svg\";}i:12;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JStSSMa-KnOlxYs.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-700-italic.svg\";}i:13;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblemono/v8/tssPAoFBci4C4gvhPXrt3wjT1MqSzhA4t7IIcncBiwKonlKh6PW-UyGM1JTKSSMa-KnOlxYs.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Mono\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono-800-italic.svg\";}}s:7:\"preview\";s:102:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-mono/atkinson-hyperlegible-mono.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:126;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:26:\"Atkinson Hyperlegible Next\";s:10:\"fontFamily\";s:40:\"\"Atkinson Hyperlegible Next\", sans-serif\";s:4:\"slug\";s:26:\"atkinson-hyperlegible-next\";s:8:\"fontFace\";a:14:{i:0;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW3bLQhsdl93TwPEQ.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-200-normal.svg\";}i:1;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW3srQhsdl93TwPEQ.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-300-normal.svg\";}i:2;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW37LQhsdl93TwPEQ.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-400-normal.svg\";}i:3;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW33rQhsdl93TwPEQ.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-500-normal.svg\";}i:4;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW3MrMhsdl93TwPEQ.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-600-normal.svg\";}i:5;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW3C7Mhsdl93TwPEQ.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-700-normal.svg\";}i:6;a:5:{s:3:\"src\";s:132:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP4cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGscKFt4tOOfV4ZmW3bLMhsdl93TwPEQ.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-800-normal.svg\";}i:7;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPdJ99N8_zkfEYNP.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-200-italic.svg\";}i:8;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPeX99N8_zkfEYNP.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-300-italic.svg\";}i:9;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPfJ99N8_zkfEYNP.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-400-italic.svg\";}i:10;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPf799N8_zkfEYNP.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-500-italic.svg\";}i:11;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPcX8NN8_zkfEYNP.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-600-italic.svg\";}i:12;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPcu8NN8_zkfEYNP.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-700-italic.svg\";}i:13;a:5:{s:3:\"src\";s:134:\"https://fonts.gstatic.com/s/atkinsonhyperlegiblenext/v7/NaP6cYPdHfdVxJw0IfIP0lvYFqijb-UxCtm5_wdGseiMhXSWUJ7iyGKiJPdJ8NN8_zkfEYNP.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:26:\"Atkinson Hyperlegible Next\";s:7:\"preview\";s:113:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next-800-italic.svg\";}}s:7:\"preview\";s:102:\"https://s.w.org/images/fonts/wp-6.9/previews/atkinson-hyperlegible-next/atkinson-hyperlegible-next.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:127;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:4:\"Atma\";s:10:\"fontFamily\";s:15:\"Atma, system-ui\";s:4:\"slug\";s:4:\"atma\";s:8:\"fontFace\";a:5:{i:0;a:5:{s:3:\"src\";s:70:\"https://fonts.gstatic.com/s/atma/v19/uK_z4rqWc-Eoo8JzKjI9PvedRkM.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Atma\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/atma/atma-300-normal.svg\";}i:1;a:5:{s:3:\"src\";s:66:\"https://fonts.gstatic.com/s/atma/v19/uK_84rqWc-Eom2tbDj8WIv4.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Atma\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/atma/atma-400-normal.svg\";}i:2;a:5:{s:3:\"src\";s:70:\"https://fonts.gstatic.com/s/atma/v19/uK_z4rqWc-Eoo5pyKjI9PvedRkM.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Atma\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/atma/atma-500-normal.svg\";}i:3;a:5:{s:3:\"src\";s:70:\"https://fonts.gstatic.com/s/atma/v19/uK_z4rqWc-Eoo7Z1KjI9PvedRkM.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Atma\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/atma/atma-600-normal.svg\";}i:4;a:5:{s:3:\"src\";s:70:\"https://fonts.gstatic.com/s/atma/v19/uK_z4rqWc-Eoo9J0KjI9PvedRkM.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"Atma\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/atma/atma-700-normal.svg\";}}s:7:\"preview\";s:58:\"https://s.w.org/images/fonts/wp-6.9/previews/atma/atma.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:128;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:10:\"Atomic Age\";s:10:\"fontFamily\";s:23:\"\"Atomic Age\", system-ui\";s:4:\"slug\";s:10:\"atomic-age\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:79:\"https://fonts.gstatic.com/s/atomicage/v29/f0Xz0eug6sdmRFkYZZGL58Tt9a8GYeA.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Atomic Age\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/atomic-age/atomic-age-400-normal.svg\";}}s:7:\"preview\";s:70:\"https://s.w.org/images/fonts/wp-6.9/previews/atomic-age/atomic-age.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:129;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:6:\"Aubrey\";s:10:\"fontFamily\";s:17:\"Aubrey, system-ui\";s:4:\"slug\";s:6:\"aubrey\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:71:\"https://fonts.gstatic.com/s/aubrey/v29/q5uGsou7NPBw-p7vvwNsCxVEgA.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:6:\"Aubrey\";s:7:\"preview\";s:73:\"https://s.w.org/images/fonts/wp-6.9/previews/aubrey/aubrey-400-normal.svg\";}}s:7:\"preview\";s:62:\"https://s.w.org/images/fonts/wp-6.9/previews/aubrey/aubrey.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:130;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:9:\"Audiowide\";s:10:\"fontFamily\";s:20:\"Audiowide, system-ui\";s:4:\"slug\";s:9:\"audiowide\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:78:\"https://fonts.gstatic.com/s/audiowide/v22/l7gdbjpo0cum0ckerWCtlAXPExpQBw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"Audiowide\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/audiowide/audiowide-400-normal.svg\";}}s:7:\"preview\";s:68:\"https://s.w.org/images/fonts/wp-6.9/previews/audiowide/audiowide.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:131;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:10:\"Autour One\";s:10:\"fontFamily\";s:23:\"\"Autour One\", system-ui\";s:4:\"slug\";s:10:\"autour-one\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:79:\"https://fonts.gstatic.com/s/autourone/v25/UqyVK80cP25l3fJgbdfbk5xWVscxdKE.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:10:\"Autour One\";s:7:\"preview\";s:81:\"https://s.w.org/images/fonts/wp-6.9/previews/autour-one/autour-one-400-normal.svg\";}}s:7:\"preview\";s:70:\"https://s.w.org/images/fonts/wp-6.9/previews/autour-one/autour-one.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:132;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:7:\"Average\";s:10:\"fontFamily\";s:14:\"Average, serif\";s:4:\"slug\";s:7:\"average\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/average/v19/fC1hPYBHe23MxA7rIedwVWytTyk.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:7:\"Average\";s:7:\"preview\";s:75:\"https://s.w.org/images/fonts/wp-6.9/previews/average/average-400-normal.svg\";}}s:7:\"preview\";s:64:\"https://s.w.org/images/fonts/wp-6.9/previews/average/average.svg\";}s:10:\"categories\";a:1:{i:0;s:5:\"serif\";}}i:133;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:12:\"Average Sans\";s:10:\"fontFamily\";s:26:\"\"Average Sans\", sans-serif\";s:4:\"slug\";s:12:\"average-sans\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:84:\"https://fonts.gstatic.com/s/averagesans/v17/1Ptpg8fLXP2dlAXR-HlJJNJPANqazVoK4A.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Average Sans\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/average-sans/average-sans-400-normal.svg\";}}s:7:\"preview\";s:74:\"https://s.w.org/images/fonts/wp-6.9/previews/average-sans/average-sans.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:134;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:19:\"Averia Gruesa Libre\";s:10:\"fontFamily\";s:32:\"\"Averia Gruesa Libre\", system-ui\";s:4:\"slug\";s:19:\"averia-gruesa-libre\";s:8:\"fontFace\";a:1:{i:0;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/averiagruesalibre/v22/NGSov4nEGEktOaDRKsY-1dhh8eEtIx3ZUmyJw0SLRA8.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:19:\"Averia Gruesa Libre\";s:7:\"preview\";s:99:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-gruesa-libre/averia-gruesa-libre-400-normal.svg\";}}s:7:\"preview\";s:88:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-gruesa-libre/averia-gruesa-libre.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:135;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:12:\"Averia Libre\";s:10:\"fontFamily\";s:25:\"\"Averia Libre\", system-ui\";s:4:\"slug\";s:12:\"averia-libre\";s:8:\"fontFace\";a:6:{i:0;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/averialibre/v16/2V0FKIcMGZEnV6xygz7eNjEarovtak7t-pQgTw.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Averia Libre\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-libre/averia-libre-300-normal.svg\";}i:1;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/averialibre/v16/2V0HKIcMGZEnV6xygz7eNjESAJFhbUTs2JEwT4Sk.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:12:\"Averia Libre\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-libre/averia-libre-300-italic.svg\";}i:2;a:5:{s:3:\"src\";s:84:\"https://fonts.gstatic.com/s/averialibre/v16/2V0aKIcMGZEnV6xygz7eNjEiB6PJZ2Xx8w.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Averia Libre\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-libre/averia-libre-400-normal.svg\";}i:3;a:5:{s:3:\"src\";s:86:\"https://fonts.gstatic.com/s/averialibre/v16/2V0EKIcMGZEnV6xygz7eNjESAKnIRWDh8405.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:12:\"Averia Libre\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-libre/averia-libre-400-italic.svg\";}i:4;a:5:{s:3:\"src\";s:88:\"https://fonts.gstatic.com/s/averialibre/v16/2V0FKIcMGZEnV6xygz7eNjEavoztak7t-pQgTw.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:12:\"Averia Libre\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-libre/averia-libre-700-normal.svg\";}i:5;a:5:{s:3:\"src\";s:90:\"https://fonts.gstatic.com/s/averialibre/v16/2V0HKIcMGZEnV6xygz7eNjESAJFxakTs2JEwT4Sk.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:12:\"Averia Libre\";s:7:\"preview\";s:85:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-libre/averia-libre-700-italic.svg\";}}s:7:\"preview\";s:74:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-libre/averia-libre.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:136;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:17:\"Averia Sans Libre\";s:10:\"fontFamily\";s:30:\"\"Averia Sans Libre\", system-ui\";s:4:\"slug\";s:17:\"averia-sans-libre\";s:8:\"fontFace\";a:6:{i:0;a:5:{s:3:\"src\";s:98:\"https://fonts.gstatic.com/s/averiasanslibre/v20/ga6SaxZG_G5OvCf_rt7FH3B6BHLMEd3lMKcVJZP1LmD9.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:17:\"Averia Sans Libre\";s:7:\"preview\";s:95:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-sans-libre/averia-sans-libre-300-normal.svg\";}i:1;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/averiasanslibre/v20/ga6caxZG_G5OvCf_rt7FH3B6BHLMEdVLKisSL5LXK3D9qtg.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:17:\"Averia Sans Libre\";s:7:\"preview\";s:95:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-sans-libre/averia-sans-libre-300-italic.svg\";}i:2;a:5:{s:3:\"src\";s:94:\"https://fonts.gstatic.com/s/averiasanslibre/v20/ga6XaxZG_G5OvCf_rt7FH3B6BHLMEeVMGIMYDo_8.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:17:\"Averia Sans Libre\";s:7:\"preview\";s:95:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-sans-libre/averia-sans-libre-400-normal.svg\";}i:3;a:5:{s:3:\"src\";s:97:\"https://fonts.gstatic.com/s/averiasanslibre/v20/ga6RaxZG_G5OvCf_rt7FH3B6BHLMEdVLEoI6C5_8N3k.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:17:\"Averia Sans Libre\";s:7:\"preview\";s:95:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-sans-libre/averia-sans-libre-400-italic.svg\";}i:4;a:5:{s:3:\"src\";s:98:\"https://fonts.gstatic.com/s/averiasanslibre/v20/ga6SaxZG_G5OvCf_rt7FH3B6BHLMEd31N6cVJZP1LmD9.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:17:\"Averia Sans Libre\";s:7:\"preview\";s:95:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-sans-libre/averia-sans-libre-700-normal.svg\";}i:5;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/averiasanslibre/v20/ga6caxZG_G5OvCf_rt7FH3B6BHLMEdVLKjsVL5LXK3D9qtg.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:17:\"Averia Sans Libre\";s:7:\"preview\";s:95:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-sans-libre/averia-sans-libre-700-italic.svg\";}}s:7:\"preview\";s:84:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-sans-libre/averia-sans-libre.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:137;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:18:\"Averia Serif Libre\";s:10:\"fontFamily\";s:31:\"\"Averia Serif Libre\", system-ui\";s:4:\"slug\";s:18:\"averia-serif-libre\";s:8:\"fontFace\";a:6:{i:0;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/averiaseriflibre/v19/neIVzD2ms4wxr6GvjeD0X88SHPyX2xYGCSmqxKcqdrKvbQ.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:18:\"Averia Serif Libre\";s:7:\"preview\";s:97:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-serif-libre/averia-serif-libre-300-normal.svg\";}i:1;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/averiaseriflibre/v19/neIbzD2ms4wxr6GvjeD0X88SHPyX2xYOpzMmw60rVLe_bXHq.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:18:\"Averia Serif Libre\";s:7:\"preview\";s:97:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-serif-libre/averia-serif-libre-300-italic.svg\";}i:2;a:5:{s:3:\"src\";s:97:\"https://fonts.gstatic.com/s/averiaseriflibre/v19/neIWzD2ms4wxr6GvjeD0X88SHPyX2xY-oAGOyYw2fw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:18:\"Averia Serif Libre\";s:7:\"preview\";s:97:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-serif-libre/averia-serif-libre-400-normal.svg\";}i:3;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/averiaseriflibre/v19/neIUzD2ms4wxr6GvjeD0X88SHPyX2xYOpwuP64kmf6u2.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:18:\"Averia Serif Libre\";s:7:\"preview\";s:97:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-serif-libre/averia-serif-libre-400-italic.svg\";}i:4;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/averiaseriflibre/v19/neIVzD2ms4wxr6GvjeD0X88SHPyX2xYGGS6qxKcqdrKvbQ.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:18:\"Averia Serif Libre\";s:7:\"preview\";s:97:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-serif-libre/averia-serif-libre-700-normal.svg\";}i:5;a:5:{s:3:\"src\";s:103:\"https://fonts.gstatic.com/s/averiaseriflibre/v19/neIbzD2ms4wxr6GvjeD0X88SHPyX2xYOpzM2xK0rVLe_bXHq.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:18:\"Averia Serif Libre\";s:7:\"preview\";s:97:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-serif-libre/averia-serif-libre-700-italic.svg\";}}s:7:\"preview\";s:86:\"https://s.w.org/images/fonts/wp-6.9/previews/averia-serif-libre/averia-serif-libre.svg\";}s:10:\"categories\";a:1:{i:0;s:7:\"display\";}}i:138;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:11:\"Azeret Mono\";s:10:\"fontFamily\";s:24:\"\"Azeret Mono\", monospace\";s:4:\"slug\";s:11:\"azeret-mono\";s:8:\"fontFace\";a:18:{i:0;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfnPRh17aa-5s3AA.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-100-normal.svg\";}i:1;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfHPVh17aa-5s3AA.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-200-normal.svg\";}i:2;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfwvVh17aa-5s3AA.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-300-normal.svg\";}i:3;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfnPVh17aa-5s3AA.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-400-normal.svg\";}i:4;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfrvVh17aa-5s3AA.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-500-normal.svg\";}i:5;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfQvJh17aa-5s3AA.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-600-normal.svg\";}i:6;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfe_Jh17aa-5s3AA.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-700-normal.svg\";}i:7;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfHPJh17aa-5s3AA.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-800-normal.svg\";}i:8;a:5:{s:3:\"src\";s:99:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF5ErsiyJsY9O_Gepph-FvtTQgMQUdNekSfNfJh17aa-5s3AA.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-900-normal.svg\";}i:9;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLaJkLyb2Z4nAN7J.woff2\";s:10:\"fontWeight\";s:3:\"100\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-100-italic.svg\";}i:10;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLYJkbyb2Z4nAN7J.woff2\";s:10:\"fontWeight\";s:3:\"200\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-200-italic.svg\";}i:11;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLbXkbyb2Z4nAN7J.woff2\";s:10:\"fontWeight\";s:3:\"300\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-300-italic.svg\";}i:12;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLaJkbyb2Z4nAN7J.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-400-italic.svg\";}i:13;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLa7kbyb2Z4nAN7J.woff2\";s:10:\"fontWeight\";s:3:\"500\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-500-italic.svg\";}i:14;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLZXlryb2Z4nAN7J.woff2\";s:10:\"fontWeight\";s:3:\"600\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-600-italic.svg\";}i:15;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLZulryb2Z4nAN7J.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-700-italic.svg\";}i:16;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLYJlryb2Z4nAN7J.woff2\";s:10:\"fontWeight\";s:3:\"800\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-800-italic.svg\";}i:17;a:5:{s:3:\"src\";s:101:\"https://fonts.gstatic.com/s/azeretmono/v21/3XF_ErsiyJsY9O_Gepph-HHkf_fUKCzX1EOKVLYglryb2Z4nAN7J.woff2\";s:10:\"fontWeight\";s:3:\"900\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:11:\"Azeret Mono\";s:7:\"preview\";s:83:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono-900-italic.svg\";}}s:7:\"preview\";s:72:\"https://s.w.org/images/fonts/wp-6.9/previews/azeret-mono/azeret-mono.svg\";}s:10:\"categories\";a:1:{i:0;s:9:\"monospace\";}}i:139;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:4:\"B612\";s:10:\"fontFamily\";s:18:\"\"B612\", sans-serif\";s:4:\"slug\";s:5:\"b-612\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:66:\"https://fonts.gstatic.com/s/b612/v13/3JnySDDxiSz32jy4GDigUXw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"B612\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/b612/b612-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:69:\"https://fonts.gstatic.com/s/b612/v13/3Jn8SDDxiSz36juyGRqlQXwdVw.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"B612\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/b612/b612-400-italic.svg\";}i:2;a:5:{s:3:\"src\";s:70:\"https://fonts.gstatic.com/s/b612/v13/3Jn9SDDxiSz34oWXPDWLTXUETuE.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:4:\"B612\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/b612/b612-700-normal.svg\";}i:3;a:5:{s:3:\"src\";s:73:\"https://fonts.gstatic.com/s/b612/v13/3Jn_SDDxiSz36juKoDWBTFcBXuFb0Q.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:4:\"B612\";s:7:\"preview\";s:69:\"https://s.w.org/images/fonts/wp-6.9/previews/b612/b612-700-italic.svg\";}}s:7:\"preview\";s:58:\"https://s.w.org/images/fonts/wp-6.9/previews/b612/b612.svg\";}s:10:\"categories\";a:1:{i:0;s:10:\"sans-serif\";}}i:140;a:2:{s:20:\"font_family_settings\";a:5:{s:4:\"name\";s:9:\"B612 Mono\";s:10:\"fontFamily\";s:22:\"\"B612 Mono\", monospace\";s:4:\"slug\";s:10:\"b-612-mono\";s:8:\"fontFace\";a:4:{i:0;a:5:{s:3:\"src\";s:77:\"https://fonts.gstatic.com/s/b612mono/v16/kmK_Zq85QVWbN1eW6lJl0gTcquRTtg.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"B612 Mono\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/b612-mono/b612-mono-400-normal.svg\";}i:1;a:5:{s:3:\"src\";s:79:\"https://fonts.gstatic.com/s/b612mono/v16/kmK5Zq85QVWbN1eW6lJV1Q7diOFDtqtf.woff2\";s:10:\"fontWeight\";s:3:\"400\";s:9:\"fontStyle\";s:6:\"italic\";s:10:\"fontFamily\";s:9:\"B612 Mono\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/b612-mono/b612-mono-400-italic.svg\";}i:2;a:5:{s:3:\"src\";s:81:\"https://fonts.gstatic.com/s/b612mono/v16/kmK6Zq85QVWbN1eW6lJdayv4p89Pv7JGSg.woff2\";s:10:\"fontWeight\";s:3:\"700\";s:9:\"fontStyle\";s:6:\"normal\";s:10:\"fontFamily\";s:9:\"B612 Mono\";s:7:\"preview\";s:79:\"https://s.w.org/images/fonts/wp-6.9/previews/b612-mono/b612-mono-700-normal.svg\";