<?php
/**
 * Salamandre Child Theme
 * Functions and definitions
 */

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

/* =============================================================================
   ENQUEUE PARENT & CHILD THEME STYLES
   ========================================================================== */

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if (!function_exists('chld_thm_cfg_locale_css')):
    function chld_thm_cfg_locale_css($uri) {
        if (empty($uri) && is_rtl() && file_exists(get_template_directory() . '/rtl.css'))
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter('locale_stylesheet_uri', 'chld_thm_cfg_locale_css');

if (!function_exists('chld_thm_cfg_parent_css')):
    function chld_thm_cfg_parent_css() {
        wp_enqueue_style('chld_thm_cfg_parent', trailingslashit(get_template_directory_uri()) . 'style.css', array());
    }
endif;
add_action('wp_enqueue_scripts', 'chld_thm_cfg_parent_css', 10);

// END ENQUEUE PARENT ACTION

/* =============================================================================
   ENQUEUE CHILD THEME STYLES (avec chargement conditionnel)
   ========================================================================== */

if (!function_exists('salamandre_enqueue_styles')):
    function salamandre_enqueue_styles() {
        // CSS principal (header, footer, search modal) - toujours chargé
        wp_enqueue_style(
            'salamandre-main', 
            get_stylesheet_uri(), 
            array('chld_thm_cfg_parent'), 
            '1.0.0'
        );
        
        // CSS Homepage - seulement sur la page d'accueil
        if (is_front_page()) {
            wp_enqueue_style(
                'salamandre-homepage',
                get_stylesheet_directory_uri() . '/css/homepage.css',
                array('salamandre-main'),
                '1.0.0'
            );
        }
    }
endif;
add_action('wp_enqueue_scripts', 'salamandre_enqueue_styles', 10);

/* =============================================================================
   SEARCH MODAL FUNCTIONALITY
   Inspiré du thème Twenty Twenty
   ========================================================================== */

/**
 * Enqueue search modal JavaScript
 */
function salamandre_enqueue_search_modal() {
    wp_enqueue_script(
        'salamandre-search-modal', 
        get_stylesheet_directory_uri() . '/js/search-modal.js', 
        array(), 
        '1.0.0', 
        true
    );
}
add_action('wp_enqueue_scripts', 'salamandre_enqueue_search_modal');

/**
 * Shortcode for search button
 * Usage: [search_button] dans l'éditeur FSE
 */
function salamandre_search_button_shortcode() {
    ob_start();
    ?>
    <button class="search-toggle" data-toggle-target=".search-modal" aria-expanded="false" aria-label="<?php esc_attr_e('Open search', 'salamandre'); ?>">
        <span class="toggle-inner">
            <svg class="search-icon" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                <circle cx="10" cy="10" r="7" stroke="currentColor" stroke-width="2"/>
                <path d="M15 15L21 21" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
            </svg>
        </span>
    </button>
    <?php
    return ob_get_clean();
}
add_shortcode('search_button', 'salamandre_search_button_shortcode');

/**
 * Add search modal to footer
 * Suppression du bouton close (fermeture via overlay ou Échap)
 */
function salamandre_add_search_modal() {
    ?>
    <div class="search-modal cover-modal" data-modal-target-string=".search-modal" aria-hidden="true">
        <div class="search-modal-inner">
            <div class="section-inner">
                <?php get_search_form(); ?>
            </div>
        </div>
    </div>
    <?php
}
add_action('wp_footer', 'salamandre_add_search_modal');

/**
 * Customize search form for the modal
 * Ajout du bouton clear pour effacer le champ
 */
function salamandre_custom_search_form($form) {
    $form = '<form role="search" method="get" class="search-form" action="' . esc_url(home_url('/')) . '">
        <label for="search-field">
            <span class="screen-reader-text">' . esc_html__('Search for:', 'salamandre') . '</span>
            <input type="search" id="search-field" class="search-field" placeholder="' . esc_attr__('Rechercher…', 'salamandre') . '" value="' . get_search_query() . '" name="s" />
        </label>
        <button type="button" class="search-clear" aria-label="' . esc_attr__('Clear search', 'salamandre') . '">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                <path d="M6 6L18 18" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                <path d="M18 6L6 18" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
            </svg>
        </button>
        <button type="submit" class="search-submit">
            <span class="screen-reader-text">' . esc_html__('Search', 'salamandre') . '</span>
            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                <circle cx="10" cy="10" r="7" stroke="currentColor" stroke-width="2"/>
                <path d="M15 15L21 21" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
            </svg>
        </button>
    </form>';
    
    return $form;
}
add_filter('get_search_form', 'salamandre_custom_search_form');


